/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.datastreams;

import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.local.LocalClusterStateRequest;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamAutoShardingEvent;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetention;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetDataStreamAction
extends ActionType<Response> {
    public static final GetDataStreamAction INSTANCE = new GetDataStreamAction();
    public static final String NAME = "indices:admin/data_stream/get";

    private GetDataStreamAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        public static final ParseField DATA_STREAMS_FIELD = new ParseField("data_streams", new String[0]);
        private static final TransportVersion INTRODUCE_FAILURES_DEFAULT_RETENTION_PATCH = TransportVersion.fromName("introduce_failures_default_retention").nextPatchVersion();
        private static final TransportVersion INCLUDE_INDEX_MODE_IN_GET_DATA_STREAM = TransportVersion.fromName("include_index_mode_in_get_data_stream");
        private final List<DataStreamInfo> dataStreams;
        @Nullable
        private final RolloverConfiguration rolloverConfiguration;
        @Nullable
        private final DataStreamGlobalRetention dataGlobalRetention;
        @Nullable
        private final DataStreamGlobalRetention failuresGlobalRetention;

        public Response(List<DataStreamInfo> dataStreams) {
            this(dataStreams, null, null, null);
        }

        public Response(List<DataStreamInfo> dataStreams, @Nullable RolloverConfiguration rolloverConfiguration, @Nullable DataStreamGlobalRetention dataGlobalRetention, @Nullable DataStreamGlobalRetention failuresGlobalRetention) {
            this.dataStreams = dataStreams;
            this.rolloverConfiguration = rolloverConfiguration;
            this.dataGlobalRetention = dataGlobalRetention;
            this.failuresGlobalRetention = failuresGlobalRetention;
        }

        public List<DataStreamInfo> getDataStreams() {
            return this.dataStreams;
        }

        @Nullable
        public RolloverConfiguration getRolloverConfiguration() {
            return this.rolloverConfiguration;
        }

        @Nullable
        public DataStreamGlobalRetention getDataGlobalRetention() {
            return this.dataGlobalRetention;
        }

        @Nullable
        public DataStreamGlobalRetention getFailuresGlobalRetention() {
            return this.failuresGlobalRetention;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.dataStreams);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
                out.writeOptionalWriteable(this.rolloverConfiguration);
            }
            if (out.getTransportVersion().supports(INTRODUCE_FAILURES_DEFAULT_RETENTION_PATCH)) {
                out.writeOptionalTimeValue(this.dataGlobalRetention == null ? null : this.dataGlobalRetention.defaultRetention());
                out.writeOptionalTimeValue(this.dataGlobalRetention == null ? null : this.dataGlobalRetention.maxRetention());
                out.writeOptionalTimeValue(this.failuresGlobalRetention == null ? null : this.failuresGlobalRetention.defaultRetention());
            } else if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_14_0)) {
                out.writeOptionalWriteable(this.dataGlobalRetention);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray(DATA_STREAMS_FIELD.getPreferredName());
            for (DataStreamInfo dataStream : this.dataStreams) {
                dataStream.toXContent(builder, DataStreamLifecycle.addEffectiveRetentionParams(params), this.rolloverConfiguration, this.dataGlobalRetention, this.failuresGlobalRetention);
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return this.dataStreams.equals(response.dataStreams) && Objects.equals(this.rolloverConfiguration, response.rolloverConfiguration) && Objects.equals(this.dataGlobalRetention, response.dataGlobalRetention) && Objects.equals(this.failuresGlobalRetention, response.failuresGlobalRetention);
        }

        public int hashCode() {
            return Objects.hash(this.dataStreams, this.rolloverConfiguration, this.dataGlobalRetention, this.failuresGlobalRetention);
        }

        public static class DataStreamInfo
        implements SimpleDiffable<DataStreamInfo>,
        ToXContentObject {
            public static final ParseField STATUS_FIELD = new ParseField("status", new String[0]);
            public static final ParseField INDEX_TEMPLATE_FIELD = new ParseField("template", new String[0]);
            public static final ParseField SETTINGS_FIELD = new ParseField("settings", new String[0]);
            public static final ParseField PREFER_ILM = new ParseField("prefer_ilm", new String[0]);
            public static final ParseField MANAGED_BY = new ParseField("managed_by", new String[0]);
            public static final ParseField NEXT_GENERATION_INDEX_MANAGED_BY = new ParseField("next_generation_managed_by", new String[0]);
            public static final ParseField ILM_POLICY_FIELD = new ParseField("ilm_policy", new String[0]);
            public static final ParseField LIFECYCLE_FIELD = new ParseField("lifecycle", new String[0]);
            public static final ParseField HIDDEN_FIELD = new ParseField("hidden", new String[0]);
            public static final ParseField SYSTEM_FIELD = new ParseField("system", new String[0]);
            public static final ParseField ALLOW_CUSTOM_ROUTING = new ParseField("allow_custom_routing", new String[0]);
            public static final ParseField REPLICATED = new ParseField("replicated", new String[0]);
            public static final ParseField ROLLOVER_ON_WRITE = new ParseField("rollover_on_write", new String[0]);
            public static final ParseField TIME_SERIES = new ParseField("time_series", new String[0]);
            public static final ParseField TEMPORAL_RANGES = new ParseField("temporal_ranges", new String[0]);
            public static final ParseField TEMPORAL_RANGE_START = new ParseField("start", new String[0]);
            public static final ParseField TEMPORAL_RANGE_END = new ParseField("end", new String[0]);
            public static final ParseField TIME_SINCE_LAST_AUTO_SHARD_EVENT = new ParseField("time_since_last_auto_shard_event", new String[0]);
            public static final ParseField TIME_SINCE_LAST_AUTO_SHARD_EVENT_MILLIS = new ParseField("time_since_last_auto_shard_event_millis", new String[0]);
            public static final ParseField FAILURE_STORE_ENABLED = new ParseField("enabled", new String[0]);
            public static final ParseField MAXIMUM_TIMESTAMP = new ParseField("maximum_timestamp", new String[0]);
            public static final ParseField INDEX_MODE = new ParseField("index_mode", new String[0]);
            private final DataStream dataStream;
            private final ClusterHealthStatus dataStreamStatus;
            private final boolean failureStoreEffectivelyEnabled;
            @Nullable
            private final String indexTemplate;
            @Nullable
            private final String ilmPolicyName;
            @Nullable
            private final TimeSeries timeSeries;
            private final Map<Index, IndexProperties> indexSettingsValues;
            private final boolean templatePreferIlmValue;
            @Nullable
            private final Long maximumTimestamp;
            @Nullable
            private final String indexMode;

            public DataStreamInfo(DataStream dataStream, boolean failureStoreEffectivelyEnabled, ClusterHealthStatus dataStreamStatus, @Nullable String indexTemplate, @Nullable String ilmPolicyName, @Nullable TimeSeries timeSeries, Map<Index, IndexProperties> indexSettingsValues, boolean templatePreferIlmValue, @Nullable Long maximumTimestamp, @Nullable String indexMode) {
                this.dataStream = dataStream;
                this.failureStoreEffectivelyEnabled = failureStoreEffectivelyEnabled;
                this.dataStreamStatus = dataStreamStatus;
                this.indexTemplate = indexTemplate;
                this.ilmPolicyName = ilmPolicyName;
                this.timeSeries = timeSeries;
                this.indexSettingsValues = indexSettingsValues;
                this.templatePreferIlmValue = templatePreferIlmValue;
                this.maximumTimestamp = maximumTimestamp;
                this.indexMode = indexMode;
            }

            public DataStream getDataStream() {
                return this.dataStream;
            }

            public boolean isFailureStoreEffectivelyEnabled() {
                return this.failureStoreEffectivelyEnabled;
            }

            public ClusterHealthStatus getDataStreamStatus() {
                return this.dataStreamStatus;
            }

            @Nullable
            public String getIndexTemplate() {
                return this.indexTemplate;
            }

            @Nullable
            public String getIlmPolicy() {
                return this.ilmPolicyName;
            }

            @Nullable
            public TimeSeries getTimeSeries() {
                return this.timeSeries;
            }

            public Map<Index, IndexProperties> getIndexSettingsValues() {
                return this.indexSettingsValues;
            }

            public boolean templatePreferIlmValue() {
                return this.templatePreferIlmValue;
            }

            @Nullable
            public Long getMaximumTimestamp() {
                return this.maximumTimestamp;
            }

            @Nullable
            public String getIndexModeName() {
                return this.indexMode;
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                this.dataStream.writeTo(out);
                out.writeBoolean(this.failureStoreEffectivelyEnabled);
                this.dataStreamStatus.writeTo(out);
                out.writeOptionalString(this.indexTemplate);
                out.writeOptionalString(this.ilmPolicyName);
                if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_3_0)) {
                    out.writeOptionalWriteable(this.timeSeries);
                }
                if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_11_X)) {
                    out.writeMap(this.indexSettingsValues);
                    out.writeBoolean(this.templatePreferIlmValue);
                }
                if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0)) {
                    out.writeOptionalVLong(this.maximumTimestamp);
                }
                if (out.getTransportVersion().supports(INCLUDE_INDEX_MODE_IN_GET_DATA_STREAM)) {
                    out.writeOptionalString(this.indexMode);
                }
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                return this.toXContent(builder, params, null, null, null);
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, @Nullable RolloverConfiguration rolloverConfiguration, @Nullable DataStreamGlobalRetention dataGlobalRetention, @Nullable DataStreamGlobalRetention failureGlobalRetention) throws IOException {
                builder.startObject();
                builder.field(DataStream.NAME_FIELD.getPreferredName(), this.dataStream.getName());
                builder.field(DataStream.TIMESTAMP_FIELD_FIELD.getPreferredName()).startObject().field(DataStream.NAME_FIELD.getPreferredName(), "@timestamp").endObject();
                this.indicesToXContent(builder, this.dataStream.getIndices(), false);
                builder.field(DataStream.GENERATION_FIELD.getPreferredName(), this.dataStream.getGeneration());
                if (this.dataStream.getMetadata() != null) {
                    builder.field(DataStream.METADATA_FIELD.getPreferredName(), this.dataStream.getMetadata());
                }
                builder.field(STATUS_FIELD.getPreferredName(), (Enum)this.dataStreamStatus);
                if (this.indexTemplate != null) {
                    builder.field(INDEX_TEMPLATE_FIELD.getPreferredName(), this.indexTemplate);
                }
                if (this.dataStream.getDataLifecycle() != null) {
                    builder.field(LIFECYCLE_FIELD.getPreferredName());
                    this.dataStream.getDataLifecycle().toXContent(builder, params, rolloverConfiguration, dataGlobalRetention, this.dataStream.isInternal());
                }
                if (this.ilmPolicyName != null) {
                    builder.field(ILM_POLICY_FIELD.getPreferredName(), this.ilmPolicyName);
                }
                builder.field(NEXT_GENERATION_INDEX_MANAGED_BY.getPreferredName(), this.getNextGenerationManagedBy().displayValue);
                builder.field(PREFER_ILM.getPreferredName(), this.templatePreferIlmValue);
                builder.field(HIDDEN_FIELD.getPreferredName(), this.dataStream.isHidden());
                builder.field(SYSTEM_FIELD.getPreferredName(), this.dataStream.isSystem());
                builder.field(ALLOW_CUSTOM_ROUTING.getPreferredName(), this.dataStream.isAllowCustomRouting());
                builder.field(REPLICATED.getPreferredName(), this.dataStream.isReplicated());
                builder.field(ROLLOVER_ON_WRITE.getPreferredName(), this.dataStream.rolloverOnWrite());
                if (this.maximumTimestamp != null) {
                    builder.field(MAXIMUM_TIMESTAMP.getPreferredName(), this.maximumTimestamp);
                }
                if (this.indexMode != null) {
                    builder.field(INDEX_MODE.getPreferredName(), this.indexMode);
                }
                this.addAutoShardingEvent(builder, params, this.dataStream.getAutoShardingEvent());
                if (this.timeSeries != null) {
                    builder.startObject(TIME_SERIES.getPreferredName());
                    builder.startArray(TEMPORAL_RANGES.getPreferredName());
                    for (Tuple<Instant, Instant> range : this.timeSeries.temporalRanges()) {
                        builder.startObject();
                        Instant start = (Instant)range.v1();
                        builder.field(TEMPORAL_RANGE_START.getPreferredName(), DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.format(start));
                        Instant end = (Instant)range.v2();
                        builder.field(TEMPORAL_RANGE_END.getPreferredName(), DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.format(end));
                        builder.endObject();
                    }
                    builder.endArray();
                    builder.endObject();
                }
                builder.startObject(SETTINGS_FIELD.getPreferredName());
                this.dataStream.getSettings().toXContent(builder, params);
                builder.endObject();
                builder.startObject(DataStream.FAILURE_STORE_FIELD.getPreferredName());
                builder.field(FAILURE_STORE_ENABLED.getPreferredName(), this.failureStoreEffectivelyEnabled);
                builder.field(DataStream.ROLLOVER_ON_WRITE_FIELD.getPreferredName(), this.dataStream.getFailureComponent().isRolloverOnWrite());
                this.indicesToXContent(builder, this.dataStream.getFailureIndices(), true);
                this.addAutoShardingEvent(builder, params, this.dataStream.getFailureComponent().getAutoShardingEvent());
                DataStreamLifecycle failuresLifecycle = this.dataStream.getFailuresLifecycle(this.failureStoreEffectivelyEnabled);
                if (failuresLifecycle != null) {
                    builder.field(LIFECYCLE_FIELD.getPreferredName());
                    failuresLifecycle.toXContent(builder, params, rolloverConfiguration, failureGlobalRetention, this.dataStream.isInternal());
                }
                builder.endObject();
                builder.endObject();
                return builder;
            }

            private XContentBuilder indicesToXContent(XContentBuilder builder, List<Index> indices, boolean failureIndices) throws IOException {
                builder.field(DataStream.INDICES_FIELD.getPreferredName());
                builder.startArray();
                for (Index index : indices) {
                    builder.startObject();
                    index.toXContentFragment(builder);
                    IndexProperties indexProperties = this.indexSettingsValues.get(index);
                    if (indexProperties != null) {
                        builder.field(MANAGED_BY.getPreferredName(), indexProperties.managedBy.displayValue);
                        if (failureIndices) {
                            if (indexProperties.ilmPolicyName() != null) {
                                builder.field(PREFER_ILM.getPreferredName(), indexProperties.preferIlm());
                                builder.field(ILM_POLICY_FIELD.getPreferredName(), indexProperties.ilmPolicyName());
                            }
                        } else {
                            builder.field(PREFER_ILM.getPreferredName(), indexProperties.preferIlm());
                            if (indexProperties.ilmPolicyName() != null) {
                                builder.field(ILM_POLICY_FIELD.getPreferredName(), indexProperties.ilmPolicyName());
                            }
                            builder.field(INDEX_MODE.getPreferredName(), indexProperties.indexMode);
                        }
                    }
                    builder.endObject();
                }
                builder.endArray();
                return builder;
            }

            private void addAutoShardingEvent(XContentBuilder builder, ToXContent.Params params, DataStreamAutoShardingEvent autoShardingEvent) throws IOException {
                if (autoShardingEvent == null) {
                    return;
                }
                builder.startObject(DataStream.AUTO_SHARDING_FIELD.getPreferredName());
                autoShardingEvent.toXContent(builder, params);
                builder.humanReadableField(TIME_SINCE_LAST_AUTO_SHARD_EVENT_MILLIS.getPreferredName(), TIME_SINCE_LAST_AUTO_SHARD_EVENT.getPreferredName(), (Object)autoShardingEvent.getTimeSinceLastAutoShardingEvent(System::currentTimeMillis));
                builder.endObject();
            }

            public ManagedBy getNextGenerationManagedBy() {
                if (this.ilmPolicyName != null && this.dataStream.getDataLifecycle() != null && this.dataStream.getDataLifecycle().enabled()) {
                    return this.templatePreferIlmValue ? ManagedBy.ILM : ManagedBy.LIFECYCLE;
                }
                if (this.ilmPolicyName != null) {
                    return ManagedBy.ILM;
                }
                if (this.dataStream.getDataLifecycle() != null && this.dataStream.getDataLifecycle().enabled()) {
                    return ManagedBy.LIFECYCLE;
                }
                return ManagedBy.UNMANAGED;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                DataStreamInfo that = (DataStreamInfo)o;
                return this.templatePreferIlmValue == that.templatePreferIlmValue && Objects.equals(this.dataStream, that.dataStream) && this.failureStoreEffectivelyEnabled == that.failureStoreEffectivelyEnabled && this.dataStreamStatus == that.dataStreamStatus && Objects.equals(this.indexTemplate, that.indexTemplate) && Objects.equals(this.ilmPolicyName, that.ilmPolicyName) && Objects.equals(this.timeSeries, that.timeSeries) && Objects.equals(this.indexSettingsValues, that.indexSettingsValues) && Objects.equals(this.maximumTimestamp, that.maximumTimestamp) && Objects.equals(this.indexMode, that.indexMode);
            }

            public int hashCode() {
                return Objects.hash(this.dataStream, this.dataStreamStatus, this.failureStoreEffectivelyEnabled, this.indexTemplate, this.ilmPolicyName, this.timeSeries, this.indexSettingsValues, this.templatePreferIlmValue, this.maximumTimestamp, this.indexMode);
            }
        }

        public record IndexProperties(boolean preferIlm, @Nullable String ilmPolicyName, ManagedBy managedBy, @Nullable String indexMode) implements Writeable
        {
            public IndexProperties(StreamInput in) throws IOException {
                this(in.readBoolean(), in.readOptionalString(), in.readEnum(ManagedBy.class), in.getTransportVersion().supports(INCLUDE_INDEX_MODE_IN_GET_DATA_STREAM) ? in.readOptionalString() : "unknown");
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeBoolean(this.preferIlm);
                out.writeOptionalString(this.ilmPolicyName);
                out.writeEnum(this.managedBy);
                if (out.getTransportVersion().supports(INCLUDE_INDEX_MODE_IN_GET_DATA_STREAM)) {
                    out.writeOptionalString(this.indexMode);
                }
            }
        }

        public record TimeSeries(List<Tuple<Instant, Instant>> temporalRanges) implements Writeable
        {
            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeCollection(this.temporalRanges, (out1, value) -> {
                    out1.writeInstant((Instant)value.v1());
                    out1.writeInstant((Instant)value.v2());
                });
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                TimeSeries that = (TimeSeries)o;
                return this.temporalRanges.equals(that.temporalRanges);
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.temporalRanges);
            }
        }

        public static enum ManagedBy {
            ILM("Index Lifecycle Management"),
            LIFECYCLE("Data stream lifecycle"),
            UNMANAGED("Unmanaged");

            public final String displayValue;

            private ManagedBy(String displayValue) {
                this.displayValue = displayValue;
            }
        }
    }

    public static class Request
    extends LocalClusterStateRequest
    implements IndicesRequest.Replaceable {
        private String[] names;
        private IndicesOptions indicesOptions = IndicesOptions.builder().concreteTargetOptions(IndicesOptions.ConcreteTargetOptions.ERROR_WHEN_UNAVAILABLE_TARGETS).wildcardOptions(IndicesOptions.WildcardOptions.builder().matchOpen(true).matchClosed(true).includeHidden(false).resolveAliases(false).allowEmptyExpressions(true).build()).gatekeeperOptions(IndicesOptions.GatekeeperOptions.builder().allowAliasToMultipleIndices(false).allowClosedIndices(true).ignoreThrottled(false).allowSelectors(false).build()).build();
        private boolean includeDefaults = false;
        private boolean verbose = false;

        public Request(TimeValue masterNodeTimeout, String[] names) {
            super(masterNodeTimeout);
            this.names = names;
        }

        public Request(TimeValue masterNodeTimeout, String[] names, boolean includeDefaults) {
            super(masterNodeTimeout);
            this.names = names;
            this.includeDefaults = includeDefaults;
        }

        public String[] getNames() {
            return this.names;
        }

        public boolean verbose() {
            return this.verbose;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "", parentTaskId, headers);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.names = in.readOptionalStringArray();
            this.indicesOptions = IndicesOptions.readIndicesOptions(in);
            this.includeDefaults = in.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X) ? in.readBoolean() : false;
            this.verbose = in.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0) ? in.readBoolean() : false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Arrays.equals(this.names, request.names) && this.indicesOptions.equals(request.indicesOptions) && this.includeDefaults == request.includeDefaults && this.verbose == request.verbose;
        }

        public int hashCode() {
            int result = Objects.hash(this.indicesOptions, this.includeDefaults, this.verbose);
            result = 31 * result + Arrays.hashCode(this.names);
            return result;
        }

        @Override
        public String[] indices() {
            return this.names;
        }

        @Override
        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        public boolean includeDefaults() {
            return this.includeDefaults;
        }

        public Request indicesOptions(IndicesOptions indicesOptions) {
            this.indicesOptions = indicesOptions;
            return this;
        }

        @Override
        public boolean includeDataStreams() {
            return true;
        }

        @Override
        public IndicesRequest indices(String ... indices) {
            this.names = indices;
            return this;
        }

        public Request includeDefaults(boolean includeDefaults) {
            this.includeDefaults = includeDefaults;
            return this;
        }

        public Request verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }
    }
}

