/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.SslConfiguration;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.RunOnce;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Strings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterPortSettings;
import org.elasticsearch.transport.RemoteConnectionManager;
import org.elasticsearch.transport.SendRequestTransportException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.CrossClusterAccessSubjectInfo;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptorsIntersection;
import org.elasticsearch.xpack.core.security.transport.ProfileConfigurations;
import org.elasticsearch.xpack.core.security.user.InternalUser;
import org.elasticsearch.xpack.core.security.user.SystemUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.action.SecurityActionMapper;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authc.CrossClusterAccessAuthenticationService;
import org.elasticsearch.xpack.security.authc.CrossClusterAccessHeaders;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.authz.AuthorizationUtils;
import org.elasticsearch.xpack.security.authz.PreAuthorizationUtils;
import org.elasticsearch.xpack.security.transport.CrossClusterAccessServerTransportFilter;
import org.elasticsearch.xpack.security.transport.ServerTransportFilter;

public class SecurityServerTransportInterceptor
implements TransportInterceptor {
    private static final Logger logger = LogManager.getLogger(SecurityServerTransportInterceptor.class);
    private static final Map<String, String> RCS_INTERNAL_ACTIONS_REPLACEMENTS = Map.of("internal:admin/ccr/restore/session/put", "indices:internal/admin/ccr/restore/session/put", "internal:admin/ccr/restore/session/clear", "indices:internal/admin/ccr/restore/session/clear", "internal:admin/ccr/restore/file_chunk/get", "indices:internal/admin/ccr/restore/file_chunk/get", "internal:data/read/esql/open_exchange", "cluster:internal:data/read/esql/open_exchange", "internal:data/read/esql/exchange", "cluster:internal:data/read/esql/exchange", "internal:admin/tasks/ban", "cluster:internal/admin/tasks/ban", "internal:admin/tasks/cancel_child", "cluster:internal/admin/tasks/cancel_child");
    private final AuthenticationService authcService;
    private final AuthorizationService authzService;
    private final SSLService sslService;
    private final Map<String, ServerTransportFilter> profileFilters;
    private final ThreadPool threadPool;
    private final Settings settings;
    private final SecurityContext securityContext;
    private final CrossClusterAccessAuthenticationService crossClusterAccessAuthcService;
    private final Function<Transport.Connection, Optional<RemoteConnectionManager.RemoteClusterAliasWithCredentials>> remoteClusterCredentialsResolver;
    private final XPackLicenseState licenseState;

    public SecurityServerTransportInterceptor(Settings settings, ThreadPool threadPool, AuthenticationService authcService, AuthorizationService authzService, SSLService sslService, SecurityContext securityContext, DestructiveOperations destructiveOperations, CrossClusterAccessAuthenticationService crossClusterAccessAuthcService, XPackLicenseState licenseState) {
        this(settings, threadPool, authcService, authzService, sslService, securityContext, destructiveOperations, crossClusterAccessAuthcService, licenseState, RemoteConnectionManager::resolveRemoteClusterAliasWithCredentials);
    }

    SecurityServerTransportInterceptor(Settings settings, ThreadPool threadPool, AuthenticationService authcService, AuthorizationService authzService, SSLService sslService, SecurityContext securityContext, DestructiveOperations destructiveOperations, CrossClusterAccessAuthenticationService crossClusterAccessAuthcService, XPackLicenseState licenseState, Function<Transport.Connection, Optional<RemoteConnectionManager.RemoteClusterAliasWithCredentials>> remoteClusterCredentialsResolver) {
        this.settings = settings;
        this.threadPool = threadPool;
        this.authcService = authcService;
        this.authzService = authzService;
        this.sslService = sslService;
        this.securityContext = securityContext;
        this.crossClusterAccessAuthcService = crossClusterAccessAuthcService;
        this.licenseState = licenseState;
        this.remoteClusterCredentialsResolver = remoteClusterCredentialsResolver;
        this.profileFilters = this.initializeProfileFilters(destructiveOperations);
    }

    public TransportInterceptor.AsyncSender interceptSender(TransportInterceptor.AsyncSender sender) {
        return this.interceptForAllRequests(this.interceptForCrossClusterAccessRequests(sender));
    }

    private TransportInterceptor.AsyncSender interceptForAllRequests(final TransportInterceptor.AsyncSender sender) {
        return new TransportInterceptor.AsyncSender(){

            public <T extends TransportResponse> void sendRequest(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
                this.assertNoCrossClusterAccessHeadersInContext();
                Optional<String> remoteClusterAlias = SecurityServerTransportInterceptor.this.remoteClusterCredentialsResolver.apply(connection).map(RemoteConnectionManager.RemoteClusterAliasWithCredentials::clusterAlias);
                if (PreAuthorizationUtils.shouldRemoveParentAuthorizationFromThreadContext(remoteClusterAlias, action, SecurityServerTransportInterceptor.this.securityContext)) {
                    SecurityServerTransportInterceptor.this.securityContext.executeAfterRemovingParentAuthorization(original -> SecurityServerTransportInterceptor.this.sendRequestInner(sender, connection, action, request, options, new TransportService.ContextRestoreResponseHandler(SecurityServerTransportInterceptor.this.threadPool.getThreadContext().wrapRestorable(original), handler)));
                } else {
                    SecurityServerTransportInterceptor.this.sendRequestInner(sender, connection, action, request, options, handler);
                }
            }

            private void assertNoCrossClusterAccessHeadersInContext() {
                assert (SecurityServerTransportInterceptor.this.securityContext.getThreadContext().getHeader("_cross_cluster_access_credentials") == null) : "cross cluster access headers should not be in security context";
                assert (SecurityServerTransportInterceptor.this.securityContext.getThreadContext().getHeader("_cross_cluster_access_subject_info") == null) : "cross cluster access headers should not be in security context";
            }
        };
    }

    public <T extends TransportResponse> void sendRequestInner(TransportInterceptor.AsyncSender sender, Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        TransportVersion minVersion = TransportVersion.min((TransportVersion)connection.getTransportVersion(), (TransportVersion)TransportVersion.current());
        if (AuthorizationUtils.shouldReplaceUserWithSystem(this.threadPool.getThreadContext(), action)) {
            this.securityContext.executeAsSystemUser(minVersion, original -> this.sendWithUser(connection, action, request, options, (TransportResponseHandler)new TransportService.ContextRestoreResponseHandler(this.threadPool.getThreadContext().wrapRestorable(original), handler), sender));
        } else if (AuthorizationUtils.shouldSetUserBasedOnActionOrigin(this.threadPool.getThreadContext())) {
            AuthorizationUtils.switchUserBasedOnActionOriginAndExecute(this.threadPool.getThreadContext(), this.securityContext, minVersion, original -> this.sendWithUser(connection, action, request, options, (TransportResponseHandler)new TransportService.ContextRestoreResponseHandler(this.threadPool.getThreadContext().wrapRestorable(original), handler), sender));
        } else if (this.securityContext.getAuthentication() != null && !this.securityContext.getAuthentication().getEffectiveSubject().getTransportVersion().equals((Object)minVersion)) {
            this.securityContext.executeAfterRewritingAuthentication(original -> this.sendWithUser(connection, action, request, options, (TransportResponseHandler)new TransportService.ContextRestoreResponseHandler(this.threadPool.getThreadContext().wrapRestorable(original), handler), sender), minVersion);
        } else {
            this.sendWithUser(connection, action, request, options, handler, sender);
        }
    }

    Map<String, ServerTransportFilter> getProfileFilters() {
        return this.profileFilters;
    }

    private TransportInterceptor.AsyncSender interceptForCrossClusterAccessRequests(final TransportInterceptor.AsyncSender sender) {
        return new TransportInterceptor.AsyncSender(){

            public <T extends TransportResponse> void sendRequest(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
                Optional<RemoteClusterCredentials> remoteClusterCredentials = this.getRemoteClusterCredentials(connection);
                if (remoteClusterCredentials.isPresent()) {
                    this.sendWithCrossClusterAccessHeaders(remoteClusterCredentials.get(), connection, action, request, options, handler);
                } else {
                    try {
                        sender.sendRequest(connection, action, request, options, handler);
                    }
                    catch (Exception e) {
                        handler.handleException((TransportException)new SendRequestTransportException(connection.getNode(), action, (Throwable)e));
                    }
                }
            }

            private Optional<RemoteClusterCredentials> getRemoteClusterCredentials(Transport.Connection connection) {
                Optional<RemoteConnectionManager.RemoteClusterAliasWithCredentials> remoteClusterAliasWithCredentials = SecurityServerTransportInterceptor.this.remoteClusterCredentialsResolver.apply(connection);
                if (remoteClusterAliasWithCredentials.isEmpty()) {
                    logger.trace("Connection is not remote");
                    return Optional.empty();
                }
                String remoteClusterAlias = remoteClusterAliasWithCredentials.get().clusterAlias();
                SecureString remoteClusterCredentials = remoteClusterAliasWithCredentials.get().credentials();
                if (remoteClusterCredentials == null) {
                    logger.trace("No cluster credentials are configured for remote cluster [{}]", (Object)remoteClusterAlias);
                    return Optional.empty();
                }
                return Optional.of(new RemoteClusterCredentials(remoteClusterAlias, ApiKeyService.withApiKeyPrefix(remoteClusterCredentials.toString())));
            }

            private <T extends TransportResponse> void sendWithCrossClusterAccessHeaders(RemoteClusterCredentials remoteClusterCredentials, Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
                if (!Security.ADVANCED_REMOTE_CLUSTER_SECURITY_FEATURE.check(SecurityServerTransportInterceptor.this.licenseState)) {
                    throw LicenseUtils.newComplianceException((String)Security.ADVANCED_REMOTE_CLUSTER_SECURITY_FEATURE.getName());
                }
                String remoteClusterAlias = remoteClusterCredentials.clusterAlias();
                if (connection.getTransportVersion().before((VersionId)RemoteClusterPortSettings.TRANSPORT_VERSION_ADVANCED_REMOTE_CLUSTER_SECURITY)) {
                    throw 2.illegalArgumentExceptionWithDebugLog("Settings for remote cluster [" + remoteClusterAlias + "] indicate cross cluster access headers should be sent but target cluster version [" + connection.getTransportVersion().toReleaseVersion() + "] does not support receiving them");
                }
                logger.trace(() -> Strings.format((String)"Sending [%s] request for [%s] action to [%s] with cross cluster access headers", (Object[])new Object[]{request.getClass(), action, remoteClusterAlias}));
                Authentication authentication = SecurityServerTransportInterceptor.this.securityContext.getAuthentication();
                assert (authentication != null) : "authentication must be present in security context";
                User user = authentication.getEffectiveSubject().getUser();
                if (user instanceof InternalUser && !SystemUser.is((User)user)) {
                    String message = "Internal user [" + user.principal() + "] should not be used for cross cluster requests";
                    assert (false) : message;
                    throw 2.illegalArgumentExceptionWithDebugLog(message);
                }
                if (SystemUser.is((User)user) || action.equals("cluster:monitor/state")) {
                    if (SystemUser.is((User)user)) {
                        logger.trace("Request [{}] for action [{}] towards [{}] initiated by the system user. Sending request with internal cross cluster access user headers", (Object)request.getClass(), (Object)action, (Object)remoteClusterAlias);
                    } else {
                        logger.trace(() -> Strings.format((String)"Switching to the system user for cluster state action towards [{}]. Original user is [%s]", (Object[])new Object[]{remoteClusterAlias, user}));
                    }
                    CrossClusterAccessHeaders crossClusterAccessHeaders = new CrossClusterAccessHeaders(remoteClusterCredentials.credentials(), SystemUser.crossClusterAccessSubjectInfo((TransportVersion)authentication.getEffectiveSubject().getTransportVersion(), (String)authentication.getEffectiveSubject().getRealm().getNodeName()));
                    String effectiveAction = RCS_INTERNAL_ACTIONS_REPLACEMENTS.getOrDefault(action, action);
                    if (!effectiveAction.equals(action)) {
                        logger.trace("switching internal action from [{}] to [{}]", (Object)action, (Object)effectiveAction);
                    }
                    this.sendWithCrossClusterAccessHeaders(crossClusterAccessHeaders, connection, effectiveAction, request, options, handler);
                } else {
                    assert (!action.startsWith("internal:")) : "internal action must be sent with system user";
                    SecurityServerTransportInterceptor.this.authzService.getRoleDescriptorsIntersectionForRemoteCluster(remoteClusterAlias, connection.getTransportVersion(), authentication.getEffectiveSubject(), (ActionListener<RoleDescriptorsIntersection>)ActionListener.wrap(roleDescriptorsIntersection -> {
                        logger.trace(() -> Strings.format((String)"Subject [%s] has role descriptors intersection [%s] for action [%s] towards remote cluster [%s]", (Object[])new Object[]{authentication.getEffectiveSubject(), roleDescriptorsIntersection, action, remoteClusterAlias}));
                        if (roleDescriptorsIntersection.isEmpty()) {
                            throw SecurityServerTransportInterceptor.this.authzService.remoteActionDenied(authentication, SecurityActionMapper.action(action, request), remoteClusterAlias);
                        }
                        CrossClusterAccessHeaders crossClusterAccessHeaders = new CrossClusterAccessHeaders(remoteClusterCredentials.credentials(), new CrossClusterAccessSubjectInfo(authentication, roleDescriptorsIntersection));
                        this.sendWithCrossClusterAccessHeaders(crossClusterAccessHeaders, connection, action, request, options, handler);
                    }, e -> handler.handleException((TransportException)new SendRequestTransportException(connection.getNode(), action, (Throwable)e))));
                }
            }

            private <T extends TransportResponse> void sendWithCrossClusterAccessHeaders(CrossClusterAccessHeaders crossClusterAccessHeaders, Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
                ThreadContext threadContext = SecurityServerTransportInterceptor.this.securityContext.getThreadContext();
                TransportService.ContextRestoreResponseHandler contextRestoreHandler = new TransportService.ContextRestoreResponseHandler(threadContext.newRestorableContext(true), handler);
                try (ThreadContext.StoredContext ignored = threadContext.stashContextPreservingRequestHeaders(ThreadContext.HeadersFor.REMOTE_CLUSTER, new String[]{"_xpack_audit_request_id"});){
                    crossClusterAccessHeaders.writeToContext(threadContext);
                    sender.sendRequest(connection, action, request, options, (TransportResponseHandler)contextRestoreHandler);
                }
                catch (Exception e) {
                    contextRestoreHandler.handleException((TransportException)new SendRequestTransportException(connection.getNode(), action, (Throwable)e));
                }
            }

            private static IllegalArgumentException illegalArgumentExceptionWithDebugLog(String message) {
                logger.debug(message);
                return new IllegalArgumentException(message);
            }
        };
    }

    private <T extends TransportResponse> void sendWithUser(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler, TransportInterceptor.AsyncSender sender) {
        if (this.securityContext.getAuthentication() == null) {
            this.assertNoAuthentication(action);
            throw new IllegalStateException("there should always be a user when sending a message for action [" + action + "]");
        }
        assert (this.securityContext.getParentAuthorization() == null || this.remoteClusterCredentialsResolver.apply(connection).isEmpty()) : "parent authorization header should not be set for remote cluster requests";
        try {
            sender.sendRequest(connection, action, request, options, handler);
        }
        catch (Exception e) {
            handler.handleException((TransportException)new SendRequestTransportException(connection.getNode(), action, (Throwable)e));
        }
    }

    void assertNoAuthentication(String action) {
        assert (false) : "there should always be a user when sending a message for action [" + action + "]";
    }

    public <T extends TransportRequest> TransportRequestHandler<T> interceptHandler(String action, Executor executor, boolean forceExecution, TransportRequestHandler<T> actualHandler) {
        return new ProfileSecuredRequestHandler<T>(logger, action, forceExecution, executor, actualHandler, this.profileFilters, this.threadPool);
    }

    private Map<String, ServerTransportFilter> initializeProfileFilters(DestructiveOperations destructiveOperations) {
        Map<String, SslConfiguration> profileConfigurations = ProfileConfigurations.get(this.settings, this.sslService, false);
        Map profileFilters = Maps.newMapWithExpectedSize((int)(profileConfigurations.size() + 1));
        boolean transportSSLEnabled = (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(this.settings);
        boolean remoteClusterPortEnabled = (Boolean)RemoteClusterPortSettings.REMOTE_CLUSTER_SERVER_ENABLED.get(this.settings);
        boolean remoteClusterServerSSLEnabled = (Boolean)XPackSettings.REMOTE_CLUSTER_SERVER_SSL_ENABLED.get(this.settings);
        for (Map.Entry<String, SslConfiguration> entry : profileConfigurations.entrySet()) {
            boolean useRemoteClusterProfile;
            SslConfiguration profileConfiguration = entry.getValue();
            String profileName = entry.getKey();
            boolean bl = useRemoteClusterProfile = remoteClusterPortEnabled && profileName.equals("_remote_cluster");
            if (useRemoteClusterProfile) {
                profileFilters.put(profileName, new CrossClusterAccessServerTransportFilter(this.crossClusterAccessAuthcService, this.authzService, this.threadPool.getThreadContext(), remoteClusterServerSSLEnabled && SSLService.isSSLClientAuthEnabled((SslConfiguration)profileConfiguration), destructiveOperations, this.securityContext, this.licenseState));
                continue;
            }
            profileFilters.put(profileName, new ServerTransportFilter(this.authcService, this.authzService, this.threadPool.getThreadContext(), transportSSLEnabled && SSLService.isSSLClientAuthEnabled((SslConfiguration)profileConfiguration), destructiveOperations, this.securityContext));
        }
        return Collections.unmodifiableMap(profileFilters);
    }

    public static class ProfileSecuredRequestHandler<T extends TransportRequest>
    implements TransportRequestHandler<T> {
        private final String action;
        private final TransportRequestHandler<T> handler;
        private final Map<String, ServerTransportFilter> profileFilters;
        private final ThreadContext threadContext;
        private final Executor executor;
        private final ThreadPool threadPool;
        private final boolean forceExecution;
        private final Logger logger;

        ProfileSecuredRequestHandler(Logger logger, String action, boolean forceExecution, Executor executor, TransportRequestHandler<T> handler, Map<String, ServerTransportFilter> profileFilters, ThreadPool threadPool) {
            this.logger = logger;
            this.action = action;
            this.executor = executor;
            this.handler = handler;
            this.profileFilters = profileFilters;
            this.threadContext = threadPool.getThreadContext();
            this.threadPool = threadPool;
            this.forceExecution = forceExecution;
        }

        AbstractRunnable getReceiveRunnable(T request, final TransportChannel channel, Task task) {
            RunOnce releaseRequest = new RunOnce(() -> request.decRef());
            request.mustIncRef();
            return new AbstractRunnable((TransportRequest)request, task, (Runnable)releaseRequest){
                final /* synthetic */ TransportRequest val$request;
                final /* synthetic */ Task val$task;
                final /* synthetic */ Runnable val$releaseRequest;
                {
                    this.val$request = transportRequest;
                    this.val$task = task;
                    this.val$releaseRequest = runnable;
                }

                public boolean isForceExecution() {
                    return forceExecution;
                }

                public void onFailure(Exception e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        e1.addSuppressed(e);
                        logger.warn("failed to send exception response for action [" + action + "]", (Throwable)e1);
                    }
                }

                protected void doRun() throws Exception {
                    handler.messageReceived(this.val$request, channel, this.val$task);
                }

                public void onAfter() {
                    this.val$releaseRequest.run();
                }
            };
        }

        public String toString() {
            return "ProfileSecuredRequestHandler{action='" + this.action + "', forceExecution=" + this.forceExecution + "}";
        }

        public void messageReceived(T request, TransportChannel channel, Task task) {
            try (ThreadContext.StoredContext ctx = this.threadContext.newStoredContextPreservingResponseHeaders();){
                AbstractFilterListener filterListener;
                String profile = channel.getProfileName();
                ServerTransportFilter filter = this.getServerTransportFilter(profile);
                assert (filter != null);
                assert (request != null);
                this.logger.trace(() -> Strings.format((String)"Applying transport filter [%s] for transport profile [%s] on request [%s]", (Object[])new Object[]{filter.getClass(), profile, request.getClass()}));
                AbstractRunnable receiveMessage = this.getReceiveRunnable(request, channel, task);
                if (this.executor == EsExecutors.DIRECT_EXECUTOR_SERVICE) {
                    filterListener = new AbstractFilterListener(this, receiveMessage){

                        public void onResponse(Void unused) {
                            this.receiveMessage.run();
                        }
                    };
                } else {
                    final Thread executingThread = Thread.currentThread();
                    filterListener = new AbstractFilterListener(receiveMessage){

                        public void onResponse(Void unused) {
                            if (executingThread == Thread.currentThread()) {
                                this.receiveMessage.run();
                            } else {
                                try {
                                    executor.execute((Runnable)this.receiveMessage);
                                }
                                catch (Exception e) {
                                    this.onFailure(e);
                                }
                            }
                        }
                    };
                }
                filter.inbound(this.action, (TransportRequest)request, channel, filterListener);
            }
        }

        private ServerTransportFilter getServerTransportFilter(String profile) {
            ServerTransportFilter filter = this.profileFilters.get(profile);
            if (filter != null) {
                return filter;
            }
            if (".direct".equals(profile)) {
                return this.profileFilters.get("default");
            }
            String msg = "transport profile [" + profile + "] is not associated with a transport filter";
            throw new IllegalStateException(msg);
        }
    }

    record RemoteClusterCredentials(String clusterAlias, String credentials) {
        @Override
        public String toString() {
            return "RemoteClusterCredentials{clusterAlias='" + this.clusterAlias + "', credentials='::es_redacted::'}";
        }
    }

    private static abstract class AbstractFilterListener
    implements ActionListener<Void> {
        protected final AbstractRunnable receiveMessage;

        protected AbstractFilterListener(AbstractRunnable receiveMessage) {
            this.receiveMessage = receiveMessage;
        }

        public void onFailure(Exception e) {
            try {
                this.receiveMessage.onFailure(e);
            }
            finally {
                this.receiveMessage.onAfter();
            }
        }
    }
}

