/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.apikey.CustomApiKeyAuthenticator;
import org.elasticsearch.xpack.security.authc.Authenticator;

public class PluggableApiKeyAuthenticator
implements Authenticator {
    private final CustomApiKeyAuthenticator authenticator;

    public PluggableApiKeyAuthenticator(CustomApiKeyAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    @Override
    public String name() {
        return this.authenticator.name();
    }

    @Override
    public AuthenticationToken extractCredentials(Authenticator.Context context) {
        return this.authenticator.extractCredentials(context.getApiKeyString());
    }

    @Override
    public void authenticate(Authenticator.Context context, ActionListener<AuthenticationResult<Authentication>> listener) {
        AuthenticationToken authenticationToken = context.getMostRecentAuthenticationToken();
        this.authenticator.authenticate(authenticationToken, ActionListener.wrap(response -> {
            if (response.isAuthenticated()) {
                listener.onResponse(response);
            } else if (response.getStatus() == AuthenticationResult.Status.TERMINATE) {
                Exception ex = response.getException();
                if (ex == null) {
                    listener.onFailure((Exception)((Object)context.getRequest().authenticationFailed(authenticationToken)));
                } else {
                    listener.onFailure((Exception)((Object)context.getRequest().exceptionProcessingRequest(ex, authenticationToken)));
                }
            } else if (response.getStatus() == AuthenticationResult.Status.CONTINUE) {
                listener.onResponse((Object)AuthenticationResult.notHandled());
            }
        }, ex -> listener.onFailure((Exception)((Object)context.getRequest().exceptionProcessingRequest((Exception)ex, authenticationToken)))));
    }
}

