/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.elasticsearch.bootstrap.TestBuildInfo;
import org.elasticsearch.bootstrap.TestBuildInfoLocation;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class TestBuildInfoParser {
    private static final String PLUGIN_TEST_BUILD_INFO_RESOURCES = "META-INF/plugin-test-build-info.json";
    private static final String SERVER_TEST_BUILD_INFO_RESOURCE = "META-INF/server-test-build-info.json";
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("test_build_info", Builder::new);
    private static final ObjectParser<Location, Void> LOCATION_PARSER = new ObjectParser("location", Location::new);

    static TestBuildInfo fromXContent(XContentParser parser) throws IOException {
        return ((Builder)PARSER.parse(parser, null)).build();
    }

    public static List<TestBuildInfo> parseAllPluginTestBuildInfo() throws IOException {
        XContent xContent = XContentFactory.xContent((XContentType)XContentType.JSON);
        ArrayList<TestBuildInfo> pluginsTestBuildInfos = new ArrayList<TestBuildInfo>();
        Enumeration<URL> resources = TestBuildInfoParser.class.getClassLoader().getResources(PLUGIN_TEST_BUILD_INFO_RESOURCES);
        while (resources.hasMoreElements()) {
            InputStream stream = TestBuildInfoParser.getStream(resources.nextElement());
            try {
                XContentParser parser = xContent.createParser(XContentParserConfiguration.EMPTY, stream);
                try {
                    pluginsTestBuildInfos.add(TestBuildInfoParser.fromXContent(parser));
                }
                finally {
                    if (parser == null) continue;
                    parser.close();
                }
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        return pluginsTestBuildInfos;
    }

    public static TestBuildInfo parseServerTestBuildInfo() throws IOException {
        XContent xContent = XContentFactory.xContent((XContentType)XContentType.JSON);
        URL resource = TestBuildInfoParser.class.getClassLoader().getResource(SERVER_TEST_BUILD_INFO_RESOURCE);
        if (resource == null) {
            return null;
        }
        try (InputStream stream = TestBuildInfoParser.getStream(resource);){
            TestBuildInfo testBuildInfo;
            block13: {
                XContentParser parser = xContent.createParser(XContentParserConfiguration.EMPTY, stream);
                try {
                    testBuildInfo = TestBuildInfoParser.fromXContent(parser);
                    if (parser == null) break block13;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return testBuildInfo;
        }
    }

    @SuppressForbidden(reason="URLs from class loader")
    private static InputStream getStream(URL resource) throws IOException {
        return resource.openStream();
    }

    static {
        LOCATION_PARSER.declareString(Location::representativeClass, new ParseField("representative_class", new String[0]));
        LOCATION_PARSER.declareString(Location::module, new ParseField("module", new String[0]));
        PARSER.declareString(Builder::component, new ParseField("component", new String[0]));
        PARSER.declareObjectArray(Builder::locations, LOCATION_PARSER, new ParseField("locations", new String[0]));
    }

    private static final class Builder {
        private String component;
        private List<Location> locations;

        private Builder() {
        }

        public void component(String component) {
            this.component = component;
        }

        public void locations(List<Location> locations) {
            this.locations = locations;
        }

        TestBuildInfo build() {
            return new TestBuildInfo(this.component, this.locations.stream().map(l -> new TestBuildInfoLocation(l.representativeClass, l.module)).toList());
        }
    }

    private static class Location {
        private String representativeClass;
        private String module;

        private Location() {
        }

        public void module(String module) {
            this.module = module;
        }

        public void representativeClass(String representativeClass) {
            this.representativeClass = representativeClass;
        }
    }
}

