/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.h3.H3;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StGeohexToLongFromStringEvaluator;

public class StGeohexToLong
extends AbstractConvertFunction
implements EvaluatorMapper {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "StGeohexToLong", StGeohexToLong::new);
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataType.LONG, (source, fieldEval) -> fieldEval), Map.entry(DataType.KEYWORD, StGeohexToLongFromStringEvaluator.Factory::new));

    @FunctionInfo(returnType={"long"}, preview=true, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW)}, description="Converts an input value representing a geohex grid-ID in string format into a long.", examples={@Example(file="spatial-grid", tag="geohex_to_long")}, depthOffset=1)
    public StGeohexToLong(Source source, @Param(name="grid_id", type={"keyword", "long"}, description="Input geohex grid-id. The input can be a single- or multi-valued column or an expression.") Expression v) {
        super(source, v);
    }

    private StGeohexToLong(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return StGeohexToLong.ENTRY.name;
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataType.LONG;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new StGeohexToLong(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, StGeohexToLong::new, (Object)this.field());
    }

    static long fromString(BytesRef gridId) {
        return H3.stringToH3((String)gridId.utf8ToString());
    }
}

