/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToString;

public final class ToStringFromUnsignedLongEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ToStringFromUnsignedLongEvaluator.class);
    private final EvalOperator.ExpressionEvaluator lng;

    public ToStringFromUnsignedLongEvaluator(Source source, EvalOperator.ExpressionEvaluator lng, DriverContext driverContext) {
        super(driverContext, source);
        this.lng = lng;
    }

    @Override
    public EvalOperator.ExpressionEvaluator next() {
        return this.lng;
    }

    @Override
    public Block evalVector(Vector v) {
        LongVector vector = (LongVector)v;
        int positionCount = v.getPositionCount();
        if (vector.isConstant()) {
            return this.driverContext.blockFactory().newConstantBytesRefBlockWith(this.evalValue(vector, 0), positionCount);
        }
        try (BytesRefBlock.Builder builder = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                builder.appendBytesRef(this.evalValue(vector, p));
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    private BytesRef evalValue(LongVector container, int index) {
        long value = container.getLong(index);
        return ToString.fromUnsignedLong(value);
    }

    @Override
    public Block evalBlock(Block b) {
        LongBlock block = (LongBlock)b;
        int positionCount = block.getPositionCount();
        try (BytesRefBlock.Builder builder = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    BytesRef value = this.evalValue(block, i);
                    if (!positionOpened && valueCount > 1) {
                        builder.beginPositionEntry();
                        positionOpened = true;
                    }
                    builder.appendBytesRef(value);
                    valuesAppended = true;
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    private BytesRef evalValue(LongBlock container, int index) {
        long value = container.getLong(index);
        return ToString.fromUnsignedLong(value);
    }

    public String toString() {
        return "ToStringFromUnsignedLongEvaluator[lng=" + String.valueOf(this.lng) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.lng);
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.lng.baseRamBytesUsed();
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory lng;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory lng) {
            this.source = source;
            this.lng = lng;
        }

        public ToStringFromUnsignedLongEvaluator get(DriverContext context) {
            return new ToStringFromUnsignedLongEvaluator(this.source, this.lng.get(context), context);
        }

        public String toString() {
            return "ToStringFromUnsignedLongEvaluator[lng=" + String.valueOf(this.lng) + "]";
        }
    }
}

