/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.blockhash;

import java.util.BitSet;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.data.sort.LongTopNSet;
import org.elasticsearch.compute.operator.mvdedupe.MultivalueDedupe;
import org.elasticsearch.compute.operator.mvdedupe.TopNMultivalueDedupeLong;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.sort.SortOrder;

final class LongTopNBlockHash
extends BlockHash {
    private final int channel;
    private final boolean asc;
    private final boolean nullsFirst;
    private final int limit;
    private final LongHash hash;
    private final LongTopNSet topValues;
    private boolean hasNull;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LongTopNBlockHash(int channel, boolean asc, boolean nullsFirst, int limit, BlockFactory blockFactory) {
        super(blockFactory);
        assert (limit > 0) : "LongTopNBlockHash requires a limit greater than 0";
        this.channel = channel;
        this.asc = asc;
        this.nullsFirst = nullsFirst;
        this.limit = limit;
        boolean success = false;
        try {
            this.hash = new LongHash(1L, blockFactory.bigArrays());
            this.topValues = new LongTopNSet(blockFactory.bigArrays(), asc ? SortOrder.ASC : SortOrder.DESC, limit);
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    @Override
    public void add(Page page, GroupingAggregatorFunction.AddInput addInput) {
        Object block = page.getBlock(this.channel);
        if (block.areAllValuesNull() && this.acceptNull()) {
            this.hasNull = true;
            try (IntVector groupIds = this.blockFactory.newConstantIntVector(0, block.getPositionCount());){
                addInput.add(0, groupIds);
            }
            return;
        }
        LongBlock castBlock = (LongBlock)block;
        LongVector vector = castBlock.asVector();
        if (vector == null) {
            try (IntBlock groupIds = this.add(castBlock);){
                addInput.add(0, groupIds);
            }
            return;
        }
        try (IntBlock groupIds = this.add(vector);){
            addInput.add(0, groupIds);
        }
    }

    private boolean acceptNull() {
        if (this.hasNull) {
            return true;
        }
        if (this.nullsFirst) {
            this.hasNull = true;
            assert (this.topValues.getLimit() == this.limit) : "The top values can't be reduced twice";
            this.topValues.reduceLimitByOne();
            return true;
        }
        if (this.topValues.getCount() < this.limit) {
            this.hasNull = true;
            return true;
        }
        return false;
    }

    private boolean acceptValue(long value) {
        if (!this.topValues.collect(value)) {
            return false;
        }
        if (this.topValues.getCount() == this.limit && this.hasNull && !this.nullsFirst) {
            this.hasNull = false;
        }
        return true;
    }

    private boolean isAcceptable(long value) {
        return !this.isTopComplete() || this.hasNull && !this.nullsFirst || this.isInTop(value);
    }

    private boolean isInTop(long value) {
        return this.asc ? value <= this.topValues.getWorstValue() : value >= this.topValues.getWorstValue();
    }

    private boolean isTopComplete() {
        return this.topValues.getCount() >= this.limit - (this.hasNull ? 1 : 0);
    }

    IntBlock add(LongVector vector) {
        int positions = vector.getPositionCount();
        for (int i = 0; i < positions; ++i) {
            long v = vector.getLong(i);
            this.acceptValue(v);
        }
        try (IntBlock.Builder builder = this.blockFactory.newIntBlockBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                long v = vector.getLong(i);
                if (this.isAcceptable(v)) {
                    builder.appendInt(Math.toIntExact(LongTopNBlockHash.hashOrdToGroupNullReserved(this.hash.add(v))));
                    continue;
                }
                builder.appendNull();
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    IntBlock add(LongBlock block) {
        for (int p = 0; p < block.getPositionCount(); ++p) {
            int count = block.getValueCount(p);
            if (count == 0) {
                this.acceptNull();
                continue;
            }
            int first = block.getFirstValueIndex(p);
            for (int i = 0; i < count; ++i) {
                long value = block.getLong(first + i);
                this.acceptValue(value);
            }
        }
        MultivalueDedupe.HashResult result = new TopNMultivalueDedupeLong(block, this.hasNull, this::isAcceptable).hashAdd(this.blockFactory, this.hash);
        return result.ords();
    }

    @Override
    public ReleasableIterator<IntBlock> lookup(Page page, ByteSizeValue targetBlockSize) {
        Object block = page.getBlock(this.channel);
        if (block.areAllValuesNull()) {
            return ReleasableIterator.single((Releasable)this.blockFactory.newConstantIntVector(0, block.getPositionCount()).asBlock());
        }
        LongBlock castBlock = (LongBlock)block;
        LongVector vector = castBlock.asVector();
        if (vector == null) {
            return ReleasableIterator.single((Releasable)this.lookup(castBlock));
        }
        return ReleasableIterator.single((Releasable)this.lookup(vector));
    }

    private IntBlock lookup(LongVector vector) {
        int positions = vector.getPositionCount();
        try (IntBlock.Builder builder = this.blockFactory.newIntBlockBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                long v = vector.getLong(i);
                long found = this.hash.find(v);
                if (found < 0L || !this.isAcceptable(v)) {
                    builder.appendNull();
                    continue;
                }
                builder.appendInt(Math.toIntExact(LongTopNBlockHash.hashOrdToGroupNullReserved(found)));
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    private IntBlock lookup(LongBlock block) {
        return new TopNMultivalueDedupeLong(block, this.hasNull, this::isAcceptable).hashLookup(this.blockFactory, this.hash);
    }

    public LongBlock[] getKeys() {
        if (this.hasNull) {
            long[] keys = new long[this.topValues.getCount() + 1];
            int keysIndex = 1;
            int i = 1;
            while ((long)i < this.hash.size() + 1L) {
                long value = this.hash.get((long)(i - 1));
                if (this.isInTop(value)) {
                    keys[keysIndex++] = value;
                }
                ++i;
            }
            BitSet nulls = new BitSet(1);
            nulls.set(0);
            return new LongBlock[]{this.blockFactory.newLongArrayBlock(keys, keys.length, null, nulls, Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING)};
        }
        long[] keys = new long[this.topValues.getCount()];
        int keysIndex = 0;
        int i = 0;
        while ((long)i < this.hash.size()) {
            long value = this.hash.get((long)i);
            if (this.isInTop(value)) {
                keys[keysIndex++] = value;
            }
            ++i;
        }
        return new LongBlock[]{this.blockFactory.newLongArrayVector(keys, keys.length).asBlock()};
    }

    @Override
    public IntVector nonEmpty() {
        int nullOffset = this.hasNull ? 1 : 0;
        int[] ids = new int[this.topValues.getCount() + nullOffset];
        int idsIndex = nullOffset;
        int i = 1;
        while ((long)i < this.hash.size() + 1L) {
            long value = this.hash.get((long)(i - 1));
            if (this.isInTop(value)) {
                ids[idsIndex++] = i;
            }
            ++i;
        }
        return this.blockFactory.newIntArrayVector(ids, ids.length);
    }

    @Override
    public BitArray seenGroupIds(BigArrays bigArrays) {
        BitArray seenGroups = new BitArray(1L, bigArrays);
        if (this.hasNull) {
            seenGroups.set(0L);
        }
        int i = 1;
        while ((long)i < this.hash.size() + 1L) {
            long value = this.hash.get((long)(i - 1));
            if (this.isInTop(value)) {
                seenGroups.set((long)i);
            }
            ++i;
        }
        return seenGroups;
    }

    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.hash, this.topValues});
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LongTopNBlockHash{channel=").append(this.channel);
        b.append(", asc=").append(this.asc);
        b.append(", nullsFirst=").append(this.nullsFirst);
        b.append(", limit=").append(this.limit);
        b.append(", entries=").append(this.hash.size());
        b.append(", hasNull=").append(this.hasNull);
        return b.append('}').toString();
    }
}

