/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.sniff.ElasticsearchNodesSniffer;
import org.elasticsearch.client.sniff.NodesSniffer;
import org.elasticsearch.client.sniff.Sniffer;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.ssl.SslConfiguration;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.monitoring.Monitoring;
import org.elasticsearch.xpack.monitoring.MonitoringTemplateRegistry;
import org.elasticsearch.xpack.monitoring.exporter.ClusterAlertsUtil;
import org.elasticsearch.xpack.monitoring.exporter.ExportBulk;
import org.elasticsearch.xpack.monitoring.exporter.Exporter;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringMigrationCoordinator;
import org.elasticsearch.xpack.monitoring.exporter.http.ClusterAlertHttpResource;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpExportBulk;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpHostBuilder;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpResource;
import org.elasticsearch.xpack.monitoring.exporter.http.MultiHttpResource;
import org.elasticsearch.xpack.monitoring.exporter.http.NodeFailureListener;
import org.elasticsearch.xpack.monitoring.exporter.http.SecurityHttpClientConfigCallback;
import org.elasticsearch.xpack.monitoring.exporter.http.TemplateHttpResource;
import org.elasticsearch.xpack.monitoring.exporter.http.TimeoutRequestConfigCallback;
import org.elasticsearch.xpack.monitoring.exporter.http.VersionHttpResource;
import org.elasticsearch.xpack.monitoring.exporter.http.WatcherExistsHttpResource;

public class HttpExporter
extends Exporter {
    private static final Logger logger = LogManager.getLogger(HttpExporter.class);
    public static final String TYPE = "http";
    private static final Setting.AffixSettingDependency HTTP_TYPE_DEPENDENCY = new Setting.AffixSettingDependency(){

        public Setting.AffixSetting<String> getSetting() {
            return Exporter.TYPE_SETTING;
        }

        public void validate(String key, Object value, Object dependency) {
            if (!HttpExporter.TYPE.equals(dependency)) {
                throw new SettingsException("[" + key + "] is set but type is [" + String.valueOf(dependency) + "]");
            }
        }
    };
    public static final Setting.AffixSetting<List<String>> HOST_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"host", key -> Setting.stringListSetting((String)key, (Setting.Validator)new Setting.Validator<List<String>>(){

        public void validate(List<String> value) {
        }

        public void validate(List<String> hosts, Map<Setting<?>, Object> settings) {
            String namespace = HOST_SETTING.getNamespace(HOST_SETTING.getConcreteSetting(key));
            String type = (String)settings.get(Exporter.TYPE_SETTING.getConcreteSettingForNamespace(namespace));
            if (hosts.isEmpty()) {
                String defaultType = (String)Exporter.TYPE_SETTING.getConcreteSettingForNamespace(namespace).get(Settings.EMPTY);
                if (Objects.equals(type, defaultType)) {
                    return;
                }
                throw new SettingsException("host list for [" + key + "] is empty but type is [" + type + "]");
            }
            boolean httpHostFound = false;
            boolean httpsHostFound = false;
            for (String host : hosts) {
                HttpHost httpHost;
                try {
                    httpHost = HttpHostBuilder.builder(host).build();
                }
                catch (IllegalArgumentException e) {
                    throw new SettingsException("[" + key + "] invalid host: [" + host + "]", (Throwable)e);
                }
                if (HttpExporter.TYPE.equals(httpHost.getSchemeName())) {
                    httpHostFound = true;
                } else {
                    httpsHostFound = true;
                }
                if (!httpHostFound || !httpsHostFound) continue;
                throw new SettingsException("[" + key + "] must use a consistent scheme: http or https");
            }
        }

        public Iterator<Setting<?>> settings() {
            String namespace = HOST_SETTING.getNamespace(HOST_SETTING.getConcreteSetting(key));
            List<Setting> settings = List.of(Exporter.TYPE_SETTING.getConcreteSettingForNamespace(namespace));
            return settings.iterator();
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.DeprecatedWarning}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{HTTP_TYPE_DEPENDENCY});
    public static final Setting.AffixSetting<TimeValue> BULK_TIMEOUT_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"bulk.timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.MINUS_ONE, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.DeprecatedWarning}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{HTTP_TYPE_DEPENDENCY});
    public static final Setting.AffixSetting<TimeValue> CONNECTION_TIMEOUT_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"connection.timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueSeconds((long)6L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.DeprecatedWarning}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{HTTP_TYPE_DEPENDENCY});
    public static final Setting.AffixSetting<TimeValue> CONNECTION_READ_TIMEOUT_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"connection.read_timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueSeconds((long)60L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.DeprecatedWarning}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{HTTP_TYPE_DEPENDENCY});
    public static final Setting.AffixSetting<String> AUTH_USERNAME_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"auth.username", key -> Setting.simpleString((String)key, (Setting.Validator)new Setting.Validator<String>(){

        public void validate(String password) {
        }

        public void validate(String username, Map<Setting<?>, Object> settings) {
            String type;
            String namespace = AUTH_USERNAME_SETTING.getNamespace(AUTH_USERNAME_SETTING.getConcreteSetting(key));
            if (!Strings.isNullOrEmpty((String)username) && !HttpExporter.TYPE.equals(type = (String)settings.get(Exporter.TYPE_SETTING.getConcreteSettingForNamespace(namespace)))) {
                throw new SettingsException("username for [" + key + "] is set but type is [" + type + "]");
            }
        }

        public Iterator<Setting<?>> settings() {
            String namespace = AUTH_USERNAME_SETTING.getNamespace(AUTH_USERNAME_SETTING.getConcreteSetting(key));
            List<Setting> settings = List.of(Exporter.TYPE_SETTING.getConcreteSettingForNamespace(namespace));
            return settings.iterator();
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.DeprecatedWarning}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{HTTP_TYPE_DEPENDENCY});
    public static final Setting.AffixSetting<SecureString> AUTH_SECURE_PASSWORD_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"auth.secure_password", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[]{Setting.Property.DeprecatedWarning}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{HTTP_TYPE_DEPENDENCY});
    public static final Setting.AffixSetting<Settings> SSL_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"ssl", key -> Setting.groupSetting((String)(key + "."), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.DeprecatedWarning}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{HTTP_TYPE_DEPENDENCY});
    public static final Setting.AffixSetting<String> PROXY_BASE_PATH_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"proxy.base_path", key -> Setting.simpleString((String)key, value -> {
        if (!Strings.isNullOrEmpty((String)value)) {
            try {
                RestClientBuilder.cleanPathPrefix((String)value);
            }
            catch (RuntimeException e) {
                Setting concreteSetting = PROXY_BASE_PATH_SETTING.getConcreteSetting(key);
                throw new SettingsException("[" + concreteSetting.getKey() + "] is malformed [" + value + "]", (Throwable)e);
            }
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.DeprecatedWarning}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{HTTP_TYPE_DEPENDENCY});
    public static final Setting.AffixSetting<Boolean> SNIFF_ENABLED_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"sniff.enabled", key -> Setting.boolSetting((String)key, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.DeprecatedWarning}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{HTTP_TYPE_DEPENDENCY});
    public static final Setting.AffixSetting<Settings> HEADERS_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"headers", key -> Setting.groupSetting((String)(key + "."), settings -> {
        Set names = settings.names();
        for (String name : names) {
            String fullSetting = key + "." + name;
            if (BLACKLISTED_HEADERS.contains(name)) {
                throw new SettingsException("header cannot be overwritten via [" + fullSetting + "]");
            }
            List values = settings.getAsList(name);
            if (!values.isEmpty()) continue;
            throw new SettingsException("headers must have values, missing for setting [" + fullSetting + "]");
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.DeprecatedWarning}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{HTTP_TYPE_DEPENDENCY});
    public static final Set<String> BLACKLISTED_HEADERS = Set.of("Content-Length", "Content-Type");
    public static final Setting.AffixSetting<TimeValue> TEMPLATE_CHECK_TIMEOUT_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"index.template.master_timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.MINUS_ONE, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.DeprecatedWarning}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{HTTP_TYPE_DEPENDENCY});
    public static final Version MIN_SUPPORTED_CLUSTER_VERSION = Version.V_7_0_0;
    private final RestClient client;
    @Nullable
    private final Sniffer sniffer;
    private final Map<String, String> defaultParams;
    private final HttpResource resource;
    private final HttpResource alertingResource;
    private final AtomicBoolean clusterAlertsAllowed = new AtomicBoolean(false);
    private final MonitoringMigrationCoordinator migrationCoordinator;
    private static final ConcurrentHashMap<String, SecureString> SECURE_AUTH_PASSWORDS = new ConcurrentHashMap();
    private final ThreadContext threadContext;
    private final DateFormatter dateTimeFormatter;
    private final ClusterStateListener onLocalMasterListener;

    public HttpExporter(Exporter.Config config, SSLService sslService, ThreadContext threadContext, MonitoringMigrationCoordinator migrationCoordinator) {
        this(config, sslService, threadContext, migrationCoordinator, new NodeFailureListener(), HttpExporter.createResources(config));
    }

    private HttpExporter(Exporter.Config config, SSLService sslService, ThreadContext threadContext, MonitoringMigrationCoordinator migrationCoordinator, NodeFailureListener listener, Resources resource) {
        this(config, sslService, threadContext, migrationCoordinator, listener, (HttpResource)resource.allResources, resource.alertingResource);
    }

    HttpExporter(Exporter.Config config, SSLService sslService, ThreadContext threadContext, MonitoringMigrationCoordinator migrationCoordinator, NodeFailureListener listener, HttpResource resource, HttpResource alertingResource) {
        this(config, HttpExporter.createRestClient(config, sslService, listener), threadContext, migrationCoordinator, listener, resource, alertingResource);
    }

    HttpExporter(Exporter.Config config, RestClient client, ThreadContext threadContext, MonitoringMigrationCoordinator migrationCoordinator, NodeFailureListener listener, HttpResource resource, HttpResource alertingResource) {
        this(config, client, HttpExporter.createSniffer(config, client, listener), threadContext, migrationCoordinator, listener, resource, alertingResource);
    }

    HttpExporter(Exporter.Config config, RestClient client, @Nullable Sniffer sniffer, ThreadContext threadContext, MonitoringMigrationCoordinator migrationCoordinator, NodeFailureListener listener, HttpResource resource, HttpResource alertingResource) {
        super(config);
        this.client = Objects.requireNonNull(client);
        this.sniffer = sniffer;
        this.resource = resource;
        this.alertingResource = alertingResource;
        this.defaultParams = HttpExporter.createDefaultParams(config);
        this.threadContext = threadContext;
        this.migrationCoordinator = migrationCoordinator;
        this.dateTimeFormatter = HttpExporter.dateTimeFormatter(config);
        listener.setResource(resource);
        this.onLocalMasterListener = clusterChangedEvent -> {
            if (clusterChangedEvent.nodesDelta().masterNodeChanged() && clusterChangedEvent.localNodeMaster()) {
                resource.markDirty();
            }
        };
        config.clusterService().addListener(this.onLocalMasterListener);
    }

    public static void registerSettingValidators(ClusterService clusterService, SSLService sslService) {
        clusterService.getClusterSettings().addAffixUpdateConsumer(SSL_SETTING, (ignoreKey, ignoreSettings) -> {}, (key, settings) -> {
            HttpExporter.validateSslSettings(key, settings);
            HttpExporter.configureSslStrategy(settings, null, sslService);
        });
    }

    private static void validateSslSettings(String exporter, Settings settings) {
        List<String> secureSettings = SSLConfigurationSettings.withoutPrefix((boolean)true).getSecureSettingsInUse(settings).stream().map(Setting::getKey).toList();
        if (!secureSettings.isEmpty()) {
            throw new IllegalStateException("Cannot dynamically update SSL settings for the exporter [" + exporter + "] as it depends on the secure setting(s) [" + Strings.collectionToCommaDelimitedString(secureSettings) + "]");
        }
    }

    static RestClient createRestClient(Exporter.Config config, SSLService sslService, NodeFailureListener listener) {
        RestClientBuilder builder = RestClient.builder((HttpHost[])HttpExporter.createHosts(config)).setFailureListener((RestClient.FailureListener)listener);
        Setting concreteSetting = PROXY_BASE_PATH_SETTING.getConcreteSettingForNamespace(config.name());
        String proxyBasePath = (String)concreteSetting.get(config.settings());
        if (!Strings.isNullOrEmpty((String)proxyBasePath)) {
            try {
                builder.setPathPrefix(proxyBasePath);
            }
            catch (IllegalArgumentException e) {
                throw new SettingsException("[" + concreteSetting.getKey() + "] is malformed [" + proxyBasePath + "]", (Throwable)e);
            }
        }
        HttpExporter.configureHeaders(builder, config);
        HttpExporter.configureSecurity(builder, config, sslService);
        HttpExporter.configureTimeouts(builder, config);
        return builder.build();
    }

    static Sniffer createSniffer(Exporter.Config config, RestClient client, NodeFailureListener listener) {
        Sniffer sniffer = null;
        boolean sniffingEnabled = (Boolean)SNIFF_ENABLED_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        if (sniffingEnabled) {
            List hosts = (List)HOST_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
            ElasticsearchNodesSniffer.Scheme scheme = ((String)hosts.get(0)).startsWith("https") ? ElasticsearchNodesSniffer.Scheme.HTTPS : ElasticsearchNodesSniffer.Scheme.HTTP;
            ElasticsearchNodesSniffer hostsSniffer = new ElasticsearchNodesSniffer(client, ElasticsearchNodesSniffer.DEFAULT_SNIFF_REQUEST_TIMEOUT, scheme);
            sniffer = Sniffer.builder((RestClient)client).setNodesSniffer((NodesSniffer)hostsSniffer).build();
            listener.setSniffer(sniffer);
            logger.debug("exporter [{}] using host sniffing", (Object)config.name());
        }
        return sniffer;
    }

    static Resources createResources(Exporter.Config config) {
        String resourceOwnerName = "xpack.monitoring.exporters." + config.name();
        ArrayList<HttpResource> resources = new ArrayList<HttpResource>();
        resources.add(new VersionHttpResource(resourceOwnerName, MIN_SUPPORTED_CLUSTER_VERSION));
        HttpExporter.configureTemplateResources(config, resourceOwnerName, resources);
        HttpResource alertingResource = HttpExporter.configureClusterAlertsResources(config, resourceOwnerName);
        if (alertingResource != null) {
            resources.add(alertingResource);
        }
        return new Resources(new MultiHttpResource(resourceOwnerName, resources), alertingResource);
    }

    private static HttpHost[] createHosts(Exporter.Config config) {
        List hosts = (List)HOST_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        ArrayList<HttpHost> httpHosts = new ArrayList<HttpHost>(hosts.size());
        for (String host : hosts) {
            HttpHost httpHost = HttpHostBuilder.builder(host).build();
            httpHosts.add(httpHost);
        }
        logger.debug("exporter [{}] using hosts {}", (Object)config.name(), (Object)hosts);
        return httpHosts.toArray(new HttpHost[0]);
    }

    private static void configureHeaders(RestClientBuilder builder, Exporter.Config config) {
        Setting concreteSetting = HEADERS_SETTING.getConcreteSettingForNamespace(config.name());
        Settings headerSettings = (Settings)concreteSetting.get(config.settings());
        Set names = headerSettings.names();
        if (names.isEmpty()) {
            return;
        }
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        for (String name : names) {
            List values = headerSettings.getAsList(name);
            for (String value : values) {
                headers.add(new BasicHeader(name, value));
            }
        }
        builder.setDefaultHeaders(headers.toArray(new Header[headers.size()]));
    }

    private static void configureSecurity(RestClientBuilder builder, Exporter.Config config, SSLService sslService) {
        Setting concreteSetting = SSL_SETTING.getConcreteSettingForNamespace(config.name());
        Settings sslSettings = (Settings)concreteSetting.get(config.settings());
        SSLIOSessionStrategy sslStrategy = HttpExporter.configureSslStrategy(sslSettings, (Setting<Settings>)concreteSetting, sslService);
        CredentialsProvider credentialsProvider = HttpExporter.createCredentialsProvider(config);
        List hostList = (List)HOST_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        if (credentialsProvider != null && !hostList.stream().findFirst().orElse("").startsWith("https")) {
            logger.warn("exporter [{}] is not using https, but using user authentication with plaintext username/password!", (Object)config.name());
        }
        if (sslStrategy != null) {
            builder.setHttpClientConfigCallback((RestClientBuilder.HttpClientConfigCallback)new SecurityHttpClientConfigCallback(sslStrategy, credentialsProvider));
        }
    }

    private static SSLIOSessionStrategy configureSslStrategy(Settings sslSettings, Setting<Settings> concreteSetting, SSLService sslService) {
        SSLIOSessionStrategy sslStrategy;
        if (SSLConfigurationSettings.withoutPrefix((boolean)true).getSecureSettingsInUse(sslSettings).isEmpty()) {
            sslStrategy = sslService.sslIOSessionStrategy(sslSettings);
        } else {
            SslConfiguration sslConfiguration = sslService.getSSLConfiguration(concreteSetting.getKey());
            sslStrategy = sslService.sslIOSessionStrategy(sslConfiguration);
        }
        return sslStrategy;
    }

    private static void configureTimeouts(RestClientBuilder builder, Exporter.Config config) {
        TimeValue connectTimeout = (TimeValue)CONNECTION_TIMEOUT_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        TimeValue socketTimeout = (TimeValue)CONNECTION_READ_TIMEOUT_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        builder.setRequestConfigCallback((RestClientBuilder.RequestConfigCallback)new TimeoutRequestConfigCallback(connectTimeout, socketTimeout));
    }

    public static List<String> loadSettings(Settings settings) {
        ArrayList<String> changedExporters = new ArrayList<String>();
        for (String namespace : AUTH_SECURE_PASSWORD_SETTING.getNamespaces(settings)) {
            SecureString existingPassword;
            Setting s = AUTH_SECURE_PASSWORD_SETTING.getConcreteSettingForNamespace(namespace);
            SecureString securePassword = (SecureString)s.get(settings);
            if (securePassword.equals((Object)(existingPassword = SECURE_AUTH_PASSWORDS.put(namespace, securePassword)))) continue;
            changedExporters.add(namespace);
        }
        return changedExporters;
    }

    @Nullable
    static CredentialsProvider createCredentialsProvider(Exporter.Config config) {
        String username = (String)AUTH_USERNAME_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        if (Strings.isNullOrEmpty((String)username)) {
            return null;
        }
        SecureString securePassword = SECURE_AUTH_PASSWORDS.get(config.name());
        String password = securePassword != null ? securePassword.toString() : null;
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        return credentialsProvider;
    }

    static Map<String, String> createDefaultParams(Exporter.Config config) {
        TimeValue bulkTimeout = (TimeValue)BULK_TIMEOUT_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(3);
        if (!TimeValue.MINUS_ONE.equals((Object)bulkTimeout)) {
            entries.add(Map.entry("timeout", bulkTimeout.toString()));
        }
        entries.add(Map.entry("filter_path", "errors,items.*.error"));
        return Maps.ofEntries(entries);
    }

    private static void configureTemplateResources(Exporter.Config config, String resourceOwnerName, List<HttpResource> resources) {
        TimeValue templateTimeout = (TimeValue)TEMPLATE_CHECK_TIMEOUT_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        for (String templateName : MonitoringTemplateRegistry.TEMPLATE_NAMES) {
            resources.add(new TemplateHttpResource(resourceOwnerName, templateTimeout, templateName));
        }
    }

    private static HttpResource configureClusterAlertsResources(Exporter.Config config, String resourceOwnerName) {
        if (((Boolean)CLUSTER_ALERTS_MANAGEMENT_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings())).booleanValue()) {
            ClusterService clusterService = config.clusterService();
            ArrayList<ClusterAlertHttpResource> watchResources = new ArrayList<ClusterAlertHttpResource>();
            List<String> blacklist = ClusterAlertsUtil.getClusterAlertsBlacklist(config);
            for (String watchId : ClusterAlertsUtil.WATCH_IDS) {
                boolean blacklisted = blacklist.contains(watchId) || (Boolean)Monitoring.MIGRATION_DECOMMISSION_ALERTS.get(config.settings()) != false;
                Supplier<String> uniqueWatchId = () -> ClusterAlertsUtil.createUniqueWatchId(clusterService, watchId);
                Supplier<String> watch = blacklisted ? null : () -> ClusterAlertsUtil.loadWatch(clusterService, watchId);
                watchResources.add(new ClusterAlertHttpResource(resourceOwnerName, config.licenseState(), uniqueWatchId, watch));
            }
            return new WatcherExistsHttpResource(resourceOwnerName, clusterService, new MultiHttpResource(resourceOwnerName, watchResources));
        }
        return null;
    }

    @Override
    public void removeAlerts(Consumer<Exporter.ExporterResourceStatus> listener) {
        this.alertingResource.checkAndPublish(this.client, (ActionListener<HttpResource.ResourcePublishResult>)ActionListener.wrap(result -> {
            Exporter.ExporterResourceStatus status;
            if (result.isSuccess()) {
                status = Exporter.ExporterResourceStatus.ready(this.name(), TYPE);
            } else {
                status = switch (result.getResourceState()) {
                    default -> throw new MatchException(null, null);
                    case HttpResource.State.CLEAN -> Exporter.ExporterResourceStatus.ready(this.name(), TYPE);
                    case HttpResource.State.CHECKING, HttpResource.State.DIRTY -> Exporter.ExporterResourceStatus.notReady(this.name(), TYPE, result.getReason(), new Object[0]);
                };
            }
            listener.accept(status);
        }, exception -> listener.accept(Exporter.ExporterResourceStatus.notReady(this.name(), TYPE, exception))));
    }

    @Override
    public void openBulk(ActionListener<ExportBulk> listener) {
        boolean canUseClusterAlerts = Monitoring.MONITORING_CLUSTER_ALERTS_FEATURE.check(this.config.licenseState());
        if (this.clusterAlertsAllowed.compareAndSet(!canUseClusterAlerts, canUseClusterAlerts)) {
            this.resource.markDirty();
        }
        if (this.migrationCoordinator.canInstall()) {
            this.resource.checkAndPublishIfDirty(this.client, (ActionListener<Boolean>)listener.delegateFailureAndWrap((delegate, success) -> {
                if (success.booleanValue()) {
                    String name = "xpack.monitoring.exporters." + this.config.name();
                    delegate.onResponse((Object)new HttpExportBulk(name, this.client, this.defaultParams, this.dateTimeFormatter, this.threadContext));
                } else {
                    delegate.onResponse(null);
                }
            }));
        } else {
            listener.onResponse(null);
        }
    }

    @Override
    public void doClose() {
        try {
            this.config.clusterService().removeListener(this.onLocalMasterListener);
            if (this.sniffer != null) {
                this.sniffer.close();
            }
        }
        catch (Exception e) {
            logger.error("an error occurred while closing the internal client sniffer", (Throwable)e);
        }
        finally {
            try {
                this.client.close();
            }
            catch (Exception e) {
                logger.error("an error occurred while closing the internal client", (Throwable)e);
            }
        }
    }

    public static List<Setting.AffixSetting<?>> getDynamicSettings() {
        return Arrays.asList(HOST_SETTING, AUTH_USERNAME_SETTING, BULK_TIMEOUT_SETTING, CONNECTION_READ_TIMEOUT_SETTING, CONNECTION_TIMEOUT_SETTING, PROXY_BASE_PATH_SETTING, SNIFF_ENABLED_SETTING, TEMPLATE_CHECK_TIMEOUT_SETTING, SSL_SETTING, HEADERS_SETTING);
    }

    public static List<Setting.AffixSetting<?>> getSecureSettings() {
        return List.of(AUTH_SECURE_PASSWORD_SETTING);
    }

    public static List<Setting.AffixSetting<?>> getSettings() {
        ArrayList allSettings = new ArrayList(HttpExporter.getDynamicSettings());
        allSettings.addAll(HttpExporter.getSecureSettings());
        return allSettings;
    }

    static class Resources {
        MultiHttpResource allResources;
        HttpResource alertingResource;

        Resources(MultiHttpResource allResources, HttpResource alertingResource) {
            this.allResources = allResources;
            this.alertingResource = alertingResource;
        }
    }
}

