/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.migrate.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.TransportDeleteIndexAction;
import org.elasticsearch.action.admin.indices.rollover.RolloverAction;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsAction;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.put.TransportUpdateSettingsAction;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.datastreams.GetDataStreamAction;
import org.elasticsearch.action.datastreams.ModifyDataStreamsAction;
import org.elasticsearch.action.support.CountDownActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamAction;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.deprecation.DeprecatedIndexPredicate;
import org.elasticsearch.xpack.core.ilm.action.ILMActions;
import org.elasticsearch.xpack.core.ilm.action.RetryActionRequest;
import org.elasticsearch.xpack.migrate.action.ReindexDataStreamIndexAction;
import org.elasticsearch.xpack.migrate.task.ReindexDataStreamPersistentTaskState;
import org.elasticsearch.xpack.migrate.task.ReindexDataStreamTask;
import org.elasticsearch.xpack.migrate.task.ReindexDataStreamTaskParams;

public class ReindexDataStreamPersistentTaskExecutor
extends PersistentTasksExecutor<ReindexDataStreamTaskParams> {
    public static final Setting<Integer> MAX_CONCURRENT_INDICES_REINDEXED_PER_DATA_STREAM_SETTING = Setting.intSetting((String)"migrate.max_concurrent_indices_reindexed_per_data_stream", (int)1, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private static final Logger logger = LogManager.getLogger(ReindexDataStreamPersistentTaskExecutor.class);
    private static final TimeValue TASK_KEEP_ALIVE_TIME = TimeValue.timeValueDays((long)1L);
    private final Client client;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;

    public ReindexDataStreamPersistentTaskExecutor(Client client, ClusterService clusterService, String taskName, ThreadPool threadPool) {
        super(taskName, (Executor)threadPool.generic());
        this.client = client;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
    }

    protected ReindexDataStreamTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetadata.PersistentTask<ReindexDataStreamTaskParams> taskInProgress, Map<String, String> headers) {
        ReindexDataStreamTaskParams params = (ReindexDataStreamTaskParams)taskInProgress.getParams();
        return new ReindexDataStreamTask(this.clusterService, params.startTime(), params.totalIndices(), params.totalIndicesToBeUpgraded(), id, type, action, "Reindexing data stream " + ((ReindexDataStreamTaskParams)taskInProgress.getParams()).getSourceDataStream(), parentTaskId, headers);
    }

    protected void nodeOperation(AllocatedPersistentTask task, ReindexDataStreamTaskParams params, PersistentTaskState persistentTaskState) {
        Long completionTime = this.getCompletionTime(persistentTaskState);
        if (completionTime != null && task instanceof ReindexDataStreamTask) {
            ReindexDataStreamTask reindexDataStreamTask = (ReindexDataStreamTask)task;
            reindexDataStreamTask.allReindexesCompleted(this.threadPool, this.getTimeToLive(completionTime));
            return;
        }
        ReindexDataStreamPersistentTaskState state = (ReindexDataStreamPersistentTaskState)persistentTaskState;
        String sourceDataStream = params.getSourceDataStream();
        TaskId taskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        GetDataStreamAction.Request request = new GetDataStreamAction.Request(TimeValue.MAX_VALUE, new String[]{sourceDataStream});
        request.setParentTask(taskId);
        assert (task instanceof ReindexDataStreamTask);
        ReindexDataStreamTask reindexDataStreamTask = (ReindexDataStreamTask)task;
        this.client.execute((ActionType)GetDataStreamAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(response -> {
            List dataStreamInfos = response.getDataStreams();
            if (dataStreamInfos.size() == 1) {
                DataStream dataStream = ((GetDataStreamAction.Response.DataStreamInfo)dataStreamInfos.getFirst()).getDataStream();
                boolean includeSystem = dataStream.isSystem();
                if (DeprecatedIndexPredicate.getReindexRequiredPredicate((ProjectMetadata)this.clusterService.state().metadata().getProject(), (boolean)false, (boolean)includeSystem).test(dataStream.getWriteIndex())) {
                    RolloverRequest rolloverRequest = new RolloverRequest(sourceDataStream, null);
                    rolloverRequest.setParentTask(taskId);
                    this.client.execute((ActionType)RolloverAction.INSTANCE, (ActionRequest)rolloverRequest, ActionListener.wrap(rolloverResponse -> this.reindexIndices(dataStream, dataStream.getIndices().size() + 1, reindexDataStreamTask, params, state, sourceDataStream, taskId), e -> this.completeFailedPersistentTask(reindexDataStreamTask, state, (Exception)e)));
                } else {
                    this.reindexIndices(dataStream, dataStream.getIndices().size(), reindexDataStreamTask, params, state, sourceDataStream, taskId);
                }
            } else {
                this.completeFailedPersistentTask(reindexDataStreamTask, state, (Exception)new ElasticsearchException("data stream does not exist", new Object[0]));
            }
        }, exception -> this.completeFailedPersistentTask(reindexDataStreamTask, state, (Exception)exception)));
    }

    private void reindexIndices(DataStream dataStream, int totalIndicesInDataStream, ReindexDataStreamTask reindexDataStreamTask, ReindexDataStreamTaskParams params, ReindexDataStreamPersistentTaskState state, String sourceDataStream, TaskId parentTaskId) {
        ReindexDataStreamPersistentTaskState updatedState;
        List indices = dataStream.getIndices();
        List indicesToBeReindexed = indices.stream().filter(DeprecatedIndexPredicate.getReindexRequiredPredicate((ProjectMetadata)this.clusterService.state().metadata().getProject(), (boolean)false, (boolean)dataStream.isSystem())).toList();
        if (params.totalIndices() != totalIndicesInDataStream || params.totalIndicesToBeUpgraded() != indicesToBeReindexed.size() || state != null && state.totalIndices() != null && state.totalIndicesToBeUpgraded() != null && (state.totalIndices() != totalIndicesInDataStream || state.totalIndicesToBeUpgraded().intValue() != indicesToBeReindexed.size())) {
            updatedState = new ReindexDataStreamPersistentTaskState(totalIndicesInDataStream, indicesToBeReindexed.size(), state == null ? null : state.completionTime());
            reindexDataStreamTask.updatePersistentTaskState(updatedState, ActionListener.noop());
        } else {
            updatedState = state;
        }
        reindexDataStreamTask.setPendingIndicesCount(indicesToBeReindexed.size());
        CountDownActionListener listener = new CountDownActionListener(indicesToBeReindexed.size() + 1, ActionListener.wrap(response1 -> this.completeSuccessfulPersistentTask(reindexDataStreamTask, updatedState), exception -> this.completeFailedPersistentTask(reindexDataStreamTask, updatedState, (Exception)exception)));
        int maxConcurrentIndices = (Integer)this.clusterService.getClusterSettings().get(MAX_CONCURRENT_INDICES_REINDEXED_PER_DATA_STREAM_SETTING);
        List<Index> indicesRemaining = Collections.synchronizedList(new ArrayList(indicesToBeReindexed));
        logger.debug("Reindexing {} indices, with up to {} handled concurrently", (Object)indicesRemaining.size(), (Object)maxConcurrentIndices);
        for (int i = 0; i < maxConcurrentIndices; ++i) {
            this.maybeProcessNextIndex(indicesRemaining, reindexDataStreamTask, sourceDataStream, listener, parentTaskId);
        }
        listener.onResponse(null);
    }

    private void maybeProcessNextIndex(List<Index> indicesRemaining, ReindexDataStreamTask reindexDataStreamTask, String sourceDataStream, CountDownActionListener listener, TaskId parentTaskId) {
        Index index;
        if (indicesRemaining.isEmpty()) {
            return;
        }
        try {
            index = indicesRemaining.removeFirst();
        }
        catch (NoSuchElementException e2) {
            return;
        }
        reindexDataStreamTask.incrementInProgressIndicesCount(index.getName());
        ReindexDataStreamIndexAction.Request reindexDataStreamIndexRequest = new ReindexDataStreamIndexAction.Request(index.getName());
        reindexDataStreamIndexRequest.setParentTask(parentTaskId);
        SubscribableListener.newForked(l -> this.client.execute(ReindexDataStreamIndexAction.INSTANCE, (ActionRequest)reindexDataStreamIndexRequest, l)).andThen((l, result) -> this.updateDataStream(sourceDataStream, index.getName(), result.getDestIndex(), (ActionListener<String>)l, parentTaskId)).andThen((l, newIndex) -> this.copySettings(index.getName(), (String)newIndex, (ActionListener<AcknowledgedResponse>)l, parentTaskId)).andThen(l -> this.deleteIndex(index.getName(), parentTaskId, (ActionListener<AcknowledgedResponse>)l)).addListener(ActionListener.wrap(unused -> {
            reindexDataStreamTask.reindexSucceeded(index.getName());
            listener.onResponse(null);
            this.maybeProcessNextIndex(indicesRemaining, reindexDataStreamTask, sourceDataStream, listener, parentTaskId);
        }, e -> {
            reindexDataStreamTask.reindexFailed(index.getName(), (Exception)e);
            listener.onResponse(null);
            this.maybeProcessNextIndex(indicesRemaining, reindexDataStreamTask, sourceDataStream, listener, parentTaskId);
        }));
    }

    private void updateDataStream(String dataStream, String oldIndex, String newIndex, ActionListener<String> listener, TaskId parentTaskId) {
        ModifyDataStreamsAction.Request modifyDataStreamRequest = new ModifyDataStreamsAction.Request(TimeValue.MAX_VALUE, TimeValue.MAX_VALUE, List.of(DataStreamAction.removeBackingIndex((String)dataStream, (String)oldIndex), DataStreamAction.addBackingIndex((String)dataStream, (String)newIndex)));
        modifyDataStreamRequest.setParentTask(parentTaskId);
        this.client.execute((ActionType)ModifyDataStreamsAction.INSTANCE, (ActionRequest)modifyDataStreamRequest, listener.map(ingored -> newIndex));
    }

    private void copySettings(String oldIndex, String newIndex, ActionListener<AcknowledgedResponse> listener, TaskId parentTaskId) {
        GetSettingsRequest getSettingsRequest = new GetSettingsRequest(TimeValue.MAX_VALUE).indices(new String[]{oldIndex});
        getSettingsRequest.setParentTask(parentTaskId);
        this.client.execute((ActionType)GetSettingsAction.INSTANCE, (ActionRequest)getSettingsRequest, listener.delegateFailure((delegate, response) -> {
            String lifecycleName = response.getSetting(oldIndex, "index.lifecycle.name");
            if (lifecycleName != null) {
                Settings settings = Settings.builder().put("index.lifecycle.name", lifecycleName).build();
                UpdateSettingsRequest updateSettingsRequest = new UpdateSettingsRequest(settings, new String[]{newIndex});
                updateSettingsRequest.setParentTask(parentTaskId);
                this.client.execute(TransportUpdateSettingsAction.TYPE, (ActionRequest)updateSettingsRequest, delegate.delegateFailure((delegate2, response2) -> this.maybeRunILMAsyncAction(newIndex, (ActionListener<AcknowledgedResponse>)delegate2, parentTaskId)));
            } else {
                delegate.onResponse(null);
            }
        }));
    }

    private void maybeRunILMAsyncAction(String newIndex, ActionListener<AcknowledgedResponse> listener, TaskId parentTaskId) {
        RetryActionRequest retryActionRequest = new RetryActionRequest(TimeValue.MAX_VALUE, TimeValue.MAX_VALUE, new String[]{newIndex});
        retryActionRequest.setParentTask(parentTaskId);
        retryActionRequest.requireError(false);
        this.client.execute(ILMActions.RETRY, (ActionRequest)retryActionRequest, listener);
    }

    private void deleteIndex(String indexName, TaskId parentTaskId, ActionListener<AcknowledgedResponse> listener) {
        DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(indexName);
        deleteIndexRequest.setParentTask(parentTaskId);
        this.client.execute(TransportDeleteIndexAction.TYPE, (ActionRequest)deleteIndexRequest, listener);
    }

    private void completeSuccessfulPersistentTask(ReindexDataStreamTask persistentTask, @Nullable ReindexDataStreamPersistentTaskState state) {
        persistentTask.allReindexesCompleted(this.threadPool, this.updateCompletionTimeAndGetTimeToLive(persistentTask, state));
    }

    private void completeFailedPersistentTask(ReindexDataStreamTask persistentTask, @Nullable ReindexDataStreamPersistentTaskState state, Exception e) {
        persistentTask.taskFailed(this.threadPool, this.updateCompletionTimeAndGetTimeToLive(persistentTask, state), e);
    }

    private Long getCompletionTime(PersistentTaskState persistentTaskState) {
        if (persistentTaskState instanceof ReindexDataStreamPersistentTaskState) {
            ReindexDataStreamPersistentTaskState state = (ReindexDataStreamPersistentTaskState)persistentTaskState;
            return state.completionTime();
        }
        return null;
    }

    private TimeValue updateCompletionTimeAndGetTimeToLive(ReindexDataStreamTask reindexDataStreamTask, @Nullable ReindexDataStreamPersistentTaskState state) {
        long completionTime;
        PersistentTasksCustomMetadata.PersistentTask persistentTask = PersistentTasksCustomMetadata.getTaskWithId((ClusterState)this.clusterService.state(), (String)reindexDataStreamTask.getPersistentTaskId());
        if (persistentTask == null) {
            return TimeValue.timeValueMillis((long)0L);
        }
        if (state == null) {
            completionTime = this.threadPool.absoluteTimeInMillis();
            reindexDataStreamTask.updatePersistentTaskState(new ReindexDataStreamPersistentTaskState(null, null, completionTime), ActionListener.noop());
        } else if (state.completionTime() == null) {
            completionTime = this.threadPool.absoluteTimeInMillis();
            reindexDataStreamTask.updatePersistentTaskState(new ReindexDataStreamPersistentTaskState(state.totalIndices(), state.totalIndicesToBeUpgraded(), completionTime), ActionListener.noop());
        } else {
            completionTime = state.completionTime();
        }
        return this.getTimeToLive(completionTime);
    }

    private TimeValue getTimeToLive(long completionTimeInMillis) {
        return TimeValue.timeValueMillis((long)(TASK_KEEP_ALIVE_TIME.millis() - Math.min(TASK_KEEP_ALIVE_TIME.millis(), this.threadPool.absoluteTimeInMillis() - completionTimeInMillis)));
    }
}

