/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.system_indices.task;

import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.system_indices.task.FeatureMigrationResults;
import org.elasticsearch.system_indices.task.SingleFeatureMigrationResult;

public class MigrationResultsUpdateTask
extends ClusterStateUpdateTask {
    private static final Logger logger = LogManager.getLogger(MigrationResultsUpdateTask.class);
    private final String featureName;
    private final SingleFeatureMigrationResult status;
    private final ActionListener<ClusterState> listener;

    private MigrationResultsUpdateTask(String featureName, SingleFeatureMigrationResult status, ActionListener<ClusterState> listener) {
        this.featureName = featureName;
        this.status = status;
        this.listener = listener;
    }

    public static MigrationResultsUpdateTask upsert(String featureName, SingleFeatureMigrationResult status, ActionListener<ClusterState> listener) {
        return new MigrationResultsUpdateTask(featureName, status, listener);
    }

    public void submit(ClusterService clusterService) {
        String source = Strings.format((String)"record [%s] migration [%s]", (Object[])new Object[]{this.featureName, this.status.succeeded() ? "success" : "failure"});
        MigrationResultsUpdateTask.submitUnbatchedTask(clusterService, source, this);
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private static void submitUnbatchedTask(ClusterService clusterService, String source, ClusterStateUpdateTask task) {
        clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    public ClusterState execute(ClusterState currentState) throws Exception {
        ProjectMetadata project = currentState.metadata().getProject();
        FeatureMigrationResults currentResults = (FeatureMigrationResults)project.custom("system_index_migration");
        if (currentResults == null) {
            currentResults = new FeatureMigrationResults(new HashMap<String, SingleFeatureMigrationResult>());
        }
        FeatureMigrationResults newResults = currentResults.withResult(this.featureName, this.status);
        return currentState.copyAndUpdateProject(project.id(), builder -> builder.putCustom("system_index_migration", (Metadata.ProjectCustom)newResults));
    }

    public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
        this.listener.onResponse((Object)newState);
    }

    public void onFailure(Exception clusterStateUpdateException) {
        if (this.status.succeeded()) {
            logger.warn(() -> "failed to update cluster state after successful migration of feature [" + this.featureName + "]", (Throwable)clusterStateUpdateException);
        } else {
            logger.error(() -> Strings.format((String)"failed to update cluster state after failed migration of feature [%s] on index [%s]", (Object[])new Object[]{this.featureName, this.status.getFailedResourceName()}), (Throwable)clusterStateUpdateException);
        }
        this.listener.onFailure(clusterStateUpdateException);
    }
}

