/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore.testkit.analyze;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.common.blobstore.OptionalBytesReference;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThrottledIterator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryVerificationException;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.repositories.blobstore.testkit.SnapshotRepositoryTestKit;
import org.elasticsearch.repositories.blobstore.testkit.analyze.BlobAnalyzeAction;
import org.elasticsearch.repositories.blobstore.testkit.analyze.ContendedRegisterAnalyzeAction;
import org.elasticsearch.repositories.blobstore.testkit.analyze.GetBlobChecksumAction;
import org.elasticsearch.repositories.blobstore.testkit.analyze.RepositoryPerformanceSummary;
import org.elasticsearch.repositories.blobstore.testkit.analyze.UncontendedRegisterAnalyzeAction;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ReceiveTimeoutTransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class RepositoryAnalyzeAction
extends HandledTransportAction<Request, Response> {
    private static final Logger logger = LogManager.getLogger(RepositoryAnalyzeAction.class);
    public static final ActionType<Response> INSTANCE = new ActionType("cluster:admin/repository/analyze");
    static final String UNCONTENDED_REGISTER_NAME_PREFIX = "test-register-uncontended-";
    static final String CONTENDED_REGISTER_NAME_PREFIX = "test-register-contended-";
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final RepositoriesService repositoriesService;

    @Inject
    public RepositoryAnalyzeAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, RepositoriesService repositoriesService) {
        super(INSTANCE.name(), transportService, actionFilters, Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.repositoriesService = repositoriesService;
        new BlobAnalyzeAction(transportService, actionFilters, repositoriesService);
        new GetBlobChecksumAction(transportService, actionFilters, repositoriesService);
        new ContendedRegisterAnalyzeAction(transportService, actionFilters, repositoriesService);
        new UncontendedRegisterAnalyzeAction(transportService, actionFilters, repositoriesService);
    }

    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        ClusterState state = this.clusterService.state();
        ThreadPool threadPool = this.transportService.getThreadPool();
        request.reseed(threadPool.relativeTimeInMillis());
        DiscoveryNode localNode = this.transportService.getLocalNode();
        if (RepositoryAnalyzeAction.isSnapshotNode(localNode)) {
            Repository repository = this.repositoriesService.repository(request.getRepositoryName());
            if (!(repository instanceof BlobStoreRepository)) {
                throw new IllegalArgumentException("repository [" + request.getRepositoryName() + "] is not a blob-store repository");
            }
            if (repository.isReadOnly()) {
                throw new IllegalArgumentException("repository [" + request.getRepositoryName() + "] is read-only");
            }
            assert (task instanceof CancellableTask);
            new AsyncAction(this.transportService, (BlobStoreRepository)repository, (CancellableTask)task, request, state.nodes(), state.getMinTransportVersion(), threadPool.relativeTimeInMillisSupplier(), listener).run();
            return;
        }
        if (request.getReroutedFrom() != null) {
            assert (false) : request.getReroutedFrom();
            throw new IllegalArgumentException("analysis of repository [" + request.getRepositoryName() + "] rerouted from [" + String.valueOf(request.getReroutedFrom()) + "] to non-snapshot node");
        }
        request.reroutedFrom(localNode);
        List<DiscoveryNode> snapshotNodes = RepositoryAnalyzeAction.getSnapshotNodes(state.nodes());
        if (snapshotNodes.isEmpty()) {
            listener.onFailure((Exception)new IllegalArgumentException("no snapshot nodes found for analysis of repository [" + request.getRepositoryName() + "]"));
        } else {
            if (snapshotNodes.size() > 1) {
                snapshotNodes.remove(state.nodes().getMasterNode());
            }
            DiscoveryNode targetNode = snapshotNodes.get(new Random(request.getSeed()).nextInt(snapshotNodes.size()));
            logger.trace("rerouting analysis [{}] to [{}]", (Object)request.getDescription(), (Object)targetNode);
            this.transportService.sendChildRequest(targetNode, INSTANCE.name(), (TransportRequest)request, task, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler(listener, Response::new, TransportResponseHandler.TRANSPORT_WORKER));
        }
    }

    private static boolean isSnapshotNode(DiscoveryNode discoveryNode) {
        return (discoveryNode.canContainData() || discoveryNode.isMasterNode()) && !RepositoriesService.isDedicatedVotingOnlyNode((Set)discoveryNode.getRoles());
    }

    private static List<DiscoveryNode> getSnapshotNodes(DiscoveryNodes discoveryNodes) {
        Collection nodesCollection = discoveryNodes.getMasterAndDataNodes().values();
        ArrayList<DiscoveryNode> nodes = new ArrayList<DiscoveryNode>(nodesCollection.size());
        for (DiscoveryNode node : nodesCollection) {
            if (!RepositoryAnalyzeAction.isSnapshotNode(node)) continue;
            nodes.add(node);
        }
        return nodes;
    }

    static List<Long> getBlobSizes(Request request) {
        long maxBlobSize;
        int blobCount = request.getBlobCount();
        long maxTotalBytes = request.getMaxTotalDataSize().getBytes();
        if (maxTotalBytes - (maxBlobSize = request.getMaxBlobSize().getBytes()) < (long)(blobCount - 1)) {
            throw new IllegalArgumentException("cannot satisfy max total bytes [" + maxTotalBytes + "B/" + String.valueOf(request.getMaxTotalDataSize()) + "]: must write at least one byte per blob and at least one max-sized blob which is [" + ((long)blobCount + maxBlobSize - 1L) + "B] in total");
        }
        ArrayList<Long> blobSizes = new ArrayList<Long>();
        for (long s = 1L; 0L < s && s < maxBlobSize; s <<= 1) {
            blobSizes.add(s);
        }
        blobSizes.add(maxBlobSize);
        long evenSpreadSize = blobSizes.stream().mapToLong(l -> l).sum();
        int evenSpreadCount = 0;
        while (blobSizes.size() <= blobCount && (long)(blobCount - blobSizes.size()) <= maxTotalBytes - evenSpreadSize) {
            ++evenSpreadCount;
            maxTotalBytes -= evenSpreadSize;
            blobCount -= blobSizes.size();
        }
        if (evenSpreadCount == 0) {
            --blobCount;
            maxTotalBytes -= maxBlobSize;
        }
        List<Long> perBlobSizes = new BlobCountCalculator(blobCount, maxTotalBytes, blobSizes).calculate();
        if (evenSpreadCount == 0) {
            perBlobSizes.add(maxBlobSize);
        } else {
            Iterator iterator = blobSizes.iterator();
            while (iterator.hasNext()) {
                long blobSize = (Long)iterator.next();
                for (int i = 0; i < evenSpreadCount; ++i) {
                    perBlobSizes.add(blobSize);
                }
            }
        }
        assert (perBlobSizes.size() == request.getBlobCount());
        assert (perBlobSizes.stream().mapToLong(l -> l).sum() <= request.getMaxTotalDataSize().getBytes());
        assert (perBlobSizes.stream().allMatch(l -> 1L <= l && l <= request.getMaxBlobSize().getBytes()));
        assert (perBlobSizes.stream().anyMatch(l -> l.longValue() == request.getMaxBlobSize().getBytes()));
        return perBlobSizes;
    }

    public static class Request
    extends LegacyActionRequest {
        private final String repositoryName;
        private int blobCount = 100;
        private int concurrency = 10;
        private int registerOperationCount = 10;
        private int readNodeCount = 10;
        private int earlyReadNodeCount = 2;
        private long seed = 0L;
        private double rareActionProbability = 0.02;
        private TimeValue timeout = TimeValue.timeValueSeconds((long)30L);
        private ByteSizeValue maxBlobSize = ByteSizeValue.ofMb((long)10L);
        private ByteSizeValue maxTotalDataSize = ByteSizeValue.ofGb((long)1L);
        private boolean detailed = false;
        private DiscoveryNode reroutedFrom = null;
        private boolean abortWritePermitted = true;

        public Request(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.repositoryName = in.readString();
            this.seed = in.readLong();
            this.rareActionProbability = in.readDouble();
            this.blobCount = in.readVInt();
            this.concurrency = in.readVInt();
            this.registerOperationCount = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_12_0) ? in.readVInt() : this.concurrency;
            this.readNodeCount = in.readVInt();
            this.earlyReadNodeCount = in.readVInt();
            this.timeout = in.readTimeValue();
            this.maxBlobSize = ByteSizeValue.readFrom((StreamInput)in);
            this.maxTotalDataSize = ByteSizeValue.readFrom((StreamInput)in);
            this.detailed = in.readBoolean();
            this.reroutedFrom = (DiscoveryNode)in.readOptionalWriteable(DiscoveryNode::new);
            this.abortWritePermitted = in.readBoolean();
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.repositoryName);
            out.writeLong(this.seed);
            out.writeDouble(this.rareActionProbability);
            out.writeVInt(this.blobCount);
            out.writeVInt(this.concurrency);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_12_0)) {
                out.writeVInt(this.registerOperationCount);
            } else if (this.registerOperationCount != this.concurrency) {
                throw new IllegalArgumentException("cannot send request with registerOperationCount != concurrency to version [" + out.getTransportVersion().toReleaseVersion() + "]");
            }
            out.writeVInt(this.readNodeCount);
            out.writeVInt(this.earlyReadNodeCount);
            out.writeTimeValue(this.timeout);
            this.maxBlobSize.writeTo(out);
            this.maxTotalDataSize.writeTo(out);
            out.writeBoolean(this.detailed);
            out.writeOptionalWriteable((Writeable)this.reroutedFrom);
            out.writeBoolean(this.abortWritePermitted);
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, this.getDescription(), parentTaskId, headers);
        }

        public void blobCount(int blobCount) {
            if (blobCount <= 0) {
                throw new IllegalArgumentException("blobCount must be >0, but was [" + blobCount + "]");
            }
            if (blobCount > 100000) {
                throw new IllegalArgumentException("blobCount must be <= 100000, but was [" + blobCount + "]");
            }
            this.blobCount = blobCount;
        }

        public void concurrency(int concurrency) {
            if (concurrency <= 0) {
                throw new IllegalArgumentException("concurrency must be >0, but was [" + concurrency + "]");
            }
            this.concurrency = concurrency;
        }

        public void registerOperationCount(int registerOperationCount) {
            if (registerOperationCount <= 0) {
                throw new IllegalArgumentException("registerOperationCount must be >0, but was [" + registerOperationCount + "]");
            }
            this.registerOperationCount = registerOperationCount;
        }

        public void seed(long seed) {
            this.seed = seed;
        }

        public void timeout(TimeValue timeout) {
            this.timeout = timeout;
        }

        public void maxBlobSize(ByteSizeValue maxBlobSize) {
            if (maxBlobSize.getBytes() <= 0L) {
                throw new IllegalArgumentException("maxBlobSize must be >0, but was [" + String.valueOf(maxBlobSize) + "]");
            }
            this.maxBlobSize = maxBlobSize;
        }

        public void maxTotalDataSize(ByteSizeValue maxTotalDataSize) {
            if (maxTotalDataSize.getBytes() <= 0L) {
                throw new IllegalArgumentException("maxTotalDataSize must be >0, but was [" + String.valueOf(maxTotalDataSize) + "]");
            }
            this.maxTotalDataSize = maxTotalDataSize;
        }

        public void detailed(boolean detailed) {
            this.detailed = detailed;
        }

        public int getBlobCount() {
            return this.blobCount;
        }

        public int getConcurrency() {
            return this.concurrency;
        }

        public int getRegisterOperationCount() {
            return this.registerOperationCount;
        }

        public String getRepositoryName() {
            return this.repositoryName;
        }

        public TimeValue getTimeout() {
            return this.timeout;
        }

        public long getSeed() {
            return this.seed;
        }

        public ByteSizeValue getMaxBlobSize() {
            return this.maxBlobSize;
        }

        public ByteSizeValue getMaxTotalDataSize() {
            return this.maxTotalDataSize;
        }

        public boolean getDetailed() {
            return this.detailed;
        }

        public DiscoveryNode getReroutedFrom() {
            return this.reroutedFrom;
        }

        public void reroutedFrom(DiscoveryNode discoveryNode) {
            this.reroutedFrom = discoveryNode;
        }

        public void readNodeCount(int readNodeCount) {
            if (readNodeCount <= 0) {
                throw new IllegalArgumentException("readNodeCount must be >0, but was [" + readNodeCount + "]");
            }
            this.readNodeCount = readNodeCount;
        }

        public int getReadNodeCount() {
            return this.readNodeCount;
        }

        public void earlyReadNodeCount(int earlyReadNodeCount) {
            if (earlyReadNodeCount < 0) {
                throw new IllegalArgumentException("earlyReadNodeCount must be >=0, but was [" + earlyReadNodeCount + "]");
            }
            this.earlyReadNodeCount = earlyReadNodeCount;
        }

        public int getEarlyReadNodeCount() {
            return this.earlyReadNodeCount;
        }

        public void rareActionProbability(double rareActionProbability) {
            if (rareActionProbability < 0.0 || rareActionProbability > 1.0) {
                throw new IllegalArgumentException("rareActionProbability must be between 0 and 1, but was [" + rareActionProbability + "]");
            }
            this.rareActionProbability = rareActionProbability;
        }

        public double getRareActionProbability() {
            return this.rareActionProbability;
        }

        public void abortWritePermitted(boolean abortWritePermitted) {
            this.abortWritePermitted = abortWritePermitted;
        }

        public boolean isAbortWritePermitted() {
            return this.abortWritePermitted;
        }

        public String toString() {
            return "Request{" + this.getDescription() + "}";
        }

        public String getDescription() {
            return "analysis [repository=" + this.repositoryName + ", blobCount=" + this.blobCount + ", concurrency=" + this.concurrency + ", readNodeCount=" + this.readNodeCount + ", earlyReadNodeCount=" + this.earlyReadNodeCount + ", seed=" + this.seed + ", rareActionProbability=" + this.rareActionProbability + ", timeout=" + String.valueOf(this.timeout) + ", maxBlobSize=" + String.valueOf(this.maxBlobSize) + ", maxTotalDataSize=" + String.valueOf(this.maxTotalDataSize) + ", detailed=" + this.detailed + ", abortWritePermitted=" + this.abortWritePermitted + "]";
        }

        public void reseed(long newSeed) {
            if (this.seed == 0L) {
                this.seed = newSeed;
            }
        }
    }

    public static class AsyncAction {
        private static final TransportVersion REPO_ANALYSIS_COPY_BLOB = TransportVersion.fromName((String)"repo_analysis_copy_blob");
        private final TransportService transportService;
        private final BlobStoreRepository repository;
        private final CancellableTask task;
        private final Request request;
        private final DiscoveryNodes discoveryNodes;
        private final TransportVersion minClusterTransportVersion;
        private final LongSupplier currentTimeMillisSupplier;
        private final ActionListener<Response> listener;
        private final SubscribableListener<Void> cancellationListener;
        private final long timeoutTimeMillis;
        private final String blobPath = "temp-analysis-" + UUIDs.randomBase64UUID();
        private final AtomicLong expectedRegisterValue = new AtomicLong();
        private final Queue<Consumer<Releasable>> queue = ConcurrentCollections.newQueue();
        private final AtomicReference<Exception> failure = new AtomicReference();
        private final Semaphore innerFailures = new Semaphore(5);
        private final RefCountingRunnable requestRefs = new RefCountingRunnable(this::runCleanUp);
        private final Set<String> expectedBlobs = ConcurrentCollections.newConcurrentSet();
        private final List<BlobAnalyzeAction.Response> responses;
        private final RepositoryPerformanceSummary.Builder summary = new RepositoryPerformanceSummary.Builder();
        private final RepositoryVerificationException analysisCancelledException;
        private final RepositoryVerificationException analysisTimedOutException;

        public AsyncAction(TransportService transportService, BlobStoreRepository repository, CancellableTask task, Request request, DiscoveryNodes discoveryNodes, TransportVersion minClusterTransportVersion, LongSupplier currentTimeMillisSupplier, ActionListener<Response> listener) {
            this.transportService = transportService;
            this.repository = repository;
            this.task = task;
            this.request = request;
            this.discoveryNodes = discoveryNodes;
            this.minClusterTransportVersion = minClusterTransportVersion;
            this.currentTimeMillisSupplier = currentTimeMillisSupplier;
            this.timeoutTimeMillis = currentTimeMillisSupplier.getAsLong() + request.getTimeout().millis();
            this.cancellationListener = new SubscribableListener();
            this.listener = ActionListener.runBefore(listener, () -> this.cancellationListener.onResponse(null));
            this.responses = new ArrayList<BlobAnalyzeAction.Response>(request.blobCount);
            this.analysisCancelledException = new RepositoryVerificationException(request.repositoryName, "analysis cancelled");
            this.analysisTimedOutException = new RepositoryVerificationException(request.repositoryName, "analysis timed out after [" + String.valueOf(request.getTimeout()) + "]");
        }

        private boolean setFirstFailure(Exception e) {
            if (this.failure.compareAndSet(null, e)) {
                this.transportService.getTaskManager().cancelTaskAndDescendants(this.task, "task failed", false, ActionListener.noop());
                return true;
            }
            return false;
        }

        private void fail(Exception e) {
            logger.trace(() -> org.elasticsearch.common.Strings.format((String)"repository analysis in [%s] failed", (Object[])new Object[]{this.blobPath}), (Throwable)e);
            if (!this.setFirstFailure(e) && this.innerFailures.tryAcquire()) {
                Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                if (cause instanceof TaskCancelledException || cause instanceof ReceiveTimeoutTransportException) {
                    this.innerFailures.release();
                } else {
                    this.failure.get().addSuppressed(e);
                }
            }
        }

        private boolean isRunning() {
            return this.failure.get() == null;
        }

        public void run() {
            assert (this.queue.isEmpty()) : "must only run action once";
            assert (this.failure.get() == null) : "must only run action once";
            logger.info("running analysis of repository [{}] using path [{}]", (Object)this.request.getRepositoryName(), (Object)this.blobPath);
            this.cancellationListener.addTimeout(this.request.getTimeout(), this.repository.threadPool(), (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
            this.cancellationListener.addListener((ActionListener)new CheckForCancelListener());
            this.task.addListener(() -> this.setFirstFailure((Exception)this.analysisCancelledException));
            Random random = new Random(this.request.getSeed());
            List<DiscoveryNode> nodes = RepositoryAnalyzeAction.getSnapshotNodes(this.discoveryNodes);
            if (this.minClusterTransportVersion.onOrAfter((VersionId)TransportVersions.V_8_8_0)) {
                String contendedRegisterName = RepositoryAnalyzeAction.CONTENDED_REGISTER_NAME_PREFIX + UUIDs.randomBase64UUID((Random)random);
                AtomicBoolean contendedRegisterAnalysisComplete = new AtomicBoolean();
                try (RefCountingRunnable registerRefs = new RefCountingRunnable(this.finalRegisterValueVerifier(contendedRegisterName, random, Releasables.wrap((Releasable[])new Releasable[]{this.requestRefs.acquire(), () -> contendedRegisterAnalysisComplete.set(true)})));){
                    int registerOperations = Math.max(nodes.size(), this.request.getRegisterOperationCount());
                    for (int i = 0; i < registerOperations; ++i) {
                        ContendedRegisterAnalyzeAction.Request registerAnalyzeRequest = new ContendedRegisterAnalyzeAction.Request(this.request.getRepositoryName(), this.blobPath, contendedRegisterName, registerOperations, random.nextInt((registerOperations + 1) * 2));
                        DiscoveryNode node = nodes.get(i < nodes.size() ? i : random.nextInt(nodes.size()));
                        Releasable registerRef = registerRefs.acquire();
                        this.queue.add(ref -> this.runContendedRegisterAnalysis(Releasables.wrap((Releasable[])new Releasable[]{registerRef, ref}), registerAnalyzeRequest, node));
                    }
                }
                if (this.minClusterTransportVersion.onOrAfter((VersionId)TransportVersions.V_8_12_0)) {
                    new UncontendedRegisterAnalysis(new Random(random.nextLong()), nodes, contendedRegisterAnalysisComplete).run();
                }
            }
            List<Long> blobSizes = RepositoryAnalyzeAction.getBlobSizes(this.request);
            Collections.shuffle(blobSizes, random);
            int blobCount = this.request.getBlobCount();
            for (int i = 0; i < blobCount; ++i) {
                long targetLength = blobSizes.get(i);
                boolean smallBlob = targetLength <= Integer.MAX_VALUE;
                boolean abortWrite = smallBlob && this.request.isAbortWritePermitted() && this.rarely(random);
                boolean doCopy = this.minClusterTransportVersion.supports(REPO_ANALYSIS_COPY_BLOB) && this.rarely(random) && i > 0;
                String blobName = "test-blob-" + i + "-" + UUIDs.randomBase64UUID((Random)random);
                String copyBlobName = null;
                if (doCopy) {
                    copyBlobName = blobName + "-copy";
                    if (i >= --blobCount) break;
                }
                BlobAnalyzeAction.Request blobAnalyzeRequest = new BlobAnalyzeAction.Request(this.request.getRepositoryName(), this.blobPath, blobName, targetLength, random.nextLong(), nodes, this.request.getReadNodeCount(), this.request.getEarlyReadNodeCount(), smallBlob && this.rarely(random), this.repository.supportURLRepo() && this.repository.hasAtomicOverwrites() && smallBlob && this.rarely(random) && !abortWrite, abortWrite, copyBlobName);
                DiscoveryNode node = nodes.get(random.nextInt(nodes.size()));
                this.queue.add(ref -> this.runBlobAnalysis((Releasable)ref, blobAnalyzeRequest, node));
            }
            ThrottledIterator.run(this.getQueueIterator(), (ref, task) -> task.accept(ref), (int)this.request.getConcurrency(), () -> ((RefCountingRunnable)this.requestRefs).close());
        }

        private boolean rarely(Random random) {
            return random.nextDouble() < this.request.getRareActionProbability();
        }

        private Iterator<Consumer<Releasable>> getQueueIterator() {
            return new Iterator<Consumer<Releasable>>(){
                Consumer<Releasable> nextItem;
                {
                    this.nextItem = queue.poll();
                }

                @Override
                public boolean hasNext() {
                    return this.nextItem != null;
                }

                @Override
                public Consumer<Releasable> next() {
                    assert (this.nextItem != null);
                    Consumer<Releasable> currentItem = this.nextItem;
                    this.nextItem = queue.poll();
                    return currentItem;
                }
            };
        }

        private void runBlobAnalysis(Releasable ref, final BlobAnalyzeAction.Request request, final DiscoveryNode node) {
            if (this.isRunning()) {
                logger.trace("processing [{}] on [{}]", (Object)request, (Object)node);
                this.transportService.sendChildRequest(node, "cluster:admin/repository/analyze/blob", (TransportRequest)request, (Task)this.task, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler(ActionListener.releaseAfter((ActionListener)new ActionListener<BlobAnalyzeAction.Response>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onResponse(BlobAnalyzeAction.Response response) {
                        logger.trace("finished [{}] on [{}]", (Object)request, (Object)node);
                        if (!request.getAbortWrite()) {
                            expectedBlobs.add(request.getBlobName());
                        }
                        if (request.detailed) {
                            List<BlobAnalyzeAction.Response> list = responses;
                            synchronized (list) {
                                responses.add(response);
                            }
                        }
                        summary.add(response);
                    }

                    public void onFailure(Exception exp) {
                        logger.debug(() -> "failed [" + String.valueOf((Object)request) + "] on [" + String.valueOf(node) + "]", (Throwable)exp);
                        this.fail(exp);
                    }
                }, (Releasable)ref), BlobAnalyzeAction.Response::new, TransportResponseHandler.TRANSPORT_WORKER));
            } else {
                ref.close();
            }
        }

        private BlobContainer getBlobContainer() {
            return this.repository.blobStore().blobContainer(this.repository.basePath().add(this.blobPath));
        }

        private void runContendedRegisterAnalysis(Releasable ref, final ContendedRegisterAnalyzeAction.Request request, final DiscoveryNode node) {
            if (this.isRunning()) {
                this.transportService.sendChildRequest(node, "cluster:admin/repository/analyze/register", (TransportRequest)request, (Task)this.task, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler(ActionListener.releaseAfter((ActionListener)new ActionListener<ActionResponse.Empty>(){

                    public void onResponse(ActionResponse.Empty response) {
                        expectedRegisterValue.incrementAndGet();
                    }

                    public void onFailure(Exception exp) {
                        logger.debug(() -> "failed [" + String.valueOf((Object)request) + "] on [" + String.valueOf(node) + "]", (Throwable)exp);
                        this.fail(exp);
                    }
                }, (Releasable)ref), in -> ActionResponse.Empty.INSTANCE, TransportResponseHandler.TRANSPORT_WORKER));
            } else {
                ref.close();
            }
        }

        private Runnable finalRegisterValueVerifier(final String registerName, Random random, Releasable ref) {
            return () -> {
                if (this.isRunning()) {
                    final long expectedFinalRegisterValue = this.expectedRegisterValue.get();
                    this.transportService.getThreadPool().executor("snapshot").execute((Runnable)ActionRunnable.wrap((ActionListener)ActionListener.releaseAfter((ActionListener)new ActionListener<OptionalBytesReference>(){

                        public void onResponse(OptionalBytesReference actualFinalRegisterValue) {
                            if (!actualFinalRegisterValue.isPresent() || ContendedRegisterAnalyzeAction.longFromBytes(actualFinalRegisterValue.bytesReference()) != expectedFinalRegisterValue) {
                                this.fail((Exception)new RepositoryVerificationException(request.getRepositoryName(), org.elasticsearch.common.Strings.format((String)"register [%s] should have value [%d] but instead had value [%s]", (Object[])new Object[]{registerName, expectedFinalRegisterValue, actualFinalRegisterValue})));
                            }
                        }

                        public void onFailure(Exception exp) {
                            if (!(exp instanceof UnsupportedOperationException)) {
                                this.fail(exp);
                            }
                        }
                    }, (Releasable)ref), listener -> {
                        switch (random.nextInt(3)) {
                            case 0: {
                                this.getBlobContainer().getRegister(OperationPurpose.REPOSITORY_ANALYSIS, registerName, listener);
                                break;
                            }
                            case 1: {
                                this.getBlobContainer().compareAndExchangeRegister(OperationPurpose.REPOSITORY_ANALYSIS, registerName, ContendedRegisterAnalyzeAction.bytesFromLong(expectedFinalRegisterValue), (BytesReference)new BytesArray(new byte[]{-1}), listener);
                                break;
                            }
                            case 2: {
                                this.getBlobContainer().compareAndSetRegister(OperationPurpose.REPOSITORY_ANALYSIS, registerName, ContendedRegisterAnalyzeAction.bytesFromLong(expectedFinalRegisterValue), (BytesReference)new BytesArray(new byte[]{-1}), listener.map(b -> b != false ? OptionalBytesReference.of((BytesReference)ContendedRegisterAnalyzeAction.bytesFromLong(expectedFinalRegisterValue)) : OptionalBytesReference.MISSING));
                                break;
                            }
                            default: {
                                assert (false);
                                throw new IllegalStateException();
                            }
                        }
                    }));
                } else {
                    ref.close();
                }
            };
        }

        private void runCleanUp() {
            this.transportService.getThreadPool().executor("snapshot").execute((Runnable)ActionRunnable.wrap(this.listener, l -> {
                long listingStartTimeNanos = System.nanoTime();
                this.ensureConsistentListing();
                long deleteStartTimeNanos = System.nanoTime();
                this.deleteContainer();
                this.sendResponse(listingStartTimeNanos, deleteStartTimeNanos);
            }));
        }

        private void ensureConsistentListing() {
            if (this.timeoutTimeMillis < this.currentTimeMillisSupplier.getAsLong() || this.task.isCancelled()) {
                logger.warn("analysis of repository [{}] failed before cleanup phase, attempting best-effort cleanup but you may need to manually remove [{}]", (Object)this.request.getRepositoryName(), (Object)this.blobPath);
                this.isRunning();
            } else {
                logger.trace("all tasks completed, checking expected blobs exist in [{}:{}] before cleanup", (Object)this.request.repositoryName, (Object)this.blobPath);
                try {
                    BlobContainer blobContainer = this.getBlobContainer();
                    HashSet<String> missingBlobs = new HashSet<String>(this.expectedBlobs);
                    Map blobsMap = blobContainer.listBlobs(OperationPurpose.REPOSITORY_ANALYSIS);
                    missingBlobs.removeAll(blobsMap.keySet());
                    if (missingBlobs.isEmpty()) {
                        logger.trace("all expected blobs found, cleaning up [{}:{}]", (Object)this.request.getRepositoryName(), (Object)this.blobPath);
                    } else {
                        RepositoryVerificationException repositoryVerificationException = new RepositoryVerificationException(this.request.repositoryName, "expected blobs " + String.valueOf(missingBlobs) + " missing in [" + this.request.repositoryName + ":" + this.blobPath + "]");
                        logger.debug("failing due to missing blobs", (Throwable)repositoryVerificationException);
                        this.fail((Exception)repositoryVerificationException);
                    }
                }
                catch (Exception e) {
                    logger.debug(() -> Strings.format((String)"failure during cleanup of [%s:%s]", (Object[])new Object[]{this.request.getRepositoryName(), this.blobPath}), (Throwable)e);
                    this.fail(e);
                }
            }
        }

        private void deleteContainer() {
            try {
                BlobContainer blobContainer = this.getBlobContainer();
                blobContainer.delete(OperationPurpose.REPOSITORY_ANALYSIS);
                if (this.failure.get() != null) {
                    return;
                }
                Map blobsMap = blobContainer.listBlobs(OperationPurpose.REPOSITORY_ANALYSIS);
                if (!blobsMap.isEmpty()) {
                    RepositoryVerificationException repositoryVerificationException = new RepositoryVerificationException(this.request.repositoryName, "failed to clean up blobs " + String.valueOf(blobsMap.keySet()));
                    logger.debug("failing due to leftover blobs", (Throwable)repositoryVerificationException);
                    this.fail((Exception)repositoryVerificationException);
                }
            }
            catch (Exception e) {
                this.fail(e);
            }
        }

        private void sendResponse(long listingStartTimeNanos, long deleteStartTimeNanos) {
            Exception exception = this.failure.get();
            if (exception == null) {
                long completionTimeNanos = System.nanoTime();
                logger.trace("[{}] completed successfully", (Object)this.request.getDescription());
                this.listener.onResponse((Object)new Response(this.transportService.getLocalNode().getId(), this.transportService.getLocalNode().getName(), this.request.getRepositoryName(), this.request.blobCount, this.request.concurrency, this.request.readNodeCount, this.request.earlyReadNodeCount, this.request.maxBlobSize, this.request.maxTotalDataSize, this.request.seed, this.request.rareActionProbability, this.blobPath, this.summary.build(), this.responses, deleteStartTimeNanos - listingStartTimeNanos, completionTimeNanos - deleteStartTimeNanos));
            } else {
                logger.debug(() -> "analysis of repository [" + this.request.repositoryName + "] failed", (Throwable)exception);
                String failureDetail = exception == this.analysisCancelledException ? "Repository analysis was cancelled." : (exception == this.analysisTimedOutException ? org.elasticsearch.common.Strings.format((String)"Repository analysis timed out. Consider specifying a longer timeout using the [?timeout] request parameter. See [%s] for more information.", (Object[])new Object[]{ReferenceDocs.SNAPSHOT_REPOSITORY_ANALYSIS}) : this.repository.getAnalysisFailureExtraDetail());
                this.listener.onFailure((Exception)new RepositoryVerificationException(this.request.getRepositoryName(), org.elasticsearch.common.Strings.format((String)"%s Elasticsearch attempted to remove the data it wrote at [%s] but may have left some behind. If so, please now remove this data manually.", (Object[])new Object[]{failureDetail, this.blobPath}), (Throwable)exception));
            }
        }

        private class CheckForCancelListener
        implements ActionListener<Void> {
            private CheckForCancelListener() {
            }

            public void onResponse(Void unused) {
            }

            public void onFailure(Exception e) {
                assert (e instanceof ElasticsearchTimeoutException) : e;
                if (AsyncAction.this.isRunning()) {
                    AsyncAction.this.setFirstFailure((Exception)AsyncAction.this.analysisTimedOutException);
                }
            }
        }

        private class UncontendedRegisterAnalysis
        implements Runnable {
            private final Random random;
            private final String registerName;
            private final List<DiscoveryNode> nodes;
            private final AtomicBoolean otherAnalysisComplete;
            private int currentValue;
            private final ActionListener<ActionResponse.Empty> stepListener = new ActionListener<ActionResponse.Empty>(){

                public void onResponse(ActionResponse.Empty ignored) {
                    ++UncontendedRegisterAnalysis.this.currentValue;
                    UncontendedRegisterAnalysis.this.run();
                }

                public void onFailure(Exception e) {
                    AsyncAction.this.fail(e);
                }
            };

            UncontendedRegisterAnalysis(Random random, List<DiscoveryNode> nodes, AtomicBoolean otherAnalysisComplete) {
                this.random = random;
                this.registerName = RepositoryAnalyzeAction.UNCONTENDED_REGISTER_NAME_PREFIX + UUIDs.randomBase64UUID((Random)random);
                this.nodes = nodes;
                this.otherAnalysisComplete = otherAnalysisComplete;
            }

            @Override
            public void run() {
                if (!AsyncAction.this.isRunning()) {
                    return;
                }
                if (this.currentValue <= AsyncAction.this.request.getRegisterOperationCount() || !this.otherAnalysisComplete.get()) {
                    logger.trace("[{}] incrementing uncontended register [{}] from [{}]", (Object)AsyncAction.this.blobPath, (Object)this.registerName, (Object)this.currentValue);
                    AsyncAction.this.transportService.sendChildRequest(this.nodes.get(this.currentValue < this.nodes.size() ? this.currentValue : this.random.nextInt(this.nodes.size())), "cluster:admin/repository/analyze/register/uncontended", (TransportRequest)new UncontendedRegisterAnalyzeAction.Request(AsyncAction.this.request.getRepositoryName(), AsyncAction.this.blobPath, this.registerName, this.currentValue), (Task)AsyncAction.this.task, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler(ActionListener.releaseAfter(this.stepListener, (Releasable)AsyncAction.this.requestRefs.acquire()), in -> ActionResponse.Empty.INSTANCE, TransportResponseHandler.TRANSPORT_WORKER));
                } else {
                    logger.trace("[{}] resetting uncontended register [{}] from [{}]", (Object)AsyncAction.this.blobPath, (Object)this.registerName, (Object)this.currentValue);
                    AsyncAction.this.transportService.getThreadPool().executor("snapshot").execute((Runnable)ActionRunnable.wrap((ActionListener)ActionListener.releaseAfter((ActionListener)ActionListener.wrap(r -> logger.trace("[{}] uncontended register [{}] analysis succeeded", (Object)AsyncAction.this.blobPath, (Object)this.registerName), AsyncAction.this::fail), (Releasable)AsyncAction.this.requestRefs.acquire()), l -> UncontendedRegisterAnalyzeAction.verifyFinalValue(new UncontendedRegisterAnalyzeAction.Request(AsyncAction.this.request.getRepositoryName(), AsyncAction.this.blobPath, this.registerName, this.currentValue), (Repository)AsyncAction.this.repository, (ActionListener<Void>)l)));
                }
            }
        }
    }

    private static class BlobCountCalculator {
        private final int blobCount;
        private final long maxTotalBytes;
        private final List<Long> blobSizes;
        private final int sizeCount;
        private final int[] blobsBySize;
        private long totalBytes;
        private int totalBlobs;

        BlobCountCalculator(int blobCount, long maxTotalBytes, List<Long> blobSizes) {
            this.blobCount = blobCount;
            this.maxTotalBytes = maxTotalBytes;
            assert ((long)blobCount <= maxTotalBytes);
            this.blobSizes = blobSizes;
            this.sizeCount = blobSizes.size();
            assert (this.sizeCount > 0);
            this.blobsBySize = new int[this.sizeCount];
            assert (this.invariant());
        }

        List<Long> calculate() {
            this.addBlobsRoughlyEvenly(this.sizeCount - 1);
            while (this.totalBlobs < this.blobCount) {
                assert (this.totalBytes <= this.maxTotalBytes);
                int minSplitCount = Arrays.stream(this.blobsBySize).skip(1L).allMatch(i -> i <= 1) ? 1 : 2;
                int splitIndex = IntStream.range(1, this.sizeCount).filter(i -> this.blobsBySize[i] >= minSplitCount).reduce(-1, (i, j) -> j);
                assert (splitIndex > 0) : "split at " + splitIndex;
                assert (this.blobsBySize[splitIndex] >= minSplitCount);
                long splitSize = this.blobSizes.get(splitIndex);
                int n = splitIndex;
                this.blobsBySize[n] = this.blobsBySize[n] - 1;
                this.totalBytes -= splitSize;
                --this.totalBlobs;
                this.addBlobsRoughlyEvenly(splitIndex - 1);
                assert (this.invariant());
            }
            return this.getPerBlobSizes();
        }

        private List<Long> getPerBlobSizes() {
            assert (this.invariant());
            ArrayList<Long> perBlobSizes = new ArrayList<Long>(this.blobCount);
            for (int sizeIndex = 0; sizeIndex < this.sizeCount; ++sizeIndex) {
                long size = this.blobSizes.get(sizeIndex);
                for (int i = 0; i < this.blobsBySize[sizeIndex]; ++i) {
                    perBlobSizes.add(size);
                }
            }
            return perBlobSizes;
        }

        private void addBlobsRoughlyEvenly(int startingIndex) {
            while (this.totalBlobs < this.blobCount && this.totalBytes < this.maxTotalBytes) {
                boolean progress = false;
                for (int sizeIndex = startingIndex; 0 <= sizeIndex && this.totalBlobs < this.blobCount && this.totalBytes < this.maxTotalBytes; --sizeIndex) {
                    long size = this.blobSizes.get(sizeIndex);
                    if (this.totalBytes + size > this.maxTotalBytes) continue;
                    progress = true;
                    int n = sizeIndex;
                    this.blobsBySize[n] = this.blobsBySize[n] + 1;
                    ++this.totalBlobs;
                    this.totalBytes += size;
                }
                assert (progress);
                assert (this.invariant());
            }
        }

        private boolean invariant() {
            assert (IntStream.of(this.blobsBySize).sum() == this.totalBlobs) : this;
            assert (IntStream.range(0, this.sizeCount).mapToLong(i -> this.blobSizes.get(i) * (long)this.blobsBySize[i]).sum() == this.totalBytes) : this;
            assert (this.totalBlobs <= this.blobCount) : this;
            assert (this.totalBytes <= this.maxTotalBytes) : this;
            return true;
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final String coordinatingNodeId;
        private final String coordinatingNodeName;
        private final String repositoryName;
        private final int blobCount;
        private final int concurrency;
        private final int readNodeCount;
        private final int earlyReadNodeCount;
        private final ByteSizeValue maxBlobSize;
        private final ByteSizeValue maxTotalDataSize;
        private final long seed;
        private final double rareActionProbability;
        private final String blobPath;
        private final RepositoryPerformanceSummary summary;
        private final List<BlobAnalyzeAction.Response> blobResponses;
        private final long listingTimeNanos;
        private final long deleteTimeNanos;

        public Response(String coordinatingNodeId, String coordinatingNodeName, String repositoryName, int blobCount, int concurrency, int readNodeCount, int earlyReadNodeCount, ByteSizeValue maxBlobSize, ByteSizeValue maxTotalDataSize, long seed, double rareActionProbability, String blobPath, RepositoryPerformanceSummary summary, List<BlobAnalyzeAction.Response> blobResponses, long listingTimeNanos, long deleteTimeNanos) {
            this.coordinatingNodeId = coordinatingNodeId;
            this.coordinatingNodeName = coordinatingNodeName;
            this.repositoryName = repositoryName;
            this.blobCount = blobCount;
            this.concurrency = concurrency;
            this.readNodeCount = readNodeCount;
            this.earlyReadNodeCount = earlyReadNodeCount;
            this.maxBlobSize = maxBlobSize;
            this.maxTotalDataSize = maxTotalDataSize;
            this.seed = seed;
            this.rareActionProbability = rareActionProbability;
            this.blobPath = blobPath;
            this.summary = summary;
            this.blobResponses = blobResponses;
            this.listingTimeNanos = listingTimeNanos;
            this.deleteTimeNanos = deleteTimeNanos;
        }

        public Response(StreamInput in) throws IOException {
            this.coordinatingNodeId = in.readString();
            this.coordinatingNodeName = in.readString();
            this.repositoryName = in.readString();
            this.blobCount = in.readVInt();
            this.concurrency = in.readVInt();
            this.readNodeCount = in.readVInt();
            this.earlyReadNodeCount = in.readVInt();
            this.maxBlobSize = ByteSizeValue.readFrom((StreamInput)in);
            this.maxTotalDataSize = ByteSizeValue.readFrom((StreamInput)in);
            this.seed = in.readLong();
            this.rareActionProbability = in.readDouble();
            this.blobPath = in.readString();
            this.summary = new RepositoryPerformanceSummary(in);
            this.blobResponses = in.readCollectionAsList(BlobAnalyzeAction.Response::new);
            this.listingTimeNanos = in.readVLong();
            this.deleteTimeNanos = in.readVLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.coordinatingNodeId);
            out.writeString(this.coordinatingNodeName);
            out.writeString(this.repositoryName);
            out.writeVInt(this.blobCount);
            out.writeVInt(this.concurrency);
            out.writeVInt(this.readNodeCount);
            out.writeVInt(this.earlyReadNodeCount);
            this.maxBlobSize.writeTo(out);
            this.maxTotalDataSize.writeTo(out);
            out.writeLong(this.seed);
            out.writeDouble(this.rareActionProbability);
            out.writeString(this.blobPath);
            this.summary.writeTo(out);
            out.writeCollection(this.blobResponses);
            out.writeVLong(this.listingTimeNanos);
            out.writeVLong(this.deleteTimeNanos);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startObject("coordinating_node");
            builder.field("id", this.coordinatingNodeId);
            builder.field("name", this.coordinatingNodeName);
            builder.endObject();
            builder.field("repository", this.repositoryName);
            builder.field("blob_count", this.blobCount);
            builder.field("concurrency", this.concurrency);
            builder.field("read_node_count", this.readNodeCount);
            builder.field("early_read_node_count", this.earlyReadNodeCount);
            builder.humanReadableField("max_blob_size_bytes", "max_blob_size", (Object)this.maxBlobSize);
            builder.humanReadableField("max_total_data_size_bytes", "max_total_data_size", (Object)this.maxTotalDataSize);
            builder.field("seed", this.seed);
            builder.field("rare_action_probability", this.rareActionProbability);
            builder.field("blob_path", this.blobPath);
            builder.startArray("issues_detected");
            builder.endArray();
            builder.field("summary", (ToXContent)this.summary);
            if (this.blobResponses.size() > 0) {
                builder.startArray("details");
                for (BlobAnalyzeAction.Response blobResponse : this.blobResponses) {
                    blobResponse.toXContent(builder, params);
                }
                builder.endArray();
            }
            SnapshotRepositoryTestKit.humanReadableNanos(builder, "listing_elapsed_nanos", "listing_elapsed", this.listingTimeNanos);
            SnapshotRepositoryTestKit.humanReadableNanos(builder, "delete_elapsed_nanos", "delete_elapsed", this.deleteTimeNanos);
            builder.endObject();
            return builder;
        }
    }
}

