/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.logical.command.sys;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.predicate.regex.LikePattern;
import org.elasticsearch.xpack.ql.index.IndexResolver;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.sql.plan.logical.command.Command;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.SqlSession;

public class SysTables
extends Command {
    private final String index;
    private final LikePattern pattern;
    private final LikePattern clusterPattern;
    private final EnumSet<IndexResolver.IndexType> types;

    public SysTables(Source source, LikePattern clusterPattern, String index, LikePattern pattern, EnumSet<IndexResolver.IndexType> types) {
        super(source);
        this.clusterPattern = clusterPattern;
        this.index = index;
        this.pattern = pattern;
        this.types = types;
    }

    protected NodeInfo<SysTables> info() {
        return NodeInfo.create((Node)this, SysTables::new, (Object)this.clusterPattern, (Object)this.index, (Object)this.pattern, this.types);
    }

    @Override
    public List<Attribute> output() {
        return Arrays.asList(this.keyword("TABLE_CAT"), this.keyword("TABLE_SCHEM"), this.keyword("TABLE_NAME"), this.keyword("TABLE_TYPE"), this.keyword("REMARKS"), this.keyword("TYPE_CAT"), this.keyword("TYPE_SCHEM"), this.keyword("TYPE_NAME"), this.keyword("SELF_REFERENCING_COL_NAME"), this.keyword("REF_GENERATION"));
    }

    @Override
    public final void execute(SqlSession session, ActionListener<Cursor.Page> listener) {
        String cRegex;
        String cluster = session.indexResolver().clusterName();
        if ((this.clusterPattern == null || this.clusterPattern.pattern().equals("%")) && this.pattern != null && this.pattern.pattern().isEmpty() && this.index == null && this.types == null) {
            Set clusters = session.indexResolver().remoteClusters();
            clusters.add(cluster);
            ArrayList rows = new ArrayList(clusters.size());
            for (String name : clusters) {
                ArrayList<String> row = new ArrayList<String>(10);
                row.addAll(Arrays.asList(name, null, null, null, null, null, null, null, null, null));
                rows.add(row);
            }
            listener.onResponse((Object)this.of(session, rows));
            return;
        }
        boolean includeFrozen = session.configuration().includeFrozen();
        if (this.types == null && this.clusterPattern != null && this.clusterPattern.pattern().isEmpty() && this.pattern != null && this.pattern.pattern().isEmpty() && this.index == null) {
            ArrayList values = new ArrayList();
            EnumSet typeSet = IndexResolver.IndexType.VALID_REGULAR;
            for (IndexResolver.IndexType type : typeSet) {
                Object[] enumeration = new Object[10];
                enumeration[3] = type.toSql();
                values.add(Arrays.asList(enumeration));
            }
            values.sort(Comparator.comparing(l -> l.get(3).toString()));
            listener.onResponse((Object)this.of(session, values));
            return;
        }
        String string = cRegex = this.clusterPattern != null ? this.clusterPattern.asIndexNameWildcard() : null;
        String idx = Strings.hasText((String)this.index) ? this.index : (this.pattern != null ? this.pattern.asIndexNameWildcard() : "*");
        String regex = this.pattern != null ? this.pattern.asJavaRegex() : null;
        EnumSet tableTypes = this.types;
        if (tableTypes == null) {
            tableTypes = includeFrozen ? IndexResolver.IndexType.VALID_INCLUDE_FROZEN : IndexResolver.IndexType.VALID_REGULAR;
        } else if (includeFrozen && !tableTypes.contains(IndexResolver.IndexType.FROZEN_INDEX)) {
            tableTypes.add(IndexResolver.IndexType.FROZEN_INDEX);
        }
        session.indexResolver().resolveNames(cRegex, idx, regex, tableTypes, listener.delegateFailureAndWrap((delegate, result) -> delegate.onResponse((Object)this.of(session, result.stream().sorted(Comparator.comparing(i -> i.type().toSql()).thenComparing(IndexResolver.IndexInfo::cluster).thenComparing(IndexResolver.IndexInfo::name)).map(t -> Arrays.asList(t.cluster(), null, t.name(), t.type().toSql(), "", null, null, null, null, null)).collect(Collectors.toList())))));
    }

    public int hashCode() {
        return Objects.hash(this.clusterPattern, this.index, this.pattern, this.types);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SysTables other = (SysTables)obj;
        return Objects.equals(this.clusterPattern, other.clusterPattern) && Objects.equals(this.index, other.index) && Objects.equals(this.pattern, other.pattern) && Objects.equals(this.types, other.types);
    }
}

