/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.persistent;

import java.util.Objects;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.persistent.CompletionPersistentTaskAction;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskResponse;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksExecutorRegistry;
import org.elasticsearch.persistent.RemovePersistentTaskAction;
import org.elasticsearch.persistent.StartPersistentTaskAction;
import org.elasticsearch.persistent.UpdatePersistentTaskStatusAction;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;

public class PersistentTasksService {
    private static final Logger logger = LogManager.getLogger(PersistentTasksService.class);
    public static final String PERSISTENT_TASK_ORIGIN = "persistent_tasks";
    private final Client client;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;

    public PersistentTasksService(ClusterService clusterService, ThreadPool threadPool, Client client) {
        this.client = new OriginSettingClient(client, PERSISTENT_TASK_ORIGIN);
        this.clusterService = clusterService;
        this.threadPool = threadPool;
    }

    @Deprecated(forRemoval=true)
    public <Params extends PersistentTaskParams> void sendStartRequest(String taskId, String taskName, Params taskParams, TimeValue timeout, ActionListener<PersistentTasksCustomMetadata.PersistentTask<Params>> listener) {
        this.sendStartRequest(null, taskId, taskName, taskParams, timeout, listener);
    }

    public <Params extends PersistentTaskParams> void sendClusterStartRequest(String taskId, String taskName, Params taskParams, TimeValue timeout, ActionListener<PersistentTasksCustomMetadata.PersistentTask<Params>> listener) {
        this.assertClusterScope();
        assert (PersistentTasksExecutorRegistry.isClusterScopedTask(taskName)) : taskName + " is not a cluster scoped task";
        this.sendStartRequest(null, taskId, taskName, taskParams, timeout, listener);
    }

    public <Params extends PersistentTaskParams> void sendProjectStartRequest(ProjectId projectId, String taskId, String taskName, Params taskParams, TimeValue timeout, ActionListener<PersistentTasksCustomMetadata.PersistentTask<Params>> listener) {
        assert (!PersistentTasksExecutorRegistry.isClusterScopedTask(taskName)) : taskName + " is not a project scoped task";
        this.sendStartRequest(Objects.requireNonNull(projectId), taskId, taskName, taskParams, timeout, listener);
    }

    private <Params extends PersistentTaskParams> void sendStartRequest(@Nullable ProjectId projectId, String taskId, String taskName, Params taskParams, TimeValue timeout, ActionListener<PersistentTasksCustomMetadata.PersistentTask<Params>> listener) {
        ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> wrappedListener = listener.map(t -> t);
        this.execute(projectId, new StartPersistentTaskAction.Request(Objects.requireNonNull(timeout), taskId, taskName, taskParams), StartPersistentTaskAction.INSTANCE, wrappedListener);
    }

    @Deprecated(forRemoval=true)
    public void sendCompletionRequest(String taskId, long taskAllocationId, @Nullable Exception taskFailure, @Nullable String localAbortReason, @Nullable TimeValue timeout, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.sendCompletionRequest(null, taskId, taskAllocationId, taskFailure, localAbortReason, timeout, listener);
    }

    public void sendClusterCompletionRequest(String taskId, long taskAllocationId, @Nullable Exception taskFailure, @Nullable String localAbortReason, @Nullable TimeValue timeout, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.assertClusterScope();
        this.sendCompletionRequest(null, taskId, taskAllocationId, taskFailure, localAbortReason, timeout, listener);
    }

    public void sendProjectCompletionRequest(ProjectId projectId, String taskId, long taskAllocationId, @Nullable Exception taskFailure, @Nullable String localAbortReason, @Nullable TimeValue timeout, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.sendCompletionRequest(Objects.requireNonNull(projectId), taskId, taskAllocationId, taskFailure, localAbortReason, timeout, listener);
    }

    private void sendCompletionRequest(@Nullable ProjectId projectId, String taskId, long taskAllocationId, @Nullable Exception taskFailure, @Nullable String localAbortReason, @Nullable TimeValue timeout, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.execute(projectId, new CompletionPersistentTaskAction.Request(Objects.requireNonNull(timeout), taskId, taskAllocationId, taskFailure, localAbortReason), CompletionPersistentTaskAction.INSTANCE, listener);
    }

    void sendCancelRequest(long taskId, String reason, ActionListener<ListTasksResponse> listener) {
        CancelTasksRequest request = new CancelTasksRequest();
        request.setTargetTaskId(new TaskId(this.clusterService.localNode().getId(), taskId));
        request.setReason(reason);
        try {
            this.client.admin().cluster().cancelTasks(request, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    @Deprecated(forRemoval=true)
    void sendUpdateStateRequest(String taskId, long taskAllocationID, PersistentTaskState taskState, TimeValue timeout, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.sendUpdateStateRequest(null, taskId, taskAllocationID, taskState, timeout, listener);
    }

    void sendClusterUpdateStateRequest(String taskId, long taskAllocationID, PersistentTaskState taskState, TimeValue timeout, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.assertClusterScope();
        this.sendUpdateStateRequest(null, taskId, taskAllocationID, taskState, timeout, listener);
    }

    void sendProjectUpdateStateRequest(ProjectId projectId, String taskId, long taskAllocationID, PersistentTaskState taskState, TimeValue timeout, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.sendUpdateStateRequest(Objects.requireNonNull(projectId), taskId, taskAllocationID, taskState, timeout, listener);
    }

    private void sendUpdateStateRequest(@Nullable ProjectId projectId, String taskId, long taskAllocationID, PersistentTaskState taskState, TimeValue timeout, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.execute(projectId, new UpdatePersistentTaskStatusAction.Request(Objects.requireNonNull(timeout), taskId, taskAllocationID, taskState), UpdatePersistentTaskStatusAction.INSTANCE, listener);
    }

    public void sendRemoveRequest(String taskId, TimeValue timeout, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.sendRemoveRequest(null, taskId, timeout, listener);
    }

    public void sendClusterRemoveRequest(String taskId, TimeValue timeout, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.assertClusterScope();
        this.sendRemoveRequest(null, taskId, timeout, listener);
    }

    public void sendProjectRemoveRequest(ProjectId projectId, String taskId, TimeValue timeout, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.sendRemoveRequest(Objects.requireNonNull(projectId), taskId, timeout, listener);
    }

    private void sendRemoveRequest(@Nullable ProjectId projectId, String taskId, TimeValue timeout, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.execute(projectId, new RemovePersistentTaskAction.Request(Objects.requireNonNull(timeout), taskId), RemovePersistentTaskAction.INSTANCE, listener);
    }

    private <Req extends ActionRequest, Resp extends PersistentTaskResponse> void execute(@Nullable ProjectId projectId, Req request, ActionType<Resp> action, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        try {
            this.getDefaultOrProjectClient(projectId).execute(action, request, listener.map(PersistentTaskResponse::getTask));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    @Deprecated(forRemoval=true)
    public void waitForPersistentTaskCondition(String taskId, Predicate<PersistentTasksCustomMetadata.PersistentTask<?>> predicate, @Nullable TimeValue timeout, WaitForPersistentTaskListener<?> listener) {
        ProjectId projectId = this.clusterService.state().metadata().getProject().id();
        this.waitForPersistentTaskCondition(projectId, taskId, predicate, timeout, listener);
    }

    public void waitForPersistentTaskCondition(final ProjectId projectId, final String taskId, Predicate<PersistentTasksCustomMetadata.PersistentTask<?>> predicate, @Nullable TimeValue timeout, final WaitForPersistentTaskListener<?> listener) {
        ClusterStateObserver.waitForState(this.clusterService, this.threadPool.getThreadContext(), new ClusterStateObserver.Listener(){

            @Override
            public void onNewClusterState(ClusterState state) {
                ProjectMetadata project = state.metadata().projects().get(projectId);
                listener.onResponse(project == null ? null : PersistentTasksCustomMetadata.getTaskWithId(project, taskId));
            }

            @Override
            public void onClusterServiceClose() {
                listener.onFailure(new NodeClosedException(PersistentTasksService.this.clusterService.localNode()));
            }

            @Override
            public void onTimeout(TimeValue timeout) {
                listener.onTimeout(timeout);
            }
        }, clusterState -> {
            ProjectMetadata project = clusterState.metadata().projects().get(projectId);
            if (project == null) {
                logger.debug("project [{}] not found while waiting for persistent task [{}] to pass predicate", (Object)projectId, (Object)taskId);
                return predicate.test(null);
            }
            return predicate.test(PersistentTasksCustomMetadata.getTaskWithId(project, taskId));
        }, timeout, logger);
    }

    ClusterService getClusterService() {
        return this.clusterService;
    }

    ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void waitForPersistentTasksCondition(ProjectId projectId, Predicate<PersistentTasksCustomMetadata> predicate, @Nullable TimeValue timeout, final ActionListener<Boolean> listener) {
        ClusterStateObserver.waitForState(this.clusterService, this.threadPool.getThreadContext(), new ClusterStateObserver.Listener(){

            @Override
            public void onNewClusterState(ClusterState state) {
                listener.onResponse(true);
            }

            @Override
            public void onClusterServiceClose() {
                listener.onFailure(new NodeClosedException(PersistentTasksService.this.clusterService.localNode()));
            }

            @Override
            public void onTimeout(TimeValue timeout) {
                listener.onFailure(new IllegalStateException("Timed out when waiting for persistent tasks after " + String.valueOf(timeout)));
            }
        }, clusterState -> {
            ProjectMetadata project = clusterState.metadata().projects().get(projectId);
            if (project == null) {
                logger.debug("project [{}] not found while waiting for persistent tasks condition", (Object)projectId);
                return predicate.test(null);
            }
            return predicate.test(PersistentTasksCustomMetadata.get(project));
        }, timeout, logger);
    }

    private Client getDefaultOrProjectClient(@Nullable ProjectId projectId) {
        if (projectId == null) {
            return this.client;
        }
        ProjectId currentProjectId = this.client.projectResolver().getProjectId();
        if (projectId.equals(currentProjectId)) {
            return this.client;
        }
        return this.client.projectClient(projectId);
    }

    private void assertClusterScope() {
        ProjectResolver projectResolver = this.client.projectResolver();
        assert (projectResolver.getProjectId() == null || ProjectId.DEFAULT.equals(projectResolver.getProjectId()));
    }

    public static interface WaitForPersistentTaskListener<P extends PersistentTaskParams>
    extends ActionListener<PersistentTasksCustomMetadata.PersistentTask<P>> {
        default public void onTimeout(TimeValue timeout) {
            this.onFailure(new IllegalStateException("Timed out when waiting for persistent task after " + String.valueOf(timeout)));
        }
    }
}

