/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.support;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.LifecyclePolicyConfig;
import org.elasticsearch.xpack.watcher.Watcher;

public class WatcherIndexTemplateRegistry
extends IndexTemplateRegistry {
    public static final String WATCHER_TEMPLATE_VERSION_VARIABLE = "xpack.watcher.template.version";
    private final boolean ilmManagementEnabled;
    private static final Map<String, ComposableIndexTemplate> TEMPLATES_WATCH_HISTORY = WatcherIndexTemplateRegistry.parseComposableTemplates((IndexTemplateConfig[])new IndexTemplateConfig[]{new IndexTemplateConfig(".watch-history-17", "/watch-history.json", 17, "xpack.watcher.template.version")});
    private static final Map<String, ComposableIndexTemplate> TEMPLATES_WATCH_HISTORY_NO_ILM = WatcherIndexTemplateRegistry.parseComposableTemplates((IndexTemplateConfig[])new IndexTemplateConfig[]{new IndexTemplateConfig(".watch-history-no-ilm-17", "/watch-history-no-ilm.json", 17, "xpack.watcher.template.version")});
    private static final LifecyclePolicyConfig LIFECYCLE_POLICIES = new LifecyclePolicyConfig("watch-history-ilm-policy-16", "/watch-history-ilm-policy.json");

    public WatcherIndexTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        super(nodeSettings, clusterService, threadPool, client, xContentRegistry);
        this.ilmManagementEnabled = (Boolean)Watcher.USE_ILM_INDEX_MANAGEMENT.get(nodeSettings);
    }

    protected Map<String, ComposableIndexTemplate> getComposableTemplateConfigs() {
        return this.ilmManagementEnabled ? TEMPLATES_WATCH_HISTORY : TEMPLATES_WATCH_HISTORY_NO_ILM;
    }

    protected List<LifecyclePolicyConfig> getLifecycleConfigs() {
        return List.of(LIFECYCLE_POLICIES);
    }

    protected List<LifecyclePolicy> getLifecyclePolicies() {
        return (Boolean)Watcher.USE_ILM_INDEX_MANAGEMENT.get(this.settings) == false ? Collections.emptyList() : this.lifecyclePolicies;
    }

    protected String getOrigin() {
        return "watcher";
    }

    public static boolean validate(ClusterState state) {
        return state.getMetadata().getProject().templatesV2().keySet().stream().filter(s -> s.startsWith(".watch-history-")).map(s -> Integer.valueOf(s.substring(s.lastIndexOf(45) + 1))).anyMatch(version -> version >= 12);
    }
}

