/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.optimizer.LocalPhysicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.PhysicalVerifier;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.EnableSpatialDistancePushdown;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.InsertFieldExtraction;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.ParallelizeTimeSeriesSource;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.PushFiltersToSource;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.PushLimitToSource;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.PushSampleToSource;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.PushStatsToSource;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.PushTopNToSource;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.ReplaceSourceAttributes;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.SpatialDocValuesExtraction;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.SpatialShapeBoundsExtraction;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.rule.ParameterizedRuleExecutor;
import org.elasticsearch.xpack.esql.rule.Rule;
import org.elasticsearch.xpack.esql.rule.RuleExecutor;

public class LocalPhysicalPlanOptimizer
extends ParameterizedRuleExecutor<PhysicalPlan, LocalPhysicalOptimizerContext> {
    private static final List<RuleExecutor.Batch<PhysicalPlan>> RULES = LocalPhysicalPlanOptimizer.rules(true);
    private final PhysicalVerifier verifier = PhysicalVerifier.INSTANCE;

    public LocalPhysicalPlanOptimizer(LocalPhysicalOptimizerContext context) {
        super(context);
    }

    public PhysicalPlan localOptimize(PhysicalPlan plan) {
        return this.verify(this.execute(plan));
    }

    PhysicalPlan verify(PhysicalPlan plan) {
        Failures failures = this.verifier.verify(plan);
        if (failures.hasFailures()) {
            throw new VerificationException(failures);
        }
        return plan;
    }

    @Override
    protected List<RuleExecutor.Batch<PhysicalPlan>> batches() {
        return RULES;
    }

    protected static List<RuleExecutor.Batch<PhysicalPlan>> rules(boolean optimizeForEsSource) {
        ArrayList<Rule> esSourceRules = new ArrayList<Rule>(6);
        esSourceRules.add(new ReplaceSourceAttributes());
        if (optimizeForEsSource) {
            esSourceRules.add(new PushTopNToSource());
            esSourceRules.add(new PushLimitToSource());
            esSourceRules.add(new PushFiltersToSource());
            esSourceRules.add(new PushSampleToSource());
            esSourceRules.add(new PushStatsToSource());
            esSourceRules.add(new EnableSpatialDistancePushdown());
        }
        RuleExecutor.Batch pushdown = new RuleExecutor.Batch("Push to ES", (Rule[])esSourceRules.toArray(Rule[]::new));
        RuleExecutor.Batch fieldExtraction = new RuleExecutor.Batch("Field extraction", RuleExecutor.Limiter.ONCE, new InsertFieldExtraction(), new SpatialDocValuesExtraction(), new SpatialShapeBoundsExtraction(), new ParallelizeTimeSeriesSource());
        return List.of(pushdown, fieldExtraction);
    }
}

