/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb.patternedtext;

import java.io.IOException;
import org.apache.lucene.index.LeafReader;
import org.elasticsearch.index.mapper.CompositeSyntheticFieldLoader;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.logsdb.patternedtext.PatternedTextDocValues;

class PatternedTextSyntheticFieldLoaderLayer
implements CompositeSyntheticFieldLoader.DocValuesLayer {
    private final String name;
    private final String templateFieldName;
    private final String argsFieldName;
    private PatternedTextSyntheticFieldLoader loader;

    PatternedTextSyntheticFieldLoaderLayer(String name, String templateFieldName, String argsFieldName) {
        this.name = name;
        this.templateFieldName = templateFieldName;
        this.argsFieldName = argsFieldName;
    }

    public long valueCount() {
        return this.loader != null && this.loader.hasValue() ? 1L : 0L;
    }

    public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
        PatternedTextDocValues docValues = PatternedTextDocValues.from(leafReader, this.templateFieldName, this.argsFieldName);
        if (docValues == null) {
            return null;
        }
        this.loader = new PatternedTextSyntheticFieldLoader(docValues);
        return this.loader;
    }

    public boolean hasValue() {
        return this.loader != null && this.loader.hasValue();
    }

    public void write(XContentBuilder b) throws IOException {
        if (this.loader != null) {
            this.loader.write(b);
        }
    }

    public String fieldName() {
        return this.name;
    }

    private static class PatternedTextSyntheticFieldLoader
    implements SourceLoader.SyntheticFieldLoader.DocValuesLoader {
        private final PatternedTextDocValues docValues;
        private boolean hasValue = false;

        PatternedTextSyntheticFieldLoader(PatternedTextDocValues docValues) {
            this.docValues = docValues;
        }

        public boolean hasValue() {
            assert (this.docValues.docID() != Integer.MAX_VALUE);
            return this.hasValue;
        }

        public boolean advanceToDoc(int docId) throws IOException {
            this.hasValue = this.docValues.advanceExact(docId);
            return this.hasValue;
        }

        public void write(XContentBuilder b) throws IOException {
            if (this.hasValue) {
                b.value(this.docValues.binaryValue().utf8ToString());
            }
        }
    }
}

