/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb.patternedtext;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.FeatureFlag;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.CompositeSyntheticFieldLoader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.TextParams;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.xpack.logsdb.patternedtext.PatternedTextFieldType;
import org.elasticsearch.xpack.logsdb.patternedtext.PatternedTextSyntheticFieldLoaderLayer;
import org.elasticsearch.xpack.logsdb.patternedtext.PatternedTextValueProcessor;

public class PatternedTextFieldMapper
extends FieldMapper {
    public static final FeatureFlag PATTERNED_TEXT_MAPPER = new FeatureFlag("patterned_text");
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.indexVersionCreated(), c.getIndexAnalyzers()));
    private final IndexVersion indexCreatedVersion;
    private final IndexAnalyzers indexAnalyzers;
    private final NamedAnalyzer indexAnalyzer;
    private final int positionIncrementGap;
    private final FieldType fieldType;

    private PatternedTextFieldMapper(String simpleName, PatternedTextFieldType mappedFieldPatternedTextFieldType, FieldMapper.BuilderParams builderParams, Builder builder) {
        super(simpleName, (MappedFieldType)mappedFieldPatternedTextFieldType, builderParams);
        assert (mappedFieldPatternedTextFieldType.getTextSearchInfo().isTokenized());
        assert (!mappedFieldPatternedTextFieldType.hasDocValues());
        this.fieldType = Defaults.FIELD_TYPE;
        this.indexCreatedVersion = builder.indexCreatedVersion;
        this.indexAnalyzers = builder.analyzers.indexAnalyzers;
        this.indexAnalyzer = builder.analyzers.getIndexAnalyzer();
        this.positionIncrementGap = (Integer)builder.analyzers.positionIncrementGap.getValue();
    }

    public Map<String, NamedAnalyzer> indexAnalyzers() {
        return Map.of(this.mappedFieldType.name(), this.indexAnalyzer);
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.indexCreatedVersion, this.indexAnalyzers).init(this);
    }

    protected void parseCreateField(DocumentParserContext context) throws IOException {
        String value = context.parser().textOrNull();
        if (value == null) {
            return;
        }
        IndexableField existingValue = context.doc().getField(this.fieldType().name());
        if (existingValue != null) {
            throw new IllegalArgumentException("Multiple values are not allowed for field [" + this.fieldType().name() + "].");
        }
        PatternedTextValueProcessor.Parts parts = PatternedTextValueProcessor.split(value);
        context.doc().add((IndexableField)new Field(this.fieldType().name(), (CharSequence)value, (IndexableFieldType)this.fieldType));
        context.doc().add((IndexableField)new SortedSetDocValuesField(this.fieldType().templateFieldName(), new BytesRef((CharSequence)parts.template())));
        if (!parts.args().isEmpty()) {
            String remainingArgs = PatternedTextValueProcessor.encodeRemainingArgs(parts);
            context.doc().add((IndexableField)new SortedSetDocValuesField(this.fieldType().argsFieldName(), new BytesRef((CharSequence)remainingArgs)));
        }
    }

    protected String contentType() {
        return "patterned_text";
    }

    public PatternedTextFieldType fieldType() {
        return (PatternedTextFieldType)super.fieldType();
    }

    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        return new FieldMapper.SyntheticSourceSupport.Native(() -> new CompositeSyntheticFieldLoader(this.leafName(), this.fullPath(), new CompositeSyntheticFieldLoader.Layer[]{new PatternedTextSyntheticFieldLoaderLayer(this.fieldType().name(), this.fieldType().templateFieldName(), this.fieldType().argsFieldName())}));
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE;

        static {
            FieldType ft = new FieldType();
            ft.setTokenized(true);
            ft.setStored(false);
            ft.setStoreTermVectors(false);
            ft.setOmitNorms(true);
            ft.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE = Mapper.freezeAndDeduplicateFieldType((FieldType)ft);
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final IndexVersion indexCreatedVersion;
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final TextParams.Analyzers analyzers;

        public Builder(String name, IndexVersion indexCreatedVersion, IndexAnalyzers indexAnalyzers) {
            super(name);
            this.indexCreatedVersion = indexCreatedVersion;
            this.analyzers = new TextParams.Analyzers(indexAnalyzers, m -> ((PatternedTextFieldMapper)m).indexAnalyzer, m -> ((PatternedTextFieldMapper)m).positionIncrementGap, indexCreatedVersion);
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.meta};
        }

        private PatternedTextFieldType buildFieldType(MapperBuilderContext context) {
            NamedAnalyzer searchAnalyzer = this.analyzers.getSearchAnalyzer();
            NamedAnalyzer searchQuoteAnalyzer = this.analyzers.getSearchQuoteAnalyzer();
            NamedAnalyzer indexAnalyzer = this.analyzers.getIndexAnalyzer();
            TextSearchInfo tsi = new TextSearchInfo(Defaults.FIELD_TYPE, null, searchAnalyzer, searchQuoteAnalyzer);
            return new PatternedTextFieldType(context.buildFullName(this.leafName()), tsi, (Analyzer)indexAnalyzer, context.isSourceSynthetic(), (Map)this.meta.getValue());
        }

        public PatternedTextFieldMapper build(MapperBuilderContext context) {
            return new PatternedTextFieldMapper(this.leafName(), this.buildFieldType(context), this.builderParams((Mapper.Builder)this, context), this);
        }
    }
}

