/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexSortConfig;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.logsdb.LogsDBPlugin;
import org.elasticsearch.xpack.logsdb.LogsdbLicenseService;

final class LogsdbIndexModeSettingsProvider
implements IndexSettingProvider {
    private static final Logger LOGGER = LogManager.getLogger(LogsdbIndexModeSettingsProvider.class);
    static final String LOGS_PATTERN = "logs-*-*";
    private static final Set<String> MAPPING_INCLUDES = Set.of("_source.*", "properties.host**", "subobjects").stream().flatMap(v -> Stream.of(v, "_doc." + v)).collect(Collectors.toSet());
    private final LogsdbLicenseService licenseService;
    private final SetOnce<CheckedFunction<IndexMetadata, MapperService, IOException>> mapperServiceFactory = new SetOnce();
    private final SetOnce<Supplier<IndexVersion>> createdIndexVersion = new SetOnce();
    private final SetOnce<Supplier<Version>> minNodeVersion = new SetOnce();
    private final SetOnce<Boolean> supportFallbackToStoredSource = new SetOnce();
    private final SetOnce<Boolean> supportFallbackLogsdbRouting = new SetOnce();
    private volatile boolean isLogsdbEnabled;

    LogsdbIndexModeSettingsProvider(LogsdbLicenseService licenseService, Settings settings) {
        this.licenseService = licenseService;
        this.isLogsdbEnabled = (Boolean)LogsDBPlugin.CLUSTER_LOGSDB_ENABLED.get(settings);
    }

    void updateClusterIndexModeLogsdbEnabled(boolean isLogsdbEnabled) {
        this.isLogsdbEnabled = isLogsdbEnabled;
    }

    void init(CheckedFunction<IndexMetadata, MapperService, IOException> factory, Supplier<IndexVersion> indexVersion, Supplier<Version> minNodeVersion, boolean supportFallbackToStoredSource, boolean supportFallbackLogsdbRouting) {
        this.mapperServiceFactory.set(factory);
        this.createdIndexVersion.set(indexVersion);
        this.minNodeVersion.set(minNodeVersion);
        this.supportFallbackToStoredSource.set((Object)supportFallbackToStoredSource);
        this.supportFallbackLogsdbRouting.set((Object)supportFallbackLogsdbRouting);
    }

    public boolean overrulesTemplateAndRequestSettings() {
        return true;
    }

    public Settings getAdditionalIndexSettings(String indexName, String dataStreamName, IndexMode templateIndexMode, ProjectMetadata metadata, Instant resolvedAt, Settings settings, List<CompressedXContent> combinedTemplateMappings) {
        boolean legacyLicensedUsageOfSyntheticSourceAllowed;
        Settings.Builder settingsBuilder = null;
        boolean isLogsDB = templateIndexMode == IndexMode.LOGSDB;
        boolean isTemplateValidation = "validate-index-name".equals(indexName);
        if (this.isLogsdbEnabled && dataStreamName != null && LogsdbIndexModeSettingsProvider.resolveIndexMode(settings.get(IndexSettings.MODE.getKey())) == null && LogsdbIndexModeSettingsProvider.matchesLogsPattern(dataStreamName)) {
            settingsBuilder = Settings.builder().put(IndexSettings.MODE.getKey(), IndexMode.LOGSDB.getName());
            settings = Settings.builder().put(IndexSettings.MODE.getKey(), IndexMode.LOGSDB.getName()).put(settings).build();
            isLogsDB = true;
        }
        MappingHints mappingHints = this.getMappingHints(indexName, templateIndexMode, settings, combinedTemplateMappings);
        if (mappingHints.hasSyntheticSourceUsage && ((Boolean)this.supportFallbackToStoredSource.get()).booleanValue() && ((Version)((Supplier)this.minNodeVersion.get()).get()).onOrAfter((VersionId)Version.V_8_17_0) && this.licenseService.fallbackToStoredSource(isTemplateValidation, legacyLicensedUsageOfSyntheticSourceAllowed = this.isLegacyLicensedUsageOfSyntheticSourceAllowed(templateIndexMode, indexName, dataStreamName))) {
            LOGGER.debug("creation of index [{}] with synthetic source without it being allowed", (Object)indexName);
            settingsBuilder = LogsdbIndexModeSettingsProvider.getBuilder(settingsBuilder).put(IndexSettings.INDEX_MAPPER_SOURCE_MODE_SETTING.getKey(), SourceFieldMapper.Mode.STORED.toString());
        }
        if (isLogsDB && ((Version)((Supplier)this.minNodeVersion.get()).get()).onOrAfter((VersionId)Version.V_8_18_0)) {
            if (mappingHints.sortOnHostName) {
                if (mappingHints.addHostNameField) {
                    settingsBuilder = LogsdbIndexModeSettingsProvider.getBuilder(settingsBuilder).put(IndexSettings.LOGSDB_ADD_HOST_NAME_FIELD.getKey(), true);
                }
                settingsBuilder = LogsdbIndexModeSettingsProvider.getBuilder(settingsBuilder).put(IndexSettings.LOGSDB_SORT_ON_HOST_NAME.getKey(), true);
            }
            if (settings.getAsBoolean(IndexSettings.LOGSDB_ROUTE_ON_SORT_FIELDS.getKey(), Boolean.valueOf(false)).booleanValue()) {
                if (!((Boolean)this.supportFallbackLogsdbRouting.get()).booleanValue() || this.licenseService.allowLogsdbRoutingOnSortField(isTemplateValidation)) {
                    ArrayList<String> sortFields = new ArrayList<String>(settings.getAsList(IndexSortConfig.INDEX_SORT_FIELD_SETTING.getKey()));
                    sortFields.removeIf(s -> s.equals("@timestamp"));
                    if (sortFields.size() < 2) {
                        throw new IllegalStateException(String.format(Locale.ROOT, "data stream [%s] in logsdb mode and with [%s] index setting has only %d sort fields (excluding timestamp), needs at least 2", dataStreamName, IndexSettings.LOGSDB_ROUTE_ON_SORT_FIELDS.getKey(), sortFields.size()));
                    }
                    if (settings.hasValue(IndexMetadata.INDEX_ROUTING_PATH.getKey())) {
                        List routingPaths = settings.getAsList(IndexMetadata.INDEX_ROUTING_PATH.getKey());
                        if (!routingPaths.equals(sortFields)) {
                            throw new IllegalStateException(String.format(Locale.ROOT, "data stream [%s] in logsdb mode and with [%s] index setting has mismatching sort and routing fields, [index.routing_path:%s], [index.sort.fields:%s]", dataStreamName, IndexSettings.LOGSDB_ROUTE_ON_SORT_FIELDS.getKey(), routingPaths, sortFields));
                        }
                    } else {
                        settingsBuilder = LogsdbIndexModeSettingsProvider.getBuilder(settingsBuilder).putList(IndexMetadata.INDEX_ROUTING_PATH.getKey(), sortFields);
                    }
                } else {
                    LOGGER.debug("creation of index [{}] with logsdb mode and routing on sort fields without it being allowed", (Object)indexName);
                    settingsBuilder = LogsdbIndexModeSettingsProvider.getBuilder(settingsBuilder).put(IndexSettings.LOGSDB_ROUTE_ON_SORT_FIELDS.getKey(), false);
                }
            }
        }
        return settingsBuilder == null ? Settings.EMPTY : settingsBuilder.build();
    }

    private static boolean matchesLogsPattern(String name) {
        return Regex.simpleMatch((String)LOGS_PATTERN, (String)name);
    }

    private static IndexMode resolveIndexMode(String mode) {
        return mode != null ? Enum.valueOf(IndexMode.class, mode.toUpperCase(Locale.ROOT)) : null;
    }

    private static Settings.Builder getBuilder(Settings.Builder builder) {
        if (builder == null) {
            return Settings.builder();
        }
        return builder;
    }

    MappingHints getMappingHints(String indexName, IndexMode templateIndexMode, Settings indexTemplateAndCreateRequestSettings, List<CompressedXContent> combinedTemplateMappings) {
        MappingHints mappingHints;
        block15: {
            if ("validate-index-name".equals(indexName)) {
                return MappingHints.EMPTY;
            }
            IndexMetadata tmpIndexMetadata = this.buildIndexMetadataForMapperService(indexName, templateIndexMode, indexTemplateAndCreateRequestSettings);
            IndexMode indexMode = tmpIndexMetadata.getIndexMode();
            boolean hasSyntheticSourceUsage = false;
            if (IndexSettings.INDEX_MAPPER_SOURCE_MODE_SETTING.exists(tmpIndexMetadata.getSettings()) || indexMode == IndexMode.LOGSDB || indexMode == IndexMode.TIME_SERIES) {
                SourceFieldMapper.Mode sourceMode = (SourceFieldMapper.Mode)IndexSettings.INDEX_MAPPER_SOURCE_MODE_SETTING.get(tmpIndexMetadata.getSettings());
                boolean bl = hasSyntheticSourceUsage = sourceMode == SourceFieldMapper.Mode.SYNTHETIC;
                if (!((List)IndexSortConfig.INDEX_SORT_FIELD_SETTING.get(indexTemplateAndCreateRequestSettings)).isEmpty()) {
                    return new MappingHints(hasSyntheticSourceUsage, false, false);
                }
                if (((Boolean)IndexSettings.LOGSDB_SORT_ON_HOST_NAME.get(indexTemplateAndCreateRequestSettings)).booleanValue() && ((Boolean)IndexSettings.LOGSDB_ADD_HOST_NAME_FIELD.get(indexTemplateAndCreateRequestSettings)).booleanValue()) {
                    return new MappingHints(hasSyntheticSourceUsage, true, true);
                }
            }
            MapperService mapperService = (MapperService)((CheckedFunction)this.mapperServiceFactory.get()).apply((Object)tmpIndexMetadata);
            try {
                KeywordFieldMapper kfm;
                NumberFieldMapper nfm;
                if (combinedTemplateMappings == null || combinedTemplateMappings.isEmpty()) {
                    combinedTemplateMappings = List.of(new CompressedXContent("{}"));
                } else {
                    ArrayList<CompressedXContent> filteredMappings = new ArrayList<CompressedXContent>(combinedTemplateMappings.size());
                    for (CompressedXContent mappingSource : combinedTemplateMappings) {
                        BytesReference ref = mappingSource.compressedReference();
                        Map map = (Map)XContentHelper.convertToMap((BytesReference)ref, (boolean)true, (XContentType)XContentType.JSON, MAPPING_INCLUDES, Set.of()).v2();
                        filteredMappings.add(new CompressedXContent(map));
                    }
                    combinedTemplateMappings = filteredMappings;
                }
                mapperService.merge("_doc", combinedTemplateMappings, MapperService.MergeReason.INDEX_TEMPLATE);
                Mapper hostName = mapperService.mappingLookup().getMapper("host.name");
                hasSyntheticSourceUsage = hasSyntheticSourceUsage || mapperService.documentMapper().sourceMapper().isSynthetic();
                boolean addHostNameField = (Boolean)IndexSettings.LOGSDB_ADD_HOST_NAME_FIELD.get(indexTemplateAndCreateRequestSettings) != false || hostName == null && mapperService.mappingLookup().objectMappers().get("host.name") == null && (mapperService.mappingLookup().getMapper("host") == null || mapperService.mappingLookup().getMapping().getRoot().subobjects() == ObjectMapper.Subobjects.DISABLED);
                boolean sortOnHostName = (Boolean)IndexSettings.LOGSDB_SORT_ON_HOST_NAME.get(indexTemplateAndCreateRequestSettings) != false || addHostNameField || hostName instanceof NumberFieldMapper && (nfm = (NumberFieldMapper)hostName).fieldType().hasDocValues() || hostName instanceof KeywordFieldMapper && (kfm = (KeywordFieldMapper)hostName).fieldType().hasDocValues();
                mappingHints = new MappingHints(hasSyntheticSourceUsage, sortOnHostName, addHostNameField);
                if (mapperService == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (mapperService != null) {
                        try {
                            mapperService.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AssertionError | Exception e) {
                    LOGGER.warn(() -> Strings.format((String)"unable to create mapper service for index [%s]", (Object[])new Object[]{indexName}), (Throwable)e);
                    return MappingHints.EMPTY;
                }
            }
            mapperService.close();
        }
        return mappingHints;
    }

    private IndexMetadata buildIndexMetadataForMapperService(String indexName, IndexMode templateIndexMode, Settings indexTemplateAndCreateRequestSettings) {
        IndexMetadata.Builder tmpIndexMetadata = IndexMetadata.builder((String)indexName);
        int dummyPartitionSize = (Integer)IndexMetadata.INDEX_ROUTING_PARTITION_SIZE_SETTING.get(indexTemplateAndCreateRequestSettings);
        int dummyShards = indexTemplateAndCreateRequestSettings.getAsInt("index.number_of_shards", Integer.valueOf(dummyPartitionSize == 1 ? 1 : dummyPartitionSize + 1));
        int shardReplicas = indexTemplateAndCreateRequestSettings.getAsInt("index.number_of_replicas", Integer.valueOf(0));
        Settings.Builder finalResolvedSettings = Settings.builder().put("index.version.created", (VersionId)((Supplier)this.createdIndexVersion.get()).get()).put(indexTemplateAndCreateRequestSettings).put("index.number_of_shards", dummyShards).put("index.number_of_replicas", shardReplicas).put("index.uuid", UUIDs.randomBase64UUID()).put(IndexSettings.INDEX_FAST_REFRESH_SETTING.getKey(), false);
        if (templateIndexMode == IndexMode.TIME_SERIES) {
            finalResolvedSettings.put(IndexSettings.MODE.getKey(), (Enum)IndexMode.TIME_SERIES);
            finalResolvedSettings.putList(IndexMetadata.INDEX_ROUTING_PATH.getKey(), List.of("path"));
        }
        tmpIndexMetadata.settings(finalResolvedSettings);
        return tmpIndexMetadata.build();
    }

    private boolean isLegacyLicensedUsageOfSyntheticSourceAllowed(IndexMode templateIndexMode, String indexName, String dataStreamName) {
        if (templateIndexMode == IndexMode.TIME_SERIES) {
            return true;
        }
        if (dataStreamName != null && dataStreamName.startsWith("profiling-")) {
            return true;
        }
        if (indexName.startsWith(".profiling-")) {
            return true;
        }
        return dataStreamName != null && dataStreamName.startsWith("metrics-apm.");
    }

    record MappingHints(boolean hasSyntheticSourceUsage, boolean sortOnHostName, boolean addHostNameField) {
        static MappingHints EMPTY = new MappingHints(false, false, false);
    }
}

