/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.telemetry;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

public record InferenceTimer(Instant startTime, Clock clock) {
    public InferenceTimer {
        Objects.requireNonNull(startTime);
        Objects.requireNonNull(clock);
    }

    public static InferenceTimer start() {
        return InferenceTimer.start(Clock.systemUTC());
    }

    public static InferenceTimer start(Clock clock) {
        return new InferenceTimer(clock.instant(), clock);
    }

    public long elapsedMillis() {
        return Duration.between(this.startTime(), this.clock().instant()).toMillis();
    }
}

