/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.jinaai.rerank;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.jinaai.JinaAIRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.jinaai.JinaAIServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class JinaAIRerankServiceSettings
extends FilteredXContentObject
implements ServiceSettings,
JinaAIRateLimitServiceSettings {
    public static final String NAME = "jinaai_rerank_service_settings";
    private static final Logger logger = LogManager.getLogger(JinaAIRerankServiceSettings.class);
    private final JinaAIServiceSettings commonSettings;

    public static JinaAIRerankServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        JinaAIServiceSettings commonServiceSettings = JinaAIServiceSettings.fromMap(map, context);
        return new JinaAIRerankServiceSettings(commonServiceSettings);
    }

    public JinaAIRerankServiceSettings(JinaAIServiceSettings commonSettings) {
        this.commonSettings = commonSettings;
    }

    public JinaAIRerankServiceSettings(StreamInput in) throws IOException {
        this.commonSettings = new JinaAIServiceSettings(in);
    }

    public JinaAIServiceSettings getCommonSettings() {
        return this.commonSettings;
    }

    public String modelId() {
        return this.commonSettings.modelId();
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.commonSettings.rateLimitSettings();
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder = this.commonSettings.toXContentFragment(builder, params);
        builder.endObject();
        return builder;
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.commonSettings.toXContentFragmentOfExposedFields(builder, params);
        return builder;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.minimumCompatible();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.commonSettings.writeTo(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JinaAIRerankServiceSettings that = (JinaAIRerankServiceSettings)o;
        return Objects.equals(this.commonSettings, that.commonSettings);
    }

    public int hashCode() {
        return Objects.hash(this.commonSettings);
    }
}

