/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai.request;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.UnifiedCompletionRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;

public class GoogleVertexAiUnifiedChatCompletionRequestEntity
implements ToXContentObject {
    private static final String CONTENTS = "contents";
    private static final String ROLE = "role";
    private static final String PARTS = "parts";
    private static final String TEXT = "text";
    private static final String GENERATION_CONFIG = "generationConfig";
    private static final String TEMPERATURE = "temperature";
    private static final String MAX_OUTPUT_TOKENS = "maxOutputTokens";
    private static final String TOP_P = "topP";
    private static final String TOOLS = "tools";
    private static final String FUNCTION_DECLARATIONS = "functionDeclarations";
    private static final String FUNCTION_NAME = "name";
    private static final String FUNCTION_DESCRIPTION = "description";
    private static final String FUNCTION_PARAMETERS = "parameters";
    private static final String FUNCTION_TYPE = "function";
    private static final String TOOL_CONFIG = "toolConfig";
    private static final String FUNCTION_CALLING_CONFIG = "functionCallingConfig";
    private static final String TOOL_MODE = "mode";
    private static final String TOOL_MODE_ANY = "ANY";
    private static final String TOOL_MODE_AUTO = "auto";
    private static final String ALLOWED_FUNCTION_NAMES = "allowedFunctionNames";
    private static final String FUNCTION_CALL = "functionCall";
    private static final String FUNCTION_CALL_NAME = "name";
    private static final String FUNCTION_CALL_ARGS = "args";
    private final UnifiedChatInput unifiedChatInput;
    private static final String USER_ROLE = "user";
    private static final String MODEL_ROLE = "model";
    private static final String ASSISTANT_ROLE = "assistant";
    private static final String SYSTEM_ROLE = "system";
    private static final String TOOL_ROLE = "tool";
    private static final String STOP_SEQUENCES = "stopSequences";
    private static final String SYSTEM_INSTRUCTION = "systemInstruction";

    public GoogleVertexAiUnifiedChatCompletionRequestEntity(UnifiedChatInput unifiedChatInput) {
        this.unifiedChatInput = Objects.requireNonNull(unifiedChatInput);
    }

    private String messageRoleToGoogleVertexAiSupportedRole(String messageRole) {
        String messageRoleLowered = messageRole.toLowerCase(Locale.ROOT);
        if (messageRoleLowered.equals(USER_ROLE)) {
            return USER_ROLE;
        }
        if (messageRole.equals(ASSISTANT_ROLE)) {
            return MODEL_ROLE;
        }
        if (messageRole.equals(TOOL_ROLE)) {
            return MODEL_ROLE;
        }
        String errorMessage = Strings.format((String)"Role [%s] not supported by Google VertexAI ChatCompletion. Supported roles: [%s, %s]", (Object[])new Object[]{messageRole, USER_ROLE, ASSISTANT_ROLE});
        throw new ElasticsearchStatusException(errorMessage, RestStatus.BAD_REQUEST, new Object[0]);
    }

    private void validateAndAddContentObjectsToBuilder(XContentBuilder builder, UnifiedCompletionRequest.ContentObjects contentObjects) throws IOException {
        for (UnifiedCompletionRequest.ContentObject contentObject : contentObjects.contentObjects()) {
            if (!contentObject.type().equals(TEXT)) {
                String errorMessage = Strings.format((String)"Type [%s] not supported by Google VertexAI ChatCompletion. Supported types: [text]", (Object[])new Object[]{contentObject.type()});
                throw new ElasticsearchStatusException(errorMessage, RestStatus.BAD_REQUEST, new Object[0]);
            }
            if (contentObject.text().isEmpty()) {
                return;
            }
            builder.startObject();
            builder.field(TEXT, contentObject.text());
            builder.endObject();
        }
    }

    private static Map<String, String> jsonStringToMap(String jsonString) throws IOException {
        if (jsonString == null || jsonString.isEmpty()) {
            return null;
        }
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        try (XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, jsonString);){
            XContentParser.Token token = parser.nextToken();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)parser);
            Map map = parser.mapStrings();
            return map;
        }
    }

    private void buildSystemInstruction(XContentBuilder builder) throws IOException {
        List messages = this.unifiedChatInput.getRequest().messages();
        List<UnifiedCompletionRequest.Message> systemMessages = messages.stream().filter(message -> message.role().equalsIgnoreCase(SYSTEM_ROLE)).toList();
        if (systemMessages.isEmpty()) {
            return;
        }
        builder.startObject(SYSTEM_INSTRUCTION);
        builder.startArray(PARTS);
        for (UnifiedCompletionRequest.Message systemMessage : systemMessages) {
            Object errorMessage;
            UnifiedCompletionRequest.Content content = systemMessage.content();
            if (content instanceof UnifiedCompletionRequest.ContentString) {
                UnifiedCompletionRequest.ContentString contentString = (UnifiedCompletionRequest.ContentString)content;
                if (contentString.content().isEmpty()) {
                    errorMessage = "System message cannot be empty for Google Vertex AI";
                    throw new ElasticsearchStatusException((String)errorMessage, RestStatus.BAD_REQUEST, new Object[0]);
                }
                builder.startObject();
                builder.field(TEXT, contentString.content());
                builder.endObject();
                continue;
            }
            errorMessage = systemMessage.content();
            if (errorMessage instanceof UnifiedCompletionRequest.ContentObjects) {
                UnifiedCompletionRequest.ContentObjects contentObjects = (UnifiedCompletionRequest.ContentObjects)errorMessage;
                for (UnifiedCompletionRequest.ContentObject contentObject : contentObjects.contentObjects()) {
                    builder.startObject();
                    builder.field(TEXT, contentObject.text());
                    builder.endObject();
                }
                continue;
            }
            errorMessage = "Only text system instructions are supported for Vertex AI";
            throw new ElasticsearchStatusException((String)errorMessage, RestStatus.BAD_REQUEST, new Object[0]);
        }
        builder.endArray();
        builder.endObject();
    }

    private void buildContents(XContentBuilder builder) throws IOException {
        List messages = this.unifiedChatInput.getRequest().messages();
        builder.startArray(CONTENTS);
        for (UnifiedCompletionRequest.Message message : messages) {
            if (message.role().equalsIgnoreCase(SYSTEM_ROLE)) continue;
            builder.startObject();
            builder.field(ROLE, this.messageRoleToGoogleVertexAiSupportedRole(message.role()));
            builder.startArray(PARTS);
            if (message.content() instanceof UnifiedCompletionRequest.ContentString) {
                UnifiedCompletionRequest.ContentString contentString = (UnifiedCompletionRequest.ContentString)message.content();
                if (!contentString.content().isEmpty()) {
                    builder.startObject();
                    builder.field(TEXT, contentString.content());
                    builder.endObject();
                }
            } else if (message.content() instanceof UnifiedCompletionRequest.ContentObjects) {
                UnifiedCompletionRequest.ContentObjects contentObjects = (UnifiedCompletionRequest.ContentObjects)message.content();
                this.validateAndAddContentObjectsToBuilder(builder, contentObjects);
            }
            if (message.toolCalls() != null && !message.toolCalls().isEmpty()) {
                List toolCalls = message.toolCalls();
                for (UnifiedCompletionRequest.ToolCall toolCall : toolCalls) {
                    builder.startObject();
                    builder.startObject(FUNCTION_CALL);
                    builder.field("name", toolCall.function().name());
                    builder.field(FUNCTION_CALL_ARGS, GoogleVertexAiUnifiedChatCompletionRequestEntity.jsonStringToMap(toolCall.function().arguments()));
                    builder.endObject();
                    builder.endObject();
                }
            }
            builder.endArray();
            builder.endObject();
        }
        builder.endArray();
    }

    private void buildTools(XContentBuilder builder) throws IOException {
        UnifiedCompletionRequest request = this.unifiedChatInput.getRequest();
        List tools = request.tools();
        if (tools == null || tools.isEmpty()) {
            return;
        }
        builder.startArray(TOOLS);
        builder.startObject();
        builder.startArray(FUNCTION_DECLARATIONS);
        for (UnifiedCompletionRequest.Tool tool : tools) {
            if (!FUNCTION_TYPE.equals(tool.type())) {
                String errorMessage = Strings.format((String)"Tool type [%s] not supported by Google VertexAI ChatCompletion. Supported types: [%s]", (Object[])new Object[]{tool.type(), FUNCTION_TYPE});
                throw new ElasticsearchStatusException(errorMessage, RestStatus.BAD_REQUEST, new Object[0]);
            }
            UnifiedCompletionRequest.Tool.FunctionField function = tool.function();
            if (function == null) {
                String errorMessage = Strings.format((String)"Tool of type [%s] must have a function definition", (Object[])new Object[]{tool.type()});
                throw new ElasticsearchStatusException(errorMessage, RestStatus.BAD_REQUEST, new Object[0]);
            }
            builder.startObject();
            builder.field("name", function.name());
            if (org.elasticsearch.common.Strings.hasText((String)function.description())) {
                builder.field(FUNCTION_DESCRIPTION, function.description());
            }
            if (function.parameters() != null && !function.parameters().isEmpty()) {
                builder.field(FUNCTION_PARAMETERS, function.parameters());
            }
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        builder.endArray();
    }

    private void buildToolConfig(XContentBuilder builder) throws IOException {
        UnifiedCompletionRequest.ToolChoiceObject toolChoiceObject;
        UnifiedCompletionRequest request = this.unifiedChatInput.getRequest();
        if (!(request.toolChoice() instanceof UnifiedCompletionRequest.ToolChoiceObject)) {
            if (request.toolChoice() instanceof UnifiedCompletionRequest.ToolChoiceString) {
                UnifiedCompletionRequest.ToolChoiceString toolChoiceString = (UnifiedCompletionRequest.ToolChoiceString)request.toolChoice();
                if (toolChoiceString.value().equals(TOOL_MODE_AUTO)) {
                    return;
                }
                throw new ElasticsearchStatusException(Strings.format((String)"Tool choice value [%s] not supported by Google VertexAI ChatCompletion. Supported values: [%s]", (Object[])new Object[]{toolChoiceString.value(), TOOL_MODE_AUTO}), RestStatus.BAD_REQUEST, new Object[0]);
            }
            return;
        }
        UnifiedCompletionRequest.ToolChoiceObject toolChoice = toolChoiceObject = (UnifiedCompletionRequest.ToolChoiceObject)request.toolChoice();
        if (!FUNCTION_TYPE.equals(toolChoice.type())) {
            String errorMessage = Strings.format((String)"Tool choice type [%s] not supported by Google VertexAI ChatCompletion. Supported types: [%s]", (Object[])new Object[]{toolChoice.type(), FUNCTION_TYPE});
            throw new ElasticsearchStatusException(errorMessage, RestStatus.BAD_REQUEST, new Object[0]);
        }
        builder.startObject(TOOL_CONFIG);
        builder.startObject(FUNCTION_CALLING_CONFIG);
        UnifiedCompletionRequest.ToolChoiceObject.FunctionField chosenFunction = toolChoice.function();
        if (chosenFunction != null) {
            builder.field(TOOL_MODE, TOOL_MODE_ANY);
            if (org.elasticsearch.common.Strings.hasText((String)chosenFunction.name())) {
                builder.startArray(ALLOWED_FUNCTION_NAMES);
                builder.value(chosenFunction.name());
                builder.endArray();
            }
            builder.endObject();
            builder.endObject();
        }
    }

    private void buildGenerationConfig(XContentBuilder builder) throws IOException {
        boolean hasAnyConfig;
        UnifiedCompletionRequest request = this.unifiedChatInput.getRequest();
        boolean bl = hasAnyConfig = request.stop() != null || request.temperature() != null || request.maxCompletionTokens() != null || request.topP() != null;
        if (!hasAnyConfig) {
            return;
        }
        builder.startObject(GENERATION_CONFIG);
        if (request.stop() != null) {
            builder.stringListField(STOP_SEQUENCES, (Collection)request.stop());
        }
        if (request.temperature() != null) {
            builder.field(TEMPERATURE, request.temperature());
        }
        if (request.maxCompletionTokens() != null) {
            builder.field(MAX_OUTPUT_TOKENS, request.maxCompletionTokens());
        }
        if (request.topP() != null) {
            builder.field(TOP_P, request.topP());
        }
        builder.endObject();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.buildContents(builder);
        this.buildGenerationConfig(builder);
        this.buildTools(builder);
        this.buildToolConfig(builder);
        this.buildSystemInstruction(builder);
        builder.endObject();
        return builder;
    }
}

