/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai.request;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.common.Strings;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.googlevertexai.embeddings.GoogleVertexAiEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.googlevertexai.request.GoogleVertexAiEmbeddingsRequestEntity;
import org.elasticsearch.xpack.inference.services.googlevertexai.request.GoogleVertexAiRequest;

public class GoogleVertexAiEmbeddingsRequest
implements GoogleVertexAiRequest {
    private final Truncator truncator;
    private final Truncator.TruncationResult truncationResult;
    private final InputType inputType;
    private final GoogleVertexAiEmbeddingsModel model;

    public GoogleVertexAiEmbeddingsRequest(Truncator truncator, Truncator.TruncationResult input, InputType inputType, GoogleVertexAiEmbeddingsModel model) {
        this.truncator = Objects.requireNonNull(truncator);
        this.truncationResult = Objects.requireNonNull(input);
        this.inputType = inputType;
        this.model = Objects.requireNonNull(model);
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.model.nonStreamingUri());
        ByteArrayEntity byteEntity = new ByteArrayEntity(Strings.toString((ToXContent)new GoogleVertexAiEmbeddingsRequestEntity(this.truncationResult.input(), this.inputType, this.model.getTaskSettings())).getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        httpPost.setHeader("Content-Type", XContentType.JSON.mediaType());
        this.decorateWithAuth(httpPost);
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    public void decorateWithAuth(HttpPost httpPost) {
        GoogleVertexAiRequest.decorateWithBearerToken(httpPost, this.model.getSecretSettings());
    }

    Truncator truncator() {
        return this.truncator;
    }

    Truncator.TruncationResult truncationResult() {
        return this.truncationResult;
    }

    GoogleVertexAiEmbeddingsModel model() {
        return this.model;
    }

    @Override
    public String getInferenceEntityId() {
        return this.model.getInferenceEntityId();
    }

    @Override
    public URI getURI() {
        return this.model.nonStreamingUri();
    }

    @Override
    public Request truncate() {
        Truncator.TruncationResult truncatedInput = this.truncator.truncate(this.truncationResult.input());
        return new GoogleVertexAiEmbeddingsRequest(this.truncator, truncatedInput, this.inputType, this.model);
    }

    @Override
    public boolean[] getTruncationInfo() {
        return (boolean[])this.truncationResult.truncated().clone();
    }
}

