/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock.embeddings;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.cohere.CohereTruncation;

public record AmazonBedrockEmbeddingsTaskSettings(@Nullable CohereTruncation cohereTruncation) implements TaskSettings
{
    public static final AmazonBedrockEmbeddingsTaskSettings EMPTY = new AmazonBedrockEmbeddingsTaskSettings((CohereTruncation)null);
    public static final String NAME = "amazon_bedrock_embeddings_task_settings";
    private static final TransportVersion AMAZON_BEDROCK_TASK_SETTINGS = TransportVersion.fromName((String)"amazon_bedrock_task_settings");

    public AmazonBedrockEmbeddingsTaskSettings(StreamInput in) throws IOException {
        this((CohereTruncation)in.readOptionalEnum(CohereTruncation.class));
    }

    public static AmazonBedrockEmbeddingsTaskSettings fromMap(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return EMPTY;
        }
        ValidationException validationException = new ValidationException();
        CohereTruncation cohereTruncation = ServiceUtils.extractOptionalEnum(map, "truncate", "task_settings", CohereTruncation::fromString, CohereTruncation.ALL, validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new AmazonBedrockEmbeddingsTaskSettings(cohereTruncation);
    }

    public boolean isEmpty() {
        return this.cohereTruncation() == null;
    }

    public AmazonBedrockEmbeddingsTaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        AmazonBedrockEmbeddingsTaskSettings newTaskSettings = AmazonBedrockEmbeddingsTaskSettings.fromMap(new HashMap<String, Object>(newSettings));
        return new AmazonBedrockEmbeddingsTaskSettings(AmazonBedrockEmbeddingsTaskSettings.firstNonNullOrNull(newTaskSettings.cohereTruncation(), this.cohereTruncation()));
    }

    private static <T> T firstNonNullOrNull(T first, T second) {
        return first != null ? first : second;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        assert (false) : "should never be called when supportsVersion is used";
        return AMAZON_BEDROCK_TASK_SETTINGS;
    }

    public boolean supportsVersion(TransportVersion version) {
        return version.supports(AMAZON_BEDROCK_TASK_SETTINGS);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalEnum((Enum)this.cohereTruncation());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.cohereTruncation != null) {
            builder.field("truncate", (Enum)this.cohereTruncation);
        }
        return builder.endObject();
    }
}

