/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm.history;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.slm.history.SnapshotHistoryItem;

public class SnapshotHistoryStore {
    private static final Logger logger = LogManager.getLogger(SnapshotHistoryStore.class);
    public static final String SLM_HISTORY_DATA_STREAM = ".slm-history-7";
    private final Client client;
    private final ClusterService clusterService;
    private volatile boolean slmHistoryEnabled = true;

    public SnapshotHistoryStore(Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
        this.setSlmHistoryEnabled((Boolean)LifecycleSettings.SLM_HISTORY_INDEX_ENABLED_SETTING.get(clusterService.getSettings()));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(LifecycleSettings.SLM_HISTORY_INDEX_ENABLED_SETTING, this::setSlmHistoryEnabled);
    }

    public void putAsync(SnapshotHistoryItem item) {
        if (!this.slmHistoryEnabled) {
            logger.trace("not recording snapshot history item because [{}] is [false]: [{}]", (Object)LifecycleSettings.SLM_HISTORY_INDEX_ENABLED_SETTING.getKey(), (Object)item);
            return;
        }
        logger.trace("about to index snapshot history item in data stream [{}]: [{}]", (Object)SLM_HISTORY_DATA_STREAM, (Object)item);
        Metadata metadata = this.clusterService.state().getMetadata();
        if (!metadata.getProject().dataStreams().containsKey(SLM_HISTORY_DATA_STREAM) && !metadata.getProject().templatesV2().containsKey(SLM_HISTORY_DATA_STREAM)) {
            logger.error(() -> Strings.format((String)"failed to index snapshot history item, data stream [%s] and template [%s] don't exist", (Object[])new Object[]{SLM_HISTORY_DATA_STREAM, SLM_HISTORY_DATA_STREAM}));
            return;
        }
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            item.toXContent(builder, ToXContent.EMPTY_PARAMS);
            IndexRequest request = new IndexRequest(SLM_HISTORY_DATA_STREAM).opType(DocWriteRequest.OpType.CREATE).source(builder);
            this.client.index(request, ActionListener.wrap(indexResponse -> logger.debug("successfully indexed snapshot history item with id [{}] in data stream [{}]: [{}]", (Object)indexResponse.getId(), (Object)SLM_HISTORY_DATA_STREAM, (Object)item), exception -> logger.error(() -> Strings.format((String)"failed to index snapshot history item in data stream [%s]: [%s]", (Object[])new Object[]{SLM_HISTORY_DATA_STREAM, item}), (Throwable)exception)));
        }
        catch (IOException exception2) {
            logger.error(() -> Strings.format((String)"failed to index snapshot history item in data stream [%s]: [%s]", (Object[])new Object[]{SLM_HISTORY_DATA_STREAM, item}), (Throwable)exception2);
        }
    }

    public void setSlmHistoryEnabled(boolean slmHistoryEnabled) {
        this.slmHistoryEnabled = slmHistoryEnabled;
    }
}

