/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.imds.internal;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.ToString;

@SdkInternalApi
@Immutable
public final class Token {
    private final String value;
    private final Duration ttl;
    private final Instant createdTime;

    public Token(String value, Duration ttl) {
        this.value = value;
        this.ttl = ttl;
        this.createdTime = Instant.now();
    }

    public String value() {
        return this.value;
    }

    public Duration ttl() {
        return this.ttl;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public boolean isExpired() {
        return Instant.now().isAfter(this.createdTime.plus(this.ttl));
    }

    public String toString() {
        return ToString.builder((String)"Token").add("value", (Object)this.value).add("ttl", (Object)this.ttl).add("createdTime", (Object)this.createdTime).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token token = (Token)o;
        if (!Objects.equals(this.value, token.value)) {
            return false;
        }
        if (!Objects.equals(this.ttl, token.ttl)) {
            return false;
        }
        return Objects.equals(this.createdTime, token.createdTime);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.ttl != null ? this.ttl.hashCode() : 0);
        result = 31 * result + (this.createdTime != null ? this.createdTime.hashCode() : 0);
        return result;
    }
}

