/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.cfg;

import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.VersionInfo;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.mr.HadoopCfgUtils;
import org.elasticsearch.hadoop.mr.HadoopIOUtils;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.Version;

public class HadoopSettings
extends Settings {
    private final Configuration cfg;

    public HadoopSettings(Configuration cfg) {
        Assert.notNull(cfg, "Non-null properties expected");
        this.cfg = cfg;
        String jobName = cfg.get("mapreduce.job.name", "");
        String user = cfg.get("mapreduce.job.user.name", "");
        String taskAttemptId = cfg.get("mapreduce.task.attempt.id", "");
        String opaqueId = String.format(Locale.ROOT, "[mapreduce] [%s] [%s] [%s]", user, jobName, taskAttemptId);
        this.setOpaqueId(opaqueId);
        this.setUserAgent(String.format(Locale.ROOT, "elasticsearch-hadoop/%s hadoop/%s", Version.versionNumber(), VersionInfo.getVersion()));
    }

    @Override
    public String getProperty(String name) {
        return this.cfg.get(name);
    }

    @Override
    public void setProperty(String name, String value) {
        this.cfg.set(name, value);
    }

    @Override
    public Settings copy() {
        this.cfg.size();
        return new HadoopSettings(new Configuration(this.cfg));
    }

    @Override
    public InputStream loadResource(String location) {
        return HadoopIOUtils.open(location, this.cfg);
    }

    @Override
    public Properties asProperties() {
        return HadoopCfgUtils.asProperties(this.cfg);
    }
}

