/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.execution;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"ShutdownWatcher"})
public final class ShutdownWatcherExt
extends RubyBasicObject {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(ShutdownWatcherExt.class);
    private static final AtomicBoolean unsafeShutdown = new AtomicBoolean(false);
    private final transient List<IRubyObject> reports = new ArrayList<IRubyObject>();
    private final AtomicInteger attemptsCount = new AtomicInteger(0);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private long cyclePeriod = 1L;
    private int reportEvery = 5;
    private int abortThreshold = 3;
    private transient IRubyObject pipeline;

    @JRubyMethod(name={"unsafe_shutdown?"}, meta=true)
    public static IRubyObject isUnsafeShutdown(ThreadContext context, IRubyObject recv) {
        return unsafeShutdown.get() ? context.tru : context.fals;
    }

    @JRubyMethod(name={"unsafe_shutdown="}, meta=true)
    public static IRubyObject setUnsafeShutdown(ThreadContext context, IRubyObject recv, IRubyObject arg) {
        unsafeShutdown.set(arg.isTrue());
        return context.nil;
    }

    public ShutdownWatcherExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod(required=1, optional=3)
    public ShutdownWatcherExt initialize(ThreadContext context, IRubyObject[] args) {
        this.pipeline = args[0];
        if (args.length >= 2) {
            this.cyclePeriod = args[1].convertToInteger().getLongValue();
            if (args.length >= 3) {
                this.reportEvery = args[2].convertToInteger().getIntValue();
                if (args.length >= 4) {
                    this.abortThreshold = args[3].convertToInteger().getIntValue();
                }
            }
        }
        return this;
    }

    @JRubyMethod(name={"pipeline_report_snapshot"})
    public IRubyObject pipelineReportSnapshot(ThreadContext context) {
        return this.pipeline.callMethod(context, "reporter").callMethod(context, "snapshot");
    }

    @JRubyMethod(name={"shutdown_stalled?"})
    public IRubyObject shutdownStalled(ThreadContext context) {
        if (this.reports.size() != this.reportEvery) {
            return context.fals;
        }
        int[] inflightCounts = this.reports.stream().mapToInt(obj -> obj.callMethod(context, "inflight_count").convertToInteger().getIntValue()).toArray();
        boolean stalled = true;
        for (int i = 0; i < inflightCounts.length - 1; ++i) {
            if (inflightCounts[i] <= inflightCounts[i + 1]) continue;
            stalled = false;
            break;
        }
        if (stalled) {
            IRubyObject[] stallingThreads = (IRubyObject[])this.reports.stream().map(obj -> obj.callMethod(context, "stalling_threads")).toArray(IRubyObject[]::new);
            for (int i = 0; i < stallingThreads.length - 1; ++i) {
                if (stallingThreads[i].op_equal(context, stallingThreads[i + 1]).isTrue()) continue;
                stalled = false;
                break;
            }
            return stalled ? context.tru : context.fals;
        }
        return context.fals;
    }

    @JRubyMethod(name={"stop!"})
    public IRubyObject stop(ThreadContext context) {
        return this.running.compareAndSet(true, false) ? context.tru : context.fals;
    }

    @JRubyMethod(name={"stopped?"})
    public IRubyObject stopped(ThreadContext context) {
        return this.running.get() ? context.fals : context.tru;
    }

    @JRubyMethod(name={"attempts_count"})
    public IRubyObject attemptsCount(ThreadContext context) {
        return context.runtime.newFixnum(this.attemptsCount.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject start(ThreadContext context) throws InterruptedException {
        int cycleNumber = 0;
        int stalledCount = 0;
        this.running.set(true);
        try {
            while (true) {
                TimeUnit.SECONDS.sleep(this.cyclePeriod);
                this.attemptsCount.incrementAndGet();
                if (this.stopped(context).isTrue() || this.pipeline.callMethod(context, "finished_execution?").isTrue()) break;
                this.reports.add(this.pipelineReportSnapshot(context));
                if (this.reports.size() > this.reportEvery) {
                    this.reports.remove(0);
                }
                if (cycleNumber == this.reportEvery - 1) {
                    boolean isPqDraining = this.pipeline.callMethod(context, "worker_threads_draining?").isTrue();
                    if (!isPqDraining) {
                        LOGGER.warn(this.reports.get(this.reports.size() - 1).callMethod(context, "to_s").asJavaString());
                    }
                    if (this.shutdownStalled(context).isTrue()) {
                        if (stalledCount == 0) {
                            LOGGER.error("The shutdown process appears to be stalled due to busy or blocked plugins. Check the logs for more information.");
                            if (isPqDraining) {
                                String pipelineId = this.pipeline.callMethod(context, "pipeline_id").asJavaString();
                                LOGGER.info("The queue for pipeline {} is draining before shutdown.", (Object)pipelineId);
                            }
                        }
                        if (ShutdownWatcherExt.isUnsafeShutdown(context, null).isTrue() && this.abortThreshold == ++stalledCount) {
                            LOGGER.fatal("Forcefully quitting Logstash ...");
                            this.forceExit(context);
                        }
                    } else {
                        stalledCount = 0;
                    }
                }
                cycleNumber = (cycleNumber + 1) % this.reportEvery;
            }
            IRubyObject iRubyObject = context.nil;
            return iRubyObject;
        }
        finally {
            this.stop(context);
        }
    }

    @JRubyMethod(name={"cycle_period"})
    public IRubyObject cyclePeriod(ThreadContext context) {
        return context.runtime.newFixnum(this.cyclePeriod);
    }

    @JRubyMethod(name={"report_every"})
    public IRubyObject reportEvery(ThreadContext context) {
        return context.runtime.newFixnum(this.reportEvery);
    }

    @JRubyMethod(name={"abort_threshold"})
    public IRubyObject abortThreshold(ThreadContext context) {
        return context.runtime.newFixnum(this.abortThreshold);
    }

    @JRubyMethod(name={"force_exit"})
    public IRubyObject forceExit(ThreadContext context) {
        throw context.runtime.newSystemExit(-1);
    }
}

