/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.shared.common.util.ArrayUtil;

public class ExecRowBuilder
implements Formatable {
    private boolean indexable;
    private Object[] template;
    private int[] columns;
    private int count;
    private int maxColumnNumber;

    public ExecRowBuilder(int size, boolean indexable) {
        this.template = new Object[size];
        this.columns = new int[size];
        this.indexable = indexable;
    }

    public ExecRowBuilder() {
    }

    public void setColumn(int column, Object columnTemplate) {
        if (!(columnTemplate instanceof DataTypeDescriptor) && !(columnTemplate instanceof DataValueDescriptor)) {
            SanityManager.THROWASSERT((String)("Expected DataTypeDescriptor or DataValueDescriptor. Got: " + String.valueOf(columnTemplate == null ? columnTemplate : columnTemplate.getClass().getName())));
        }
        this.template[this.count] = columnTemplate;
        this.columns[this.count] = column;
        ++this.count;
        this.maxColumnNumber = Math.max(this.maxColumnNumber, column);
    }

    public ExecRow build(ExecutionFactory ef) throws StandardException {
        ExecRow row = this.indexable ? ef.getIndexableRow(this.maxColumnNumber) : ef.getValueRow(this.maxColumnNumber);
        for (int i = 0; i < this.count; ++i) {
            Object o = this.template[i];
            DataValueDescriptor dvd = o instanceof DataValueDescriptor ? ((DataValueDescriptor)o).getNewNull() : ((DataTypeDescriptor)o).getNull();
            row.setColumn(this.columns[i], dvd);
        }
        return row;
    }

    public void reset(ExecRow row) throws StandardException {
        for (int i = 0; i < this.count; ++i) {
            int col = this.columns[i];
            row.setColumn(col, row.getColumn(col).getNewNull());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.indexable);
        ArrayUtil.writeArray((ObjectOutput)out, (Object[])this.template);
        out.writeObject(this.columns);
        out.writeInt(this.count);
        out.writeInt(this.maxColumnNumber);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.indexable = in.readBoolean();
        this.template = ArrayUtil.readObjectArray((ObjectInput)in);
        this.columns = (int[])in.readObject();
        this.count = in.readInt();
        this.maxColumnNumber = in.readInt();
    }

    @Override
    public int getTypeFormatId() {
        return 279;
    }
}

