/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class Literal
extends Expression {
    private GroundedValue value;

    protected Literal(GroundedValue value, Container container) {
        this.value = value.reduce();
        this.setContainer(container);
    }

    public GroundedValue getValue() {
        return this.value;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        return this;
    }

    public ItemType getItemType() {
        if (this.value instanceof AtomicValue) {
            return ((AtomicValue)this.value).getItemType();
        }
        if (this.value.getLength() == 0) {
            return ErrorType.getInstance();
        }
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        return SequenceTool.getItemType(this.value, th);
    }

    public int computeCardinality() {
        if (this.value.getLength() == 0) {
            return 8192;
        }
        if (this.value instanceof AtomicValue) {
            return 16384;
        }
        try {
            UnfailingIterator iter = this.value.iterate();
            Item next = iter.next();
            if (next == null) {
                return 8192;
            }
            if (iter.next() != null) {
                return 49152;
            }
            return 16384;
        }
        catch (XPathException err) {
            return 57344;
        }
    }

    public int computeSpecialProperties() {
        if (this.value.getLength() == 0) {
            return 0xEFF0000;
        }
        return 0x400000;
    }

    public IntegerValue[] getIntegerBounds() {
        if (this.value instanceof IntegerValue) {
            return new IntegerValue[]{(IntegerValue)this.value, (IntegerValue)this.value};
        }
        if (this.value instanceof IntegerRange) {
            return new IntegerValue[]{Int64Value.makeIntegerValue(((IntegerRange)this.value).getStart()), Int64Value.makeIntegerValue(((IntegerRange)this.value).getEnd())};
        }
        return null;
    }

    public boolean isVacuousExpression() {
        return this.value.getLength() == 0;
    }

    public Expression copy() {
        return new Literal(this.value, this.getContainer());
    }

    public Pattern toPattern(Configuration config, boolean is30) throws XPathException {
        if (Literal.isEmptySequence(this)) {
            return new NodeTestPattern(ErrorType.getInstance());
        }
        return super.toPattern(config, is30);
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return pathMapNodeSet;
    }

    public final int getDependencies() {
        return 0;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.value.iterate();
    }

    public SequenceIterator iterate() throws XPathException {
        return this.value.iterate();
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        return this.value.head();
    }

    public void process(XPathContext context) throws XPathException {
        Item it;
        UnfailingIterator iter = this.value.iterate();
        SequenceReceiver out = context.getReceiver();
        while ((it = iter.next()) != null) {
            out.append(it, 0, 2);
        }
    }

    public CharSequence evaluateAsString(XPathContext context) throws XPathException {
        AtomicValue value = (AtomicValue)this.evaluateItem(context);
        if (value == null) {
            return "";
        }
        return value.getStringValueCS();
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        return this.value.effectiveBooleanValue();
    }

    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        if (this.value.getLength() != 0) {
            super.evaluatePendingUpdates(context, pul);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Literal)) {
            return false;
        }
        GroundedValue v0 = this.value;
        GroundedValue v1 = ((Literal)obj).value;
        try {
            Item m1;
            Item m0;
            UnfailingIterator i0 = v0.iterate();
            UnfailingIterator i1 = v1.iterate();
            do {
                m0 = i0.next();
                m1 = i1.next();
                if (m0 == null && m1 == null) {
                    return true;
                }
                if (m0 == null || m1 == null) {
                    return false;
                }
                boolean n0 = m0 instanceof NodeInfo;
                boolean n1 = m1 instanceof NodeInfo;
                if (n0 != n1) {
                    return false;
                }
                if (!n0 || !n1 || ((NodeInfo)m0).isSameNodeInfo((NodeInfo)m1)) continue;
                return false;
            } while (!(m0 instanceof AtomicValue) || !(m1 instanceof AtomicValue) || ((AtomicValue)m0).isIdentical((AtomicValue)m1) && ((AtomicValue)m0).getItemType() == ((AtomicValue)m1).getItemType());
            return false;
        }
        catch (XPathException err) {
            return false;
        }
    }

    public int hashCode() {
        if (this.value instanceof AtomicSequence) {
            return ((AtomicSequence)this.value).getSchemaComparable().hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        return this.value.toString();
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("literal");
        if (this.value.getLength() == 0) {
            out.emitAttribute("value", "()");
        } else if (this.value instanceof AtomicValue) {
            out.emitAttribute("value", ((AtomicValue)this.value).getStringValue());
            out.emitAttribute("type", ((AtomicValue)this.value).getItemType().getDisplayName());
        } else {
            try {
                out.emitAttribute("count", this.value.getLength() + "");
                if (this.value.getLength() < 20) {
                    Item it;
                    SequenceIterator iter = this.iterate();
                    while ((it = iter.next()) != null) {
                        if (it instanceof NodeInfo) {
                            out.startElement("node");
                            out.emitAttribute("path", Navigator.getPath((NodeInfo)it));
                            out.emitAttribute("uri", ((NodeInfo)it).getSystemId());
                            out.endElement();
                            continue;
                        }
                        if (it instanceof AtomicValue) {
                            out.startElement("atomicValue");
                            out.emitAttribute("value", it.getStringValue());
                            out.emitAttribute("type", ((AtomicValue)it).getItemType().getDisplayName());
                            out.endElement();
                            continue;
                        }
                        if (it instanceof FunctionItem) {
                            out.startElement("functionItem");
                            if (((FunctionItem)it).getFunctionName() != null) {
                                out.emitAttribute("name", ((FunctionItem)it).getFunctionName().getDisplayName());
                            }
                            out.emitAttribute("arity", "" + ((FunctionItem)it).getArity());
                            out.endElement();
                            continue;
                        }
                        if (!(it instanceof ObjectValue)) continue;
                        out.startElement("externalObject");
                        out.emitAttribute("class", ((ObjectValue)it).getObject().getClass().getName());
                        out.endElement();
                    }
                }
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        out.endElement();
    }

    public String toShortString() {
        if (this.value.getLength() == 0) {
            return "()";
        }
        if (this.value instanceof AtomicValue) {
            return this.value.toString();
        }
        return "(" + this.value.head().toString() + ",...)";
    }

    public static boolean isAtomic(Expression exp) {
        return exp instanceof Literal && ((Literal)exp).getValue() instanceof AtomicValue;
    }

    public static boolean isEmptySequence(Expression exp) {
        return exp instanceof Literal && ((Literal)exp).getValue().getLength() == 0;
    }

    public static boolean isConstantBoolean(Expression exp, boolean value) {
        if (exp instanceof Literal) {
            GroundedValue b = ((Literal)exp).getValue();
            return b instanceof BooleanValue && ((BooleanValue)b).getBooleanValue() == value;
        }
        return false;
    }

    public static boolean isConstantOne(Expression exp) {
        if (exp instanceof Literal) {
            GroundedValue v = ((Literal)exp).getValue();
            return v instanceof Int64Value && ((Int64Value)v).longValue() == 1L;
        }
        return false;
    }

    public boolean isSubtreeExpression() {
        return true;
    }

    public static Literal makeEmptySequence(Container container) {
        return new Literal(EmptySequence.getInstance(), container);
    }

    public static Literal makeLiteral(GroundedValue value, Container container) {
        if ((value = value.reduce()) instanceof StringValue) {
            return new StringLiteral((StringValue)value, container);
        }
        return new Literal(value, container);
    }
}

