/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.slm;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class SnapshotLifecycleStats
implements Writeable,
ToXContentObject {
    private final long retentionRun;
    private final long retentionFailed;
    private final long retentionTimedOut;
    private final long retentionTimeMs;
    private final Map<String, SnapshotPolicyStats> policyStats;
    public static final ParseField RETENTION_RUNS = new ParseField("retention_runs", new String[0]);
    public static final ParseField RETENTION_FAILED = new ParseField("retention_failed", new String[0]);
    public static final ParseField RETENTION_TIMED_OUT = new ParseField("retention_timed_out", new String[0]);
    public static final ParseField RETENTION_TIME = new ParseField("retention_deletion_time", new String[0]);
    public static final ParseField RETENTION_TIME_MILLIS = new ParseField("retention_deletion_time_millis", new String[0]);
    public static final ParseField POLICY_STATS = new ParseField("policy_stats", new String[0]);
    public static final ParseField TOTAL_TAKEN = new ParseField("total_snapshots_taken", new String[0]);
    public static final ParseField TOTAL_FAILED = new ParseField("total_snapshots_failed", new String[0]);
    public static final ParseField TOTAL_DELETIONS = new ParseField("total_snapshots_deleted", new String[0]);
    public static final ParseField TOTAL_DELETION_FAILURES = new ParseField("total_snapshot_deletion_failures", new String[0]);
    private static final ConstructingObjectParser<SnapshotLifecycleStats, Void> PARSER = new ConstructingObjectParser("snapshot_policy_stats", true, a -> {
        long runs = (Long)a[0];
        long failed = (Long)a[1];
        long timedOut = (Long)a[2];
        long timeMs = (Long)a[3];
        Map policyStatsMap = ((List)a[4]).stream().collect(Collectors.toMap(m -> m.policyId, Function.identity()));
        return new SnapshotLifecycleStats(runs, failed, timedOut, timeMs, Collections.unmodifiableMap(policyStatsMap));
    });

    public SnapshotLifecycleStats() {
        this(0L, 0L, 0L, 0L, Map.of());
    }

    public SnapshotLifecycleStats(long retentionRuns, long retentionFailed, long retentionTimedOut, long retentionTimeMs, Map<String, SnapshotPolicyStats> policyStats) {
        this.retentionRun = retentionRuns;
        this.retentionFailed = retentionFailed;
        this.retentionTimedOut = retentionTimedOut;
        this.retentionTimeMs = retentionTimeMs;
        this.policyStats = Collections.unmodifiableMap(policyStats);
    }

    private SnapshotLifecycleStats(Map<String, SnapshotPolicyStats> policyStats) {
        this(0L, 0L, 0L, 0L, policyStats);
    }

    public SnapshotLifecycleStats(StreamInput in) throws IOException {
        this.policyStats = in.readImmutableMap(SnapshotPolicyStats::new);
        this.retentionRun = in.readVLong();
        this.retentionFailed = in.readVLong();
        this.retentionTimedOut = in.readVLong();
        this.retentionTimeMs = in.readVLong();
    }

    public static SnapshotLifecycleStats parse(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public SnapshotLifecycleStats merge(SnapshotLifecycleStats other) {
        HashMap<String, SnapshotPolicyStats> newPolicyStats = new HashMap<String, SnapshotPolicyStats>(this.policyStats);
        other.policyStats.forEach((policyId, perRunPolicyStats) -> newPolicyStats.compute((String)policyId, (k, existingPolicyMetrics) -> {
            if (existingPolicyMetrics == null) {
                return perRunPolicyStats;
            }
            return existingPolicyMetrics.merge((SnapshotPolicyStats)perRunPolicyStats);
        }));
        return new SnapshotLifecycleStats(this.retentionRun + other.retentionRun, this.retentionFailed + other.retentionFailed, this.retentionTimedOut + other.retentionTimedOut, this.retentionTimeMs + other.retentionTimeMs, Collections.unmodifiableMap(newPolicyStats));
    }

    public SnapshotLifecycleStats removePolicy(String policyId) {
        HashMap<String, SnapshotPolicyStats> policyStatsCopy = new HashMap<String, SnapshotPolicyStats>(this.policyStats);
        policyStatsCopy.remove(policyId);
        return new SnapshotLifecycleStats(this.retentionRun, this.retentionFailed, this.retentionTimedOut, this.retentionTimeMs, Collections.unmodifiableMap(policyStatsCopy));
    }

    public Map<String, SnapshotPolicyStats> getMetrics() {
        return this.policyStats;
    }

    public SnapshotLifecycleStats withRetentionRunIncremented() {
        return new SnapshotLifecycleStats(this.retentionRun + 1L, this.retentionFailed, this.retentionTimedOut, this.retentionTimeMs, this.policyStats);
    }

    public SnapshotLifecycleStats withRetentionFailedIncremented() {
        return new SnapshotLifecycleStats(this.retentionRun, this.retentionFailed + 1L, this.retentionTimedOut, this.retentionTimeMs, this.policyStats);
    }

    public SnapshotLifecycleStats withRetentionTimedOutIncremented() {
        return new SnapshotLifecycleStats(this.retentionRun, this.retentionFailed, this.retentionTimedOut + 1L, this.retentionTimeMs, this.policyStats);
    }

    public SnapshotLifecycleStats withDeletionTimeUpdated(TimeValue elapsedTime) {
        long newRetentionTimeMs = this.retentionTimeMs + elapsedTime.millis();
        return new SnapshotLifecycleStats(this.retentionRun, this.retentionFailed, this.retentionTimedOut, newRetentionTimeMs, this.policyStats);
    }

    public SnapshotLifecycleStats withTakenIncremented(String slmPolicy) {
        return this.merge(new SnapshotLifecycleStats(Map.of(slmPolicy, SnapshotPolicyStats.taken(slmPolicy))));
    }

    public SnapshotLifecycleStats withFailedIncremented(String slmPolicy) {
        return this.merge(new SnapshotLifecycleStats(Map.of(slmPolicy, SnapshotPolicyStats.failed(slmPolicy))));
    }

    public SnapshotLifecycleStats withDeletedIncremented(String slmPolicy) {
        return this.merge(new SnapshotLifecycleStats(Map.of(slmPolicy, SnapshotPolicyStats.deleted(slmPolicy))));
    }

    public SnapshotLifecycleStats withDeleteFailureIncremented(String slmPolicy) {
        return this.merge(new SnapshotLifecycleStats(Map.of(slmPolicy, SnapshotPolicyStats.deleteFailure(slmPolicy))));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.policyStats, StreamOutput::writeWriteable);
        out.writeVLong(this.retentionRun);
        out.writeVLong(this.retentionFailed);
        out.writeVLong(this.retentionTimedOut);
        out.writeVLong(this.retentionTimeMs);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(RETENTION_RUNS.getPreferredName(), this.retentionRun);
        builder.field(RETENTION_FAILED.getPreferredName(), this.retentionFailed);
        builder.field(RETENTION_TIMED_OUT.getPreferredName(), this.retentionTimedOut);
        TimeValue retentionTime = TimeValue.timeValueMillis(this.retentionTimeMs);
        builder.field(RETENTION_TIME.getPreferredName(), retentionTime);
        builder.field(RETENTION_TIME_MILLIS.getPreferredName(), retentionTime.millis());
        List<SnapshotPolicyStats> metrics = this.getMetrics().values().stream().sorted(Comparator.comparing(SnapshotPolicyStats::getPolicyId)).toList();
        long totalTaken = metrics.stream().mapToLong(s -> s.snapshotsTaken).sum();
        long totalFailed = metrics.stream().mapToLong(s -> s.snapshotsFailed).sum();
        long totalDeleted = metrics.stream().mapToLong(s -> s.snapshotsDeleted).sum();
        long totalDeleteFailures = metrics.stream().mapToLong(s -> s.snapshotDeleteFailures).sum();
        builder.field(TOTAL_TAKEN.getPreferredName(), totalTaken);
        builder.field(TOTAL_FAILED.getPreferredName(), totalFailed);
        builder.field(TOTAL_DELETIONS.getPreferredName(), totalDeleted);
        builder.field(TOTAL_DELETION_FAILURES.getPreferredName(), totalDeleteFailures);
        builder.startArray(POLICY_STATS.getPreferredName());
        for (SnapshotPolicyStats stats : metrics) {
            builder.startObject();
            stats.toXContent(builder, params);
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.retentionRun, this.retentionFailed, this.retentionTimedOut, this.retentionTimeMs, this.policyStats);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SnapshotLifecycleStats other = (SnapshotLifecycleStats)obj;
        return Objects.equals(this.retentionRun, other.retentionRun) && Objects.equals(this.retentionFailed, other.retentionFailed) && Objects.equals(this.retentionTimedOut, other.retentionTimedOut) && Objects.equals(this.retentionTimeMs, other.retentionTimeMs) && Objects.equals(this.policyStats, other.policyStats);
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), RETENTION_RUNS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), RETENTION_FAILED);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), RETENTION_TIMED_OUT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), RETENTION_TIME_MILLIS);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), SnapshotPolicyStats.PARSER, POLICY_STATS);
    }

    public static class SnapshotPolicyStats
    implements Writeable,
    ToXContentFragment {
        private final String policyId;
        private final long snapshotsTaken;
        private final long snapshotsFailed;
        private final long snapshotsDeleted;
        private final long snapshotDeleteFailures;
        public static final ParseField POLICY_ID = new ParseField("policy", new String[0]);
        public static final ParseField SNAPSHOTS_TAKEN = new ParseField("snapshots_taken", new String[0]);
        public static final ParseField SNAPSHOTS_FAILED = new ParseField("snapshots_failed", new String[0]);
        public static final ParseField SNAPSHOTS_DELETED = new ParseField("snapshots_deleted", new String[0]);
        public static final ParseField SNAPSHOT_DELETION_FAILURES = new ParseField("snapshot_deletion_failures", new String[0]);
        static final ConstructingObjectParser<SnapshotPolicyStats, Void> PARSER = new ConstructingObjectParser("snapshot_policy_stats", true, a -> {
            String id = (String)a[0];
            long taken = (Long)a[1];
            long failed = (Long)a[2];
            long deleted = (Long)a[3];
            long deleteFailed = (Long)a[4];
            return new SnapshotPolicyStats(id, taken, failed, deleted, deleteFailed);
        });

        public SnapshotPolicyStats(String slmPolicy) {
            this(slmPolicy, 0L, 0L, 0L, 0L);
        }

        public SnapshotPolicyStats(String policyId, long snapshotsTaken, long snapshotsFailed, long deleted, long failedDeletes) {
            this.policyId = policyId;
            this.snapshotsTaken = snapshotsTaken;
            this.snapshotsFailed = snapshotsFailed;
            this.snapshotsDeleted = deleted;
            this.snapshotDeleteFailures = failedDeletes;
        }

        public SnapshotPolicyStats(StreamInput in) throws IOException {
            this(in.readString(), in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong());
        }

        public SnapshotPolicyStats merge(SnapshotPolicyStats other) {
            return new SnapshotPolicyStats(this.policyId, this.snapshotsTaken + other.snapshotsTaken, this.snapshotsFailed + other.snapshotsFailed, this.snapshotsDeleted + other.snapshotsDeleted, this.snapshotDeleteFailures + other.snapshotDeleteFailures);
        }

        private static SnapshotPolicyStats taken(String policyId) {
            return new SnapshotPolicyStats(policyId, 1L, 0L, 0L, 0L);
        }

        private static SnapshotPolicyStats failed(String policyId) {
            return new SnapshotPolicyStats(policyId, 0L, 1L, 0L, 0L);
        }

        private static SnapshotPolicyStats deleted(String policyId) {
            return new SnapshotPolicyStats(policyId, 0L, 0L, 1L, 0L);
        }

        private static SnapshotPolicyStats deleteFailure(String policyId) {
            return new SnapshotPolicyStats(policyId, 0L, 0L, 0L, 1L);
        }

        public String getPolicyId() {
            return this.policyId;
        }

        public long getSnapshotTakenCount() {
            return this.snapshotsTaken;
        }

        public long getSnapshotFailedCount() {
            return this.snapshotsFailed;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.policyId);
            out.writeVLong(this.snapshotsTaken);
            out.writeVLong(this.snapshotsFailed);
            out.writeVLong(this.snapshotsDeleted);
            out.writeVLong(this.snapshotDeleteFailures);
        }

        public int hashCode() {
            return Objects.hash(this.policyId, this.snapshotsTaken, this.snapshotsFailed, this.snapshotsDeleted, this.snapshotDeleteFailures);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            SnapshotPolicyStats other = (SnapshotPolicyStats)obj;
            return Objects.equals(this.policyId, other.policyId) && Objects.equals(this.snapshotsTaken, other.snapshotsTaken) && Objects.equals(this.snapshotsFailed, other.snapshotsFailed) && Objects.equals(this.snapshotsDeleted, other.snapshotsDeleted) && Objects.equals(this.snapshotDeleteFailures, other.snapshotDeleteFailures);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(POLICY_ID.getPreferredName(), this.policyId);
            builder.field(SNAPSHOTS_TAKEN.getPreferredName(), this.snapshotsTaken);
            builder.field(SNAPSHOTS_FAILED.getPreferredName(), this.snapshotsFailed);
            builder.field(SNAPSHOTS_DELETED.getPreferredName(), this.snapshotsDeleted);
            builder.field(SNAPSHOT_DELETION_FAILURES.getPreferredName(), this.snapshotDeleteFailures);
            return builder;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), POLICY_ID);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), SNAPSHOTS_TAKEN);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), SNAPSHOTS_FAILED);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), SNAPSHOTS_DELETED);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), SNAPSHOT_DELETION_FAILURES);
        }
    }
}

