/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.job;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.rollup.job.RollupJobConfig;

public class RollupJob
implements SimpleDiffable<RollupJob>,
PersistentTaskParams {
    public static final String NAME = "xpack/rollup/job";
    private final Map<String, String> headers;
    private final RollupJobConfig config;
    private static final ParseField CONFIG = new ParseField("config", new String[0]);
    private static final ParseField HEADERS = new ParseField("headers", new String[0]);
    public static final ConstructingObjectParser<RollupJob, Void> PARSER = new ConstructingObjectParser("xpack/rollup/job", a -> new RollupJob((RollupJobConfig)a[0], (Map)a[1]));

    public RollupJob(RollupJobConfig config, Map<String, String> headers) {
        this.config = Objects.requireNonNull(config);
        this.headers = headers == null ? Collections.emptyMap() : headers;
    }

    public RollupJob(StreamInput in) throws IOException {
        this.config = new RollupJobConfig(in);
        this.headers = in.readMap(StreamInput::readString);
    }

    public RollupJobConfig getConfig() {
        return this.config;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(CONFIG.getPreferredName(), this.config);
        ClientHelper.assertNoAuthorizationHeader(this.headers);
        builder.field(HEADERS.getPreferredName(), this.headers);
        builder.endObject();
        return builder;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.config.writeTo(out);
        out.writeMap(this.headers, StreamOutput::writeString);
    }

    static Diff<RollupJob> readJobDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(RollupJob::new, in);
    }

    public static RollupJob fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RollupJob that = (RollupJob)other;
        return Objects.equals(this.config, that.config) && Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        return Objects.hash(this.config, this.headers);
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.MINIMUM_COMPATIBLE;
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> RollupJobConfig.fromXContent(p, null), CONFIG);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.mapStrings(), HEADERS);
    }
}

