/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.profile.ProfileResult;
import org.elasticsearch.search.profile.SearchProfileDfsPhaseResult;
import org.elasticsearch.search.profile.SearchProfileQueryPhaseResult;
import org.elasticsearch.search.profile.aggregation.AggregationProfileShardResult;
import org.elasticsearch.search.profile.query.QueryProfileShardResult;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class SearchProfileShardResult
implements Writeable,
ToXContentFragment {
    private final SearchProfileQueryPhaseResult queryPhase;
    private final ProfileResult fetchPhase;

    public SearchProfileShardResult(SearchProfileQueryPhaseResult queryPhase, @Nullable ProfileResult fetch) {
        this.queryPhase = queryPhase;
        this.fetchPhase = fetch;
    }

    public SearchProfileShardResult(StreamInput in) throws IOException {
        this.queryPhase = new SearchProfileQueryPhaseResult(in);
        this.fetchPhase = in.readOptionalWriteable(ProfileResult::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.queryPhase.writeTo(out);
        out.writeOptionalWriteable(this.fetchPhase);
    }

    public SearchProfileDfsPhaseResult getSearchProfileDfsPhaseResult() {
        return this.queryPhase.getSearchProfileDfsPhaseResult();
    }

    public SearchProfileQueryPhaseResult getQueryPhase() {
        return this.queryPhase;
    }

    public ProfileResult getFetchPhase() {
        return this.fetchPhase;
    }

    public List<QueryProfileShardResult> getQueryProfileResults() {
        return this.queryPhase.getQueryProfileResults();
    }

    public AggregationProfileShardResult getAggregationProfileResults() {
        return this.queryPhase.getAggregationProfileResults();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.getSearchProfileDfsPhaseResult() != null) {
            builder.field("dfs");
            this.getSearchProfileDfsPhaseResult().toXContent(builder, params);
        }
        builder.startArray("searches");
        for (QueryProfileShardResult result : this.queryPhase.getQueryProfileResults()) {
            result.toXContent(builder, params);
        }
        builder.endArray();
        this.queryPhase.getAggregationProfileResults().toXContent(builder, params);
        if (this.fetchPhase != null) {
            builder.field("fetch");
            this.fetchPhase.toXContent(builder, params);
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchProfileShardResult that = (SearchProfileShardResult)o;
        return Objects.equals(this.queryPhase, that.queryPhase) && Objects.equals(this.fetchPhase, that.fetchPhase);
    }

    public int hashCode() {
        return Objects.hash(this.queryPhase, this.fetchPhase);
    }

    public String toString() {
        return Strings.toString(this);
    }
}

