/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lucene.spatial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.mapper.CustomDocValuesField;
import org.elasticsearch.lucene.spatial.CentroidCalculator;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.lucene.spatial.GeometryDocValueWriter;

public class BinaryShapeDocValuesField
extends CustomDocValuesField {
    private final List<IndexableField> fields = new ArrayList<IndexableField>();
    private final CoordinateEncoder coordinateEncoder;
    private final CentroidCalculator centroidCalculator;

    public BinaryShapeDocValuesField(String name, CoordinateEncoder coordinateEncoder) {
        super(name);
        this.coordinateEncoder = coordinateEncoder;
        this.centroidCalculator = new CentroidCalculator();
    }

    public void add(List<IndexableField> fields, Geometry geometry) {
        this.fields.addAll(fields);
        this.centroidCalculator.add(geometry);
    }

    @Override
    public BytesRef binaryValue() {
        try {
            return GeometryDocValueWriter.write(this.fields, this.coordinateEncoder, this.centroidCalculator);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to encode shape", (Throwable)e, new Object[0]);
        }
    }
}

