/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.es818;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.codec.vectors.reflect.OffHeapByteSizeUtils;
import org.elasticsearch.index.codec.vectors.reflect.OffHeapStats;

class MergeReaderWrapper
extends FlatVectorsReader
implements OffHeapStats {
    private final FlatVectorsReader mainReader;
    private final FlatVectorsReader mergeReader;

    protected MergeReaderWrapper(FlatVectorsReader mainReader, FlatVectorsReader mergeReader) {
        super(mainReader.getFlatVectorScorer());
        this.mainReader = mainReader;
        this.mergeReader = mergeReader;
    }

    FlatVectorsReader getMainReader() {
        return this.mainReader;
    }

    @Override
    public RandomVectorScorer getRandomVectorScorer(String field, float[] target) throws IOException {
        return this.mainReader.getRandomVectorScorer(field, target);
    }

    @Override
    public RandomVectorScorer getRandomVectorScorer(String field, byte[] target) throws IOException {
        return this.mainReader.getRandomVectorScorer(field, target);
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.mainReader.checkIntegrity();
    }

    @Override
    public FloatVectorValues getFloatVectorValues(String field) throws IOException {
        return this.mainReader.getFloatVectorValues(field);
    }

    @Override
    public ByteVectorValues getByteVectorValues(String field) throws IOException {
        return this.mainReader.getByteVectorValues(field);
    }

    @Override
    public FlatVectorsReader getMergeInstance() {
        return this.mergeReader;
    }

    @Override
    public long ramBytesUsed() {
        return this.mainReader.ramBytesUsed();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return this.mainReader.getChildResources();
    }

    @Override
    public void search(String field, float[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        this.mainReader.search(field, target, knnCollector, acceptDocs);
    }

    @Override
    public void search(String field, byte[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        this.mainReader.search(field, target, knnCollector, acceptDocs);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.mainReader, this.mergeReader);
    }

    @Override
    public Map<String, Long> getOffHeapByteSize(FieldInfo fieldInfo) {
        return OffHeapByteSizeUtils.getOffHeapByteSize(this.mainReader, fieldInfo);
    }
}

