/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.tsdb;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesSkipIndexType;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.internal.hppc.IntObjectHashMap;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.compress.LZ4;
import org.apache.lucene.util.packed.DirectMonotonicReader;
import org.apache.lucene.util.packed.PackedInts;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.codec.tsdb.ES87TSDBDocValuesFormat;
import org.elasticsearch.index.codec.tsdb.TSDBDocValuesEncoder;

final class ES87TSDBDocValuesProducer
extends DocValuesProducer {
    private final IntObjectHashMap<NumericEntry> numerics;
    private final IntObjectHashMap<BinaryEntry> binaries;
    private final IntObjectHashMap<SortedEntry> sorted;
    private final IntObjectHashMap<SortedSetEntry> sortedSets;
    private final IntObjectHashMap<SortedNumericEntry> sortedNumerics;
    private final IntObjectHashMap<DocValuesSkipperEntry> skippers;
    private final IndexInput data;
    private final int maxDoc;
    private final int version;
    private final boolean merging;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ES87TSDBDocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        int version;
        block16: {
            this.numerics = new IntObjectHashMap();
            this.binaries = new IntObjectHashMap();
            this.sorted = new IntObjectHashMap();
            this.sortedSets = new IntObjectHashMap();
            this.sortedNumerics = new IntObjectHashMap();
            this.skippers = new IntObjectHashMap();
            this.maxDoc = state.segmentInfo.maxDoc();
            this.merging = false;
            version = -1;
            String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
            try (ChecksumIndexInput in = state.directory.openChecksumInput(metaName);){
                Throwable priorE = null;
                try {
                    version = CodecUtil.checkIndexHeader(in, metaCodec, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                    this.readFields(in, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block16;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter(in, priorE);
                    }
                }
                CodecUtil.checkFooter(in, priorE);
            }
        }
        String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
        this.data = state.directory.openInput(dataName, state.context);
        boolean success = false;
        try {
            int version2 = CodecUtil.checkIndexHeader(this.data, dataCodec, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
            if (version != version2) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + version + ", data=" + version2, this.data);
            }
            CodecUtil.retrieveChecksum(this.data);
            success = true;
            this.version = version;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)this.data);
            }
        }
    }

    private ES87TSDBDocValuesProducer(IntObjectHashMap<NumericEntry> numerics, IntObjectHashMap<BinaryEntry> binaries, IntObjectHashMap<SortedEntry> sorted, IntObjectHashMap<SortedSetEntry> sortedSets, IntObjectHashMap<SortedNumericEntry> sortedNumerics, IntObjectHashMap<DocValuesSkipperEntry> skippers, IndexInput data, int maxDoc, int version, boolean merging) {
        this.numerics = numerics;
        this.binaries = binaries;
        this.sorted = sorted;
        this.sortedSets = sortedSets;
        this.sortedNumerics = sortedNumerics;
        this.skippers = skippers;
        this.data = data.clone();
        this.maxDoc = maxDoc;
        this.version = version;
        this.merging = merging;
    }

    @Override
    public DocValuesProducer getMergeInstance() {
        return new ES87TSDBDocValuesProducer(this.numerics, this.binaries, this.sorted, this.sortedSets, this.sortedNumerics, this.skippers, this.data, this.maxDoc, this.version, true);
    }

    @Override
    public NumericDocValues getNumeric(FieldInfo field) throws IOException {
        NumericEntry entry = this.numerics.get(field.number);
        return this.getNumeric(entry, -1L);
    }

    @Override
    public BinaryDocValues getBinary(FieldInfo field) throws IOException {
        final BinaryEntry entry = this.binaries.get(field.number);
        if (entry.docsWithFieldOffset == -2L) {
            return DocValues.emptyBinary();
        }
        final RandomAccessInput bytesSlice = this.data.randomAccessSlice(entry.dataOffset, entry.dataLength);
        if (entry.docsWithFieldOffset == -1L) {
            if (entry.minLength == entry.maxLength) {
                final int length = entry.maxLength;
                return new DenseBinaryDocValues(this, this.maxDoc){
                    final BytesRef bytes;
                    {
                        super(maxDoc);
                        this.bytes = new BytesRef(new byte[length], 0, length);
                    }

                    @Override
                    public BytesRef binaryValue() throws IOException {
                        bytesSlice.readBytes((long)this.doc * (long)length, this.bytes.bytes, 0, length);
                        return this.bytes;
                    }
                };
            }
            RandomAccessInput addressesData = this.data.randomAccessSlice(entry.addressesOffset, entry.addressesLength);
            final DirectMonotonicReader addresses = DirectMonotonicReader.getInstance(entry.addressesMeta, addressesData, this.merging);
            return new DenseBinaryDocValues(this, this.maxDoc){
                final BytesRef bytes;
                {
                    super(maxDoc);
                    this.bytes = new BytesRef(new byte[entry.maxLength], 0, entry.maxLength);
                }

                @Override
                public BytesRef binaryValue() throws IOException {
                    long startOffset = addresses.get(this.doc);
                    this.bytes.length = (int)(addresses.get((long)this.doc + 1L) - startOffset);
                    bytesSlice.readBytes(startOffset, this.bytes.bytes, 0, this.bytes.length);
                    return this.bytes;
                }
            };
        }
        IndexedDISI disi = new IndexedDISI(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, entry.jumpTableEntryCount, entry.denseRankPower, entry.numDocsWithField);
        if (entry.minLength == entry.maxLength) {
            final int length = entry.maxLength;
            return new SparseBinaryDocValues(this, disi){
                final BytesRef bytes;
                {
                    super(disi);
                    this.bytes = new BytesRef(new byte[length], 0, length);
                }

                @Override
                public BytesRef binaryValue() throws IOException {
                    bytesSlice.readBytes((long)this.disi.index() * (long)length, this.bytes.bytes, 0, length);
                    return this.bytes;
                }
            };
        }
        RandomAccessInput addressesData = this.data.randomAccessSlice(entry.addressesOffset, entry.addressesLength);
        final DirectMonotonicReader addresses = DirectMonotonicReader.getInstance(entry.addressesMeta, addressesData, this.merging);
        return new SparseBinaryDocValues(this, disi){
            final BytesRef bytes;
            {
                super(disi);
                this.bytes = new BytesRef(new byte[entry.maxLength], 0, entry.maxLength);
            }

            @Override
            public BytesRef binaryValue() throws IOException {
                int index = this.disi.index();
                long startOffset = addresses.get(index);
                this.bytes.length = (int)(addresses.get((long)index + 1L) - startOffset);
                bytesSlice.readBytes(startOffset, this.bytes.bytes, 0, this.bytes.length);
                return this.bytes;
            }
        };
    }

    @Override
    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        SortedEntry entry = this.sorted.get(field.number);
        return this.getSorted(entry);
    }

    private SortedDocValues getSorted(SortedEntry entry) throws IOException {
        final NumericDocValues ords = this.getNumeric(entry.ordsEntry, entry.termsDictEntry.termsDictSize);
        return new BaseSortedDocValues(this, entry){

            @Override
            public int ordValue() throws IOException {
                return (int)ords.longValue();
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                return ords.advanceExact(target);
            }

            @Override
            public int docID() {
                return ords.docID();
            }

            @Override
            public int nextDoc() throws IOException {
                return ords.nextDoc();
            }

            @Override
            public int advance(int target) throws IOException {
                return ords.advance(target);
            }

            @Override
            public long cost() {
                return ords.cost();
            }
        };
    }

    @Override
    public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        SortedNumericEntry entry = this.sortedNumerics.get(field.number);
        return this.getSortedNumeric(entry, -1L);
    }

    @Override
    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        SortedSetEntry entry = this.sortedSets.get(field.number);
        if (entry.singleValueEntry != null) {
            return DocValues.singleton(this.getSorted(entry.singleValueEntry));
        }
        SortedNumericEntry ordsEntry = entry.ordsEntry;
        final SortedNumericDocValues ords = this.getSortedNumeric(ordsEntry, entry.termsDictEntry.termsDictSize);
        return new BaseSortedSetDocValues(this, entry, this.data, this.merging){
            int i;
            int count;
            boolean set;
            {
                super(entry, data, merging);
                this.i = 0;
                this.count = 0;
                this.set = false;
            }

            @Override
            public long nextOrd() throws IOException {
                if (!this.set) {
                    this.set = true;
                    this.i = 0;
                    this.count = ords.docValueCount();
                }
                assert (this.i < this.count);
                ++this.i;
                return ords.nextValue();
            }

            @Override
            public int docValueCount() {
                return ords.docValueCount();
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                this.set = false;
                return ords.advanceExact(target);
            }

            @Override
            public int docID() {
                return ords.docID();
            }

            @Override
            public int nextDoc() throws IOException {
                this.set = false;
                return ords.nextDoc();
            }

            @Override
            public int advance(int target) throws IOException {
                this.set = false;
                return ords.advance(target);
            }

            @Override
            public long cost() {
                return ords.cost();
            }
        };
    }

    @Override
    public DocValuesSkipper getSkipper(FieldInfo field) throws IOException {
        final DocValuesSkipperEntry entry = this.skippers.get(field.number);
        final IndexInput input = this.data.slice("doc value skipper", entry.offset, entry.length);
        if (input.length() > 0L) {
            input.prefetch(0L, 1L);
        }
        return new DocValuesSkipper(this){
            final int[] minDocID = new int[4];
            final int[] maxDocID = new int[4];
            final long[] minValue;
            final long[] maxValue;
            final int[] docCount;
            int levels;
            {
                for (int i = 0; i < 4; ++i) {
                    this.maxDocID[i] = -1;
                    this.minDocID[i] = -1;
                }
                this.minValue = new long[4];
                this.maxValue = new long[4];
                this.docCount = new int[4];
                this.levels = 1;
            }

            @Override
            public void advance(int target) throws IOException {
                if (target > entry.maxDocId) {
                    for (int i = 0; i < 4; ++i) {
                        this.maxDocID[i] = Integer.MAX_VALUE;
                        this.minDocID[i] = Integer.MAX_VALUE;
                    }
                } else {
                    boolean valid;
                    assert (target > this.maxDocID[0]) : "target must be bigger that current interval";
                    block1: do {
                        this.levels = input.readByte();
                        assert (this.levels <= 4 && this.levels > 0) : "level out of range [" + this.levels + "]";
                        valid = true;
                        for (int level = this.levels - 1; level >= 0; --level) {
                            this.maxDocID[level] = input.readInt();
                            if (this.maxDocID[level] < target) {
                                input.skipBytes(ES87TSDBDocValuesFormat.SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[level]);
                                valid = false;
                                continue block1;
                            }
                            this.minDocID[level] = input.readInt();
                            this.maxValue[level] = input.readLong();
                            this.minValue[level] = input.readLong();
                            this.docCount[level] = input.readInt();
                        }
                    } while (!valid);
                    while (this.levels < 4 && this.maxDocID[this.levels] >= target) {
                        ++this.levels;
                    }
                }
            }

            @Override
            public int numLevels() {
                return this.levels;
            }

            @Override
            public int minDocID(int level) {
                return this.minDocID[level];
            }

            @Override
            public int maxDocID(int level) {
                return this.maxDocID[level];
            }

            @Override
            public long minValue(int level) {
                return this.minValue[level];
            }

            @Override
            public long maxValue(int level) {
                return this.maxValue[level];
            }

            @Override
            public int docCount(int level) {
                return this.docCount[level];
            }

            @Override
            public long minValue() {
                return entry.minValue;
            }

            @Override
            public long maxValue() {
                return entry.maxValue;
            }

            @Override
            public int docCount() {
                return entry.docCount;
            }
        };
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.data);
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    private void readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, meta);
            }
            byte type = meta.readByte();
            if (info.docValuesSkipIndexType() != DocValuesSkipIndexType.NONE) {
                this.skippers.put(info.number, ES87TSDBDocValuesProducer.readDocValueSkipperMeta(meta));
            }
            if (type == 0) {
                this.numerics.put(info.number, ES87TSDBDocValuesProducer.readNumeric(meta));
            } else if (type == 1) {
                this.binaries.put(info.number, this.readBinary(meta));
            } else if (type == 2) {
                this.sorted.put(info.number, this.readSorted(meta));
            } else if (type == 3) {
                this.sortedSets.put(info.number, this.readSortedSet(meta));
            } else if (type == 4) {
                this.sortedNumerics.put(info.number, ES87TSDBDocValuesProducer.readSortedNumeric(meta));
            } else {
                throw new CorruptIndexException("invalid type: " + type, meta);
            }
            fieldNumber = meta.readInt();
        }
    }

    private static NumericEntry readNumeric(IndexInput meta) throws IOException {
        NumericEntry entry = new NumericEntry();
        ES87TSDBDocValuesProducer.readNumeric(meta, entry);
        return entry;
    }

    private static DocValuesSkipperEntry readDocValueSkipperMeta(IndexInput meta) throws IOException {
        long offset = meta.readLong();
        long length = meta.readLong();
        long maxValue = meta.readLong();
        long minValue = meta.readLong();
        int docCount = meta.readInt();
        int maxDocID = meta.readInt();
        return new DocValuesSkipperEntry(offset, length, minValue, maxValue, docCount, maxDocID);
    }

    private static void readNumeric(IndexInput meta, NumericEntry entry) throws IOException {
        entry.docsWithFieldOffset = meta.readLong();
        entry.docsWithFieldLength = meta.readLong();
        entry.jumpTableEntryCount = meta.readShort();
        entry.denseRankPower = meta.readByte();
        entry.numValues = meta.readLong();
        if (entry.numValues > 0L) {
            int indexBlockShift = meta.readInt();
            if (indexBlockShift != -1) {
                entry.indexMeta = DirectMonotonicReader.loadMeta(meta, 1L + (entry.numValues - 1L >>> 7), indexBlockShift);
            }
            entry.indexOffset = meta.readLong();
            entry.indexLength = meta.readLong();
            entry.valuesOffset = meta.readLong();
            entry.valuesLength = meta.readLong();
        }
    }

    private BinaryEntry readBinary(IndexInput meta) throws IOException {
        BinaryEntry entry = new BinaryEntry();
        entry.dataOffset = meta.readLong();
        entry.dataLength = meta.readLong();
        entry.docsWithFieldOffset = meta.readLong();
        entry.docsWithFieldLength = meta.readLong();
        entry.jumpTableEntryCount = meta.readShort();
        entry.denseRankPower = meta.readByte();
        entry.numDocsWithField = meta.readInt();
        entry.minLength = meta.readInt();
        entry.maxLength = meta.readInt();
        if (entry.minLength < entry.maxLength) {
            entry.addressesOffset = meta.readLong();
            long numAddresses = (long)entry.numDocsWithField + 1L;
            int blockShift = meta.readVInt();
            entry.addressesMeta = DirectMonotonicReader.loadMeta(meta, numAddresses, blockShift);
            entry.addressesLength = meta.readLong();
        }
        return entry;
    }

    private static SortedNumericEntry readSortedNumeric(IndexInput meta) throws IOException {
        SortedNumericEntry entry = new SortedNumericEntry();
        ES87TSDBDocValuesProducer.readSortedNumeric(meta, entry);
        return entry;
    }

    private static SortedNumericEntry readSortedNumeric(IndexInput meta, SortedNumericEntry entry) throws IOException {
        ES87TSDBDocValuesProducer.readNumeric(meta, entry);
        entry.numDocsWithField = meta.readInt();
        if ((long)entry.numDocsWithField != entry.numValues) {
            entry.addressesOffset = meta.readLong();
            int blockShift = meta.readVInt();
            entry.addressesMeta = DirectMonotonicReader.loadMeta(meta, entry.numDocsWithField + 1, blockShift);
            entry.addressesLength = meta.readLong();
        }
        return entry;
    }

    private SortedEntry readSorted(IndexInput meta) throws IOException {
        SortedEntry entry = new SortedEntry();
        entry.ordsEntry = new NumericEntry();
        ES87TSDBDocValuesProducer.readNumeric(meta, entry.ordsEntry);
        entry.termsDictEntry = new TermsDictEntry();
        ES87TSDBDocValuesProducer.readTermDict(meta, entry.termsDictEntry);
        return entry;
    }

    private SortedSetEntry readSortedSet(IndexInput meta) throws IOException {
        SortedSetEntry entry = new SortedSetEntry();
        byte multiValued = meta.readByte();
        switch (multiValued) {
            case 0: {
                entry.singleValueEntry = this.readSorted(meta);
                return entry;
            }
            case 1: {
                break;
            }
            default: {
                throw new CorruptIndexException("Invalid multiValued flag: " + multiValued, meta);
            }
        }
        entry.ordsEntry = new SortedNumericEntry();
        ES87TSDBDocValuesProducer.readSortedNumeric(meta, entry.ordsEntry);
        entry.termsDictEntry = new TermsDictEntry();
        ES87TSDBDocValuesProducer.readTermDict(meta, entry.termsDictEntry);
        return entry;
    }

    private static void readTermDict(IndexInput meta, TermsDictEntry entry) throws IOException {
        entry.termsDictSize = meta.readVLong();
        int blockShift = meta.readInt();
        long addressesSize = entry.termsDictSize + 64L - 1L >>> 6;
        entry.termsAddressesMeta = DirectMonotonicReader.loadMeta(meta, addressesSize, blockShift);
        entry.maxTermLength = meta.readInt();
        entry.maxBlockLength = meta.readInt();
        entry.termsDataOffset = meta.readLong();
        entry.termsDataLength = meta.readLong();
        entry.termsAddressesOffset = meta.readLong();
        entry.termsAddressesLength = meta.readLong();
        entry.termsDictIndexShift = meta.readInt();
        long indexSize = entry.termsDictSize + (1L << entry.termsDictIndexShift) - 1L >>> entry.termsDictIndexShift;
        entry.termsIndexAddressesMeta = DirectMonotonicReader.loadMeta(meta, 1L + indexSize, blockShift);
        entry.termsIndexOffset = meta.readLong();
        entry.termsIndexLength = meta.readLong();
        entry.termsIndexAddressesOffset = meta.readLong();
        entry.termsIndexAddressesLength = meta.readLong();
    }

    private NumericDocValues getNumeric(NumericEntry entry, final long maxOrd) throws IOException {
        int bitsPerOrd;
        if (entry.docsWithFieldOffset == -2L) {
            return DocValues.emptyNumeric();
        }
        if (maxOrd == 1L) {
            if (entry.docsWithFieldOffset == -1L) {
                return new NumericDocValues(){
                    private final int maxDoc;
                    private int doc;
                    {
                        this.maxDoc = ES87TSDBDocValuesProducer.this.maxDoc;
                        this.doc = -1;
                    }

                    @Override
                    public long longValue() {
                        return 0L;
                    }

                    @Override
                    public int docID() {
                        return this.doc;
                    }

                    @Override
                    public int nextDoc() throws IOException {
                        return this.advance(this.doc + 1);
                    }

                    @Override
                    public int advance(int target) throws IOException {
                        if (target >= this.maxDoc) {
                            this.doc = Integer.MAX_VALUE;
                            return Integer.MAX_VALUE;
                        }
                        this.doc = target;
                        return this.doc;
                    }

                    @Override
                    public boolean advanceExact(int target) {
                        this.doc = target;
                        return true;
                    }

                    @Override
                    public long cost() {
                        return this.maxDoc;
                    }
                };
            }
            final IndexedDISI disi = new IndexedDISI(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, entry.jumpTableEntryCount, entry.denseRankPower, entry.numValues);
            return new NumericDocValues(this){

                @Override
                public int advance(int target) throws IOException {
                    return disi.advance(target);
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    return disi.advanceExact(target);
                }

                @Override
                public int nextDoc() throws IOException {
                    return disi.nextDoc();
                }

                @Override
                public int docID() {
                    return disi.docID();
                }

                @Override
                public long cost() {
                    return disi.cost();
                }

                @Override
                public long longValue() {
                    return 0L;
                }
            };
        }
        RandomAccessInput indexSlice = this.data.randomAccessSlice(entry.indexOffset, entry.indexLength);
        final DirectMonotonicReader indexReader = DirectMonotonicReader.getInstance(entry.indexMeta, indexSlice, this.merging);
        final IndexInput valuesData = this.data.slice("values", entry.valuesOffset, entry.valuesLength);
        int n = bitsPerOrd = maxOrd >= 0L ? PackedInts.bitsRequired(maxOrd - 1L) : -1;
        if (entry.docsWithFieldOffset == -1L) {
            return new NumericDocValues(){
                private final int maxDoc;
                private int doc;
                private final TSDBDocValuesEncoder decoder;
                private long currentBlockIndex;
                private final long[] currentBlock;
                {
                    this.maxDoc = ES87TSDBDocValuesProducer.this.maxDoc;
                    this.doc = -1;
                    this.decoder = new TSDBDocValuesEncoder(128);
                    this.currentBlockIndex = -1L;
                    this.currentBlock = new long[128];
                }

                @Override
                public int docID() {
                    return this.doc;
                }

                @Override
                public int nextDoc() throws IOException {
                    return this.advance(this.doc + 1);
                }

                @Override
                public int advance(int target) throws IOException {
                    if (target >= this.maxDoc) {
                        this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    this.doc = target;
                    return this.doc;
                }

                @Override
                public boolean advanceExact(int target) {
                    this.doc = target;
                    return true;
                }

                @Override
                public long cost() {
                    return this.maxDoc;
                }

                @Override
                public long longValue() throws IOException {
                    int index = this.doc;
                    int blockIndex = index >>> 7;
                    int blockInIndex = index & 0x7F;
                    if ((long)blockIndex != this.currentBlockIndex) {
                        assert ((long)blockIndex > this.currentBlockIndex) : blockIndex + " < " + this.currentBlockIndex;
                        if (this.currentBlockIndex + 1L != (long)blockIndex) {
                            valuesData.seek(indexReader.get(blockIndex));
                        }
                        this.currentBlockIndex = blockIndex;
                        if (maxOrd >= 0L) {
                            this.decoder.decodeOrdinals(valuesData, this.currentBlock, bitsPerOrd);
                        } else {
                            this.decoder.decode(valuesData, this.currentBlock);
                        }
                    }
                    return this.currentBlock[blockInIndex];
                }
            };
        }
        final IndexedDISI disi = new IndexedDISI(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, entry.jumpTableEntryCount, entry.denseRankPower, entry.numValues);
        return new NumericDocValues(this){
            private final TSDBDocValuesEncoder decoder = new TSDBDocValuesEncoder(128);
            private long currentBlockIndex = -1L;
            private final long[] currentBlock = new long[128];

            @Override
            public int advance(int target) throws IOException {
                return disi.advance(target);
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                return disi.advanceExact(target);
            }

            @Override
            public int nextDoc() throws IOException {
                return disi.nextDoc();
            }

            @Override
            public int docID() {
                return disi.docID();
            }

            @Override
            public long cost() {
                return disi.cost();
            }

            @Override
            public long longValue() throws IOException {
                int index = disi.index();
                int blockIndex = index >>> 7;
                int blockInIndex = index & 0x7F;
                if ((long)blockIndex != this.currentBlockIndex) {
                    assert ((long)blockIndex > this.currentBlockIndex) : blockIndex + "<=" + this.currentBlockIndex;
                    if (this.currentBlockIndex + 1L != (long)blockIndex) {
                        valuesData.seek(indexReader.get(blockIndex));
                    }
                    this.currentBlockIndex = blockIndex;
                    if (maxOrd >= 0L) {
                        this.decoder.decodeOrdinals(valuesData, this.currentBlock, bitsPerOrd);
                    } else {
                        this.decoder.decode(valuesData, this.currentBlock);
                    }
                }
                return this.currentBlock[blockInIndex];
            }
        };
    }

    private NumericValues getValues(NumericEntry entry, long maxOrd) throws IOException {
        assert (entry.numValues > 0L);
        RandomAccessInput indexSlice = this.data.randomAccessSlice(entry.indexOffset, entry.indexLength);
        final DirectMonotonicReader indexReader = DirectMonotonicReader.getInstance(entry.indexMeta, indexSlice, this.merging);
        final IndexInput valuesData = this.data.slice("values", entry.valuesOffset, entry.valuesLength);
        final int bitsPerOrd = maxOrd >= 0L ? PackedInts.bitsRequired(maxOrd - 1L) : -1;
        return new NumericValues(this){
            private final TSDBDocValuesEncoder decoder = new TSDBDocValuesEncoder(128);
            private long currentBlockIndex = -1L;
            private final long[] currentBlock = new long[128];

            @Override
            long advance(long index) throws IOException {
                long blockIndex = index >>> 7;
                int blockInIndex = (int)(index & 0x7FL);
                if (blockIndex != this.currentBlockIndex) {
                    if (this.currentBlockIndex + 1L != blockIndex) {
                        valuesData.seek(indexReader.get(blockIndex));
                    }
                    this.currentBlockIndex = blockIndex;
                    if (bitsPerOrd >= 0) {
                        this.decoder.decodeOrdinals(valuesData, this.currentBlock, bitsPerOrd);
                    } else {
                        this.decoder.decode(valuesData, this.currentBlock);
                    }
                }
                return this.currentBlock[blockInIndex];
            }
        };
    }

    private SortedNumericDocValues getSortedNumeric(SortedNumericEntry entry, long maxOrd) throws IOException {
        if (entry.numValues == (long)entry.numDocsWithField) {
            return DocValues.singleton(this.getNumeric(entry, maxOrd));
        }
        RandomAccessInput addressesInput = this.data.randomAccessSlice(entry.addressesOffset, entry.addressesLength);
        final DirectMonotonicReader addresses = DirectMonotonicReader.getInstance(entry.addressesMeta, addressesInput, this.merging);
        final NumericValues values = this.getValues(entry, maxOrd);
        if (entry.docsWithFieldOffset == -1L) {
            return new SortedNumericDocValues(){
                int doc = -1;
                long start;
                long end;
                int count;

                @Override
                public int nextDoc() throws IOException {
                    return this.advance(this.doc + 1);
                }

                @Override
                public int docID() {
                    return this.doc;
                }

                @Override
                public long cost() {
                    return ES87TSDBDocValuesProducer.this.maxDoc;
                }

                @Override
                public int advance(int target) throws IOException {
                    if (target >= ES87TSDBDocValuesProducer.this.maxDoc) {
                        this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    this.start = addresses.get(target);
                    this.end = addresses.get((long)target + 1L);
                    this.count = (int)(this.end - this.start);
                    this.doc = target;
                    return this.doc;
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    this.start = addresses.get(target);
                    this.end = addresses.get((long)target + 1L);
                    this.count = (int)(this.end - this.start);
                    this.doc = target;
                    return true;
                }

                @Override
                public long nextValue() throws IOException {
                    return values.advance(this.start++);
                }

                @Override
                public int docValueCount() {
                    return this.count;
                }
            };
        }
        final IndexedDISI disi = new IndexedDISI(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, entry.jumpTableEntryCount, entry.denseRankPower, entry.numDocsWithField);
        return new SortedNumericDocValues(this){
            boolean set;
            long start;
            long end;
            int count;

            @Override
            public int nextDoc() throws IOException {
                this.set = false;
                return disi.nextDoc();
            }

            @Override
            public int docID() {
                return disi.docID();
            }

            @Override
            public long cost() {
                return disi.cost();
            }

            @Override
            public int advance(int target) throws IOException {
                this.set = false;
                return disi.advance(target);
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                this.set = false;
                return disi.advanceExact(target);
            }

            @Override
            public long nextValue() throws IOException {
                this.set();
                return values.advance(this.start++);
            }

            @Override
            public int docValueCount() {
                this.set();
                return this.count;
            }

            private void set() {
                if (!this.set) {
                    int index = disi.index();
                    this.start = addresses.get(index);
                    this.end = addresses.get((long)index + 1L);
                    this.count = (int)(this.end - this.start);
                    this.set = true;
                }
            }
        };
    }

    private static class NumericEntry {
        long docsWithFieldOffset;
        long docsWithFieldLength;
        short jumpTableEntryCount;
        byte denseRankPower;
        long numValues;
        long indexOffset;
        long indexLength;
        DirectMonotonicReader.Meta indexMeta;
        long valuesOffset;
        long valuesLength;

        private NumericEntry() {
        }
    }

    private static class BinaryEntry {
        long dataOffset;
        long dataLength;
        long docsWithFieldOffset;
        long docsWithFieldLength;
        short jumpTableEntryCount;
        byte denseRankPower;
        int numDocsWithField;
        int minLength;
        int maxLength;
        long addressesOffset;
        long addressesLength;
        DirectMonotonicReader.Meta addressesMeta;

        private BinaryEntry() {
        }
    }

    private static class SortedEntry {
        NumericEntry ordsEntry;
        TermsDictEntry termsDictEntry;

        private SortedEntry() {
        }
    }

    private static class TermsDictEntry {
        long termsDictSize;
        DirectMonotonicReader.Meta termsAddressesMeta;
        int maxTermLength;
        long termsDataOffset;
        long termsDataLength;
        long termsAddressesOffset;
        long termsAddressesLength;
        int termsDictIndexShift;
        DirectMonotonicReader.Meta termsIndexAddressesMeta;
        long termsIndexOffset;
        long termsIndexLength;
        long termsIndexAddressesOffset;
        long termsIndexAddressesLength;
        int maxBlockLength;

        private TermsDictEntry() {
        }
    }

    private static class SortedNumericEntry
    extends NumericEntry {
        int numDocsWithField;
        DirectMonotonicReader.Meta addressesMeta;
        long addressesOffset;
        long addressesLength;

        private SortedNumericEntry() {
        }
    }

    private static class SortedSetEntry {
        SortedEntry singleValueEntry;
        SortedNumericEntry ordsEntry;
        TermsDictEntry termsDictEntry;

        private SortedSetEntry() {
        }
    }

    private record DocValuesSkipperEntry(long offset, long length, long minValue, long maxValue, int docCount, int maxDocId) {
    }

    private static abstract class NumericValues {
        private NumericValues() {
        }

        abstract long advance(long var1) throws IOException;
    }

    private static class TermsDict
    extends BaseTermsEnum {
        static final int LZ4_DECOMPRESSOR_PADDING = 7;
        final TermsDictEntry entry;
        final LongValues blockAddresses;
        final IndexInput bytes;
        final long blockMask;
        final LongValues indexAddresses;
        final RandomAccessInput indexBytes;
        final BytesRef term;
        long ord = -1L;
        BytesRef blockBuffer = null;
        ByteArrayDataInput blockInput = null;
        long currentCompressedBlockStart = -1L;
        long currentCompressedBlockEnd = -1L;

        TermsDict(TermsDictEntry entry, IndexInput data, boolean merging) throws IOException {
            this.entry = entry;
            RandomAccessInput addressesSlice = data.randomAccessSlice(entry.termsAddressesOffset, entry.termsAddressesLength);
            this.blockAddresses = DirectMonotonicReader.getInstance(entry.termsAddressesMeta, addressesSlice, merging);
            this.bytes = data.slice("terms", entry.termsDataOffset, entry.termsDataLength);
            this.blockMask = 63L;
            RandomAccessInput indexAddressesSlice = data.randomAccessSlice(entry.termsIndexAddressesOffset, entry.termsIndexAddressesLength);
            this.indexAddresses = DirectMonotonicReader.getInstance(entry.termsIndexAddressesMeta, indexAddressesSlice, merging);
            this.indexBytes = data.randomAccessSlice(entry.termsIndexOffset, entry.termsIndexLength);
            this.term = new BytesRef(entry.maxTermLength);
            int bufferSize = entry.maxBlockLength + entry.maxTermLength + 7;
            this.blockBuffer = new BytesRef(new byte[bufferSize], 0, bufferSize);
        }

        @Override
        public BytesRef next() throws IOException {
            if (++this.ord >= this.entry.termsDictSize) {
                return null;
            }
            if ((this.ord & this.blockMask) == 0L) {
                this.decompressBlock();
            } else {
                ByteArrayDataInput input = this.blockInput;
                int token = Byte.toUnsignedInt(((DataInput)input).readByte());
                int prefixLength = token & 0xF;
                int suffixLength = 1 + (token >>> 4);
                if (prefixLength == 15) {
                    prefixLength += ((DataInput)input).readVInt();
                }
                if (suffixLength == 16) {
                    suffixLength += ((DataInput)input).readVInt();
                }
                this.term.length = prefixLength + suffixLength;
                ((DataInput)input).readBytes(this.term.bytes, prefixLength, suffixLength);
            }
            return this.term;
        }

        @Override
        public void seekExact(long ord) throws IOException {
            if (ord < 0L || ord >= this.entry.termsDictSize) {
                throw new IndexOutOfBoundsException();
            }
            long currentBlockIndex = this.ord >> 6;
            long blockIndex = ord >> 6;
            if (ord < this.ord || blockIndex != currentBlockIndex) {
                long blockAddress = this.blockAddresses.get(blockIndex);
                this.bytes.seek(blockAddress);
                this.ord = (blockIndex << 6) - 1L;
            }
            while (this.ord < ord) {
                this.next();
            }
        }

        private BytesRef getTermFromIndex(long index) throws IOException {
            assert (index >= 0L && index <= this.entry.termsDictSize - 1L >>> this.entry.termsDictIndexShift);
            long start = this.indexAddresses.get(index);
            this.term.length = (int)(this.indexAddresses.get(index + 1L) - start);
            this.indexBytes.readBytes(start, this.term.bytes, 0, this.term.length);
            return this.term;
        }

        private long seekTermsIndex(BytesRef text) throws IOException {
            long lo = 0L;
            long hi = this.entry.termsDictSize - 1L >> this.entry.termsDictIndexShift;
            while (lo <= hi) {
                long mid = lo + hi >>> 1;
                this.getTermFromIndex(mid);
                int cmp = this.term.compareTo(text);
                if (cmp <= 0) {
                    lo = mid + 1L;
                    continue;
                }
                hi = mid - 1L;
            }
            assert (hi < 0L || this.getTermFromIndex(hi).compareTo(text) <= 0);
            assert (hi == this.entry.termsDictSize - 1L >> this.entry.termsDictIndexShift || this.getTermFromIndex(hi + 1L).compareTo(text) > 0);
            return hi;
        }

        private BytesRef getFirstTermFromBlock(long block) throws IOException {
            assert (block >= 0L && block <= this.entry.termsDictSize - 1L >>> 6);
            long blockAddress = this.blockAddresses.get(block);
            this.bytes.seek(blockAddress);
            this.term.length = this.bytes.readVInt();
            this.bytes.readBytes(this.term.bytes, 0, this.term.length);
            return this.term;
        }

        private long seekBlock(BytesRef text) throws IOException {
            long index = this.seekTermsIndex(text);
            if (index == -1L) {
                return -1L;
            }
            long ordLo = index << this.entry.termsDictIndexShift;
            long ordHi = Math.min(this.entry.termsDictSize, ordLo + (1L << this.entry.termsDictIndexShift)) - 1L;
            long blockLo = ordLo >>> 6;
            long blockHi = ordHi >>> 6;
            while (blockLo <= blockHi) {
                long blockMid = blockLo + blockHi >>> 1;
                this.getFirstTermFromBlock(blockMid);
                int cmp = this.term.compareTo(text);
                if (cmp <= 0) {
                    blockLo = blockMid + 1L;
                    continue;
                }
                blockHi = blockMid - 1L;
            }
            assert (blockHi < 0L || this.getFirstTermFromBlock(blockHi).compareTo(text) <= 0);
            assert (blockHi == this.entry.termsDictSize - 1L >>> 6 || this.getFirstTermFromBlock(blockHi + 1L).compareTo(text) > 0);
            return blockHi;
        }

        @Override
        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            long block = this.seekBlock(text);
            if (block == -1L) {
                if (this.entry.termsDictSize == 0L) {
                    this.ord = 0L;
                    return TermsEnum.SeekStatus.END;
                }
                this.seekExact(0L);
                return TermsEnum.SeekStatus.NOT_FOUND;
            }
            long blockAddress = this.blockAddresses.get(block);
            this.ord = block << 6;
            this.bytes.seek(blockAddress);
            this.decompressBlock();
            do {
                int cmp;
                if ((cmp = this.term.compareTo(text)) == 0) {
                    return TermsEnum.SeekStatus.FOUND;
                }
                if (cmp <= 0) continue;
                return TermsEnum.SeekStatus.NOT_FOUND;
            } while (this.next() != null);
            return TermsEnum.SeekStatus.END;
        }

        private void decompressBlock() throws IOException {
            this.term.length = this.bytes.readVInt();
            this.bytes.readBytes(this.term.bytes, 0, this.term.length);
            long offset = this.bytes.getFilePointer();
            if (offset < this.entry.termsDataLength - 1L) {
                if (this.currentCompressedBlockStart != offset) {
                    this.blockBuffer.offset = this.term.length;
                    this.blockBuffer.length = this.bytes.readVInt();
                    System.arraycopy(this.term.bytes, 0, this.blockBuffer.bytes, 0, this.blockBuffer.offset);
                    LZ4.decompress(this.bytes, this.blockBuffer.length, this.blockBuffer.bytes, this.blockBuffer.offset);
                    this.currentCompressedBlockStart = offset;
                    this.currentCompressedBlockEnd = this.bytes.getFilePointer();
                } else {
                    this.bytes.seek(this.currentCompressedBlockEnd);
                }
                this.blockInput = new ByteArrayDataInput(this.blockBuffer.bytes, this.blockBuffer.offset, this.blockBuffer.length);
            }
        }

        @Override
        public BytesRef term() throws IOException {
            return this.term;
        }

        @Override
        public long ord() throws IOException {
            return this.ord;
        }

        @Override
        public long totalTermFreq() throws IOException {
            return -1L;
        }

        @Override
        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImpactsEnum impacts(int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docFreq() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class BaseSortedSetDocValues
    extends SortedSetDocValues {
        final SortedSetEntry entry;
        final IndexInput data;
        final boolean merging;
        final TermsEnum termsEnum;

        BaseSortedSetDocValues(SortedSetEntry entry, IndexInput data, boolean merging) throws IOException {
            this.entry = entry;
            this.data = data;
            this.merging = merging;
            this.termsEnum = this.termsEnum();
        }

        @Override
        public long getValueCount() {
            return this.entry.termsDictEntry.termsDictSize;
        }

        @Override
        public BytesRef lookupOrd(long ord) throws IOException {
            this.termsEnum.seekExact(ord);
            return this.termsEnum.term();
        }

        @Override
        public long lookupTerm(BytesRef key) throws IOException {
            TermsEnum.SeekStatus status = this.termsEnum.seekCeil(key);
            return switch (status) {
                case TermsEnum.SeekStatus.FOUND -> this.termsEnum.ord();
                default -> -1L - this.termsEnum.ord();
            };
        }

        @Override
        public TermsEnum termsEnum() throws IOException {
            return new TermsDict(this.entry.termsDictEntry, this.data, this.merging);
        }
    }

    private abstract class BaseSortedDocValues
    extends SortedDocValues {
        final SortedEntry entry;
        final TermsEnum termsEnum;

        BaseSortedDocValues(SortedEntry entry) throws IOException {
            this.entry = entry;
            this.termsEnum = this.termsEnum();
        }

        @Override
        public int getValueCount() {
            return Math.toIntExact(this.entry.termsDictEntry.termsDictSize);
        }

        @Override
        public BytesRef lookupOrd(int ord) throws IOException {
            this.termsEnum.seekExact(ord);
            return this.termsEnum.term();
        }

        @Override
        public int lookupTerm(BytesRef key) throws IOException {
            TermsEnum.SeekStatus status = this.termsEnum.seekCeil(key);
            return switch (status) {
                case TermsEnum.SeekStatus.FOUND -> Math.toIntExact(this.termsEnum.ord());
                default -> Math.toIntExact(-1L - this.termsEnum.ord());
            };
        }

        @Override
        public TermsEnum termsEnum() throws IOException {
            return new TermsDict(this.entry.termsDictEntry, ES87TSDBDocValuesProducer.this.data, ES87TSDBDocValuesProducer.this.merging);
        }
    }

    private static abstract class SparseBinaryDocValues
    extends BinaryDocValues {
        final IndexedDISI disi;

        SparseBinaryDocValues(IndexedDISI disi) {
            this.disi = disi;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        @Override
        public int docID() {
            return this.disi.docID();
        }

        @Override
        public long cost() {
            return this.disi.cost();
        }

        @Override
        public int advance(int target) throws IOException {
            return this.disi.advance(target);
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.disi.advanceExact(target);
        }
    }

    private static abstract class DenseBinaryDocValues
    extends BinaryDocValues {
        final int maxDoc;
        int doc = -1;

        DenseBinaryDocValues(int maxDoc) {
            this.maxDoc = maxDoc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public long cost() {
            return this.maxDoc;
        }

        @Override
        public int advance(int target) throws IOException {
            if (target >= this.maxDoc) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = target;
            return this.doc;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            this.doc = target;
            return true;
        }
    }
}

