/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._helpers.bulk;

import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import java.util.Iterator;
import java.util.Optional;

class RetryableBulkOperation<Context> {
    private final BulkOperation operation;
    private final Context context;
    private final Iterator<Long> retries;
    private final Long retryTime;

    RetryableBulkOperation(BulkOperation request, Context context, Iterator<Long> retries) {
        this.operation = request;
        this.context = context;
        this.retries = retries;
        long currentMillis = this.currentMillis();
        this.retryTime = Optional.ofNullable(retries).map(r -> currentMillis + (Long)r.next()).orElse(currentMillis);
    }

    public BulkOperation operation() {
        return this.operation;
    }

    public Context context() {
        return this.context;
    }

    public Iterator<Long> retries() {
        return this.retries;
    }

    public long currentRetryTimeDelay() {
        return this.retryTime - this.currentMillis();
    }

    public boolean canRetry() {
        return Optional.ofNullable(this.retries).map(Iterator::hasNext).orElse(true);
    }

    public boolean isSendable() {
        return this.retryTime - this.currentMillis() <= 0L;
    }

    private Long currentMillis() {
        return System.nanoTime() / 1000000L;
    }
}

