"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScopedDiscoverEBTManager = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _discover_ebt_manager_registrations = require("./discover_ebt_manager_registrations");
var _context_awareness = require("../context_awareness");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
var FieldUsageEventName = /*#__PURE__*/function (FieldUsageEventName) {
  FieldUsageEventName["dataTableSelection"] = "dataTableSelection";
  FieldUsageEventName["dataTableRemoval"] = "dataTableRemoval";
  FieldUsageEventName["filterAddition"] = "filterAddition";
  return FieldUsageEventName;
}(FieldUsageEventName || {});
class ScopedDiscoverEBTManager {
  constructor(reportEvent, reportPerformanceEvent, updateProfilesContextWith, setAsActiveManager) {
    (0, _defineProperty2.default)(this, "lastResolvedContextProfiles", {
      [_context_awareness.ContextualProfileLevel.rootLevel]: undefined,
      [_context_awareness.ContextualProfileLevel.dataSourceLevel]: undefined,
      [_context_awareness.ContextualProfileLevel.documentLevel]: undefined
    });
    this.reportEvent = reportEvent;
    this.reportPerformanceEvent = reportPerformanceEvent;
    this.updateProfilesContextWith = updateProfilesContextWith;
    this.setAsActiveManager = setAsActiveManager;
  }
  async trackFieldUsageEvent({
    eventName,
    fieldName,
    filterOperation,
    fieldsMetadata
  }) {
    if (!this.reportEvent) {
      return;
    }
    const eventData = {
      [_discover_ebt_manager_registrations.FIELD_USAGE_EVENT_NAME]: eventName
    };
    if (fieldsMetadata) {
      var _fields$fieldName;
      const client = await fieldsMetadata.getClient();
      const {
        fields
      } = await client.find({
        attributes: ['short'],
        fieldNames: [fieldName]
      });

      // excludes non ECS fields
      if ((_fields$fieldName = fields[fieldName]) !== null && _fields$fieldName !== void 0 && _fields$fieldName.short) {
        eventData[_discover_ebt_manager_registrations.FIELD_USAGE_FIELD_NAME] = fieldName;
      }
    }
    if (filterOperation) {
      eventData[_discover_ebt_manager_registrations.FIELD_USAGE_FILTER_OPERATION] = filterOperation;
    }
    this.reportEvent(_discover_ebt_manager_registrations.FIELD_USAGE_EVENT_TYPE, eventData);
  }
  async trackDataTableSelection({
    fieldName,
    fieldsMetadata
  }) {
    await this.trackFieldUsageEvent({
      eventName: FieldUsageEventName.dataTableSelection,
      fieldName,
      fieldsMetadata
    });
  }
  async trackDataTableRemoval({
    fieldName,
    fieldsMetadata
  }) {
    await this.trackFieldUsageEvent({
      eventName: FieldUsageEventName.dataTableRemoval,
      fieldName,
      fieldsMetadata
    });
  }
  async trackFilterAddition({
    fieldName,
    fieldsMetadata,
    filterOperation
  }) {
    await this.trackFieldUsageEvent({
      eventName: FieldUsageEventName.filterAddition,
      fieldName,
      fieldsMetadata,
      filterOperation
    });
  }
  trackContextualProfileResolvedEvent({
    contextLevel,
    profileId
  }) {
    if (!this.reportEvent) {
      return;
    }
    if (this.lastResolvedContextProfiles[contextLevel] === profileId) {
      // avoid sending duplicate events to EBT
      return;
    }
    this.lastResolvedContextProfiles[contextLevel] = profileId;
    const eventData = {
      [_discover_ebt_manager_registrations.CONTEXTUAL_PROFILE_LEVEL]: contextLevel,
      [_discover_ebt_manager_registrations.CONTEXTUAL_PROFILE_ID]: profileId
    };
    this.reportEvent(_discover_ebt_manager_registrations.CONTEXTUAL_PROFILE_RESOLVED_EVENT_TYPE, eventData);
  }
  trackPerformanceEvent(eventName) {
    const startTime = window.performance.now();
    let reported = false;
    return {
      reportEvent: eventData => {
        if (reported || !this.reportPerformanceEvent) {
          return;
        }
        reported = true;
        const duration = window.performance.now() - startTime;
        this.reportPerformanceEvent({
          ...eventData,
          eventName,
          duration
        });
      }
    };
  }
}
exports.ScopedDiscoverEBTManager = ScopedDiscoverEBTManager;