"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeprecationsClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/* @internal */

class DeprecationsClient {
  constructor({
    http
  }) {
    (0, _defineProperty2.default)(this, "http", void 0);
    (0, _defineProperty2.default)(this, "fetchDeprecations", async () => {
      const {
        deprecations
      } = await this.http.fetch('/api/deprecations/', {
        asSystemRequest: true
      });
      return deprecations;
    });
    (0, _defineProperty2.default)(this, "getAllDeprecations", async () => {
      return await this.fetchDeprecations();
    });
    (0, _defineProperty2.default)(this, "getDeprecations", async domainId => {
      const deprecations = await this.fetchDeprecations();
      return deprecations.filter(deprecation => deprecation.domainId === domainId);
    });
    (0, _defineProperty2.default)(this, "isDeprecationResolvable", details => {
      return typeof details.correctiveActions.api === 'object';
    });
    (0, _defineProperty2.default)(this, "getResolveFetchDetails", details => {
      const {
        domainId,
        correctiveActions
      } = details;
      if (correctiveActions.api) {
        const {
          body,
          method,
          path,
          omitContextFromBody = false
        } = correctiveActions.api;
        return {
          path,
          method,
          asSystemRequest: true,
          body: JSON.stringify({
            ...body,
            ...(omitContextFromBody ? {} : {
              deprecationDetails: {
                domainId
              }
            })
          })
        };
      }
      if (correctiveActions.mark_as_resolved_api) {
        const {
          routeMethod,
          routePath,
          routeVersion,
          apiTotalCalls,
          totalMarkedAsResolved
        } = correctiveActions.mark_as_resolved_api;
        const incrementBy = apiTotalCalls - totalMarkedAsResolved;
        return {
          path: '/api/deprecations/mark_as_resolved',
          method: 'POST',
          asSystemRequest: true,
          body: JSON.stringify({
            domainId,
            routeMethod,
            routePath,
            routeVersion,
            incrementBy
          })
        };
      }
    });
    (0, _defineProperty2.default)(this, "resolveDeprecation", async details => {
      const {
        correctiveActions
      } = details;
      const noCorrectiveActionFail = {
        status: 'fail',
        reason: _i18n.i18n.translate('core.deprecations.noCorrectiveAction', {
          defaultMessage: 'This deprecation cannot be resolved automatically or marked as resolved.'
        })
      };
      if (typeof correctiveActions.api !== 'object' && typeof correctiveActions.mark_as_resolved_api !== 'object') {
        return noCorrectiveActionFail;
      }
      try {
        const fetchParams = this.getResolveFetchDetails(details);
        if (!fetchParams) {
          return noCorrectiveActionFail;
        }
        await this.http.fetch(fetchParams);
        return {
          status: 'ok'
        };
      } catch (err) {
        return {
          status: 'fail',
          reason: err.body.message
        };
      }
    });
    this.http = http;
  }
}
exports.DeprecationsClient = DeprecationsClient;