"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FloatingActions = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _uuid = require("uuid");
var _rxjs = require("rxjs");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _kibana_services = require("../../services/kibana_services");
var _controls_hover_trigger = require("../../actions/controls_hover_trigger");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const FloatingActions = ({
  children,
  viewMode,
  isEnabled,
  api,
  className = '',
  disabledActions,
  isTwoLine
}) => {
  const [floatingActions, setFloatingActions] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    if (!api) return;
    let canceled = false;
    const context = {
      embeddable: api,
      trigger: _controls_hover_trigger.controlHoverTrigger
    };
    const sortByOrder = (a, b) => {
      return (a.order || 0) - (b.order || 0);
    };
    const getActions = async () => {
      const actions = (await _kibana_services.uiActionsService.getTriggerCompatibleActions(_controls_hover_trigger.CONTROL_HOVER_TRIGGER, context)).filter(action => {
        return action.MenuItem !== undefined && (disabledActions !== null && disabledActions !== void 0 ? disabledActions : []).indexOf(action.id) === -1;
      }).sort(sortByOrder);
      return actions;
    };
    const subscriptions = new _rxjs.Subscription();
    const handleActionCompatibilityChange = (isCompatible, action) => {
      if (canceled) return;
      setFloatingActions(currentActions => {
        const newActions = currentActions === null || currentActions === void 0 ? void 0 : currentActions.filter(current => current.id !== action.id).sort(sortByOrder);
        if (isCompatible) {
          return [action, ...newActions];
        }
        return newActions;
      });
    };
    (async () => {
      const actions = await getActions();
      if (canceled) return;
      setFloatingActions(actions);
      const frequentlyChangingActions = await _kibana_services.uiActionsService.getFrequentlyChangingActionsForTrigger(_controls_hover_trigger.CONTROL_HOVER_TRIGGER, context);
      if (canceled) return;
      for (const action of frequentlyChangingActions) {
        var _action$getCompatibil;
        const compatibilitySubscription = (_action$getCompatibil = action.getCompatibilityChangesSubject(context)) === null || _action$getCompatibil === void 0 ? void 0 : _action$getCompatibil.pipe((0, _rxjs.switchMap)(async () => {
          return await action.isCompatible(context);
        })).subscribe(async isCompatible => {
          handleActionCompatibilityChange(isCompatible, action);
        });
        subscriptions.add(compatibilitySubscription);
      }
    })();
    return () => {
      canceled = true;
      subscriptions.unsubscribe();
    };
  }, [api, viewMode, disabledActions]);
  const styles = (0, _use_memo_css.useMemoCss)(floatingActionsStyles);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.wrapper
  }, children, isEnabled && floatingActions.length > 0 && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `presentationUtil__floatingActions__${(0, _presentationPublishing.apiHasUniqueId)(api) ? api.uuid : (0, _uuid.v4)()}`,
    className: (0, _classnames.default)('presentationUtil__floatingActions', `controlFrameFloatingActions--${isTwoLine ? 'twoLine' : 'oneLine'}`, className),
    css: styles.floatingActions
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, floatingActions.map(action => /*#__PURE__*/_react.default.createElement(action.MenuItem, {
    key: action.id,
    context: {
      embeddable: api
    }
  })))));
};
exports.FloatingActions = FloatingActions;
const floatingActionsStyles = {
  wrapper: ({
    euiTheme
  }) => (0, _react2.css)({
    position: 'relative',
    '&:hover, &:focus-within': {
      '.presentationUtil__floatingActions': {
        opacity: 1,
        visibility: 'visible',
        transition: `visibility ${euiTheme.animation.fast}, opacity ${euiTheme.animation.fast}`
      }
    }
  }),
  floatingActions: ({
    euiTheme
  }) => (0, _react2.css)({
    opacity: 0,
    visibility: 'hidden',
    // slower transition on hover leave in case the user accidentally stops hover
    transition: `opacity ${euiTheme.animation.slow}`,
    position: 'absolute',
    right: euiTheme.size.xs,
    top: `-${euiTheme.size.l}`,
    zIndex: euiTheme.levels.toast,
    '&.controlFrameFloatingActions--oneLine': {
      padding: euiTheme.size.xs,
      borderRadius: euiTheme.border.radius.medium,
      backgroundColor: euiTheme.colors.emptyShade,
      boxShadow: `0 0 0 1px ${euiTheme.colors.lightShade}`
    },
    '&.controlFrameFloatingActions--twoLine': {
      top: `-${euiTheme.size.xs} !important`
    }
  })
};