/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
"use strict";(self.apm_bundle_jsonpfunction=self.apm_bundle_jsonpfunction||[]).push([[1514],{21514:(e,a,t)=>{t.r(a),t.d(a,{Onboarding:()=>xe});var n=t(84286),i=t.n(n),r=t(20409),s=t(81319),o=t(12965),l=t(57991),u=t(75008),c=t(75879),p=t(52475),d=t(96791);function g({isBeta:e,guideLink:a}){const t=(0,d.jsx)(s.EuiBetaBadge,{label:u.i18n.translate("xpack.apm.onboarding.betaLabel",{defaultMessage:"Beta"})}),n=(0,p.D)("/plugins/apm/assets/apm.png"),r=[(0,d.jsx)(s.EuiImage,{size:"l",allowFullScreen:!0,fullScreenIconColor:"dark",alt:u.i18n.translate("xpack.apm.onboarding.introduction.imageAltDescription",{defaultMessage:"screenshot of primary dashboard."}),url:n})];return(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiPageHeader,{iconType:"apmApp",pageTitle:(0,d.jsx)(i().Fragment,null,u.i18n.translate("xpack.apm.onboarding.appName",{defaultMessage:"APM"}),e&&(0,d.jsx)(i().Fragment,null," ",t)),description:(0,d.jsx)(s.EuiText,null,(0,d.jsx)(c.FormattedMessage,{id:"xpack.apm.onboarding.specProvider.longDescription",defaultMessage:"Application Performance Monitoring (APM) collects in-depth performance metrics and errors from inside your application. It allows you to monitor the performance of thousands of applications in real time. {learnMoreLink}.",values:{learnMoreLink:(0,d.jsx)(s.EuiLink,{"data-test-subj":"apmIntroductionLearnMoreLink",href:a,"aria-label":u.i18n.translate("xpack.apm.onboarding.specProvider.learnMoreAriaLabel",{defaultMessage:"Learn more about APM"}),target:"_blank"},u.i18n.translate("xpack.apm.onboarding.specProvider.learnMoreLabel",{defaultMessage:"Learn more"}))}})),rightSideItems:r}))}var m=t(1493),y=t(38498),k=t(88450),f=t(70200);function v({agentTabs:e,selectedTab:a}){const t=(0,m.useHistory)(),{euiTheme:n}=(0,s.useEuiTheme)();return(0,d.jsx)(s.EuiTabs,{css:(0,d.css)("padding:0 ",n.size.l,";","")},e.map((e=>(0,d.jsx)(s.EuiTab,{key:e.id,isSelected:e.id===a,onClick:()=>{return a=e.id,void(0,f.VC)(t,{query:{agent:a}});var a}},e.text))))}function x({instructions:e,selectedTab:a}){const t=e.find((e=>e.id===a));return t?(0,d.jsx)(i().Fragment,null,t.title&&(0,d.jsx)(s.EuiTitle,{size:"m"},(0,d.jsx)("h2",null,t.title)),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiSteps,{titleSize:"xs",steps:t.instructions})):(0,d.jsx)(i().Fragment,null)}function h({instructions:e}){const a=(0,n.useMemo)((()=>e.map((e=>({id:e.id,text:(0,y.K)(e.id)})))),[e]),{query:{agent:t}}=(0,k.Oh)("/onboarding"),i=null!=t?t:a[0].id;return(0,d.jsx)(s.EuiSplitPanel.Outer,null,(0,d.jsx)(s.EuiSplitPanel.Inner,{color:"subdued",paddingSize:"none"},(0,d.jsx)(v,{agentTabs:a,selectedTab:i})),(0,d.jsx)(s.EuiSplitPanel.Inner,{paddingSize:"l"},(0,d.jsx)(x,{instructions:e,selectedTab:i})))}var E=t(55907);const A=u.i18n.translate("xpack.apm.onboarding.shared_clients.configure.commands.serviceNameHint",{defaultMessage:"The service name is the primary filter in the APM UI and is used to group errors and trace data together. Allowed characters are a-z, A-Z, 0-9, -, _, and space."}),S=u.i18n.translate("xpack.apm.onboarding.shared_clients.configure.commands.secretTokenHint",{defaultMessage:"Use if APM Server requires a secret token. Both the agent and APM Server must be configured with the same token. This ensures that only your agents can send data to your APM server."}),b=u.i18n.translate("xpack.apm.onboarding.shared_clients.configure.commands.apiKeyHint",{defaultMessage:"Use if APM Server requires an API Key. This is used to ensure that only your agents can send data to your APM server. Agents can use API keys as a replacement of secret token, APM server can have multiple API keys. When both secret token and API key are used, API key has priority and secret token is ignored."}),M=u.i18n.translate("xpack.apm.onboarding.shared_clients.configure.commands.serverUrlHint",{defaultMessage:"Set the custom APM Server URL (default: {defaultApmServerUrl}). The URL must be fully qualified, including protocol (http or https) and port.",values:{defaultApmServerUrl:"http://localhost:8200"}}),j=u.i18n.translate("xpack.apm.onboarding.shared_clients.configure.commands.serviceEnvironmentHint",{defaultMessage:'The name of the environment this service is deployed in, e.g., "production" or "staging". Environments allow you to easily filter data on a global level in the APM UI. It\'s important to be consistent when naming environments across agents.'}),T=e=>({...e&&{secretToken:"elastic.apm.secret_token"},...!e&&{apiKey:"elastic.apm.api_key"},apmServerUrl:"elastic.apm.server_url"}),K=e=>({start:1,highlight:"",annotations:{2:A,3:e?b:S,4:M,5:j}}),C=e=>({...e&&{secretToken:"secretToken"},...!e&&{apiKey:"apiKey"},apmServerUrl:"serverUrl"}),L=`// ${u.i18n.translate("xpack.apm.onboarding.nodeClient.configure.commands.addThisToTheFileTopComment",{defaultMessage:"Add this to the very top of the first file loaded in your app"})}\nvar apm = require('elastic-apm-node').start({\n  // {{serviceNameHint}} ${u.i18n.translate("xpack.apm.onboarding.nodeClient.createConfig.commands.serviceName",{defaultMessage:"Overrides the service name in package.json."})}\n  serviceName: '<your-service-name>',\n\n  {{^secretToken}}\n  // {{apiKeyHint}}\n  apiKey: '{{{apiKey}}}',\n  {{/secretToken}}\n  {{#secretToken}}\n  // {{secretTokenHint}}\n  secretToken: '{{{secretToken}}}',\n  {{/secretToken}}\n\n  // {{{serverUrlHint}}}\n  serverUrl: '{{{apmServerUrl}}}',\n\n  // {{{serviceEnvironmentHint}}}\n  environment: '<your-environment>'\n})`,P=e=>({...e&&{secretToken:"SECRET_TOKEN"},...!e&&{apiKey:"API_KEY"},apmServerUrl:"SERVER_URL"}),_=`INSTALLED_APPS = (\n  # ${u.i18n.translate("xpack.apm.onboarding.djangoClient.configure.commands.addAgentComment",{defaultMessage:"Add the agent to installed apps"})}\n  'elasticapm.contrib.django',\n  # ...\n)\n\nELASTIC_APM = {\n  # {{serviceNameHint}}\n  'SERVICE_NAME': '<your-service-name>',\n\n  {{^secretToken}}\n  # {{apiKeyHint}}\n  'API_KEY': '{{{apiKey}}}',\n  {{/secretToken}}\n  {{#secretToken}}\n  # {{secretTokenHint}}\n  'SECRET_TOKEN': '{{{secretToken}}}',\n  {{/secretToken}}\n\n  # {{{serverUrlHint}}}\n  'SERVER_URL': '{{{apmServerUrl}}}',\n\n  # {{{serviceEnvironmentHint}}}\n  'ENVIRONMENT': '<your-environment>',\n}\n\nMIDDLEWARE = (\n  # ${u.i18n.translate("xpack.apm.onboarding.djangoClient.configure.commands.addTracingMiddlewareComment",{defaultMessage:"Add our tracing middleware to send performance metrics"})}\n  'elasticapm.contrib.django.middleware.TracingMiddleware',\n  #...\n)`,w=e=>({...e&&{secretToken:"SECRET_TOKEN"},...!e&&{apiKey:"API_KEY"},apmServerUrl:"SERVER_URL"}),I=`# ${u.i18n.translate("xpack.apm.onboarding.flaskClient.configure.commands.initializeUsingEnvironmentVariablesComment",{defaultMessage:"Initialize using environment variables"})}\nfrom elasticapm.contrib.flask import ElasticAPM\napp = Flask(__name__)\napm = ElasticAPM(app)\n\n# ${u.i18n.translate("xpack.apm.onboarding.flaskClient.configure.commands.configureElasticApmComment",{defaultMessage:"Or use ELASTIC_APM in your application's settings"})}\nfrom elasticapm.contrib.flask import ElasticAPM\napp.config['ELASTIC_APM'] = {\n  # {{serviceNameHint}}\n  'SERVICE_NAME': '<your-service-name>',\n  {{^secretToken}}\n  # {{apiKeyHint}}\n  'API_KEY': '{{{apiKey}}}',\n  {{/secretToken}}\n  {{#secretToken}}\n  # {{secretTokenHint}}\n  'SECRET_TOKEN': '{{{secretToken}}}',\n  {{/secretToken}}\n\n  # {{{serverUrlHint}}}\n  'SERVER_URL': '{{{apmServerUrl}}}',\n\n  # {{{serviceEnvironmentHint}}}\n  'ENVIRONMENT': '<your-environment>',\n}\n\napm = ElasticAPM(app)`,U=e=>({...e&&{secretToken:"secret_token"},...!e&&{apiKey:"api_key"},apmServerUrl:"server_url"}),F=`# config/elastic_apm.yml:\n\n# {{serviceNameHint}} ${u.i18n.translate("xpack.apm.onboarding.railsClient.createConfig.commands.defaultServiceName",{defaultMessage:"Defaults to the name of your Rails app."})}\nservice_name: '<your-service-name>'\n\n{{^secretToken}}\n# {{apiKeyHint}}\napi_key: '{{{apiKey}}}'\n{{/secretToken}}\n{{#secretToken}}\n# {{secretTokenHint}}\nsecret_token: '{{{secretToken}}}'\n{{/secretToken}}\n\n# {{{serverUrlHint}}}\nserver_url: '{{{apmServerUrl}}}'\n\n# {{{serviceEnvironmentHint}}}\nenvironment: '<your-environment>'`,O=e=>({...e&&{secretToken:"secret_token"},...!e&&{apiKey:"api_key"},apmServerUrl:"server_url"}),R=`# config/elastic_apm.yml:\n\n# {{serviceNameHint}} ${u.i18n.translate("xpack.apm.onboarding.rackClient.createConfig.commands.defaultsToTheNameOfRackAppClassComment",{defaultMessage:"Defaults to the name of your Rack app's class."})}\nservice_name: '<your-service-name>'\n\n{{^secretToken}}\n# {{apiKeyHint}}\napi_key: '{{{apiKey}}}'\n{{/secretToken}}\n{{#secretToken}}\n# {{secretTokenHint}}\nsecret_token: '{{{secretToken}}}'\n{{/secretToken}}\n\n# {{{serverUrlHint}}}\nserver_url: '{{{apmServerUrl}}}'\n\n# {{{serviceEnvironmentHint}}}\nenvironment: '<your-environment>'`,N=e=>({...e&&{secretToken:"ELASTIC_APM_SECRET_TOKEN"},...!e&&{apiKey:"ELASTIC_APM_API_KEY"},apmServerUrl:"ELASTIC_APM_SERVER_URL"}),D=`# ${u.i18n.translate("xpack.apm.onboarding.goClient.configure.commands.initializeUsingEnvironmentVariablesComment",{defaultMessage:"Initialize using environment variables:"})}\n\n# {{serviceNameHint}} ${u.i18n.translate("xpack.apm.onboarding.goClient.configure.commands.usedExecutableNameComment",{defaultMessage:"If not specified, the executable name will be used."})}\nexport ELASTIC_APM_SERVICE_NAME=<your-service-name>\n\n{{^secretToken}}\n# {{apiKeyHint}}\nexport ELASTIC_APM_API_KEY={{{apiKey}}}\n{{/secretToken}}\n{{#secretToken}}\n# {{secretTokenHint}}\nexport ELASTIC_APM_SECRET_TOKEN={{{secretToken}}}\n{{/secretToken}}\n\n# {{{serverUrlHint}}}\nexport ELASTIC_APM_SERVER_URL={{{apmServerUrl}}}\n\n# {{{serviceEnvironmentHint}}}\nexport ELASTIC_APM_ENVIRONMENT=<your-environment>\n`,H=e=>({...e&&{secretToken:"SecretToken"},...!e&&{apiKey:"ApiKey"},apmServerUrl:"ServerUrl"}),B=`{\n  "ElasticApm": {\n    /// {{serviceNameHint}} ${u.i18n.translate("xpack.apm.onboarding.dotnetClient.createConfig.commands.defaultServiceName",{defaultMessage:"Default is the entry assembly of the application."})}\n    "ServiceName": "<your-service-name>",\n    {{^secretToken}}\n    /// {{apiKeyHint}}\n    "ApiKey": "{{{apiKey}}}",\n    {{/secretToken}}\n    {{#secretToken}}\n    /// {{secretTokenHint}}\n    "SecretToken": "{{{secretToken}}}",\n    {{/secretToken}}\n    /// {{{serverUrlHint}}}\n    "ServerUrl": "{{{apmServerUrl}}}",\n    /// {{{serviceEnvironmentHint}}}\n    "Environment": "<your-environment>",\n  }\n}`,$=e=>({...e&&{secretToken:"elastic_apm.secret_token"},...!e&&{apiKey:"elastic_apm.api_key"},apmServerUrl:"elastic_apm.server_url"}),X={java:"java -javaagent:/path/to/elastic-apm-agent-<version>.jar \\\n-Delastic.apm.service_name=<your-service-name> \\\n{{^secretToken}}\n-Delastic.apm.api_key={{{apiKey}}} \\\n{{/secretToken}}\n{{#secretToken}}\n-Delastic.apm.secret_token={{{secretToken}}} \\\n{{/secretToken}}\n-Delastic.apm.server_url={{{apmServerUrl}}} \\\n-Delastic.apm.environment=<your-environment> \\\n-Delastic.apm.application_packages=org.example \\\n-jar my-service-name.jar",node:L,django:_,flask:I,rails:F,rack:R,go:D,dotnet:B,php:'# {{serviceNameHint}}\nelastic_apm.service_name="<your-service-name>"\n\n{{^secretToken}}\n# {{apiKeyHint}}\nelastic_apm.api_key="{{{apiKey}}}"\n{{/secretToken}}\n{{#secretToken}}\n# {{secretTokenHint}}\nelastic_apm.secret_token="{{{secretToken}}}"\n{{/secretToken}}\n\n# {{serverUrlHint}}\nelastic_apm.server_url="{{{apmServerUrl}}}"\n\n# {{{serviceEnvironmentHint}}}\nelastic_apm.environment="<your-environment>"'},V={java:"java",node:"js",django:"py",flask:"py",rails:"rb",rack:"rb",go:"go",dotnet:"dotnet",php:"php"};var z=t(30770);function G({columnKey:e,value:a,createApiKey:t,createApiKeyLoading:n}){return"apiKey"===e&&null===a?(0,d.jsx)(s.EuiButton,{"data-test-subj":"createApiKeyAndId",fill:!0,onClick:t,isLoading:n},u.i18n.translate("xpack.apm.tutorial.apiKey.create",{defaultMessage:"Create API Key"})):(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiText,{size:"s",color:"accent"},a),a&&(0,d.jsx)(s.EuiButtonIcon,{"data-test-subj":"apmConfigurationValueColumnButton","aria-label":u.i18n.translate("xpack.apm.onboarding.column.value.copyIconText",{defaultMessage:"Copy to clipboard"}),color:"text",iconType:"copy",onClick:()=>(0,s.copyToClipboard)(a)}))}function q({variables:e,data:a,createApiKey:t,createApiKeyLoading:n}){if(!e)return null;const i={apmServiceName:"my-service-name",apmEnvironment:"my-environment"},r=[{field:"setting",name:u.i18n.translate("xpack.apm.onboarding.agent.column.configSettings",{defaultMessage:"Configuration setting"})},{field:"value",name:u.i18n.translate("xpack.apm.onboarding.agent.column.configValue",{defaultMessage:"Configuration value"}),render:(e,{value:a,key:i})=>(0,d.jsx)(G,{columnKey:i,value:a,createApiKey:t,createApiKeyLoading:n})}],o=Object.entries(e).map((([e,t])=>({setting:t,value:(0,z.get)({...a,...i},e),key:e})));return(0,d.jsx)(s.EuiBasicTable,{items:o,columns:r})}function W({variantId:e,apmServerUrl:a,secretToken:t,apiKey:n,createApiKey:r,createApiKeyLoading:o}){const l=function({variantId:e,apmServerUrl:a,secretToken:t,apiKey:n}){const i=X[e];return i?E.A.render(i,{apmServerUrl:a,secretToken:t,apiKey:n,serviceNameHint:A,serviceEnvironmentHint:j,serverUrlHint:M,secretTokenHint:S,apiKeyHint:b}):""}({variantId:e,apmServerUrl:a,secretToken:t,apiKey:n}),c=function(e,a){return(e=>({java:T(e),node:C(e),django:P(e),flask:w(e),rails:U(e),rack:O(e),go:N(e),dotnet:H(e),php:$(e)}))(a)[e]}(e,t),p=function(e,a){return(e=>({java:K(e),node:{start:1,highlight:"2, 4, 7, 10, 13-14"},django:{start:1,highlight:"1, 3, 5, 7, 9, 12, 15, 18-19, 21, 23, 25"},flask:{start:1,highlight:"2-4, 7-8, 10, 12, 15, 18-21"},rails:{start:1,highlight:"4, 7, 10, 13"},rack:{start:1,highlight:"4, 7, 10, 13"},go:{start:1,highlight:"4, 7, 10, 13"},dotnet:{start:1,highlight:"1-2, 4, 6, 8, 10-12"},php:{start:1,highlight:"2, 5, 8, 11"}}))(a)[e]}(e,n),g=function(e){return V[e]}(e);return(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(q,{variables:c,data:{apmServerUrl:a,secretToken:t,apiKey:n},createApiKey:r,createApiKeyLoading:o}),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiCodeBlock,{isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.agentConfigInstructions.euiCodeBlock.copyAriaLabel",{defaultMessage:"Copy {variantId} agent configuration code",values:{variantId:e}}),language:g||"bash","data-test-subj":"commands",lineNumbers:p,whiteSpace:"pre"},l))}function Y({isSuccess:e,isError:a,errorMessage:t}){return e?(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiCallOut,{title:u.i18n.translate("xpack.apm.onboarding.apiKey.success.calloutTitle",{defaultMessage:"API key created"}),color:"success",iconType:"check","data-test-subj":"apiKeySuccessCallout"},u.i18n.translate("xpack.apm.onboarding.apiKey.success.calloutMessage",{defaultMessage:"Remember to store this information in a safe place. It won't be displayed anymore after you continue"}))):a&&/missing the following requested privilege\(s\)/.test(t||"")?(0,d.jsx)(s.EuiCallOut,{title:u.i18n.translate("xpack.apm.onboarding.apiKey.warning.calloutTitle",{defaultMessage:"User does not have permissions to create API Key"}),color:"warning",iconType:"warning","data-test-subj":"apiKeyWarningCallout"},u.i18n.translate("xpack.apm.onboarding.apiKey.warning.calloutMessage",{defaultMessage:"User is missing the following privilege - {missingPrivilege}. Please add the missing APM application privilege to the role of the authenticated user",values:{missingPrivilege:"event:write"}})):(0,d.jsx)(s.EuiCallOut,{title:u.i18n.translate("xpack.apm.onboarding.apiKey.error.calloutTitle",{defaultMessage:"Failed to create API key"}),color:"danger",iconType:"error","data-test-subj":"apiKeyErrorCallout"},u.i18n.translate("xpack.apm.onboarding.apiKey.error.calloutMessage",{defaultMessage:"Error: {errorMessage}",values:{errorMessage:t}}))}function J(){return(0,d.jsx)(s.EuiCallOut,{color:"warning","data-test-subj":"agentStatusWarningCallout"},u.i18n.translate("xpack.apm.onboarding.agentStatus.warning.calloutMessage",{defaultMessage:"No data has been received from agents yet"}))}function Z(){return(0,d.jsx)(s.EuiCallOut,{color:"success","data-test-subj":"agentStatusSuccessCallout"},u.i18n.translate("xpack.apm.onboarding.agentStatus.success.calloutMessage",{defaultMessage:"Data successfully received from one or more agents"}))}function Q({checkAgentStatus:e,agentStatus:a,agentStatusLoading:t}){let n="incomplete",r=(0,d.jsx)(i().Fragment,null);return!1===a&&(n="warning",r=(0,d.jsx)(J,null)),a&&(n="complete",r=(0,d.jsx)(Z,null)),{title:u.i18n.translate("xpack.apm.onboarding.agentStatusCheck.title",{defaultMessage:"Explore your data"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.agentStatusCheck.textPre",{defaultMessage:"Make sure your application is running and data is flowing into Elastic Observability."})),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiButton,{"data-test-subj":"checkAgentStatus",onClick:e,isLoading:t},u.i18n.translate("xpack.apm.onboarding.agentStatus.check",{defaultMessage:"Check status"})),(0,d.jsx)(s.EuiSpacer,null),r),status:n}}const ee=e=>{const{baseUrl:a,apmServerUrl:t,apiKeyDetails:n,checkAgentStatus:r,agentStatus:o,agentStatusLoading:l}=e;return[{title:u.i18n.translate("xpack.apm.onboarding.java.download.title",{defaultMessage:"Download the APM agent"}),children:(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.java.download.textPre",{defaultMessage:"Download the agent jar from [Maven Central]({mavenCentralLink}).       Do **not** add the agent as a dependency to your application.",values:{mavenCentralLink:"https://oss.sonatype.org/service/local/artifact/maven/redirect?r=releases&g=co.elastic.apm&a=elastic-apm-agent&v=LATEST"}}))},{title:u.i18n.translate("xpack.apm.onboarding.java.startApplication.title",{defaultMessage:"Start your application with the javaagent flag"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.java.startApplication.textPre",{defaultMessage:"Add the `-javaagent` flag and configure the agent with system properties.\n\n * Set the required service name (allowed characters: a-z, A-Z, 0-9, -, _, and space)\n * Set the custom APM Server URL (default: {customApmServerUrl})\n * Set the APM Server secret token\n * Set the service environment\n * Set the base package of your application",values:{customApmServerUrl:"http://localhost:8200"}})),(0,d.jsx)(s.EuiSpacer,null),((null==n?void 0:n.displayApiKeySuccessCallout)||(null==n?void 0:n.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(Y,{isError:null==n?void 0:n.displayApiKeyErrorCallout,isSuccess:null==n?void 0:n.displayApiKeySuccessCallout,errorMessage:null==n?void 0:n.errorMessage}),(0,d.jsx)(s.EuiSpacer,null)),(0,d.jsx)(W,{variantId:y.X.JAVA,apmServerUrl:t,apiKey:null==n?void 0:n.apiKey,createApiKey:null==n?void 0:n.createAgentKey,createApiKeyLoading:null==n?void 0:n.createApiKeyLoading}),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.java.startApplication.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for configuration options and advanced         usage.",values:{documentationLink:`${a}guide/en/apm/agent/java/current/index.html`}})))},Q({checkAgentStatus:r,agentStatus:o,agentStatusLoading:l})]},ae=e=>{const{baseUrl:a,apmServerUrl:t,apiKeyDetails:n,checkAgentStatus:r,agentStatus:o,agentStatusLoading:l}=e;return[{title:u.i18n.translate("xpack.apm.onboarding.node.install.title",{defaultMessage:"Install the APM agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.node.install.textPre",{defaultMessage:"Install the APM agent for Node.js as a dependency to your application."})),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.node.install.copyAriaLabel",{defaultMessage:"Copy the code to install the APM agent for Node.js"})},"npm install elastic-apm-node --save"))},{title:u.i18n.translate("xpack.apm.onboarding.node.configure.title",{defaultMessage:"Configure the agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.node.configure.textPre",{defaultMessage:"Agents are libraries that run inside of your application process.  APM services are created programmatically based on the `serviceName`.  This agent supports a variety of frameworks but can also be used with your custom stack."})),(0,d.jsx)(s.EuiSpacer,null),((null==n?void 0:n.displayApiKeySuccessCallout)||(null==n?void 0:n.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(Y,{isError:null==n?void 0:n.displayApiKeyErrorCallout,isSuccess:null==n?void 0:n.displayApiKeySuccessCallout,errorMessage:null==n?void 0:n.errorMessage}),(0,d.jsx)(s.EuiSpacer,null)),(0,d.jsx)(W,{variantId:y.X.NODE,apmServerUrl:t,apiKey:null==n?void 0:n.apiKey,createApiKey:null==n?void 0:n.createAgentKey,createApiKeyLoading:null==n?void 0:n.createApiKeyLoading}),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.node.configure.textPost",{defaultMessage:"See [the documentation]({documentationLink}) for advanced usage, including how to use with [Babel/ES Modules]({babelEsModulesLink}).",values:{documentationLink:`${a}guide/en/apm/agent/nodejs/current/index.html`,babelEsModulesLink:`${a}guide/en/apm/agent/nodejs/current/advanced-setup.html#es-modules`}})))},Q({checkAgentStatus:r,agentStatus:o,agentStatusLoading:l})]},te=e=>{const{baseUrl:a,apmServerUrl:t,apiKeyDetails:n,checkAgentStatus:r,agentStatus:o,agentStatusLoading:l}=e;return[{title:u.i18n.translate("xpack.apm.onboarding.django.install.title",{defaultMessage:"Install the APM agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.django.install.textPre",{defaultMessage:"Install the APM agent for Python as a dependency."})),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.django.install.copyAriaLabel",{defaultMessage:"Copy the code to install the APM agent for Django"})},"$ pip install elastic-apm"))},{title:u.i18n.translate("xpack.apm.onboarding.django.configure.title",{defaultMessage:"Configure the agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.django.configure.textPre",{defaultMessage:"Agents are libraries that run inside of your application process. APM services are created programmatically based on the `SERVICE_NAME`."})),(0,d.jsx)(s.EuiSpacer,null),((null==n?void 0:n.displayApiKeySuccessCallout)||(null==n?void 0:n.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(Y,{isError:null==n?void 0:n.displayApiKeyErrorCallout,isSuccess:null==n?void 0:n.displayApiKeySuccessCallout,errorMessage:null==n?void 0:n.errorMessage}),(0,d.jsx)(s.EuiSpacer,null)),(0,d.jsx)(W,{variantId:y.X.DJANGO,apmServerUrl:t,apiKey:null==n?void 0:n.apiKey,createApiKey:null==n?void 0:n.createAgentKey,createApiKeyLoading:null==n?void 0:n.createApiKeyLoading}),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.django.configure.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for advanced usage.",values:{documentationLink:`${a}guide/en/apm/agent/python/current/django-support.html`}})))},Q({checkAgentStatus:r,agentStatus:o,agentStatusLoading:l})]},ne=e=>{const{baseUrl:a,apmServerUrl:t,apiKeyDetails:n,checkAgentStatus:r,agentStatus:o,agentStatusLoading:l}=e;return[{title:u.i18n.translate("xpack.apm.onboarding.flask.install.title",{defaultMessage:"Install the APM agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.flask.install.textPre",{defaultMessage:"Install the APM agent for Python as a dependency."})),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.flask.install.copyAriaLabel",{defaultMessage:"Copy the code to install the APM agent for Flask"})},"$ pip install elastic-apm[flask]"))},{title:u.i18n.translate("xpack.apm.onboarding.flask.configure.title",{defaultMessage:"Configure the agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.flask.configure.textPre",{defaultMessage:"Agents are libraries that run inside of your application process. APM services are created programmatically based on the `SERVICE_NAME`."})),(0,d.jsx)(s.EuiSpacer,null),((null==n?void 0:n.displayApiKeySuccessCallout)||(null==n?void 0:n.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(Y,{isError:null==n?void 0:n.displayApiKeyErrorCallout,isSuccess:null==n?void 0:n.displayApiKeySuccessCallout,errorMessage:null==n?void 0:n.errorMessage}),(0,d.jsx)(s.EuiSpacer,null)),(0,d.jsx)(W,{variantId:y.X.FLASK,apmServerUrl:t,apiKey:null==n?void 0:n.apiKey,createApiKey:null==n?void 0:n.createAgentKey,createApiKeyLoading:null==n?void 0:n.createApiKeyLoading}),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.flask.configure.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for advanced usage.",values:{documentationLink:`${a}guide/en/apm/agent/python/current/flask-support.html`}})))},Q({checkAgentStatus:r,agentStatus:o,agentStatusLoading:l})]},ie=e=>{const{baseUrl:a,apmServerUrl:t,apiKeyDetails:n,checkAgentStatus:r,agentStatus:o,agentStatusLoading:l}=e;return[{title:u.i18n.translate("xpack.apm.onboarding.rails.install.title",{defaultMessage:"Install the APM agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.rails.install.textPre",{defaultMessage:"Add the agent to your Gemfile."})),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.rails.install.copyAriaLabel",{defaultMessage:"Copy the code to install the APM agent for Ruby on Rails"})},"gem 'elastic-apm'"))},{title:u.i18n.translate("xpack.apm.onboarding.rails.configure.title",{defaultMessage:"Configure the agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.rails.configure.textPre",{defaultMessage:"APM is automatically started when your app boots. Configure the agent, by creating the config file {configFile}",values:{configFile:"`config/elastic_apm.yml`"}})),(0,d.jsx)(s.EuiSpacer,null),((null==n?void 0:n.displayApiKeySuccessCallout)||(null==n?void 0:n.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(Y,{isError:null==n?void 0:n.displayApiKeyErrorCallout,isSuccess:null==n?void 0:n.displayApiKeySuccessCallout,errorMessage:null==n?void 0:n.errorMessage}),(0,d.jsx)(s.EuiSpacer,null)),(0,d.jsx)(W,{variantId:y.X.RAILS,apmServerUrl:t,apiKey:null==n?void 0:n.apiKey,createApiKey:null==n?void 0:n.createAgentKey,createApiKeyLoading:null==n?void 0:n.createApiKeyLoading}),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.rails.configure.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for configuration options and advanced usage.\n\n",values:{documentationLink:`${a}guide/en/apm/agent/ruby/current/index.html`}})))},Q({checkAgentStatus:r,agentStatus:o,agentStatusLoading:l})]},re=e=>{const{baseUrl:a,apmServerUrl:t,apiKeyDetails:n,checkAgentStatus:r,agentStatus:o,agentStatusLoading:l}=e,c=`# config.ru\n  require 'sinatra/base'\n\n  class MySinatraApp < Sinatra::Base\n    use ElasticAPM::Middleware\n\n    # ...\n  end\n\n  ElasticAPM.start(\n    app: MySinatraApp, # ${u.i18n.translate("xpack.apm.onboarding.rack.configure.commands.requiredComment",{defaultMessage:"required"})}\n    config_file: '' # ${u.i18n.translate("xpack.apm.onboarding.rack.configure.commands.optionalComment",{defaultMessage:"optional, defaults to config/elastic_apm.yml"})}\n  )\n\n  run MySinatraApp\n\n  at_exit { ElasticAPM.stop }`;return[{title:u.i18n.translate("xpack.apm.onboarding.rack.install.title",{defaultMessage:"Install the APM agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.rack.install.textPre",{defaultMessage:"Add the agent to your Gemfile."})),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.rack.install.copyAriaLabel",{defaultMessage:"Copy the code to install the APM agent for Rack"})},"gem 'elastic-apm'"))},{title:u.i18n.translate("xpack.apm.onboarding.rack.configure.title",{defaultMessage:"Configure the agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.rack.configure.textPre",{defaultMessage:"For Rack or a compatible framework (e.g. Sinatra), include the middleware in your app and start the agent."})),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.rack.configure.copyAriaLabel",{defaultMessage:"Copy the code to configure the APM agent for Rack"})},c))},{title:u.i18n.translate("xpack.apm.onboarding.rack.createConfig.title",{defaultMessage:"Create config file"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.rack.createConfig.textPre",{defaultMessage:"Create a config file {configFile}:",values:{configFile:"`config/elastic_apm.yml`"}})),(0,d.jsx)(s.EuiSpacer,null),((null==n?void 0:n.displayApiKeySuccessCallout)||(null==n?void 0:n.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(Y,{isError:null==n?void 0:n.displayApiKeyErrorCallout,isSuccess:null==n?void 0:n.displayApiKeySuccessCallout,errorMessage:null==n?void 0:n.errorMessage}),(0,d.jsx)(s.EuiSpacer,null)),(0,d.jsx)(W,{variantId:y.X.RACK,apmServerUrl:t,apiKey:null==n?void 0:n.apiKey,createApiKey:null==n?void 0:n.createAgentKey,createApiKeyLoading:null==n?void 0:n.createApiKeyLoading}),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.rack.configure.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for configuration options and advanced usage.\n\n",values:{documentationLink:`${a}guide/en/apm/agent/ruby/current/index.html`}})))},Q({checkAgentStatus:r,agentStatus:o,agentStatusLoading:l})]},se=e=>{const{baseUrl:a,apmServerUrl:t,apiKeyDetails:n,checkAgentStatus:r,agentStatus:o,agentStatusLoading:l}=e;return[{title:u.i18n.translate("xpack.apm.onboarding.go.install.title",{defaultMessage:"Install the APM agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.go.install.textPre",{defaultMessage:"Install the APM agent packages for Go."})),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.go.install.copyAriaLabel",{defaultMessage:"Copy the code to install the APM agent for Go"})},"go get go.elastic.co/apm"))},{title:u.i18n.translate("xpack.apm.onboarding.go.configure.title",{defaultMessage:"Configure the agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.go.configure.textPre",{defaultMessage:"Agents are libraries that run inside of your application process. APM services are created programmatically based on the executable file name, or the `ELASTIC_APM_SERVICE_NAME` environment variable."})),(0,d.jsx)(s.EuiSpacer,null),((null==n?void 0:n.displayApiKeySuccessCallout)||(null==n?void 0:n.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(Y,{isError:null==n?void 0:n.displayApiKeyErrorCallout,isSuccess:null==n?void 0:n.displayApiKeySuccessCallout,errorMessage:null==n?void 0:n.errorMessage}),(0,d.jsx)(s.EuiSpacer,null)),(0,d.jsx)(W,{variantId:y.X.GO,apmServerUrl:t,apiKey:null==n?void 0:n.apiKey,createApiKey:null==n?void 0:n.createAgentKey,createApiKeyLoading:null==n?void 0:n.createApiKeyLoading}),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.go.configure.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for advanced configuration.",values:{documentationLink:`${a}guide/en/apm/agent/go/current/configuration.html`}})))},{title:u.i18n.translate("xpack.apm.onboarding.go.goClient.title",{defaultMessage:"Instrument your application"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.go.instrument.textPre",{defaultMessage:"Instrument your Go application by using one of the provided instrumentation modules or by using the tracer API directly."})),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiCodeBlock,{language:"go",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.go.instrument.copyAriaLabel",{defaultMessage:"Copy the code to instrument your Go application"})},'import (\n  "net/http"\n\n  "go.elastic.co/apm/module/apmhttp"\n)\n\nfunc main() {\n  mux := http.NewServeMux()\n  ...\n  http.ListenAndServe(":8080", apmhttp.Wrap(mux))\n}\n'),(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.go.instrument.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for a detailed guide to instrumenting Go source code.",values:{documentationLink:`${a}guide/en/apm/agent/go/current/instrumenting-source.html`}})))},Q({checkAgentStatus:r,agentStatus:o,agentStatusLoading:l})]},oe=e=>{const{baseUrl:a,apmServerUrl:t,apiKeyDetails:n,checkAgentStatus:r,agentStatus:o,agentStatusLoading:l}=e;return[{title:u.i18n.translate("xpack.apm.onboarding.dotNet.download.title",{defaultMessage:"Download the APM agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.dotNet.download.textPre",{defaultMessage:"Add the the agent package(s) from [NuGet]({allNuGetPackagesLink}) to your .NET application. There are multiple       NuGet packages available for different use cases. \n\nFor an ASP.NET Core application with Entity Framework       Core download the [Elastic.Apm.NetCoreAll]({netCoreAllApmPackageLink}) package. This package will automatically add every       agent component to your application. \n\n In case you would like to minimize the dependencies, you can use the       [Elastic.Apm.AspNetCore]({aspNetCorePackageLink}) package for just       ASP.NET Core monitoring or the [Elastic.Apm.EfCore]({efCorePackageLink}) package for just Entity Framework Core monitoring. \n\n In       case you only want to use the public Agent API for manual instrumentation use the [Elastic.Apm]({elasticApmPackageLink}) package.",values:{allNuGetPackagesLink:"https://www.nuget.org/packages?q=Elastic.apm",netCoreAllApmPackageLink:"https://www.nuget.org/packages/Elastic.Apm.NetCoreAll",aspNetCorePackageLink:"https://www.nuget.org/packages/Elastic.Apm.AspNetCore",efCorePackageLink:"https://www.nuget.org/packages/Elastic.Apm.EntityFrameworkCore",elasticApmPackageLink:"https://www.nuget.org/packages/Elastic.Apm"}})))},{title:u.i18n.translate("xpack.apm.onboarding.dotNet.configureApplication.title",{defaultMessage:"Add the agent to the application"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.dotNet.configureApplication.textPre",{defaultMessage:"In case of ASP.NET Core with the `Elastic.Apm.NetCoreAll` package, call the `AddAllElasticApm`       extension method on the `IServiceCollection` within the `Program.cs` file."})),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.dotNet.configureApplication.copyAriaLabel",{defaultMessage:"Copy the code to add the APM agent to the dotnet application"})},"var builder = WebApplication.CreateBuilder(args);\n\nbuilder.Services.AddAllElasticApm();\n\nvar app = builder.Build();\n\n// Configure the HTTP request pipeline.\n\napp.Run();"),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.dotNet.configureApplication.textPost",{defaultMessage:"The agent will implicitly read config settings through the application’s       `IConfiguration` instance (e.g. from the `appsettings.json` file)."})))},{title:u.i18n.translate("xpack.apm.onboarding.dotNet.configureAgent.title",{defaultMessage:"Sample appsettings.json file:"}),children:(0,d.jsx)(i().Fragment,null,((null==n?void 0:n.displayApiKeySuccessCallout)||(null==n?void 0:n.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(Y,{isError:null==n?void 0:n.displayApiKeyErrorCallout,isSuccess:null==n?void 0:n.displayApiKeySuccessCallout,errorMessage:null==n?void 0:n.errorMessage}),(0,d.jsx)(s.EuiSpacer,null)),(0,d.jsx)(W,{variantId:y.X.DOTNET,apmServerUrl:t,apiKey:null==n?void 0:n.apiKey,createApiKey:null==n?void 0:n.createAgentKey,createApiKeyLoading:null==n?void 0:n.createApiKeyLoading}),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.dotNet.configureAgent.textPost",{defaultMessage:"You can also configure the agent through environment variables. \n       See [the documentation]({documentationLink}) for advanced usage, including the [Profiler Auto instrumentation]({profilerLink}) quick start.",values:{documentationLink:`${a}guide/en/apm/agent/dotnet/current/configuration.html`,profilerLink:`${a}guide/en/apm/agent/dotnet/current/setup-auto-instrumentation.html#setup-auto-instrumentation`}})))},Q({checkAgentStatus:r,agentStatus:o,agentStatusLoading:l})]},le=e=>{const{baseUrl:a,apmServerUrl:t,apiKeyDetails:n,checkAgentStatus:r,agentStatus:o,agentStatusLoading:l}=e;return[{title:u.i18n.translate("xpack.apm.onboarding.php.download.title",{defaultMessage:"Download the APM agent"}),children:(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.php.download.textPre",{defaultMessage:"Download the package corresponding to your platform from [GitHub releases]({githubReleasesLink}).",values:{githubReleasesLink:"https://github.com/elastic/apm-agent-php/releases"}}))},{title:u.i18n.translate("xpack.apm.onboarding.php.installPackage.title",{defaultMessage:"Install the downloaded package"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.php.installPackage.textPre",{defaultMessage:"For example on Alpine Linux using APK package:"})),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.php.installPackage.copyAriaLabel",{defaultMessage:"Copy the code to install the APM agent for PHP"})},"apk add --allow-untrusted <package-file>.apk"),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.php.installPackage.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for installation commands on other supported platforms and advanced installation.",values:{documentationLink:`${a}guide/en/apm/agent/php/current/setup.html`}})))},{title:u.i18n.translate("xpack.apm.onboarding.php.configureAgent.title",{defaultMessage:"Configure the agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.php.Configure the agent.textPre",{defaultMessage:"APM is automatically started when your app boots. Configure the agent either via `php.ini` file:"})),((null==n?void 0:n.displayApiKeySuccessCallout)||(null==n?void 0:n.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(Y,{isError:null==n?void 0:n.displayApiKeyErrorCallout,isSuccess:null==n?void 0:n.displayApiKeySuccessCallout,errorMessage:null==n?void 0:n.errorMessage}),(0,d.jsx)(s.EuiSpacer,null)),(0,d.jsx)(W,{variantId:y.X.PHP,apmServerUrl:t,apiKey:null==n?void 0:n.apiKey,createApiKey:null==n?void 0:n.createAgentKey,createApiKeyLoading:null==n?void 0:n.createApiKeyLoading}),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.php.configureAgent.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for configuration options and advanced usage.\n\n",values:{documentationLink:`${a}guide/en/apm/agent/php/current/configuration.html`}})))},Q({checkAgentStatus:r,agentStatus:o,agentStatusLoading:l})]},ue=e=>{const{apmServerUrl:a,otlpManagedServiceUrl:t,apiKeyDetails:n,checkAgentStatus:i,agentStatus:r,agentStatusLoading:o}=e;return[{title:u.i18n.translate("xpack.apm.onboarding.otel.download.title",{defaultMessage:"Instrument your app with OpenTelemetry SDK"}),children:(0,d.jsx)(s.EuiText,null,(0,d.jsx)(c.FormattedMessage,{id:"xpack.apm.onboarding.otel.download.textPre",defaultMessage:"For guidance on downloading and getting started with the OpenTelemetry SDK or Elastic Distribution of OpenTelemetry (EDOT) SDK, either review the {openTelemetryDocLink} or see the {edotDocLink}.",values:{openTelemetryDocLink:(0,d.jsx)(s.EuiLink,{"data-test-subj":"apmCreateOpenTelemetryAgentInstructionsOpenTelemetryDocumentationLink",target:"_blank",href:"https://opentelemetry.io/docs/instrumentation"},u.i18n.translate("xpack.apm.createOpenTelemetryAgentInstructions.openTelemetryDocumentationLinkLabel",{defaultMessage:"OpenTelemetry documentation"})),edotDocLink:(0,d.jsx)(s.EuiLink,{"data-test-subj":"apmCreateOpenTelemetryAgentInstructionsEDOTDocsLink",target:"_blank",href:"http://ela.st/edot-sdks"},u.i18n.translate("xpack.apm.createOpenTelemetryAgentInstructions.EDOTDocumentationLinkLabel",{defaultMessage:"EDOT documentation"}))}}))},{title:u.i18n.translate("xpack.apm.onboarding.otel.configureAgent.title",{defaultMessage:"Configure the OpenTelemetry SDK"}),children:(0,d.jsx)(pe,{apmServerUrl:a,otlpManagedServiceUrl:t,apiKeyDetails:n})},Q({checkAgentStatus:i,agentStatus:r,agentStatusLoading:o})]};function ce({setting:e,value:a,createApiKey:t,createApiKeyLoading:n,apiKey:r}){return"OTEL_EXPORTER_OTLP_HEADERS"===e&&null===r?(0,d.jsx)(s.EuiButton,{"data-test-subj":"createApiKeyAndId",fill:!0,onClick:t,isLoading:n},u.i18n.translate("xpack.apm.onboarding.apiKey.create",{defaultMessage:"Create API Key"})):(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiText,{size:"s",color:"accent"},a),a&&(0,d.jsx)(s.EuiButtonIcon,{"data-test-subj":"apmConfigurationValueColumnButton","aria-label":u.i18n.translate("xpack.apm.onboarding.otel.column.value.copyIconText",{defaultMessage:"Copy to clipboard"}),color:"text",iconType:"copy",onClick:()=>(0,s.copyToClipboard)(a)}))}function pe({otlpManagedServiceUrl:e,apmServerUrl:a,apiKeyDetails:t}){const[r,o]=(0,n.useState)("apm");return(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiButtonGroup,{legend:"Default single select button group",options:[{id:"apm",label:"Classic APM Endpoint"},{id:"otlp",label:"Managed OTLP Endpoint",iconType:"beaker",iconSide:"right",toolTipContent:(0,d.jsx)(c.FormattedMessage,{id:"xpack.apm.onboarding.otel.managedOtlpEndpointTooltip",defaultMessage:"This functionality is in Tech Preview."}),toolTipProps:{position:"right"}}],idSelected:r,onChange:e=>o(e)}),(0,d.jsx)(s.EuiSpacer,null),"apm"===r?(0,d.jsx)(de,{apmServerUrl:a,apiKeyDetails:t}):(0,d.jsx)(ge,{otlpManagedServiceUrl:e,apiKeyDetails:t}))}function de({apmServerUrl:e,apiKeyDetails:a}){const t=[{setting:"OTEL_EXPORTER_OTLP_ENDPOINT",value:e||"<apm-managed-service-url>"},{setting:"OTEL_EXPORTER_OTLP_HEADERS",value:`Authorization=ApiKey ${null==a?void 0:a.apiKey}`,apiKey:null==a?void 0:a.apiKey},{setting:"OTEL_METRICS_EXPORTER",value:"otlp",notes:"Enable metrics when supported by your OpenTelemetry client."},{setting:"OTEL_LOGS_EXPORTER",value:"otlp",notes:"Enable logs when supported by your OpenTelemetry client"},{setting:"OTEL_RESOURCE_ATTRIBUTES",value:"service.name=<app-name>,service.version=<app-version>,deployment.environment=production"}],n=[{field:"setting",width:"23%",name:u.i18n.translate("xpack.apm.onboarding.config_classic_otel.column.configSettings",{defaultMessage:"Configuration setting"})},{field:"value",width:"55%",name:u.i18n.translate("xpack.apm.onboarding.config_classic_otel.column.configValue",{defaultMessage:"Configuration value"}),render:(e,{value:t,setting:n,apiKey:i})=>(0,d.jsx)(ce,{setting:n,value:t,createApiKey:null==a?void 0:a.createAgentKey,createApiKeyLoading:null==a?void 0:a.createApiKeyLoading,apiKey:null==a?void 0:a.apiKey})},{field:"notes",name:u.i18n.translate("xpack.apm.onboarding.config_classic_otel.column.notes",{defaultMessage:"Notes"})}];return(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.otel.configureSDK.classic.description",{defaultMessage:"The Classic APM Endpoint translates OpenTelemetry semantic conventions into ECS format prior to storage. Specify the following OpenTelemetry settings as part of the startup of your application."})),(0,d.jsx)(s.EuiSpacer,null),((null==a?void 0:a.displayApiKeySuccessCallout)||(null==a?void 0:a.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(Y,{isError:null==a?void 0:a.displayApiKeyErrorCallout,isSuccess:null==a?void 0:a.displayApiKeySuccessCallout,errorMessage:null==a?void 0:a.errorMessage}),(0,d.jsx)(s.EuiSpacer,null)),(0,d.jsx)(s.EuiBasicTable,{items:t,columns:n,"data-test-subj":"otel-instructions-table"}),(0,d.jsx)(s.EuiSpacer,{size:"m"}),(0,d.jsx)(me,null))}function ge({otlpManagedServiceUrl:e,apiKeyDetails:a}){const t=[{setting:"OTEL_EXPORTER_OTLP_ENDPOINT",value:e||"<otlp-managed-service-url>"},{setting:"OTEL_EXPORTER_OTLP_HEADERS",value:`Authorization=ApiKey ${null==a?void 0:a.apiKey}`,apiKey:null==a?void 0:a.apiKey},{setting:"OTEL_RESOURCE_ATTRIBUTES",value:"service.name=<app-name>,service.version=<app-version>,deployment.environment=production"}],n=[{field:"setting",width:"23%",name:u.i18n.translate("xpack.apm.onboarding.config_otel.column.configSettings",{defaultMessage:"Configuration setting"})},{field:"value",width:"55%",name:u.i18n.translate("xpack.apm.onboarding.config_otel.column.configValue",{defaultMessage:"Configuration value"}),render:(e,{value:t,setting:n,apiKey:i})=>(0,d.jsx)(ce,{setting:n,value:t,createApiKey:null==a?void 0:a.createAgentKey,createApiKeyLoading:null==a?void 0:a.createApiKeyLoading,apiKey:null==a?void 0:a.apiKey})}];return(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.otel.configureAgent.textPre",{defaultMessage:"The Managed OTLP Endpoint provides native support for handling of log, metric, and trace data from OpenTelemetry sources. It preserves OpenTelemetry semantic conventions and resource attributes, offering a native experience aligned with OpenTelemetry standards. Managed OTLP endpoint is currently in **Technical Preview.** Specify the following OpenTelemetry settings as part of the startup of your application."})),(0,d.jsx)(s.EuiSpacer,null),((null==a?void 0:a.displayApiKeySuccessCallout)||(null==a?void 0:a.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(Y,{isError:null==a?void 0:a.displayApiKeyErrorCallout,isSuccess:null==a?void 0:a.displayApiKeySuccessCallout,errorMessage:null==a?void 0:a.errorMessage}),(0,d.jsx)(s.EuiSpacer,null)),(0,d.jsx)(s.EuiBasicTable,{items:t,columns:n,"data-test-subj":"otel-instructions-table"}),(0,d.jsx)(s.EuiSpacer,{size:"m"}),(0,d.jsx)(me,null))}function me(){return(0,d.jsx)(s.EuiText,{size:"xs",color:"subdued"},(0,d.jsx)(c.FormattedMessage,{id:"xpack.apm.onboarding.config_otel.description1",defaultMessage:"OpenTelemetry agents and SDKs must support the {otelExporterOtlpEndpoint}, {otelExporterOtlpHeaders}, and {otelResourceAttributes} variables; some unstable components may not yet comply with this requirement.",values:{otelExporterOtlpEndpoint:(0,d.jsx)(s.EuiLink,{"data-test-subj":"apmOpenTelemetryInstructionsOtelExporterOtlpEndpointLink",target:"_blank",href:"https://ela.st/otel-spec-exporter-doc"},"OTEL_EXPORTER_OTLP_ENDPOINT"),otelExporterOtlpHeaders:(0,d.jsx)(s.EuiLink,{"data-test-subj":"apmOpenTelemetryInstructionsOtelExporterOtlpHeadersLink",target:"_blank",href:"https://ela.st/otel-spec-exporter-doc"},"OTEL_EXPORTER_OTLP_HEADERS"),otelResourceAttributes:(0,d.jsx)(s.EuiLink,{"data-test-subj":"apmOpenTelemetryInstructionsOtelResourceAttributesLink",target:"_blank",href:"https://ela.st/otel-spec-sdk"},"OTEL_RESOURCE_ATTRIBUTES")}}))}const ye=u.i18n.translate("xpack.apm.onboarding.defaultTitle",{defaultMessage:"APM Agents"});function ke(e){if(!e)return"";const a=e.split(".");return`${a[0]}.ingest.${a.slice(2).join(".")}:443`}function fe(){const e=(0,p.D)("/app/apm");return(0,d.jsx)(s.EuiPanel,{paddingSize:"l"},(0,d.jsx)(s.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},(0,d.jsx)(s.EuiFlexItem,{grow:!1},(0,d.jsx)(s.EuiText,null,(0,d.jsx)("p",null,(0,d.jsx)(c.FormattedMessage,{id:"xpack.apm.onboarding.footer.exploreYourDataDescription",defaultMessage:"When all steps are complete, you're ready to explore your data."})))),(0,d.jsx)(s.EuiFlexItem,{grow:!1},(0,d.jsx)(s.EuiButton,{"data-test-subj":"apmTutorialFooterButton",fill:!0,href:e},u.i18n.translate("xpack.apm.onboarding.footer.cta",{defaultMessage:"Launch APM"})))))}var ve=t(32336);function xe(){const[e,a]=(0,n.useState)([]),[t,i]=(0,n.useState)({apiKey:null,error:!1}),[u,c]=(0,n.useState)(!1),[p,m]=(0,n.useState)(),[k,f]=(0,n.useState)(!1),{services:v}=(0,r.useKibana)(),{config:x}=(0,l.W)(),{docLinks:E,observabilityShared:A}=v,S=(null==E?void 0:E.links.kibana.guide)||"https://www.elastic.co/guide/en/kibana/current/index.html",b=(null==E?void 0:E.ELASTIC_WEBSITE_URL)||"https://www.elastic.co/",M=async()=>{try{c(!0);const e=[ve.i_.EVENT],{agentKey:a}=await(0,o.L)("POST /api/apm/agent_keys 2023-10-31",{signal:null,params:{body:{name:`onboarding-${(Math.random()+1).toString(36).substring(7)}`,privileges:e}}});i({apiKey:a.encoded,id:a.id,error:!1})}catch(a){var e;i({apiKey:null,error:!0,errorMessage:(null===(e=a.body)||void 0===e?void 0:e.message)||a.message})}finally{c(!1)}},j=async()=>{try{f(!0);const e=await(0,o.L)("GET /internal/apm/observability_overview/has_data",{signal:null});m(e.hasData)}catch(e){m(!1)}finally{f(!1)}},T=e.length>0;(0,n.useEffect)((()=>{a(function({baseUrl:e,config:a,checkAgentStatus:t,agentStatus:n,agentStatusLoading:i},r,s,o){const{apiKey:l,error:u,errorMessage:c}=s,p=Boolean(l)&&!u,d=u&&Boolean(c),g={baseUrl:e,apmServerUrl:`${a.managedServiceUrl}:443`,otlpManagedServiceUrl:ke(a.managedServiceUrl),checkAgentStatus:t,agentStatus:n,agentStatusLoading:i,apiKeyDetails:{...s,displayApiKeySuccessCallout:p,displayApiKeyErrorCallout:d,createAgentKey:o,createApiKeyLoading:r}};return[{title:ye,id:y.X.NODE,instructions:ae(g)},{title:ye,id:y.X.DJANGO,instructions:te(g)},{title:ye,id:y.X.FLASK,instructions:ne(g)},{title:ye,id:y.X.RAILS,instructions:ie(g)},{title:ye,id:y.X.RACK,instructions:re(g)},{title:ye,id:y.X.GO,instructions:se(g)},{title:ye,id:y.X.JAVA,instructions:ee(g)},{title:ye,id:y.X.DOTNET,instructions:oe(g)},{title:ye,id:y.X.PHP,instructions:le(g)},{id:y.X.OPEN_TELEMETRY,instructions:ue(g)}]}({baseUrl:b,config:x,checkAgentStatus:j,agentStatus:p,agentStatusLoading:k},u,t,M))}),[t,b,x,u,p,k]);const K=A.navigation.PageTemplate;return(0,d.jsx)(K,null,(0,d.jsx)(g,{isBeta:!1,guideLink:S}),(0,d.jsx)(s.EuiSpacer,null),T&&(0,d.jsx)(h,{instructions:e}),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(fe,null))}}}]);