"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FailedTransactionsCorrelationsHelpPopover = FailedTransactionsCorrelationsHelpPopover;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _help_popover = require("../help_popover/help_popover");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FailedTransactionsCorrelationsHelpPopover() {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_help_popover.HelpPopover, {
    anchorPosition: "leftUp",
    button: /*#__PURE__*/_react.default.createElement(_help_popover.HelpPopoverButton, {
      buttonTextEnabled: true,
      onClick: () => {
        setIsPopoverOpen(prevIsPopoverOpen => !prevIsPopoverOpen);
      }
    }),
    closePopover: () => setIsPopoverOpen(false),
    isOpen: isPopoverOpen,
    title: _i18n.i18n.translate('xpack.apm.correlations.failedTransactions.helpPopover.title', {
      defaultMessage: 'Failed transaction correlations'
    })
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.correlations.failedTransactions.helpPopover.basicExplanation",
    defaultMessage: "Correlations help you discover which attributes are most influential in distinguishing between transaction failures and successes. Transactions are considered a failure when their {field} value is {value}.",
    values: {
      field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "event.outcome"),
      value: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "failure")
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.correlations.failedTransactions.helpPopover.tableExplanation",
    defaultMessage: "The table is sorted by scores, which are mapped to high, medium, or low impact levels. Attributes with high impact levels are more likely to contribute to failed transactions."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.correlations.failedTransactions.helpPopover.performanceExplanation",
    defaultMessage: "This analysis performs statistical searches across a large number of attributes. For large time ranges and services with high transaction throughput, this might take some time. Reduce the time range to improve performance."
  })));
}