"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiDraggableStyles = exports.euiDraggableItemStyles = void 0;
var _react = require("@emotion/react");
var _droppable = require("./droppable.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1nohugb-isRemovable",
  styles: "transition-duration:0.001s!important;label:isRemovable;"
} : {
  name: "1nohugb-isRemovable",
  styles: "transition-duration:0.001s!important;label:isRemovable;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "1wvdf2m-hasClone",
  styles: "transform:none!important;label:hasClone;"
} : {
  name: "1wvdf2m-hasClone",
  styles: "transform:none!important;label:hasClone;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "oyhf1i-euiDraggable",
  styles: "&:focus{outline:none;&>.euiDraggable__item{outline:auto;}};label:euiDraggable;"
} : {
  name: "oyhf1i-euiDraggable",
  styles: "&:focus{outline:none;&>.euiDraggable__item{outline:auto;}};label:euiDraggable;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiDraggableStyles = exports.euiDraggableStyles = function euiDraggableStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiDraggable: _ref3,
    isDragging: /*#__PURE__*/(0, _react.css)("z-index:", euiTheme.levels.toast, "!important;;label:isDragging;"),
    hasClone: _ref2,
    isRemovable: _ref,
    spacing: (0, _droppable.sharedSpacingPadding)(euiThemeContext)
  };
};
var euiDraggableItemStyles = exports.euiDraggableItemStyles = {
  euiDraggable__item: /*#__PURE__*/(0, _react.css)(";label:euiDraggable__item;"),
  disabled: process.env.NODE_ENV === "production" ? {
    name: "b86pnw-disabled",
    styles: "cursor:not-allowed;label:disabled;"
  } : {
    name: "b86pnw-disabled",
    styles: "cursor:not-allowed;label:disabled;",
    toString: _EMOTION_STRINGIFIED_CSS_ERROR__
  }
};