"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeTypeSection = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _time_utils = require("../../../lib/time_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const BoldText = ({
  children
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const boldText = (0, _react2.css)`
    font-weight: ${euiTheme.font.weight.bold};
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: boldText,
    component: "span",
    size: "s"
  }, children);
};
const AbsoluteTimeText = ({
  date
}) => {
  const absoluteDate = (0, _time_utils.convertRelativeTimeStringToAbsoluteTimeDate)(date);
  return /*#__PURE__*/_react.default.createElement(BoldText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
    value: absoluteDate,
    year: "numeric",
    month: "long",
    day: "2-digit",
    hour: "numeric",
    minute: "numeric",
    hour12: true
  }));
};
const RelativeTimeText = ({
  value,
  unit,
  roundingUnit
}) => /*#__PURE__*/_react.default.createElement(BoldText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelativeTime, {
  value: value
  // @ts-expect-error - RelativeTimeFormatSingularUnit expected here is not exported so a cast from string is not possible
  ,
  unit: unit
}), roundingUnit && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "share.link.timeRange.relativeTimeInfoText.roundingUnit",
  defaultMessage: " rounded to the {roundingUnit}",
  values: {
    roundingUnit
  }
}));
const getRelativeTimeText = timeRange => {
  // FormattedRelativeTime doesn't support "now" as a value, it will render "0 seconds" instead
  const from = (0, _time_utils.getRelativeTimeValueAndUnitFromTimeString)(timeRange.from);
  const to = (0, _time_utils.getRelativeTimeValueAndUnitFromTimeString)(timeRange.to);
  if (!(from !== null && from !== void 0 && from.value)) {
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "relativeTimeInfoTextFromNow"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "share.link.timeRange.relativeTimeInfoText.fromNow",
      defaultMessage: "The users will see all data from <bold>now</bold> to {to}, based on when they view it.",
      values: {
        to: /*#__PURE__*/_react.default.createElement(RelativeTimeText, {
          value: to === null || to === void 0 ? void 0 : to.value,
          unit: to === null || to === void 0 ? void 0 : to.unit,
          roundingUnit: to === null || to === void 0 ? void 0 : to.roundingUnit
        }),
        bold: chunks => /*#__PURE__*/_react.default.createElement(BoldText, null, chunks)
      }
    }));
  }
  if (!(to !== null && to !== void 0 && to.value)) {
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "relativeTimeInfoTextToNow"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "share.link.timeRange.relativeTimeInfoText",
      defaultMessage: "The users will see all data from {from} to <bold>now</bold>, based on when they view it.",
      values: {
        from: /*#__PURE__*/_react.default.createElement(RelativeTimeText, {
          value: from === null || from === void 0 ? void 0 : from.value,
          unit: from === null || from === void 0 ? void 0 : from.unit,
          roundingUnit: from === null || from === void 0 ? void 0 : from.roundingUnit
        }),
        bold: chunks => /*#__PURE__*/_react.default.createElement(BoldText, null, chunks)
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "relativeTimeInfoTextDefault"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "share.link.timeRange.relativeTimeInfoText.default",
    defaultMessage: "The users will see all data from {from} to {to}, based on when they view it.",
    values: {
      from: /*#__PURE__*/_react.default.createElement(RelativeTimeText, {
        value: from === null || from === void 0 ? void 0 : from.value,
        unit: from === null || from === void 0 ? void 0 : from.unit,
        roundingUnit: from === null || from === void 0 ? void 0 : from.roundingUnit
      }),
      to: /*#__PURE__*/_react.default.createElement(RelativeTimeText, {
        value: to === null || to === void 0 ? void 0 : to.value,
        unit: to === null || to === void 0 ? void 0 : to.unit,
        roundingUnit: to === null || to === void 0 ? void 0 : to.roundingUnit
      })
    }
  }));
};
const TimeTypeSection = ({
  timeRange,
  isAbsoluteTime,
  changeTimeType
}) => {
  const [isAbsoluteTimeByDefault, setIsAbsoluteTimeByDefault] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    setIsAbsoluteTimeByDefault((0, _time_utils.isTimeRangeAbsoluteTime)(timeRange));
  }, [timeRange]);
  if (!timeRange) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isAbsoluteTimeByDefault && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('share.link.timeRange.switchLabel', {
      defaultMessage: 'Use absolute time range'
    }),
    checked: isAbsoluteTime,
    onChange: changeTimeType
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, isAbsoluteTime ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "absoluteTimeInfoText"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "share.link.timeRange.absoluteTimeInfoText",
    defaultMessage: "The users will see all data from {from} to {to}.",
    values: {
      from: /*#__PURE__*/_react.default.createElement(AbsoluteTimeText, {
        date: timeRange === null || timeRange === void 0 ? void 0 : timeRange.from
      }),
      to: /*#__PURE__*/_react.default.createElement(AbsoluteTimeText, {
        date: timeRange === null || timeRange === void 0 ? void 0 : timeRange.to
      })
    }
  })) : getRelativeTimeText(timeRange)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), isAbsoluteTimeByDefault && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: _i18n.i18n.translate('share.link.timeRange.relativeTimeCallout', {
      defaultMessage: 'To use a relative time range, select it in the time picker first.'
    })
  }));
};
exports.TimeTypeSection = TimeTypeSection;