/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
"use strict";(self.serverlessSearch_bundle_jsonpfunction=self.serverlessSearch_bundle_jsonpfunction||[]).push([[291],{1327:(e,s,n)=>{n.d(s,{Dq:()=>t,XH:()=>a});const t="serverlessConnectors",a="serverlessWebCrawlers"},3089:(e,s,n)=>{n.d(s,{l:()=>j});var t=n(1319),a=n(5008),r=n(4286),o=n.n(r),i=n(5879),c=n(51),l=n(9027),u=n(7294),d=n(7018),x=n(4837),p=n(9009),g=n(6791);const j=()=>{const e=(0,d.U)().filter((e=>["Gmail","Sharepoint Online","Jira Cloud","Dropbox"].includes(e.name))),{createConnector:s,isLoading:n}=(0,x.B)(),{data:r}=(0,p.U)();return(0,g.jsx)(c.cD,{icon:"plugs",title:a.i18n.translate("xpack.serverlessSearch.selfManagedConnectorEmpty.title",{defaultMessage:"Set up a connector"}),description:a.i18n.translate("xpack.serverlessSearch.selfManagedConnectorEmpty.description",{defaultMessage:"To set up and deploy a connector you'll be working between data source, your terminal, and the Kibana UI. The high level process looks like this:"}),body:(0,g.jsx)(t.EuiFlexGroup,{alignItems:"stretch",justifyContent:"center",direction:"column",gutterSize:"s"},(0,g.jsx)(t.EuiFlexItem,null,(0,g.jsx)(t.EuiPanel,{color:"subdued"},(0,g.jsx)(t.EuiFlexItem,{grow:!1},(0,g.jsx)(l.Yz,{stepCount:3})),(0,g.jsx)(t.EuiFlexGroup,null,(0,g.jsx)(t.EuiFlexItem,null,(0,g.jsx)(t.EuiFlexGroup,{justifyContent:"flexStart",alignItems:"center",direction:"column"},(0,g.jsx)(t.EuiFlexItem,{grow:!1},(0,g.jsx)(t.EuiFlexGroup,{justifyContent:"center",alignItems:"center",direction:"row",gutterSize:"s"},e.map(((s,n)=>(0,g.jsx)(o().Fragment,{key:s.serviceType},n===Math.floor(e.length/2)&&(0,g.jsx)(t.EuiFlexItem,{grow:!1},(0,g.jsx)(t.EuiIcon,{color:"primary",size:"l",type:"documents"})),(0,g.jsx)(t.EuiFlexItem,{grow:!1},(0,g.jsx)(c.zN,{name:s.name,serviceType:s.serviceType,iconPath:s.iconPath,showTooltip:!0}))))))),(0,g.jsx)(t.EuiFlexItem,{grow:!1},(0,g.jsx)(t.EuiText,null,(0,g.jsx)("p",null,a.i18n.translate("xpack.serverlessSearch.connectorsEmpty.guideOneDescription",{defaultMessage:"Choose from over 30 third-party data sources you'd like to sync"})))))),(0,g.jsx)(t.EuiFlexItem,null,(0,g.jsx)(t.EuiFlexGroup,{justifyContent:"flexStart",alignItems:"center",direction:"column"},(0,g.jsx)(t.EuiFlexGroup,{gutterSize:"s",direction:"row",alignItems:"center",justifyContent:"center"},(0,g.jsx)(t.EuiFlexItem,{grow:!1},(0,g.jsx)(t.EuiIcon,{color:"primary",size:"l",type:"plugs"})),(0,g.jsx)(t.EuiFlexItem,null,(0,g.jsx)(t.EuiIcon,{size:"m",type:"sortRight"})),(0,g.jsx)(t.EuiFlexItem,null,(0,g.jsx)(t.EuiIcon,{color:"primary",size:"l",type:"launch"}))),(0,g.jsx)(t.EuiFlexItem,null,(0,g.jsx)(t.EuiText,null,(0,g.jsx)("p",null,(0,g.jsx)(i.FormattedMessage,{id:"xpack.serverlessSearch.connectorsEmpty.guideTwoDescription",defaultMessage:"Deploy connector code on your own infrastructure by running from {source}, or using {docker}",values:{source:(0,g.jsx)(t.EuiLink,{target:"_blank","data-test-subj":"serverlessSearchEmptyConnectorsPromptSourceLink",href:u.O.connectorsRunFromSource},a.i18n.translate("xpack.serverlessSearch.connectorsEmpty.sourceLabel",{defaultMessage:"source"})),docker:(0,g.jsx)(t.EuiLink,{target:"_blank","data-test-subj":"serverlessSearchEmptyConnectorsPromptDockerLink",href:u.O.connectorsRunWithDocker},a.i18n.translate("xpack.serverlessSearch.connectorsEmpty.dockerLabel",{defaultMessage:"Docker"}))}})))))),(0,g.jsx)(t.EuiFlexItem,null,(0,g.jsx)(t.EuiFlexGroup,{justifyContent:"flexStart",alignItems:"center",direction:"column"},(0,g.jsx)(t.EuiFlexItem,{grow:!1},(0,g.jsx)(t.EuiFlexGroup,{gutterSize:"s",direction:"row",alignItems:"center",justifyContent:"center"},(0,g.jsx)(t.EuiFlexItem,null,(0,g.jsx)(t.EuiIcon,{color:"primary",size:"l",type:"documents"})),(0,g.jsx)(t.EuiFlexItem,null,(0,g.jsx)(t.EuiIcon,{size:"m",type:"sortRight"})),(0,g.jsx)(t.EuiFlexItem,null,(0,g.jsx)(t.EuiIcon,{color:"primary",size:"l",type:"plugs"})),(0,g.jsx)(t.EuiFlexItem,null,(0,g.jsx)(t.EuiIcon,{size:"m",type:"sortRight"})),(0,g.jsx)(t.EuiFlexItem,null,(0,g.jsx)(t.EuiIcon,{color:"primary",size:"l",type:"logoElasticsearch"})))),(0,g.jsx)(t.EuiFlexItem,null,(0,g.jsx)(t.EuiText,null,(0,g.jsx)("p",null,a.i18n.translate("xpack.serverlessSearch.connectorsEmpty.guideThreeDescription",{defaultMessage:"Enter access and connection details for your data source and run your first sync"})))))))))),actions:(0,g.jsx)(t.EuiFlexGroup,{direction:"row",gutterSize:"m"},(0,g.jsx)(t.EuiFlexItem,null,(0,g.jsx)(t.EuiButton,{"data-test-subj":"serverlessSearchEmptyConnectorsPromptCreateConnectorButton",disabled:!(null!=r&&r.canManageConnectors),fill:!0,iconType:"plusInCircle",onClick:()=>s(),isLoading:n},a.i18n.translate("xpack.serverlessSearch.connectorsEmpty.selfManagedButton",{defaultMessage:"Self-managed connector"}))))})}},3291:(e,s,n)=>{n.d(s,{ConnectorsRouter:()=>le});var t=n(193),a=n(4286),r=n.n(a),o=n(1319),i=n(1493),c=n(5008),l=n(4514),u=n(6438),d=n(6791),x=n(3530);const p=e=>{const{http:s}=(0,u.y)(),n=["fetchConnector",e];return{queryKey:n,...(0,x.useQuery)({queryKey:n,queryFn:()=>s.fetch(`/internal/serverless_search/connector/${e}`)})}};var g={name:"f7ay7b",styles:"justify-content:center"},j={name:"f7ay7b",styles:"justify-content:center"},m={name:"f7ay7b",styles:"justify-content:center"};const h=({connector:e,isDisabled:s})=>{const[n,t]=(0,a.useState)(!1),[i,h]=(0,a.useState)(e.name||l.dc),{http:y}=(0,u.y)(),E=(0,x.useQueryClient)(),{queryKey:f}=p(e.id);(0,a.useEffect)((()=>h(e.name)),[e.name]);const{isLoading:v,mutate:S}=(0,x.useMutation)({mutationFn:async s=>{const n={name:s};return await y.post(`/internal/serverless_search/connectors/${e.id}/name`,{body:JSON.stringify(n)}),s},onSuccess:s=>{E.setQueryData(f,{connector:{...e,name:s}}),E.invalidateQueries(f),t(!1)}});return(0,d.jsx)(o.EuiFlexGroup,{direction:"row"},n?(0,d.jsx)(o.EuiForm,null,(0,d.jsx)(o.EuiFlexItem,{grow:!1},(0,d.jsx)(o.EuiFormLabel,null,c.i18n.translate("xpack.serverlessSearch.connectors.nameLabel",{defaultMessage:"Name"})),(0,d.jsx)(o.EuiFieldText,{"data-test-subj":"serverlessSearchEditNameFieldText",onChange:e=>h(e.target.value),value:i})),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiFlexGroup,{direction:"row",justifyContent:"center",alignItems:"center"},(0,d.jsx)(o.EuiFlexItem,{grow:!1,css:j},(0,d.jsx)(o.EuiButton,{"data-test-subj":"serverlessSearchSaveNameButton",color:"primary",fill:!0,type:"submit",onClick:()=>S(i),size:"s",isLoading:v},l.NG)),(0,d.jsx)(o.EuiFlexItem,{grow:!1,css:g},(0,d.jsx)(o.EuiButton,{"data-test-subj":"serverlessSearchCancelNameButton",size:"s",isLoading:v,onClick:()=>{h(e.name),t(!1)}},l.M0)))):(0,d.jsx)(r().Fragment,null,(0,d.jsx)(o.EuiFlexItem,{grow:!1},(0,d.jsx)(o.EuiTitle,{"data-test-subj":"serverlessSearchConnectorName"},(0,d.jsx)("h1",null,e.name||c.i18n.translate("xpack.serverlessSearch.connector.chooseName",{defaultMessage:"Choose a name for your connector"})))),(0,d.jsx)(o.EuiFlexItem,{grow:!1,css:m},(0,d.jsx)(o.EuiButtonIcon,{"data-test-subj":"serverlessSearchEditNameButton",isDisabled:s,color:"text",iconType:"pencil","aria-label":c.i18n.translate("xpack.serverlessSearch.connectors.editNameLabel",{defaultMessage:"Edit connector name"}),onClick:()=>t(!0)}))))};var y=n(7018),E={name:"1qmr6ab",styles:"overflow:auto"};const f=({connector:e,isDisabled:s})=>{var n,t;const{http:r}=(0,u.y)(),i=(0,y.U)(),g=(0,x.useQueryClient)(),{queryKey:j}=p(e.id),m=(0,a.useMemo)((()=>i.sort(((e,s)=>e.name.localeCompare(s.name)))),[i]),{isLoading:h,mutate:f}=(0,x.useMutation)({mutationFn:async s=>{if(null===s||""===s)return{serviceType:s,name:e.name};const n={service_type:s};await r.post(`/internal/serverless_search/connectors/${e.id}/service_type`,{body:JSON.stringify(n)});const t=await r.post(`/internal/serverless_search/connectors/${e.id}/generate_name`,{body:JSON.stringify({name:e.name,is_native:e.is_native,service_type:s})}),a=t.result.connectorName,o=t.result.indexName;await r.post(`/internal/serverless_search/connectors/${e.id}/name`,{body:JSON.stringify({name:a||""})});try{await r.post(`/internal/serverless_search/connectors/${e.id}/index_name`,{body:JSON.stringify({index_name:o})})}catch{}return{serviceType:s,name:a}},onSuccess:s=>{g.setQueryData(j,{connector:{...e,service_type:s.serviceType,name:s.name}}),g.invalidateQueries(j)}}),v=m.map(((e,s)=>{const n=[];let t="";return e.isTechPreview&&(n.push((0,d.jsx)(o.EuiBadge,{"aria-label":l.ns,key:s+"-preview",iconType:"beaker",color:"hollow"},c.i18n.translate("xpack.serverlessSearch.connectors.chooseConnectorSelectable.thechPreviewBadgeLabel",{defaultMessage:"Tech preview"}))),t+=` ${l.ns}`),e.isBeta&&(n.push((0,d.jsx)(o.EuiBadge,{"aria-label":l.IO,key:s+"-beta",iconType:"beta",color:"hollow"},l.IO)),t+=` ${l.IO}`),{key:s.toString(),label:e.name,value:{_icon:n,_badges:(0,d.jsx)(o.EuiIcon,{size:"l",type:e.iconPath}),serviceType:e.serviceType},"aria-label":e.name+t}})),{euiTheme:S}=(0,o.useEuiTheme)(),b=(0,a.useCallback)((e=>{if(0===e.length)return;const s=Number(e[0].key);f(m[s].serviceType)}),[f,m]),C=(0,a.useMemo)((()=>{const s=v.find((s=>{var n;return(null===(n=s.value)||void 0===n?void 0:n.serviceType)===e.service_type}));return s?[s]:[]}),[v,e.service_type]);return(0,d.jsx)(o.EuiFormRow,{label:c.i18n.translate("xpack.serverlessSearch.connectors.serviceTypeLabel",{defaultMessage:"Connector type"}),"data-test-subj":"serverlessSearchEditConnectorType",fullWidth:!0},(0,d.jsx)(o.EuiComboBox,{"aria-label":c.i18n.translate("xpack.serverlessSearch.connectors.chooseConnectorSelectable.euiComboBox.accessibleScreenReaderLabelLabel",{defaultMessage:"Select a data source for your connector to use."}),isDisabled:Boolean(e.service_type)||s,isLoading:h,"data-test-subj":"serverlessSearchEditConnectorTypeChoices",prepend:(0,d.jsx)(o.EuiIcon,{type:e.service_type?null!==(n=null===(t=i.find((s=>s.serviceType===e.service_type)))||void 0===t?void 0:t.iconPath)&&void 0!==n?n:"":"plugs",size:"l"}),singleSelection:{asPlainText:!0},fullWidth:!0,placeholder:c.i18n.translate("xpack.serverlessSearch.connectors.chooseConnectorSelectable.placeholder.text",{defaultMessage:"Choose a data source"}),options:v,selectedOptions:C,onChange:b,renderOption:(e,s,n)=>{const{value:{_icon:t,_badges:a,serviceType:r}={_icon:[],_badges:null,serviceType:""},key:i,label:c}=e;return(0,d.jsx)(o.EuiFlexGroup,{className:n,key:i+"-span",gutterSize:"m",responsive:!1,direction:"row"},(0,d.jsx)(o.EuiFlexItem,{grow:!1},a),(0,d.jsx)(o.EuiFlexItem,{css:E,grow:!0,"data-test-subj":`serverlessSearchConnectorServiceType-${r}`},(0,d.jsx)(o.EuiText,{textAlign:"left",size:"s"},(0,d.jsx)(o.EuiTextTruncate,{text:c,truncation:"end"}))),(0,d.jsx)(o.EuiFlexItem,{grow:!1},(0,d.jsx)(o.EuiBadgeGroup,{gutterSize:"xs"},t)))},rowHeight:S.base/2*5}))};var v={name:"f7ay7b",styles:"justify-content:center"},S={name:"f7ay7b",styles:"justify-content:center"};const b=({connector:e,isDisabled:s})=>{const[n,t]=(0,a.useState)(!1),[r,i]=(0,a.useState)(e.description||""),{http:g}=(0,u.y)(),j=(0,x.useQueryClient)(),{queryKey:m}=p(e.id);(0,a.useEffect)((()=>i(e.description||"")),[e.description]);const{isLoading:h,mutate:y}=(0,x.useMutation)({mutationFn:async s=>{const n={description:s};return await g.post(`/internal/serverless_search/connectors/${e.id}/description`,{body:JSON.stringify(n)}),s},onSuccess:s=>{j.setQueryData(m,{connector:{...e,description:s}}),j.invalidateQueries(m),t(!1)}});return(0,d.jsx)(o.EuiFormRow,{helpText:!n&&c.i18n.translate("xpack.serverlessSearch.connectors.descriptionHelpText",{defaultMessage:"Optional description for your connector."}),label:c.i18n.translate("xpack.serverlessSearch.connectors.descriptionLabel",{defaultMessage:"Description"}),labelAppend:s?void 0:(0,d.jsx)(o.EuiText,{size:"xs"},(0,d.jsx)(o.EuiLink,{"data-test-subj":"serverlessSearchEditDescriptionButton",onClick:()=>t(!0),role:"button"},l.us)),fullWidth:!0},(0,d.jsx)(o.EuiFlexGroup,{direction:"column",gutterSize:"xs"},(0,d.jsx)(o.EuiFlexItem,null,n?(0,d.jsx)(o.EuiFieldText,{"data-test-subj":"serverlessSearchEditDescriptionFieldText",onChange:e=>i(e.target.value),value:r||"",fullWidth:!0}):(0,d.jsx)(o.EuiText,{size:"s","data-test-subj":"serverlessSearchConnectorDescription"},e.description)),n&&(0,d.jsx)(o.EuiFlexItem,null,(0,d.jsx)(o.EuiSpacer,{size:"s"}),(0,d.jsx)(o.EuiFlexGroup,{direction:"row",justifyContent:"flexStart",gutterSize:"s"},(0,d.jsx)(o.EuiFlexItem,{grow:!1,css:S},(0,d.jsx)(o.EuiButton,{"data-test-subj":"serverlessSearchSaveDescriptionButton",color:"primary",fill:!0,onClick:()=>y(r),type:"submit",size:"s",isLoading:h},l.NG)),(0,d.jsx)(o.EuiFlexItem,{grow:!1,css:v},(0,d.jsx)(o.EuiButton,{"data-test-subj":"serverlessSearchCancelDescriptionButton",size:"s",isLoading:h,onClick:()=>{i(e.description||""),t(!1)}},l.M0))))))},C=c.i18n.translate("xpack.serverlessSearch.connectors.deleteModal.deleteLabel",{defaultMessage:"DELETE"}),k=({connectorId:e,connectorName:s,closeDeleteModal:n,onSuccess:t})=>{const r=(0,o.useGeneratedHtmlId)(),{http:i}=(0,u.y)(),{isLoading:l,isSuccess:p,mutate:g}=(0,x.useMutation)({mutationFn:async()=>(await i.delete(`/internal/serverless_search/connectors/${e}`)).acknowledged});(0,a.useEffect)((()=>{p&&(t&&t(),n())}),[n,p,t]);const[j,m]=(0,a.useState)("");return(0,d.jsx)(o.EuiConfirmModal,{"aria-labelledby":r,title:c.i18n.translate("xpack.serverlessSearch.connectors.deleteModal.title",{defaultMessage:"Are you sure you want to delete connector {connectorName}",values:{connectorName:s||e}}),titleProps:{id:r},onCancel:()=>{n()},onConfirm:()=>{g()},cancelButtonText:l?c.i18n.translate("xpack.serverlessSearch.connectors.deleteModal.closeButton.title",{defaultMessage:"Close"}):c.i18n.translate("xpack.serverlessSearch.connectors.deleteModal.cancelButton.title",{defaultMessage:"Cancel"}),confirmButtonText:c.i18n.translate("xpack.serverlessSearch.connectors.deleteModal.confirmButton.title",{defaultMessage:"Delete connector"}),defaultFocusedButton:"confirm",buttonColor:"danger",confirmButtonDisabled:j.trim()!==(s||C),isLoading:l},(0,d.jsx)("p",null,c.i18n.translate("xpack.serverlessSearch.connectors.deleteModal.syncsWarning.connectorNameDescription",{defaultMessage:"This action cannot be undone. Please type {connectorName} to confirm.",values:{connectorName:s||C}})),(0,d.jsx)(o.EuiForm,null,(0,d.jsx)(o.EuiFormRow,{label:s?c.i18n.translate("xpack.serverlessSearch.connectors.deleteModal.connectorNameInput.label",{defaultMessage:"Connector name"}):void 0},(0,d.jsx)(o.EuiFieldText,{"data-test-subj":"serverlessSearchDeleteConnectorModalFieldText",onChange:e=>m(e.target.value),value:j}))))};var I=n(9027),F=n(7294),T=n(6030),M=n(5879),w=n(4226);const L=({connectorId:e,serviceType:s,status:n})=>{const{elasticsearchUrl:t}=(0,w.m)(),a=`connectors:\n-\n  connector_id: ${e}\n  service_type: ${s}\n  api_key:\nelasticsearch:\n  host: ${t}\n  api_key:`;return(0,d.jsx)(o.EuiPanel,{hasBorder:!0},(0,d.jsx)(o.EuiTitle,{size:"xs"},(0,d.jsx)("h3",null,(0,d.jsx)(M.FormattedMessage,{id:"xpack.serverlessSearch.connectors.variablesTitle",defaultMessage:"Variables for your {url}",values:{url:(0,d.jsx)(o.EuiCode,null,"elastic/connectors/config.yml")}}))),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiText,{color:"subdued"},(0,d.jsx)(M.FormattedMessage,{id:"xpack.serverlessSearch.connectors.config.apiKeyExplanation",defaultMessage:"You will need to fill in the {api_key} fields with an API key. One can be generated on the Getting Started page.",values:{api_key:(0,d.jsx)(o.EuiCode,null,"api_key")}})),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiCodeBlock,{language:"yaml",isCopyable:!0,"data-test-subj":"serverlessSearchConnectorConnectorDetails"},a))},_=({connectorId:e,serviceType:s,status:n})=>{const t=(0,T.Y)();return(0,d.jsx)(o.EuiFlexGroup,{direction:"column",alignItems:"center",justifyContent:"center"},(0,d.jsx)(o.EuiFlexItem,null,(0,d.jsx)(o.EuiTitle,{size:"s"},(0,d.jsx)("h2",null,c.i18n.translate("xpack.serverlessSearch.connectors.config.link.linkToElasticTitle",{defaultMessage:"Link your connector to Elasticsearch"})))),(0,d.jsx)(o.EuiFlexItem,null,(0,d.jsx)(o.EuiText,{color:"subdued"},c.i18n.translate("xpack.serverlessSearch.connectors.config.linkToElasticDescription",{defaultMessage:"You need to run the connector code on your own infrastructure and link it to your Elasticsearch instance. You have two options:"}))),(0,d.jsx)(o.EuiFlexItem,null,(0,d.jsx)(o.EuiFlexGroup,{direction:"row",alignItems:"center",justifyContent:"center"},(0,d.jsx)(o.EuiFlexItem,{grow:!1},(0,d.jsx)("span",null,(0,d.jsx)(o.EuiButton,{"data-test-subj":"serverlessSearchConnectorLinkElasticsearchRunWithDockerButton",iconType:`${t}/docker.svg`,href:F.O.connectorsRunWithDocker,target:"_blank",fill:!0},c.i18n.translate("xpack.serverlessSearch.connectors.runWithDockerLink",{defaultMessage:"Run with Docker"})))),(0,d.jsx)(o.EuiFlexItem,{grow:!1},(0,d.jsx)("span",null,(0,d.jsx)(o.EuiButton,{"data-test-subj":"serverlessSearchConnectorLinkElasticsearchRunFromSourceButton",iconType:`${t}/github_white.svg`,href:F.O.connectorsRunFromSource,target:"_blank",fill:!0},c.i18n.translate("xpack.serverlessSearch.connectors.runFromSourceLink",{defaultMessage:"Run from source"}))))),(0,d.jsx)(o.EuiSpacer,null),Boolean(s)?(0,d.jsx)(o.EuiFlexItem,null,(0,d.jsx)(L,{connectorId:e,serviceType:s,status:n})):(0,d.jsx)(o.EuiFlexItem,null,(0,d.jsx)(o.EuiCallOut,{title:c.i18n.translate("xpack.serverlessSearch.connectors.pleaseSelectServiceType",{defaultMessage:"Please select a connector type."}),color:"warning",iconType:"info"})),(0,d.jsx)(o.EuiSpacer,null),!Boolean(s)||n!==I.AY.CREATED&&n!==I.AY.NEEDS_CONFIGURATION?null:(0,d.jsx)(o.EuiFlexItem,null,(0,d.jsx)(o.EuiCallOut,{title:c.i18n.translate("xpack.serverlessSearch.connectors.waitingForConnection",{defaultMessage:"Waiting for connection"}),color:"warning",iconType:"info"}))))},D=e=>{const{http:s}=(0,u.y)();return(0,x.useMutation)({mutationFn:async n=>{const t={configuration:n};return await s.post(`/internal/serverless_search/connectors/${e}/configuration`,{body:JSON.stringify(t)})}})},N=({connector:e,isDisabled:s})=>{const{data:n,isLoading:t,isSuccess:r,mutate:i,reset:l}=D(e.id),{queryKey:u}=p(e.id),g=(0,x.useQueryClient)();return(0,a.useEffect)((()=>{r&&(g.setQueryData(u,{connector:{...e,configuration:n}}),g.invalidateQueries(u),l())}),[n,r,e,g,u,l]),(0,d.jsx)(o.EuiFlexGroup,{direction:"column",alignItems:"center",justifyContent:"center"},(0,d.jsx)(o.EuiFlexItem,null,(0,d.jsx)(o.EuiTitle,{size:"s"},(0,d.jsx)("h2",null,c.i18n.translate("xpack.serverlessSearch.connectors.config.connectorConfigTitle",{defaultMessage:"Configure your connector"})))),(0,d.jsx)(o.EuiFlexItem,null,(0,d.jsx)(o.EuiText,{color:"subdued"},c.i18n.translate("xpack.serverlessSearch.connectors.config.connectorConfigDescription",{defaultMessage:"Your connector is set up. Now you can enter access details for your data source. This ensures the connector can find content and is authorized to access it."}))),(0,d.jsx)(o.EuiFlexItem,null,(0,d.jsx)(I.bd,{connector:e,hasPlatinumLicense:!1,isDisabled:s,isLoading:t,saveConfig:i})),(0,d.jsx)(o.EuiFlexItem,null,(0,d.jsx)(o.EuiText,{color:"subdued"},(0,d.jsx)(M.FormattedMessage,{id:"xpack.serverlessSearch.searchConnectors.configurationConnector.config.documentation.description",defaultMessage:"This connector supports several authentication methods. Ask your administrator for the correct connection credentials. {documentationUrl}",values:{documentationUrl:(0,d.jsx)(o.EuiLink,{target:"_blank","data-test-subj":"serverlessSearchConnectorConfigFieldsDocumentationLink",href:F.O.connectorClientAvailableConnectors},c.i18n.translate("xpack.serverlessSearch.searchConnectors.configurationConnector.config.documentation.link",{defaultMessage:"Documentation"}))}}))))};function B(e){if(!e)return!1;const s=encodeURI(e).split(/%(?:u[0-9A-F]{2})?[0-9A-F]{2}|./).length-1,n=new RegExp('[\\\\/:*?"<>|\\s,#]+');return!(s>255||e!==e.toLowerCase()||"."===e||".."===e||null!==e.match(/^[-_+]/)||null!==e.match(n))}var P=n(3222),z=n(6102);const O=({connector:e})=>{const{data:s,isLoading:n,mutate:t}=(()=>{const{http:e}=(0,u.y)();return(0,x.useMutation)({mutationFn:async s=>await e.post(P.o1,{body:JSON.stringify(s)})})})(),{data:a}=(0,z.U)();return(0,d.jsx)(o.EuiPanel,{hasBorder:!0},(0,d.jsx)(o.EuiFlexGroup,{direction:"row",justifyContent:"spaceBetween",alignItems:"center"},(0,d.jsx)(o.EuiFlexItem,{grow:!1},(0,d.jsx)(o.EuiTitle,{size:"s"},(0,d.jsx)("h3",null,c.i18n.translate("xpack.serverlessSearch.connectors.config.apiKeyTitle",{defaultMessage:"Prepare an API key"})))),(0,d.jsx)(o.EuiFlexItem,{grow:!1},(0,d.jsx)(o.EuiBadge,null,l.E$))),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiText,{color:"subdued"},(0,d.jsx)(M.FormattedMessage,{id:"xpack.serverlessSearch.connectors.config.apiKeyDescription",defaultMessage:"You can limit the connector's API key to only have access to the above index. Once created, use this key to set the {apiKey} variable in your {config} file.",values:{apiKey:(0,d.jsx)(o.EuiCode,null,"api_key"),config:(0,d.jsx)(o.EuiCode,null,"config.yml")}})),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)("span",null,(0,d.jsx)(o.EuiButton,{"data-test-subj":"serverlessSearchApiKeyPanelNewApiKeyButton",isDisabled:!e.index_name||!(null!=a&&a.canManageOwnApiKey),isLoading:n,iconType:"plusInCircle",color:"primary",onClick:()=>{e.index_name&&t({name:`${e.index_name}-connector`,role_descriptors:{[`${e.index_name}-connector-role`]:{cluster:["monitor"],index:[{names:[e.index_name,e.index_name.replace(/^(?:search-)?(.*)$/,".search-acl-filter-$1"),`${I.gA}*`],privileges:["all"]}]}}})}},c.i18n.translate("xpack.serverlessSearch.connectors.config.createApikeyLabel",{defaultMessage:"New API key"}))),(0,d.jsx)(o.EuiSpacer,null),Boolean(s)&&(0,d.jsx)(o.EuiCodeBlock,{isCopyable:!0},null==s?void 0:s.encoded))},G=({indexName:e,onChange:s,isDisabled:n})=>{const[t,r]=(0,a.useState)(""),{data:i,isLoading:l,refetch:p}=(e=>{const{http:s}=(0,u.y)();return(0,x.useQuery)({queryKey:["fetchIndexNames",e],queryFn:async()=>s.fetch("/internal/serverless_search/index_names",{query:{query:e}})})})(t);(0,a.useEffect)((()=>{p()}),[t,p]);const[g,j]=(0,a.useState)(e);return(0,a.useEffect)((()=>{s(g)}),[g,s]),(0,d.jsx)(o.EuiForm,{fullWidth:!0},(0,d.jsx)(o.EuiFormRow,{error:B(g||"")?void 0:c.i18n.translate("xpack.serverlessSearch.connectors.indexNameErrorText",{defaultMessage:"Names should be lowercase and cannot contain spaces or special characters."}),isInvalid:!!g&&!B(g),label:c.i18n.translate("xpack.serverlessSearch.connectors.config.indexNameLabel",{defaultMessage:"Create or select an index"}),fullWidth:!0,helpText:c.i18n.translate("xpack.serverlessSearch.connectors.indexNameInputHelpText",{defaultMessage:"Names should be lowercase and cannot contain spaces or special characters."})},(0,d.jsx)(o.EuiComboBox,{isInvalid:!!g&&!B(g),async:!0,isClearable:!1,customOptionText:c.i18n.translate("xpack.serverlessSearch.connectors.config.createIndexLabel",{defaultMessage:"The connector will create the index {searchValue}",values:{searchValue:"{searchValue}"}}),isDisabled:n,isLoading:l,onChange:e=>{e[0].value&&j(e[0].value)},onCreateOption:e=>j(e),onSearchChange:e=>r(e),options:((null==i?void 0:i.index_names)||[]).map((e=>({label:e,value:e}))),selectedOptions:g?[{label:g,value:g}]:[],singleSelection:!0})))},A=()=>(0,d.jsx)(o.EuiCallOut,{color:"primary",iconType:"info",title:c.i18n.translate("xpack.serverlessSearch.connectors.syncScheduledTitle",{defaultMessage:"A sync has been scheduled"})},(0,d.jsx)(o.EuiText,null,c.i18n.translate("xpack.serverlessSearch.connectors.syncSheduledDescription",{defaultMessage:"It may take a minute for this sync to be visible and for the connector to pick it up"})));var R=n(5850);const U=({connector:e,isDisabled:s})=>{const{http:n}=(0,u.y)(),t=(0,x.useQueryClient)(),{queryKey:i}=p(e.id),[g,j]=(0,a.useState)(!1),{data:m,isLoading:h,mutate:y}=(0,x.useMutation)({mutationFn:async({inputName:s,sync:t})=>{if(j(!1),s&&s!==e.index_name){const t={index_name:s};await n.post(`/internal/serverless_search/connectors/${e.id}/index_name`,{body:JSON.stringify(t)})}return t&&(await n.post(`/internal/serverless_search/connectors/${e.id}/sync`),j(!0)),s},onSuccess:()=>{t.setQueryData(i,{connector:{...e,index_name:m}}),t.invalidateQueries(i)}}),[E,f]=(0,a.useState)(e.index_name);return(0,d.jsx)(r().Fragment,null,(0,d.jsx)(o.EuiFlexGroup,{direction:"column",alignItems:"center",justifyContent:"center"},(0,d.jsx)(o.EuiFlexItem,null,(0,d.jsx)(o.EuiTitle,{size:"s"},(0,d.jsx)("h2",null,c.i18n.translate("xpack.serverlessSearch.connectors.config.connectorIndexNameTitle",{defaultMessage:"Link index"})))),(0,d.jsx)(o.EuiFlexItem,null,(0,d.jsx)(o.EuiText,{color:"subdued"},c.i18n.translate("xpack.serverlessSearch.connectors.config.connectorIndexNameDescription",{defaultMessage:"Pick an index where your documents will be synced, or create a new one for this connector."})))),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(G,{isDisabled:s,indexName:E||"",onChange:e=>f(e)}),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiPanel,{hasBorder:!0},(0,d.jsx)(o.EuiFlexGroup,{direction:"column",justifyContent:"spaceBetween"},(0,d.jsx)(o.EuiFlexItem,{grow:!1},(0,d.jsx)(o.EuiTitle,{size:"s"},(0,d.jsx)("h3",null,c.i18n.translate("xpack.serverlessSearch.connectors.config.preprocessData.title",{defaultMessage:"Preprocess your data"})))),(0,d.jsx)(o.EuiFlexItem,{grow:!1},(0,d.jsx)(o.EuiText,null,(0,d.jsx)("p",null,(0,d.jsx)(M.FormattedMessage,{id:"xpack.serverlessSearch.connectors.config.preprocessData.description",defaultMessage:"Use ingest pipelines to preprocess data before indexing into Elasticsearch. Note that self-managed connectors use the {clientIngestionPipeline} pipeline for preprocessing.",values:{clientIngestionPipeline:(0,d.jsx)(o.EuiCode,null,R.IM)}})))),(0,d.jsx)(o.EuiFlexItem,null,(0,d.jsx)(o.EuiText,null,(0,d.jsx)("p",null,(0,d.jsx)(o.EuiLink,{"data-test-subj":"serverlessSearchConnectorIndexNameLearnMoreLink",href:F.O.pipelines,target:"_blank"},c.i18n.translate("xpack.serverlessSearch.connectors.config.preprocessDataTitle.learnMore",{defaultMessage:"Learn More"}))))))),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(O,{connector:e}),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiFlexGroup,null,(0,d.jsx)(o.EuiFlexItem,{grow:!1},(0,d.jsx)("span",null,(0,d.jsx)(o.EuiButton,{"data-test-subj":"serverlessSearchConnectorIndexNameButton",color:"primary",isDisabled:!B(E)||s,isLoading:h,onClick:()=>y({inputName:E,sync:!1})},l.NG))),(0,d.jsx)(o.EuiFlexItem,{grow:!1},(0,d.jsx)("span",null,(0,d.jsx)(o.EuiButton,{"data-test-subj":"serverlessSearchConnectorIndexNameSaveAndSyncButton",color:"primary",disabled:!(B(E)&&[I.AY.CONFIGURED,I.AY.CONNECTED].includes(e.status))||s,fill:!0,isLoading:h,onClick:()=>y({inputName:E,sync:!0})},c.i18n.translate("xpack.serverlessSearch.connectors.config.saveSyncLabel",{defaultMessage:"Save and sync"}))))),g&&(0,d.jsx)(r().Fragment,null,(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(A,null)))},$=({canManageConnectors:e,connector:s})=>{const{http:n}=(0,u.y)(),{data:t,isLoading:i,isSuccess:c,mutate:g,reset:j}=(0,x.useMutation)({mutationFn:async e=>{if(e&&e!==s.index_name){const t={index_name:e};await n.post(`/internal/serverless_search/connectors/${s.id}/index_name`,{body:JSON.stringify(t)})}return e}}),m=(0,x.useQueryClient)(),{queryKey:h}=p(s.id);(0,a.useEffect)((()=>{c&&(m.setQueryData(h,{connector:{...s,index_name:t}}),m.invalidateQueries(h),j())}),[t,c,s,m,h,j]);const[y,E]=(0,a.useState)(s.index_name||"");return(0,d.jsx)(r().Fragment,null,(0,d.jsx)(G,{isDisabled:i||!e,indexName:y,onChange:e=>E(e)}),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiFlexGroup,{alignItems:"flexEnd",direction:"row"},(0,d.jsx)(o.EuiFlexItem,null,(0,d.jsx)("span",null,(0,d.jsx)(o.EuiButton,{"data-test-subj":"serverlessSearchConnectorIndexnamePanelButton",color:"primary",disabled:!B(y),fill:!0,isLoading:i,onClick:()=>g(y)},l.Lz)))))},Y=({canManageConnectors:e,connector:s})=>{const{data:n,isLoading:t,isSuccess:i,mutate:c,reset:l}=D(s.id),{queryKey:u}=p(s.id),g=(0,x.useQueryClient)();return(0,a.useEffect)((()=>{i&&(g.setQueryData(u,{connector:{...s,configuration:n}}),g.invalidateQueries(u),l())}),[n,i,s,g,u,l]),(0,d.jsx)(r().Fragment,null,(0,d.jsx)(o.EuiPanel,{hasBorder:!0},(0,d.jsx)(I.bd,{isDisabled:!e,connector:s,hasPlatinumLicense:!1,isLoading:t,saveConfig:c}),(0,d.jsx)(o.EuiSpacer,null)),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(o.EuiPanel,{hasBorder:!0},(0,d.jsx)($,{canManageConnectors:e,connector:s})),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(L,{connectorId:s.id,serviceType:s.service_type,status:s.status}),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(O,{connector:s}),(0,d.jsx)(o.EuiSpacer,null))},Q=({canManageConnectors:e,connector:s})=>{const{http:n}=(0,u.y)(),t=(0,x.useQueryClient)(),{queryKey:i}=p(s.id),{data:l,isLoading:g,isSuccess:j,mutate:m}=(0,x.useMutation)({mutationFn:async()=>{await n.post(`/internal/serverless_search/connectors/${s.id}/sync`)},onSuccess:()=>{t.setQueryData(i,{connector:{...s,index_name:l}}),t.invalidateQueries(i)}}),[h,y]=(0,a.useState)({pageIndex:0,pageSize:20}),{data:E,isLoading:f}=((e,s)=>{const{http:n}=(0,u.y)();return(0,x.useQuery)({keepPreviousData:!0,queryKey:["fetchSyncJobs",s],queryFn:async()=>n.fetch(`/internal/serverless_search/connectors/${e}/sync_jobs`,{query:{from:s.pageIndex*(s.pageSize||10),size:s.pageSize||10}})})})(s.id,h);return(0,d.jsx)(r().Fragment,null,(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(I.sK,{isLoading:f,onPaginate:({page:e})=>y({pageIndex:e.index,pageSize:e.size}),pagination:E?(0,I.jg)(null==E?void 0:E._meta.page):{pageIndex:0,pageSize:20,totalItemCount:0},syncJobs:(null==E?void 0:E.data)||[],type:"content"}),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)("span",null,(0,d.jsx)(o.EuiButton,{"data-test-subj":"serverlessSearchConnectorOverviewSyncButton",color:"primary",disabled:[I.AY.CREATED,I.AY.NEEDS_CONFIGURATION].includes(s.status)||!e,fill:!0,isLoading:g,onClick:()=>m()},c.i18n.translate("xpack.serverlessSearch.connectors.config.syncLabel",{defaultMessage:"Sync"}))),j&&(0,d.jsx)(r().Fragment,null,(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(A,null)))};var q=n(3073);const K=({canManageConnectors:e,connector:s})=>{var n,t,o,i,c;const[l,p]=(0,a.useState)(!1),{isLoading:g,mutate:j}=(e=>{const{http:s}=(0,u.y)();return(0,x.useMutation)({mutationFn:async n=>await s.post(`/internal/serverless_search/connectors/${e}/scheduling`,{body:JSON.stringify({...n})})})})(s.id),m=null!==(n=null==s||null===(t=s.features)||void 0===t?void 0:t.incremental_sync)&&void 0!==n&&n&&null!==(o=null==s||null===(i=s.features)||void 0===i||null===(c=i.incremental_sync)||void 0===c?void 0:c.enabled)&&void 0!==o&&o;return(0,d.jsx)(r().Fragment,null,(0,d.jsx)(q.x,{connector:s,isDisabled:!e,dataTelemetryIdPrefix:"serverlessSearch",hasChanges:l,hasIngestionError:(null==s?void 0:s.status)===I.AY.ERROR,hasPlatinumLicense:!1,setHasChanges:p,shouldShowAccessControlSync:!1,shouldShowIncrementalSync:m,updateConnectorStatus:g,updateScheduling:j}))};var W=n(9009);const J=({connector:e})=>{const{data:s}=(0,W.U)(),{canManageConnectors:n}=s||{canManageConnectors:!1},[t,i]=(0,a.useState)("link");(0,a.useEffect)((()=>{let s="link";switch(e.status){case I.AY.CREATED:s="link";break;case I.AY.NEEDS_CONFIGURATION:s=Object.keys(e.configuration||{}).length>0?"configure":"link";break;case I.AY.CONFIGURED:s="connect";break;default:s="connected"}i(s)}),[e.status,i,e.configuration]);const u=[{title:c.i18n.translate("xpack.serverlessSearch.connectors.config.linkToElasticTitle",{defaultMessage:"Link to Elasticsearch"}),status:"link"===t?"current":e.status===I.AY.CREATED?"incomplete":"complete",onClick:()=>i("link"),size:"s"},{title:c.i18n.translate("xpack.serverlessSearch.connectors.config.configureTitle",{defaultMessage:"Configure"}),status:"configure"===t?"current":e.status===I.AY.CONFIGURED||e.status===I.AY.CONNECTED?"complete":"incomplete",onClick:()=>i("configure"),size:"s"},{title:c.i18n.translate("xpack.serverlessSearch.connectors.config.connectTitle",{defaultMessage:"Connect Index"}),status:"connect"===t?"current":e.status===I.AY.CONNECTED&&e.index_name?"complete":"incomplete",onClick:()=>i("connect"),size:"s"}],x=[{content:(0,d.jsx)(Q,{canManageConnectors:n,connector:e}),id:"overview",name:l.td},{content:(0,d.jsx)(r().Fragment,null,(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(Y,{canManageConnectors:n,connector:e})),id:"configuration",name:l.K2},{content:(0,d.jsx)(r().Fragment,null,(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(K,{canManageConnectors:n,connector:e})),id:"scheduling",name:l.k}];return"connected"===t?(0,d.jsx)(o.EuiTabbedContent,{tabs:x}):(0,d.jsx)(o.EuiFlexGroup,{direction:"column"},(0,d.jsx)(o.EuiFlexItem,{grow:!1},(0,d.jsx)(o.EuiStepsHorizontal,{size:"s",steps:u})),(0,d.jsx)(o.EuiFlexItem,null,"link"===t&&(0,d.jsx)(_,{connectorId:e.id,serviceType:e.service_type||"",status:e.status}),"configure"===t&&(0,d.jsx)(N,{connector:e,isDisabled:!n}),"connect"===t&&(0,d.jsx)(U,{isDisabled:!n,connector:e})))},H=()=>{const{data:e}=(0,W.U)();if(!e||e.canManageConnectors&&e.canReadConnectors)return null;const s=c.i18n.translate("xpack.serverlessSearch.connectors.noPrivilegesTitle",{defaultMessage:"Insufficient access"});return(0,d.jsx)(r().Fragment,null,(0,d.jsx)(o.EuiCallOut,{title:s,color:"warning",iconType:"info"},e.canReadConnectors?c.i18n.translate("xpack.serverlessSearch.connectors.noManagePrivileges",{defaultMessage:"You have read-only access to connectors. Contact your administrator for elevated privileges."}):c.i18n.translate("xpack.serverlessSearch.connectors.noPrivileges",{defaultMessage:"You don't have access to connectors. Contact your administrator for access."})),(0,d.jsx)(o.EuiSpacer,null))},V=()=>{const[e,s]=(0,a.useState)(!1),[n,t]=(0,a.useState)(!1),{data:r}=(0,W.U)(),x=!(null!=r&&r.canManageConnectors),{id:g}=(0,i.useParams)();(0,a.useEffect)((()=>s(!1)),[g,s]);const{application:{navigateToUrl:j}}=(0,u.y)(),{data:m,isLoading:y}=p(g);if(m&&!y||(0,d.jsx)(o.EuiPageTemplate,{offset:0,grow:!0,restrictWidth:!0,"data-test-subj":"svlSearchEditConnectorsPage"},(0,d.jsx)(o.EuiPageTemplate.EmptyPrompt,{title:(0,d.jsx)("h1",null,c.i18n.translate("xpack.serverlessSearch.connectors.loading",{defaultMessage:"Loading"}))})),null==m||!m.connector)return(0,d.jsx)(o.EuiPageTemplate,{offset:0,grow:!0,restrictWidth:!0,"data-test-subj":"svlSearchEditConnectorsPage"},(0,d.jsx)(o.EuiPageTemplate.EmptyPrompt,{title:(0,d.jsx)("h1",null,c.i18n.translate("xpack.serverlessSearch.connectors.notFound",{defaultMessage:"Could not find connector {id}",values:{id:g}})),actions:(0,d.jsx)(o.EuiButton,{"data-test-subj":"serverlessSearchEditConnectorGoBackButton",color:"primary",fill:!0,onClick:()=>j("./")},c.i18n.translate("xpack.serverlessSearch.connectors.goBack",{defaultMessage:"Go back"}))}));const{connector:E}=m;return(0,d.jsx)(o.EuiPageTemplate,{offset:0,grow:!0,restrictWidth:!0,"data-test-subj":"svlSearchEditConnectorsPage"},(0,d.jsx)(o.EuiPageTemplate.Section,{grow:!1,color:"subdued"},(0,d.jsx)(o.EuiText,{size:"s"},l.dc),(0,d.jsx)(o.EuiFlexGroup,{direction:"row",justifyContent:"spaceBetween"},(0,d.jsx)(o.EuiFlexItem,null,(0,d.jsx)(h,{connector:E,isDisabled:x})),(0,d.jsx)(o.EuiFlexItem,{grow:!1},e&&(0,d.jsx)(k,{closeDeleteModal:()=>s(!1),connectorId:E.id,connectorName:E.name,onSuccess:()=>j("./")}),(0,d.jsx)("span",null,(0,d.jsx)(o.EuiPopover,{id:"connectorMenu",button:(0,d.jsx)(o.EuiButtonIcon,{"data-test-subj":"serverlessSearchEditConnectorButton","aria-label":c.i18n.translate("xpack.serverlessSearch.connectors.openMenuLabel",{defaultMessage:"Open menu"}),iconType:"boxesVertical",onClick:()=>t(!n)}),isOpen:n,closePopover:()=>t(!1),panelPaddingSize:"none"},(0,d.jsx)(o.EuiContextMenu,{initialPanelId:0,"data-test-subj":"serverlessSearchEditConnectorContextMenu",panels:[{id:0,items:[{name:l.DT,icon:"copy",onClick:()=>{(0,o.copyToClipboard)(E.id),t(!1)}},{name:l.lt,disabled:x,icon:"trash",onClick:()=>{s(!0)}}]}]})))))),(0,d.jsx)(o.EuiPageTemplate.Section,null,(0,d.jsx)(H,null),(0,d.jsx)(o.EuiFlexGroup,{direction:"row"},(0,d.jsx)(o.EuiFlexItem,{grow:1},(0,d.jsx)(o.EuiForm,null,(0,d.jsx)(f,{isDisabled:x,connector:E}),(0,d.jsx)(o.EuiSpacer,null),(0,d.jsx)(b,{isDisabled:x,connector:E}))),(0,d.jsx)(o.EuiFlexItem,{grow:2},(0,d.jsx)(o.EuiPanel,{hasBorder:!0,hasShadow:!1},(0,d.jsx)(J,{connector:E}))))))};var X=n(3511),Z=n(3089),ee=n(4837),se=n(4810);const ne=()=>{var e,s,n;const[t,x]=(0,a.useState)(0),[p,g]=(0,a.useState)(10),[j,m]=(0,a.useState)(""),{data:h,isError:E,isLoading:f}=(0,W.U)(),v=(0,y.U)(),{application:{navigateToUrl:S}}=(0,u.y)(),[b,C]=(0,a.useState)("name");if((0,a.useEffect)((()=>{j&&x(0)}),[j,b]),E)return(0,d.jsx)(o.EuiEmptyPrompt,null,c.i18n.translate("xpack.serverlessSearch.connectors.errorFetchingConnectors",{defaultMessage:"We encountered an error fetching your connectors."}));const k=c.i18n.translate("xpack.serverlessSearch.connectors.connected",{defaultMessage:"Connected"}),F=c.i18n.translate("xpack.serverlessSearch.connectors.configuredLabel",{defaultMessage:"Configured"}),T=c.i18n.translate("xpack.serverlessSearch.connectors.typeLabel",{defaultMessage:"Type"}),w=c.i18n.translate("xpack.serverlessSearch.connectors.nameLabel",{defaultMessage:"Name"}),L=c.i18n.translate("xpack.serverlessSearch.connectors.syncStatusLabel",{defaultMessage:"Sync status"}),_=[{text:w,value:"name"},{text:T,value:"service_type"},{text:c.i18n.translate("xpack.serverlessSearch.connectors.descriptionLabel",{defaultMessage:"Description"}),value:"description"},{text:L,value:"last_sync_status"}],D=[{field:"name",name:w,render:(e,s)=>(0,d.jsx)(o.EuiLink,{"data-test-subj":"serverlessSearchColumnsLink",onClick:()=>S((0,i.generatePath)(se.H9,{id:s.id}))},e||s.id),truncateText:!0},{field:"service_type",name:T,render:e=>{const s=v.find((s=>s.serviceType===(null!=e?e:"")));return s?(0,d.jsx)(o.EuiFlexGroup,{direction:"row",gutterSize:"s",alignItems:"center"},(0,d.jsx)(o.EuiFlexItem,{grow:!1},(0,d.jsx)(o.EuiIcon,{type:s.iconPath,"aria-label":s.name})),(0,d.jsx)(o.EuiFlexItem,null,(0,d.jsx)(o.EuiText,{size:"s"},s.name))):(0,d.jsx)(r().Fragment,null)}},{field:"status",name:k,render:e=>e===I.AY.CONNECTED?(0,d.jsx)(o.EuiIcon,{"aria-label":k,color:"success",type:"checkInCircleFilled"}):(0,d.jsx)(o.EuiBadge,null,c.i18n.translate("xpack.serverlessSearch.connectors.notConnectedLabel",{defaultMessage:"Not connected"}))},{field:"status",name:F,render:e=>[I.AY.CONNECTED,I.AY.CONFIGURED].includes(e)?(0,d.jsx)(o.EuiIcon,{"aria-label":F,color:"success",type:"checkInCircleFilled"}):(0,d.jsx)(o.EuiBadge,null,c.i18n.translate("xpack.serverlessSearch.connectors.notConfiguredLabel",{defaultMessage:"Not configured"}))},{field:"last_sync_status",name:L,render:e=>e?(0,d.jsx)(o.EuiBadge,{color:(0,I.wx)(e)},(0,I.SP)(e)):(0,d.jsx)(o.EuiBadge,null,c.i18n.translate("xpack.serverlessSearch.connectors.notSyncedLabel",{defaultMessage:"Not synced"}))},{field:"last_sync_status",name:L,render:e=>e?(0,d.jsx)(o.EuiBadge,{color:(0,I.wx)(e)},(0,I.SP)(e)):(0,d.jsx)(o.EuiBadge,null,c.i18n.translate("xpack.serverlessSearch.connectors.notSyncedLabel",{defaultMessage:"Not synced"}))},{actions:[{name:l.DT,description:l.DT,icon:"copy",type:"icon",onClick:e=>(0,o.copyToClipboard)(e.id)},{render:e=>(0,d.jsx)(te,{connector:e,disabled:!(null!=h&&h.canManageConnectors)})}],name:c.i18n.translate("xpack.serverlessSearch.connectors.actionsLabel",{defaultMessage:"Actions"})}],N=null!==(e=null==h?void 0:h.connectors.filter((e=>!b||`${e[b]}`.toLowerCase().includes(j.toLowerCase()))).slice(t*p,(t+1)*p))&&void 0!==e?e:[];return(0,d.jsx)(r().Fragment,null,(0,d.jsx)(o.EuiFlexGroup,{direction:"row"},(0,d.jsx)(o.EuiFlexItem,null,(0,d.jsx)(o.EuiSearchBar,{box:{"data-test-subj":"serverlessSearchConnectorsTableSearchBar"},onChange:({queryText:e})=>m(null!=e?e:""),query:j})),(0,d.jsx)(o.EuiFlexItem,{grow:!1},(0,d.jsx)(o.EuiSelect,{"data-test-subj":"serverlessSearchConnectorsTableSelect",onChange:e=>C(e.currentTarget.value),options:_}))),(0,d.jsx)(o.EuiSpacer,{size:"xl"}),(0,d.jsx)(o.EuiText,{size:"xs"},(0,d.jsx)(M.FormattedMessage,{id:"xpack.serverlessSearch.connectorsTable.summaryLabel",defaultMessage:"Showing {items} of {count} {connectors}",values:{connectors:(0,d.jsx)("strong",null,l._U),items:(0,d.jsx)("strong",null,(0,d.jsx)(o.EuiI18nNumber,{value:t*p}),"-",(0,d.jsx)(o.EuiI18nNumber,{value:t*p+N.length})),count:(0,d.jsx)(o.EuiI18nNumber,{value:null!==(s=null==h?void 0:h.connectors.length)&&void 0!==s?s:0})}})),(0,d.jsx)(o.EuiSpacer,{size:"s"}),(0,d.jsx)(o.EuiHorizontalRule,{margin:"none",style:{height:2}}),(0,d.jsx)(o.EuiBasicTable,{"data-test-subj":"serverlessSearchConnectorTable",columns:D,loading:f,items:N,onChange:({page:e})=>{if(e){const{index:s,size:n}=e;x(s),g(n)}},pagination:{pageIndex:t,pageSize:p,totalItemCount:null!==(n=null==h?void 0:h.connectors.length)&&void 0!==n?n:0}}))},te=({connector:e,disabled:s})=>{const[n,t]=(0,a.useState)(!1);return(0,d.jsx)(r().Fragment,null,n&&(0,d.jsx)(k,{closeDeleteModal:()=>t(!1),connectorId:e.id,connectorName:e.name}),(0,d.jsx)(o.EuiToolTip,{content:l.lt,disableScreenReaderOutput:!0},(0,d.jsx)(o.EuiButtonIcon,{disabled:s,"data-test-subj":"serverlessSearchDeleteConnectorModalActionButton","aria-label":l.lt,onClick:()=>t(!0),iconType:"trash",color:"danger"})))},ae=()=>{const{data:e,isLoading:s}=(0,W.U)(),{console:n}=(0,u.y)(),{createConnector:t,isLoading:r}=(0,ee.B)(),i=(0,a.useMemo)((()=>null!=n&&n.EmbeddableConsole?(0,d.jsx)(n.EmbeddableConsole,null):null),[n]),x=!e||e.canManageConnectors,p=(0,T.Y)();return(0,d.jsx)(o.EuiPageTemplate,{offset:0,grow:!0,restrictWidth:!0,"data-test-subj":"svlSearchConnectorsPage"},(0,d.jsx)(o.EuiPageTemplate.Header,{pageTitle:c.i18n.translate("xpack.serverlessSearch.connectors.title",{defaultMessage:"Connectors"}),"data-test-subj":"serverlessSearchConnectorsTitle",restrictWidth:!0,rightSideItems:s||((null==e?void 0:e.connectors)||[]).length>0?[(0,d.jsx)(o.EuiFlexGroup,{direction:"row",alignItems:"center",justifyContent:"center"},(0,d.jsx)(o.EuiFlexItem,null,(0,d.jsx)(X.CR,{href:"https://github.com/elastic/connectors",label:c.i18n.translate("xpack.serverlessSearch.connectorsPythonLink",{defaultMessage:"elastic/connectors"}),assetBasePath:p,"data-test-subj":"serverlessSearchConnectorsOverviewElasticConnectorsLink"})),(0,d.jsx)(o.EuiFlexItem,null,(0,d.jsx)(o.EuiButton,{"data-test-subj":"serverlessSearchConnectorsOverviewCreateConnectorButton",disabled:!x,isLoading:r,fill:!0,iconType:"plusInCircleFilled",onClick:()=>t()},c.i18n.translate("xpack.serverlessSearch.connectors.createConnector",{defaultMessage:"Create connector"}))))]:void 0},(0,d.jsx)(o.EuiText,null,(0,d.jsx)("p",null,(0,d.jsx)(M.FormattedMessage,{id:"xpack.serverlessSearch.connectors.headerContent",defaultMessage:"Sync third-party data sources to Elasticsearch, by deploying Elastic connectors on your own infrastructure. {learnMoreLink}",values:{learnMoreLink:(0,d.jsx)(o.EuiLink,{"data-test-subj":"serverlessSearchConnectorsOverviewLink",target:"_blank",href:F.O.connectors},l.iJ)}})))),(0,d.jsx)(o.EuiPageTemplate.Section,{restrictWidth:!0,color:"subdued"},(0,d.jsx)(H,null),s||((null==e?void 0:e.connectors)||[]).length>0?(0,d.jsx)(ne,null):(0,d.jsx)(Z.l,null)),i)};var re=n(51),oe=n(1327);const ie=()=>{const e=(0,y.U)().filter((e=>["Gmail","Sharepoint Online","Jira Cloud","Dropbox"].includes(e.name))),{application:{navigateToApp:s}}=(0,u.y)();return(0,d.jsx)(re.cD,{backButton:{label:l.ni,onClickBack:()=>s(oe.Dq)},icon:"plugs",title:c.i18n.translate("xpack.serverlessSearch.elasticManagedConnectorEmpty.title",{defaultMessage:"Elastic managed connectors"}),description:c.i18n.translate("xpack.serverlessSearch.elasticManagedConnectorEmpty.description",{defaultMessage:"We're actively developing Elastic managed connectors, that won't require any self-managed infrastructure. You'll be able to handle all configuration in the UI. This will simplify syncing your data into a serverless Elasticsearch project. This new workflow will have two steps:"}),isComingSoon:!0,comingSoonLabel:l.lO,body:(0,d.jsx)(o.EuiFlexGroup,{alignItems:"stretch",justifyContent:"center",direction:"column",gutterSize:"s"},(0,d.jsx)(o.EuiFlexItem,null,(0,d.jsx)(o.EuiPanel,{color:"subdued"},(0,d.jsx)(o.EuiFlexItem,{grow:!1},(0,d.jsx)(I.Yz,{stepCount:2})),(0,d.jsx)(o.EuiFlexGroup,null,(0,d.jsx)(o.EuiFlexItem,null,(0,d.jsx)(o.EuiFlexGroup,{justifyContent:"flexStart",alignItems:"center",direction:"column"},(0,d.jsx)(o.EuiFlexItem,{grow:!1},(0,d.jsx)(o.EuiFlexGroup,{justifyContent:"center",alignItems:"center",direction:"row",gutterSize:"s"},e.map(((s,n)=>(0,d.jsx)(r().Fragment,{key:s.serviceType},n===Math.floor(e.length/2)&&(0,d.jsx)(o.EuiFlexItem,{grow:!1},(0,d.jsx)(o.EuiIcon,{color:"primary",size:"l",type:"documents"})),(0,d.jsx)(o.EuiFlexItem,{grow:!1},(0,d.jsx)(re.zN,{name:s.name,serviceType:s.serviceType,iconPath:s.iconPath,showTooltip:!0}))))))),(0,d.jsx)(o.EuiFlexItem,{grow:!1},(0,d.jsx)(o.EuiText,null,(0,d.jsx)("p",null,c.i18n.translate("xpack.serverlessSearch.elasticManagedConnectorEmpty.guideOneDescription",{defaultMessage:"Choose from over 30 third-party data sources you'd like to sync"})))))),(0,d.jsx)(o.EuiFlexItem,null,(0,d.jsx)(o.EuiFlexGroup,{justifyContent:"flexStart",alignItems:"center",direction:"column"},(0,d.jsx)(o.EuiFlexItem,{grow:!1},(0,d.jsx)(o.EuiFlexGroup,{gutterSize:"s",direction:"row",alignItems:"center",justifyContent:"center"},(0,d.jsx)(o.EuiFlexItem,null,(0,d.jsx)(o.EuiIcon,{color:"primary",size:"l",type:"plugs"})),(0,d.jsx)(o.EuiFlexItem,null,(0,d.jsx)(o.EuiIcon,{color:"primary",size:"l",type:"logoElastic"})))),(0,d.jsx)(o.EuiFlexItem,null,(0,d.jsx)(o.EuiText,null,(0,d.jsx)("p",null,c.i18n.translate("xpack.serverlessSearch.elasticManagedConnectorEmpty.guideThreeDescription",{defaultMessage:"Enter access and connection details for your data source and run your first sync using the Kibana UI"}))))))))))})},ce=()=>{const{console:e}=(0,u.y)(),s=(0,a.useMemo)((()=>null!=e&&e.EmbeddableConsole?(0,d.jsx)(e.EmbeddableConsole,null):null),[e]);return(0,d.jsx)(o.EuiPageTemplate,{offset:0,grow:!0,restrictWidth:!0,"data-test-subj":"svlSearchConnectorsPage"},(0,d.jsx)(o.EuiPageTemplate.Header,{pageTitle:c.i18n.translate("xpack.serverlessSearch.connectors.title",{defaultMessage:"Connectors"}),"data-test-subj":"serverlessSearchConnectorsTitle",restrictWidth:!0},(0,d.jsx)(o.EuiText,null,(0,d.jsx)("p",null,(0,d.jsx)(M.FormattedMessage,{id:"xpack.serverlessSearch.connectors.headerContent",defaultMessage:"Sync third-party data sources to Elasticsearch, by deploying Elastic connectors on your own infrastructure. {learnMoreLink}",values:{learnMoreLink:(0,d.jsx)(o.EuiLink,{"data-test-subj":"serverlessSearchConnectorsOverviewLink",target:"_blank",href:F.O.connectors},l.iJ)}})))),(0,d.jsx)(o.EuiPageTemplate.Section,{restrictWidth:!0,color:"subdued"},(0,d.jsx)(ie,null)),s)},le=()=>(0,d.jsx)(t.Routes,null,(0,d.jsx)(t.Route,{exact:!0,path:se.Kq},(0,d.jsx)(ce,null)),(0,d.jsx)(t.Route,{exact:!0,path:"/:id"},(0,d.jsx)(V,null)),(0,d.jsx)(t.Route,{exact:!0,path:"/"},(0,d.jsx)(ae,null)))},7018:(e,s,n)=>{n.d(s,{U:()=>a});var t=n(6438);const a=()=>{const{contentConnectors:e}=(0,t.y)();return(null==e?void 0:e.getConnectorTypes())||[]}}}]);