"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewEmptyPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _doc_links = require("../../../../common/doc_links");
var _api_empty_prompt = require("./api_empty_prompt");
var _connector_empty_prompt = require("./connector_empty_prompt");
var _connector_setup_prompt = require("./connector_setup_prompt");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var EmptyPromptView = /*#__PURE__*/function (EmptyPromptView) {
  EmptyPromptView[EmptyPromptView["Default"] = 0] = "Default";
  EmptyPromptView[EmptyPromptView["NewConnector"] = 1] = "NewConnector";
  EmptyPromptView[EmptyPromptView["API"] = 2] = "API";
  EmptyPromptView[EmptyPromptView["SetupConnector"] = 3] = "SetupConnector";
  return EmptyPromptView;
}(EmptyPromptView || {});
const OverviewEmptyPrompt = ({
  connector,
  indexName
}) => {
  const isConnectorIndex = !!connector;
  const [currentView, setView] = _react.default.useState(isConnectorIndex ? EmptyPromptView.SetupConnector : EmptyPromptView.Default);
  if (currentView === EmptyPromptView.SetupConnector) {
    return /*#__PURE__*/_react.default.createElement(_connector_setup_prompt.ConnectorSetupEmptyPrompt, {
      indexName: indexName,
      connector: connector
    });
  }
  if (currentView === EmptyPromptView.NewConnector) {
    return /*#__PURE__*/_react.default.createElement(_connector_empty_prompt.ConnectorIndexEmptyPrompt, {
      indexName: indexName,
      onBackClick: () => setView(EmptyPromptView.Default)
    });
  }
  if (currentView === EmptyPromptView.API) {
    return /*#__PURE__*/_react.default.createElement(_api_empty_prompt.APIIndexEmptyPrompt, {
      indexName: indexName,
      onBackClick: () => setView(EmptyPromptView.Default)
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "logstashInput",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.serverlessSearch.indexManagement.indexDetails.overview.emptyPrompt.title",
      defaultMessage: "Start ingesting data"
    }))),
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.serverlessSearch.indexManagement.indexDetails.overview.emptyPrompt.body",
      defaultMessage: "Populate your index with data using {logstashLink}, {beatsLink}, {connectorsLink}, or RESTful {apiCallsLink}.",
      values: {
        logstashLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "serverlessSearchIndexDetailOverviewLogstashLink",
          target: "_blank",
          external: false,
          href: _doc_links.docLinks.logstash
        }, _i18n.i18n.translate('xpack.serverlessSearch.indexManagement.indexDetails.overview.emptyPrompt.body.logstashLink', {
          defaultMessage: 'Logstash'
        })),
        beatsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "serverlessSearchIndexDetailOverviewBeatsLink",
          target: "_blank",
          external: false,
          href: _doc_links.docLinks.beats
        }, _i18n.i18n.translate('xpack.serverlessSearch.indexManagement.indexDetails.overview.emptyPrompt.body.beatsLink', {
          defaultMessage: 'Beats'
        })),
        connectorsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "serverlessSearchIndexDetailOverviewConnectorsLink",
          target: "_blank",
          external: false,
          href: _doc_links.docLinks.connectors
        }, _i18n.i18n.translate('xpack.serverlessSearch.indexManagement.indexDetails.overview.emptyPrompt.body.connectorsLink', {
          defaultMessage: 'connectors'
        })),
        apiCallsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "serverlessSearchIndexDetailOverviewAPICallsLink",
          target: "_blank",
          external: false,
          href: _doc_links.docLinks.apiIntro
        }, _i18n.i18n.translate('xpack.serverlessSearch.indexManagement.indexDetails.overview.emptyPrompt.body.apiCallsLink', {
          defaultMessage: 'API calls'
        }))
      }
    }))),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "serverlessSearchIndexDetailOverviewAddViaApiButton",
      onClick: () => setView(EmptyPromptView.API)
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.serverlessSearch.indexManagement.indexDetails.overview.emptyPrompt.actions.addViaAPI",
      defaultMessage: "Add via API"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "serverlessSearchIndexDetailOverviewAddViaConnectorButton",
      onClick: () => setView(EmptyPromptView.NewConnector)
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.serverlessSearch.indexManagement.indexDetails.overview.emptyPrompt.actions.addViaConnector",
      defaultMessage: "Add via Connector"
    }))))
  }));
};
exports.OverviewEmptyPrompt = OverviewEmptyPrompt;