"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelfManagedConnectorsEmptyPrompt = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _searchSharedUi = require("@kbn/search-shared-ui");
var _searchConnectors = require("@kbn/search-connectors");
var _doc_links = require("../../../../common/doc_links");
var _use_connector_types = require("../../hooks/api/use_connector_types");
var _use_create_connector = require("../../hooks/api/use_create_connector");
var _use_connectors = require("../../hooks/api/use_connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SelfManagedConnectorsEmptyPrompt = () => {
  const connectorTypes = (0, _use_connector_types.useConnectorTypes)();
  const connectorExamples = connectorTypes.filter(connector => ['Gmail', 'Sharepoint Online', 'Jira Cloud', 'Dropbox'].includes(connector.name));
  const {
    createConnector,
    isLoading
  } = (0, _use_create_connector.useCreateConnector)();
  const {
    data
  } = (0, _use_connectors.useConnectors)();
  return /*#__PURE__*/_react.default.createElement(_searchSharedUi.SearchEmptyPrompt, {
    icon: "plugs",
    title: _i18n.i18n.translate('xpack.serverlessSearch.selfManagedConnectorEmpty.title', {
      defaultMessage: 'Set up a connector'
    }),
    description: _i18n.i18n.translate('xpack.serverlessSearch.selfManagedConnectorEmpty.description', {
      defaultMessage: "To set up and deploy a connector you'll be working between data source, your terminal, and the Kibana UI. The high level process looks like this:"
    }),
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "stretch",
      justifyContent: "center",
      direction: "column",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_searchConnectors.DecorativeHorizontalStepper, {
      stepCount: 3
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "center",
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center",
      direction: "row",
      gutterSize: "s"
    }, connectorExamples.map((connector, index) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: connector.serviceType
    }, index === Math.floor(connectorExamples.length / 2) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "primary",
      size: "l",
      type: "documents"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_searchSharedUi.ConnectorIcon, {
      name: connector.name,
      serviceType: connector.serviceType,
      iconPath: connector.iconPath,
      showTooltip: true
    })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.serverlessSearch.connectorsEmpty.guideOneDescription', {
      defaultMessage: "Choose from over 30 third-party data sources you'd like to sync"
    })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "center",
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      direction: "row",
      alignItems: "center",
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "primary",
      size: "l",
      type: "plugs"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "m",
      type: "sortRight"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "primary",
      size: "l",
      type: "launch"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.serverlessSearch.connectorsEmpty.guideTwoDescription",
      defaultMessage: "Deploy connector code on your own infrastructure by running from {source}, or using {docker}",
      values: {
        source: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          "data-test-subj": "serverlessSearchEmptyConnectorsPromptSourceLink",
          href: _doc_links.docLinks.connectorsRunFromSource
        }, _i18n.i18n.translate('xpack.serverlessSearch.connectorsEmpty.sourceLabel', {
          defaultMessage: 'source'
        })),
        docker: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          "data-test-subj": "serverlessSearchEmptyConnectorsPromptDockerLink",
          href: _doc_links.docLinks.connectorsRunWithDocker
        }, _i18n.i18n.translate('xpack.serverlessSearch.connectorsEmpty.dockerLabel', {
          defaultMessage: 'Docker'
        }))
      }
    })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "center",
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      direction: "row",
      alignItems: "center",
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "primary",
      size: "l",
      type: "documents"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "m",
      type: "sortRight"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "primary",
      size: "l",
      type: "plugs"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "m",
      type: "sortRight"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "primary",
      size: "l",
      type: "logoElasticsearch"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.serverlessSearch.connectorsEmpty.guideThreeDescription', {
      defaultMessage: 'Enter access and connection details for your data source and run your first sync'
    })))))))))),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "serverlessSearchEmptyConnectorsPromptCreateConnectorButton",
      disabled: !(data !== null && data !== void 0 && data.canManageConnectors),
      fill: true,
      iconType: "plusInCircle",
      onClick: () => createConnector(),
      isLoading: isLoading
    }, _i18n.i18n.translate('xpack.serverlessSearch.connectorsEmpty.selfManagedButton', {
      defaultMessage: 'Self-managed connector'
    }))))
  });
};
exports.SelfManagedConnectorsEmptyPrompt = SelfManagedConnectorsEmptyPrompt;