"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectionDetails = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _use_elastisearch_url = require("../../../hooks/use_elastisearch_url");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectionDetails = ({
  connectorId,
  serviceType,
  status
}) => {
  const {
    elasticsearchUrl
  } = (0, _use_elastisearch_url.useElasticsearchUrl)();
  const codeBlock = `connectors:
-
  connector_id: ${connectorId}
  service_type: ${serviceType}
  api_key:
elasticsearch:
  host: ${elasticsearchUrl}
  api_key:`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.serverlessSearch.connectors.variablesTitle",
    defaultMessage: "Variables for your {url}",
    values: {
      url: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "elastic/connectors/config.yml")
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.serverlessSearch.connectors.config.apiKeyExplanation",
    defaultMessage: "You will need to fill in the {api_key} fields with an API key. One can be generated on the Getting Started page.",
    values: {
      api_key: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "api_key")
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "yaml",
    isCopyable: true,
    "data-test-subj": "serverlessSearchConnectorConnectorDetails"
  }, codeBlock));
};
exports.ConnectionDetails = ConnectionDetails;