"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BadgeList = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BadgeList = ({
  badges,
  maxBadgesToDisplay
}) => {
  const maxBadges = maxBadgesToDisplay !== null && maxBadgesToDisplay !== void 0 ? maxBadgesToDisplay : 3;
  if (badges.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  const badgesToDisplay = badges.slice(0, maxBadges);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
    gutterSize: "s",
    css: {
      width: '100%'
    }
  }, badgesToDisplay.map(badge => badge), badges.length > maxBadges && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, "+", badges.length - maxBadges));
};
exports.BadgeList = BadgeList;