"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReadListItemResponse = exports.ReadListItemRequestQuery = void 0;
var _zod = require("@kbn/zod");
var _list_common = require("../model/list_common.gen");
var _list_schemas = require("../model/list_schemas.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Read value list item API endpoint
 *   version: 2023-10-31
 */

const ReadListItemRequestQuery = exports.ReadListItemRequestQuery = _zod.z.object({
  /**
   * Value list item identifier. Required if `list_id` and `value` are not specified.
   */
  id: _list_common.ListId.optional(),
  /**
   * Value list item list's `id` identfier. Required if `id` is not specified.
   */
  list_id: _list_common.ListId.optional(),
  /**
   * The value used to evaluate exceptions. Required if `id` is not specified.
   */
  value: _zod.z.string().optional()
});
const ReadListItemResponse = exports.ReadListItemResponse = _zod.z.union([_list_schemas.ListItem, _zod.z.array(_list_schemas.ListItem)]);