"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _use_product_type_by_pli = require("../../hooks/use_product_type_by_pli");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndpointExceptionsDetailsUpselling = exports.default = /*#__PURE__*/(0, _react.memo)(({
  requiredPLI
}) => {
  const productTypeRequired = (0, _use_product_type_by_pli.getProductTypeByPLI)(requiredPLI);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoSecurity",
      size: "xl"
    }),
    color: "subdued",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolutionServerless.endpoint.exceptions.details.paywall.title",
      defaultMessage: "Do more with Security!"
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolutionServerless.endpoint.exceptions.details.paywall.body",
      defaultMessage: "Upgrade your license to {productTypeRequired} to use Endpoint Security Exception List.",
      values: {
        productTypeRequired
      }
    }))
  });
});
EndpointExceptionsDetailsUpselling.displayName = 'EndpointExceptionsDetailsUpselling';

// eslint-disable-next-line import/no-default-export
module.exports = exports.default;